/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TruncatedIterator<T>
implements Iterator<T>,
Composite {
    private final Iterator<? extends T> _iter;
    private int _size;

    public TruncatedIterator(Iterator<? extends T> iter, int size) {
        this._iter = iter;
        this._size = size;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._iter) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._iter) + 1;
    }

    @Override
    public boolean hasNext() {
        return this._size > 0 && this._iter.hasNext();
    }

    @Override
    public T next() {
        if (this._size <= 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        return this._iter.next();
    }

    @Override
    public void remove() {
        this._iter.remove();
    }
}

