/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.iter.FilteredIterator;
import edu.rice.cs.plt.lambda.LambdaUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoDuplicatesIterator<T>
extends FilteredIterator<T> {
    private final Set<T> _seen;

    public NoDuplicatesIterator(Iterator<? extends T> i) {
        this(i, CollectUtil.asPredicateSet(new HashSet()));
    }

    private NoDuplicatesIterator(Iterator<? extends T> i, Set<T> seen) {
        super(i, LambdaUtil.negate(CollectUtil.asPredicateSet(seen)));
        this._seen = seen;
    }

    @Override
    public T next() {
        Object result = super.next();
        this._seen.add(result);
        return result;
    }

    public static <T> NoDuplicatesIterator<T> make(Iterator<? extends T> i) {
        return new NoDuplicatesIterator<T>(i);
    }
}

