/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.lambda.Runnable1;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableSingletonIterator<T>
implements Iterator<T> {
    private final T _element;
    private final Runnable1<? super T> _removeListener;
    private boolean _hasNext;
    private boolean _removed;

    public MutableSingletonIterator(T element, Runnable1<? super T> removeListener) {
        this._element = element;
        this._removeListener = removeListener;
        this._hasNext = true;
        this._removed = false;
    }

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    public T next() {
        if (this._hasNext) {
            this._hasNext = false;
            return this._element;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this._hasNext || this._removed) {
            throw new IllegalStateException();
        }
        this._removeListener.run(this._element);
    }

    public static <T> MutableSingletonIterator<T> make(T element, Runnable1<? super T> removeListener) {
        return new MutableSingletonIterator<T>(element, removeListener);
    }
}

