/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredIterator<T>
extends ReadOnlyIterator<T>
implements Composite {
    private final Predicate<? super T> _p;
    private final Iterator<? extends T> _i;
    private T _lookahead;

    public FilteredIterator(Iterator<? extends T> i, Predicate<? super T> p) {
        this._p = p;
        this._i = i;
        this.advanceLookahead();
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._i) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._i) + 1;
    }

    @Override
    public boolean hasNext() {
        return this._lookahead != null;
    }

    @Override
    public T next() {
        T result = this._lookahead;
        this.advanceLookahead();
        return result;
    }

    private void advanceLookahead() {
        this._lookahead = null;
        while (this._i.hasNext() && this._lookahead == null) {
            T next = this._i.next();
            if (!this._p.contains(next)) continue;
            this._lookahead = next;
        }
    }

    public static <T> FilteredIterator<T> make(Iterator<? extends T> i, Predicate<? super T> p) {
        return new FilteredIterator<T>(i, p);
    }
}

