/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.CollapsedIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.MappedIterable;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollapsedIterable<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
OptimizedLastIterable<T>,
Composite,
Serializable {
    private final Iterable<? extends Iterable<? extends T>> _iters;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public CollapsedIterable(Iterable_ iters) {
        this._iters = iters;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._iters) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._iters) + 1;
    }

    @Override
    public CollapsedIterator<T> iterator() {
        Iterator i = new MappedIterable((Iterable_)((Object)this._iters), GetIterator.make()).iterator();
        return new CollapsedIterator(i);
    }

    @Override
    public boolean isEmpty() {
        return this.size(1) == 0;
    }

    @Override
    public int size() {
        int result = 0;
        Iterator i$ = IterableMethods.iterator(this._iters);
        while (i$.hasNext()) {
            Iterable_ iter = (Iterable_)i$.next();
            if ((result += IterUtil.sizeOf(iter)) >= 0) continue;
            result = Integer.MAX_VALUE;
            break;
        }
        return result;
    }

    @Override
    public int size(int bound) {
        Iterable_ iter;
        int result = 0;
        Iterator i$ = IterableMethods.iterator(this._iters);
        while (i$.hasNext() && (result += IterUtil.sizeOf(iter = (Iterable_)i$.next())) < bound) {
            if (result >= 0) continue;
            result = Integer.MAX_VALUE;
            break;
        }
        return result <= bound ? result : bound;
    }

    @Override
    public boolean isInfinite() {
        if (IterUtil.isInfinite(this._iters)) {
            return true;
        }
        Iterator i$ = IterableMethods.iterator(this._iters);
        while (i$.hasNext()) {
            Iterable_ iter = (Iterable_)i$.next();
            if (!IterUtil.isInfinite(iter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        if (!IterUtil.hasFixedSize(this._iters)) {
            return false;
        }
        Iterator i$ = IterableMethods.iterator(this._iters);
        while (i$.hasNext()) {
            Iterable_ iter = (Iterable_)i$.next();
            if (IterUtil.hasFixedSize(iter)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStatic() {
        if (!IterUtil.isStatic(this._iters)) {
            return false;
        }
        Iterator i$ = IterableMethods.iterator(this._iters);
        while (i$.hasNext()) {
            Iterable_ iter = (Iterable_)i$.next();
            if (IterUtil.isStatic(iter)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T last() {
        Iterable_ lastNonEmpty = null;
        Iterator i$ = IterableMethods.iterator(this._iters);
        while (i$.hasNext()) {
            Iterable_ iter = (Iterable_)i$.next();
            if (lastNonEmpty != null && IterUtil.isEmpty(iter)) continue;
            lastNonEmpty = iter;
        }
        return (T)IterUtil.last(lastNonEmpty);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static CollapsedIterable make(Iterable_ iters) {
        return new CollapsedIterable(iters);
    }

    @Override
    public Iterator iterator() {
        return this.iterator();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetIterator<T>
    implements Lambda<Iterable<? extends T>, Iterator<? extends T>>,
    Serializable {
        public static final GetIterator<Object> INSTANCE = new GetIterator();

        public static <T> GetIterator<T> make() {
            return INSTANCE;
        }

        private GetIterator() {
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        @Override
        public Iterator value(Iterable_ iter) {
            return IterableMethods.iterator(iter);
        }

        @Override
        public Object value(Object x0) {
            return this.value((Iterable_)x0);
        }
    }
}

