/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartesianIterator<T1, T2, R>
extends ReadOnlyIterator<R>
implements Composite {
    private final Lambda2<? super T1, ? super T2, ? extends R> _combiner;
    private final Iterator<? extends T1> _left;
    private Iterator<? extends T2> _right;
    private T1 _currentLeft;
    private boolean _done;
    private final Iterable<? extends T2> _rightIterable;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public CartesianIterator(Iterator left, Iterable_ right, Lambda2 combiner) {
        this._combiner = combiner;
        this._left = left;
        this._right = IterableMethods.iterator(right);
        if (this._left.hasNext() && this._right.hasNext()) {
            this._done = false;
            this._currentLeft = this._left.next();
        } else {
            this._done = true;
        }
        this._rightIterable = right;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._left, this._right) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._left, this._right) + 1;
    }

    @Override
    public boolean hasNext() {
        return !this._done;
    }

    @Override
    public R next() {
        if (this._done) {
            throw new NoSuchElementException();
        }
        R result = this._combiner.value(this._currentLeft, this._right.next());
        if (!this._right.hasNext()) {
            if (!this._left.hasNext()) {
                this._done = true;
            } else {
                this._currentLeft = this._left.next();
                this._right = IterableMethods.iterator(this._rightIterable);
            }
        }
        return result;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static CartesianIterator make(Iterator left, Iterable_ right, Lambda2 combiner) {
        return new CartesianIterator(left, right, combiner);
    }
}

