/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.ChecksumOutputStream;
import edu.rice.cs.plt.io.FilePredicate;
import edu.rice.cs.plt.io.MessageDigestOutputStream;
import edu.rice.cs.plt.io.WrappedDirectInputStream;
import edu.rice.cs.plt.io.WrappedDirectReader;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.recur.RecursionStack;
import edu.rice.cs.plt.tuple.Wrapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil {
    private static final Lambda<File, File> GET_ABSOLUTE_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return arg.getAbsoluteFile();
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<File, File> ATTEMPT_ABSOLUTE_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.attemptAbsoluteFile(arg);
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<File, File> GET_CANONICAL_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            try {
                return arg.getCanonicalFile();
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<File, File> ATTEMPT_CANONICAL_FILE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.attemptAbsoluteFile(arg);
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<File, File> CANONICAL_CASE = new Lambda<File, File>(){

        @Override
        public File value(File arg) {
            return IOUtil.canonicalCase(arg);
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };
    private static final Lambda<String, File> STRING_TO_FILE = new Lambda<String, File>(){

        @Override
        public File value(String arg) {
            return new File(arg);
        }

        @Override
        public Object value(Object x0) {
            return this.value((String)x0);
        }
    };
    private static final Thunk<List<InputStream>> INPUT_STREAMS_TO_CLOSE = LazyThunk.make(new Thunk<List<InputStream>>(){

        @Override
        public List<InputStream> value() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Iterator i$ = ((List)IOUtil.access$300().value()).iterator();
                    while (i$.hasNext()) {
                        InputStream in = (InputStream)i$.next();
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            return new LinkedList<InputStream>();
        }

        @Override
        public Object value() {
            return this.value();
        }
    });
    private static final Thunk<List<OutputStream>> OUTPUT_STREAMS_TO_CLOSE = LazyThunk.make(new Thunk<List<OutputStream>>(){

        @Override
        public List<OutputStream> value() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Iterator i$ = ((List)IOUtil.access$400().value()).iterator();
                    while (i$.hasNext()) {
                        OutputStream out = (OutputStream)i$.next();
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            return new LinkedList<OutputStream>();
        }

        @Override
        public Object value() {
            return this.value();
        }
    });
    private static final Thunk<List<Reader>> READERS_TO_CLOSE = LazyThunk.make(new Thunk<List<Reader>>(){

        @Override
        public List<Reader> value() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Iterator i$ = ((List)IOUtil.access$500().value()).iterator();
                    while (i$.hasNext()) {
                        Reader r = (Reader)i$.next();
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            return new LinkedList<Reader>();
        }

        @Override
        public Object value() {
            return this.value();
        }
    });
    private static final Thunk<List<Writer>> WRITERS_TO_CLOSE = LazyThunk.make(new Thunk<List<Writer>>(){

        @Override
        public List<Writer> value() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Iterator i$ = ((List)IOUtil.access$600().value()).iterator();
                    while (i$.hasNext()) {
                        Writer w = (Writer)i$.next();
                        try {
                            w.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            return new LinkedList<Writer>();
        }

        @Override
        public Object value() {
            return this.value();
        }
    });
    public static final FilePredicate IS_FILE = new IsFileFilePredicate(null);
    public static final FilePredicate IS_DIRECTORY = new IsDirectoryFilePredicate(null);
    public static final FilePredicate ALWAYS_ACCEPT = IOUtil.asFilePredicate(LambdaUtil.TRUE);
    public static final FilePredicate ALWAYS_REJECT = IOUtil.asFilePredicate(LambdaUtil.FALSE);
    private static final LinkedList<PrintStream> SYSTEM_OUT_STACK = new LinkedList();
    private static final LinkedList<PrintStream> SYSTEM_ERR_STACK = new LinkedList();
    private static final LinkedList<InputStream> SYSTEM_IN_STACK = new LinkedList();

    private IOUtil() {
    }

    public static File attemptAbsoluteFile(File f) {
        try {
            return f.getAbsoluteFile();
        }
        catch (SecurityException e) {
            return f;
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ getAbsoluteFiles(Iterable_ files) {
        return IterUtil.mapSnapshot(files, GET_ABSOLUTE_FILE);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ attemptAbsoluteFiles(Iterable_ files) {
        return IterUtil.mapSnapshot(files, ATTEMPT_ABSOLUTE_FILE);
    }

    public static File attemptCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return IOUtil.attemptAbsoluteFile(f);
        }
        catch (SecurityException e) {
            return IOUtil.attemptAbsoluteFile(f);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ getCanonicalFiles(Iterable_ files) throws IOException {
        try {
            return IterUtil.mapSnapshot(files, GET_CANONICAL_FILE);
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ attemptCanonicalFiles(Iterable_ files) {
        return IterUtil.mapSnapshot(files, ATTEMPT_CANONICAL_FILE);
    }

    public static boolean attemptCanRead(File f) {
        try {
            return f.canRead();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptCanWrite(File f) {
        try {
            return f.canWrite();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptExists(File f) {
        try {
            return f.exists();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsDirectory(File f) {
        try {
            return f.isDirectory();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsFile(File f) {
        try {
            return f.isFile();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptIsHidden(File f) {
        try {
            return f.isHidden();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static long attemptLastModified(File f) {
        try {
            return f.lastModified();
        }
        catch (SecurityException e) {
            return 0L;
        }
    }

    public static long attemptLength(File f) {
        try {
            return f.length();
        }
        catch (SecurityException e) {
            return 0L;
        }
    }

    public static boolean attemptCreateNewFile(File f) {
        try {
            return f.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptDelete(File f) {
        try {
            return f.delete();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static void attemptDeleteOnExit(File f) {
        try {
            f.deleteOnExit();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static File[] attemptListFiles(File f) {
        try {
            return f.listFiles();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static File[] attemptListFiles(File f, FileFilter filter) {
        try {
            return f.listFiles(filter);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static File[] attemptListFiles(File f, Predicate<? super File> filter) {
        return IOUtil.attemptListFiles(f, (FileFilter)IOUtil.asFilePredicate(filter));
    }

    public static File[] attemptListFiles(File f, FilePredicate filter) {
        return IOUtil.attemptListFiles(f, (FileFilter)filter);
    }

    public static Iterable<File> attemptListFilesAsIterable(File f) {
        File[] result = IOUtil.attemptListFiles(f);
        if (result == null) {
            return IterUtil.empty();
        }
        return IterUtil.asIterable(result);
    }

    public static Iterable<File> attemptListFilesAsIterable(File f, FileFilter filter) {
        File[] result = IOUtil.attemptListFiles(f, filter);
        if (result == null) {
            return IterUtil.empty();
        }
        return IterUtil.asIterable(result);
    }

    public static Iterable<File> attemptListFilesAsIterable(File f, Predicate<? super File> filter) {
        return IOUtil.attemptListFilesAsIterable((File)f, (FileFilter)IOUtil.asFilePredicate(filter));
    }

    public static Iterable<File> attemptListFilesAsIterable(File f, FilePredicate filter) {
        return IOUtil.attemptListFilesAsIterable((File)f, (FileFilter)filter);
    }

    public static boolean attemptMkdir(File f) {
        try {
            return f.mkdir();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptMkdirs(File f) {
        try {
            return f.mkdirs();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptRenameTo(File f, File dest) {
        try {
            return f.renameTo(dest);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptMove(File f, File dest) {
        IOUtil.attemptDelete(dest);
        return IOUtil.attemptRenameTo(f, dest);
    }

    public static boolean attemptSetLastModified(File f, long time) {
        try {
            return f.setLastModified(time);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean attemptSetReadOnly(File f) {
        try {
            return f.setReadOnly();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static File canonicalCase(File f) {
        File lowered = new File(f.getPath().toLowerCase());
        if (f.equals(lowered)) {
            return lowered;
        }
        return f;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Iterable_ canonicalCases(Iterable_ files) {
        return IterUtil.mapSnapshot(files, CANONICAL_CASE);
    }

    public static boolean isMember(File f, File ancestor) {
        for (File parent = f; parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public static Iterable<File> fullPath(File f) {
        AbstractIterable result = IterUtil.singleton(f);
        for (File parent = f.getParentFile(); parent != null; parent = parent.getParentFile()) {
            result = IterUtil.compose(parent, result);
        }
        return result;
    }

    public static boolean deleteRecursively(File f) {
        return IOUtil.deleteRecursively(f, new RecursionStack<File>(Wrapper.factory()));
    }

    private static boolean deleteRecursively(File f, final RecursionStack<File> stack) {
        if (f.isDirectory()) {
            try {
                final File canonicalF = f.getCanonicalFile();
                Runnable deleteMembers = new Runnable(){

                    public void run() {
                        Iterator i$ = IterableMethods.iterator(IOUtil.attemptListFilesAsIterable((File)canonicalF));
                        while (i$.hasNext()) {
                            File child = (File)i$.next();
                            IOUtil.access$000(child, stack);
                        }
                    }
                };
                stack.run(deleteMembers, canonicalF);
            }
            catch (IOException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return IOUtil.attemptDelete(f);
    }

    public static void deleteOnExitRecursively(File f) {
        IOUtil.deleteOnExitRecursively(f, new RecursionStack<File>(Wrapper.factory()));
    }

    private static void deleteOnExitRecursively(File f, final RecursionStack<File> stack) {
        IOUtil.attemptDeleteOnExit(f);
        if (f.isDirectory()) {
            try {
                final File canonicalF = f.getCanonicalFile();
                Runnable markMembers = new Runnable(){

                    public void run() {
                        Iterator i$ = IterableMethods.iterator(IOUtil.attemptListFilesAsIterable((File)canonicalF));
                        while (i$.hasNext()) {
                            File child = (File)i$.next();
                            IOUtil.access$100(child, stack);
                        }
                    }
                };
                stack.run(markMembers, canonicalF);
            }
            catch (IOException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static Iterable<File> listFilesRecursively(File f) {
        return IOUtil.listFilesRecursively((File)f, (FilePredicate)ALWAYS_ACCEPT, (FilePredicate)ALWAYS_ACCEPT);
    }

    public static Iterable<File> listFilesRecursively(File f, FileFilter filter) {
        return IOUtil.listFilesRecursively((File)f, (FileFilter)filter, (FileFilter)ALWAYS_ACCEPT);
    }

    public static Iterable<File> listFilesRecursively(File f, Predicate<? super File> filter) {
        return IOUtil.listFilesRecursively((File)f, (FilePredicate)IOUtil.asFilePredicate(filter), (FilePredicate)ALWAYS_ACCEPT);
    }

    public static Iterable<File> listFilesRecursively(File f, FilePredicate filter) {
        return IOUtil.listFilesRecursively((File)f, (FilePredicate)filter, (FilePredicate)ALWAYS_ACCEPT);
    }

    public static Iterable<File> listFilesRecursively(File f, FileFilter filter, FileFilter recursionFilter) {
        return IOUtil.listFilesRecursively((File)f, (FileFilter)filter, (FileFilter)recursionFilter, new RecursionStack(Wrapper.factory()));
    }

    public static Iterable<File> listFilesRecursively(File f, Predicate<? super File> filter, Predicate<? super File> recursionFilter) {
        return IOUtil.listFilesRecursively((File)f, (FileFilter)IOUtil.asFilePredicate(filter), (FileFilter)IOUtil.asFilePredicate(recursionFilter), new RecursionStack(Wrapper.factory()));
    }

    public static Iterable<File> listFilesRecursively(File f, FilePredicate filter, FilePredicate recursionFilter) {
        return IOUtil.listFilesRecursively((File)f, (FileFilter)filter, (FileFilter)recursionFilter, new RecursionStack(Wrapper.factory()));
    }

    private static Iterable<File> listFilesRecursively(final File f, final FileFilter filter, final FileFilter recursionFilter, final RecursionStack<File> stack) {
        AbstractIterable result;
        AbstractIterable abstractIterable = result = filter.accept(f) ? IterUtil.singleton(f) : IterUtil.empty();
        if (f.isDirectory() && recursionFilter.accept(f)) {
            Thunk<Iterable<File>> getMembers = new Thunk<Iterable<File>>(){

                @Override
                public Iterable<File> value() {
                    AbstractIterable dirFiles = IterUtil.empty();
                    Iterator i$ = IterableMethods.iterator(IOUtil.attemptListFilesAsIterable((File)f));
                    while (i$.hasNext()) {
                        File child = (File)i$.next();
                        dirFiles = IterUtil.compose(dirFiles, IOUtil.access$200(child, filter, recursionFilter, stack));
                    }
                    return dirFiles;
                }

                @Override
                public Object value() {
                    return this.value();
                }
            };
            try {
                result = IterUtil.compose(result, (Iterable_)((Object)stack.apply(getMembers, IterUtil.empty(), f.getCanonicalFile())));
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.toByteArray(input);
            return byArray;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer toStringBuffer(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            StringBuffer stringBuffer = IOUtil.toStringBuffer(reader);
            return stringBuffer;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            String string = IOUtil.toString(reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adler32Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            int n = IOUtil.adler32Hash(input);
            return n;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int crc32Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            int n = IOUtil.crc32Hash(input);
            return n;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.md5Hash(input);
            return byArray;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha1Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.sha1Hash(input);
            return byArray;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha256Hash(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] byArray = IOUtil.sha256Hash(input);
            return byArray;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                IOUtil.copyInputStream(in, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest, byte[] buffer) throws IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                IOUtil.copyInputStream(in, out, buffer);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    public static void writeStringToFile(File file, String text) throws IOException {
        IOUtil.writeStringToFile(file, text, false);
    }

    public static boolean attemptWriteStringToFile(File file, String text) {
        try {
            IOUtil.writeStringToFile(file, text);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String text, boolean append) throws IOException {
        FileWriter writer = new FileWriter(file, append);
        try {
            writer.write(text);
        }
        finally {
            writer.close();
        }
    }

    public static boolean attemptWriteStringToFile(File file, String text, boolean append) {
        try {
            IOUtil.writeStringToFile(file, text, append);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static File createAndMarkTempFile(String prefix, String suffix) throws IOException {
        return IOUtil.createAndMarkTempFile(prefix, suffix, null);
    }

    public static File createAndMarkTempFile(String prefix, String suffix, File location) throws IOException {
        File result = File.createTempFile(prefix, suffix, location);
        IOUtil.attemptDeleteOnExit(result);
        return result;
    }

    public static File createAndMarkTempDirectory(String prefix, String suffix) throws IOException {
        return IOUtil.createAndMarkTempDirectory(prefix, suffix, null);
    }

    public static File createAndMarkTempDirectory(String prefix, String suffix, File location) throws IOException {
        File result = File.createTempFile(prefix, suffix, location);
        boolean success = result.delete();
        boolean bl = success = success && result.mkdir();
        if (!success) {
            throw new IOException("Attempt to create directory failed");
        }
        IOUtil.attemptDeleteOnExit(result);
        return result;
    }

    public static Iterable<File> parsePath(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        SnapshotIterable<String> filenames = IterUtil.snapshot(IterUtil.asIterator(tokenizer));
        return IterUtil.map(filenames, STRING_TO_FILE);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static String pathToString(Iterable_ path) {
        return IterUtil.toString(path, "", File.pathSeparator, "");
    }

    public static int copyReader(Reader source, Writer dest) throws IOException {
        return WrappedDirectReader.makeDirect(source).readAll(dest);
    }

    public static int copyReader(Reader source, Writer dest, char[] buffer) throws IOException {
        return WrappedDirectReader.makeDirect(source).readAll(dest, buffer);
    }

    public static int writeFromReader(Reader source, Writer dest, int chars) throws IOException {
        return WrappedDirectReader.makeDirect(source).read(dest, chars);
    }

    public static int writeFromReader(Reader source, Writer dest, int chars, char[] buffer) throws IOException {
        return WrappedDirectReader.makeDirect(source).read(dest, chars, buffer);
    }

    public static int copyInputStream(InputStream source, OutputStream dest) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).readAll(dest);
    }

    public static int copyInputStream(InputStream source, OutputStream dest, byte[] buffer) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).readAll(dest, buffer);
    }

    public static int writeFromInputStream(InputStream source, OutputStream dest, int bytes) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).read(dest, bytes);
    }

    public static int writeFromInputStream(InputStream source, OutputStream dest, int bytes, byte[] buffer) throws IOException {
        return WrappedDirectInputStream.makeDirect(source).read(dest, bytes, buffer);
    }

    protected static int doCopyReader(Reader r, Writer w, char[] buffer) throws IOException {
        if (buffer.length == 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = r.read(buffer);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        do {
            if ((totalCharsRead += charsRead) < 0) {
                totalCharsRead = Integer.MAX_VALUE;
            }
            w.write(buffer, 0, charsRead);
        } while ((charsRead = r.read(buffer)) != -1);
        return totalCharsRead;
    }

    protected static int doCopyInputStream(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        if (buffer.length == 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = in.read(buffer);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        do {
            if ((totalCharsRead += charsRead) < 0) {
                totalCharsRead = Integer.MAX_VALUE;
            }
            out.write(buffer, 0, charsRead);
        } while ((charsRead = in.read(buffer)) != -1);
        return totalCharsRead;
    }

    protected static int doWriteFromReader(Reader r, Writer w, int chars, char[] buffer) throws IOException {
        if (buffer.length == 0 && chars > 0) {
            throw new IllegalArgumentException();
        }
        int charsRead = r.read(buffer, 0, chars < buffer.length ? chars : buffer.length);
        if (charsRead == -1) {
            return -1;
        }
        int totalCharsRead = 0;
        while (chars > 0 && charsRead > 0) {
            totalCharsRead += charsRead;
            w.write(buffer, 0, charsRead);
            if ((chars -= charsRead) <= 0) continue;
            charsRead = r.read(buffer, 0, chars < buffer.length ? chars : buffer.length);
        }
        return totalCharsRead;
    }

    protected static int doWriteFromInputStream(InputStream in, OutputStream out, int bytes, byte[] buffer) throws IOException {
        if (buffer.length == 0 && bytes > 0) {
            throw new IllegalArgumentException();
        }
        int bytesRead = in.read(buffer, 0, bytes < buffer.length ? bytes : buffer.length);
        if (bytesRead == -1) {
            return -1;
        }
        int totalBytesRead = 0;
        while (bytes > 0 && bytesRead > 0) {
            totalBytesRead += bytesRead;
            out.write(buffer, 0, bytesRead);
            if ((bytes -= bytesRead) <= 0) continue;
            bytesRead = in.read(buffer, 0, bytes < buffer.length ? bytes : buffer.length);
        }
        return totalBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer toStringBuffer(Reader r) throws IOException {
        StringWriter out = new StringWriter();
        try {
            IOUtil.copyReader(r, out);
            StringBuffer stringBuffer = out.getBuffer();
            return stringBuffer;
        }
        finally {
            out.close();
        }
    }

    public static String toString(Reader r) throws IOException {
        return IOUtil.toStringBuffer(r).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adler32Hash(InputStream stream) throws IOException {
        ChecksumOutputStream out = ChecksumOutputStream.makeAdler32();
        try {
            IOUtil.copyInputStream(stream, out);
            int n = (int)out.getValue();
            return n;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int crc32Hash(InputStream stream) throws IOException {
        ChecksumOutputStream out = ChecksumOutputStream.makeCRC32();
        try {
            IOUtil.copyInputStream(stream, out);
            int n = (int)out.getValue();
            return n;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5Hash(InputStream stream) throws IOException {
        MessageDigestOutputStream out = MessageDigestOutputStream.makeMD5();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.digest();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha1Hash(InputStream stream) throws IOException {
        MessageDigestOutputStream out = MessageDigestOutputStream.makeSHA1();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.digest();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha256Hash(InputStream stream) throws IOException {
        MessageDigestOutputStream out = MessageDigestOutputStream.makeSHA256();
        try {
            IOUtil.copyInputStream(stream, out);
            byte[] byArray = out.digest();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    public static BufferedReader asBuffered(Reader r) {
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        return new BufferedReader(r);
    }

    public static BufferedWriter asBuffered(Writer w) {
        if (w instanceof BufferedWriter) {
            return (BufferedWriter)w;
        }
        return new BufferedWriter(w);
    }

    public static BufferedInputStream asBuffered(InputStream in) {
        if (in instanceof BufferedInputStream) {
            return (BufferedInputStream)in;
        }
        return new BufferedInputStream(in);
    }

    public static BufferedOutputStream asBuffered(OutputStream out) {
        if (out instanceof BufferedOutputStream) {
            return (BufferedOutputStream)out;
        }
        return new BufferedOutputStream(out);
    }

    public static void closeOnExit(InputStream in) {
        INPUT_STREAMS_TO_CLOSE.value().add(in);
    }

    public static void closeOnExit(OutputStream out) {
        OUTPUT_STREAMS_TO_CLOSE.value().add(out);
    }

    public static void closeOnExit(Reader r) {
        READERS_TO_CLOSE.value().add(r);
    }

    public static void closeOnExit(Writer w) {
        WRITERS_TO_CLOSE.value().add(w);
    }

    public static FilePredicate asFilePredicate(Predicate<? super File> p) {
        return new PredicateFilePredicate(p);
    }

    public static FilePredicate asFilePredicate(FileFilter filter) {
        return new FileFilterFilePredicate(filter);
    }

    public static FilePredicate regexFilePredicate(String regex) {
        return new RegexFilePredicate(regex);
    }

    public static FilePredicate regexFilePredicate(Pattern regex) {
        return new RegexFilePredicate(regex);
    }

    public static FilePredicate regexCanonicalCaseFilePredicate(String regex) {
        return new RegexCanonicalCaseFilePredicate(regex);
    }

    public static FilePredicate extensionFilePredicate(String extension) {
        return new RegexCanonicalCaseFilePredicate(new StringBuffer().append(".*\\.").append(IOUtil.canonicalCase(new File(extension)).getName()).toString());
    }

    public static FilePredicate sameNameFilePredicate(String name) {
        return new SamePathFilePredicate(new File(name));
    }

    public static FilePredicate samePathFilePredicate(File path) {
        return new SamePathFilePredicate(path);
    }

    public static FilePredicate sameAttributesFilePredicate(File f) throws FileNotFoundException {
        return new SameAttributesFilePredicate(f);
    }

    public static FilePredicate sameContentsFilePredicate(File f) throws IOException {
        return new SameContentsFilePredicate(f);
    }

    public static FilePredicate and(FileFilter ... filters) {
        return new AndFilePredicate((Iterable_)((Object)IterUtil.asIterable(filters)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static FilePredicate and(Iterable_ filters) {
        return new AndFilePredicate(filters);
    }

    public static FilePredicate or(FileFilter ... filters) {
        return new OrFilePredicate((Iterable_)((Object)IterUtil.asIterable(filters)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static FilePredicate or(Iterable_ filters) {
        return new OrFilePredicate(filters);
    }

    public static FilePredicate negate(FileFilter filter) {
        return new NegationFilePredicate(filter);
    }

    public static FilePredicate fileKey(File f) throws IOException {
        return IOUtil.and(IOUtil.samePathFilePredicate(IOUtil.attemptAbsoluteFile(f)), IOUtil.sameAttributesFilePredicate(f), IOUtil.sameContentsFilePredicate(f));
    }

    public static void replaceSystemOut(OutputStream substitute) {
        SYSTEM_OUT_STACK.addLast(System.out);
        if (substitute instanceof PrintStream) {
            System.setOut((PrintStream)substitute);
        } else {
            System.setOut(new PrintStream(substitute));
        }
    }

    public static void revertSystemOut() {
        if (SYSTEM_OUT_STACK.isEmpty()) {
            DebugUtil.error.logStack("Unbalanced call to revertSystemOut");
        } else {
            System.setOut(SYSTEM_OUT_STACK.removeLast());
        }
    }

    public static void replaceSystemErr(OutputStream substitute) {
        SYSTEM_ERR_STACK.addLast(System.err);
        if (substitute instanceof PrintStream) {
            System.setErr((PrintStream)substitute);
        } else {
            System.setErr(new PrintStream(substitute));
        }
    }

    public static void revertSystemErr() {
        if (SYSTEM_ERR_STACK.isEmpty()) {
            DebugUtil.error.logStack("Unbalanced call to revertSystemErr");
        } else {
            System.setErr(SYSTEM_ERR_STACK.removeLast());
        }
    }

    public static void replaceSystemIn(InputStream substitute) {
        SYSTEM_IN_STACK.addLast(System.in);
        System.setIn(substitute);
    }

    public static void revertSystemIn() {
        if (SYSTEM_IN_STACK.isEmpty()) {
            DebugUtil.error.logStack("Unbalanced call to revertSystemIn");
        } else {
            System.setIn(SYSTEM_IN_STACK.removeLast());
        }
    }

    static boolean access$000(File x0, RecursionStack x1) {
        return IOUtil.deleteRecursively(x0, x1);
    }

    static void access$100(File x0, RecursionStack x1) {
        IOUtil.deleteOnExitRecursively(x0, x1);
    }

    static Iterable_ access$200(File x0, FileFilter x1, FileFilter x2, RecursionStack x3) {
        return IOUtil.listFilesRecursively((File)x0, (FileFilter)x1, (FileFilter)x2, (RecursionStack)x3);
    }

    static Thunk access$300() {
        return INPUT_STREAMS_TO_CLOSE;
    }

    static Thunk access$400() {
        return OUTPUT_STREAMS_TO_CLOSE;
    }

    static Thunk access$500() {
        return READERS_TO_CLOSE;
    }

    static Thunk access$600() {
        return WRITERS_TO_CLOSE;
    }

    private static final class NegationFilePredicate
    implements FilePredicate,
    Serializable {
        private final FileFilter _filter;

        public NegationFilePredicate(FileFilter filter) {
            this._filter = filter;
        }

        public boolean accept(File f) {
            return !this._filter.accept(f);
        }

        public boolean contains(File f) {
            return !this._filter.accept(f);
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrFilePredicate
    implements FilePredicate,
    Serializable {
        private final Iterable<? extends FileFilter> _filters;

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public OrFilePredicate(Iterable_ filters) {
            this._filters = filters;
        }

        @Override
        public boolean accept(File f) {
            Iterator i$ = IterableMethods.iterator(this._filters);
            while (i$.hasNext()) {
                FileFilter filter = (FileFilter)i$.next();
                if (!filter.accept(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(File f) {
            return this.accept(f);
        }

        @Override
        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AndFilePredicate
    implements FilePredicate,
    Serializable {
        private final Iterable<? extends FileFilter> _filters;

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public AndFilePredicate(Iterable_ filters) {
            this._filters = filters;
        }

        @Override
        public boolean accept(File f) {
            Iterator i$ = IterableMethods.iterator(this._filters);
            while (i$.hasNext()) {
                FileFilter filter = (FileFilter)i$.next();
                if (filter.accept(f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(File f) {
            return this.accept(f);
        }

        @Override
        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    private static final class IsDirectoryFilePredicate
    implements FilePredicate,
    Serializable {
        private IsDirectoryFilePredicate() {
        }

        public boolean accept(File f) {
            return IOUtil.attemptIsDirectory(f);
        }

        public boolean contains(File f) {
            return IOUtil.attemptIsDirectory(f);
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }

        IsDirectoryFilePredicate(1 x0) {
            this();
        }
    }

    private static final class IsFileFilePredicate
    implements FilePredicate,
    Serializable {
        private IsFileFilePredicate() {
        }

        public boolean accept(File f) {
            return IOUtil.attemptIsFile(f);
        }

        public boolean contains(File f) {
            return IOUtil.attemptIsFile(f);
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }

        IsFileFilePredicate(1 x0) {
            this();
        }
    }

    private static final class SameContentsFilePredicate
    implements FilePredicate,
    Serializable {
        private final long _length;
        private final int _hash;

        public SameContentsFilePredicate(File f) throws IOException {
            this._length = IOUtil.attemptLength(f);
            this._hash = IOUtil.crc32Hash(f);
        }

        public boolean accept(File f) {
            long fLength = IOUtil.attemptLength(f);
            if (fLength > 0L && this._length > 0L && fLength != this._length) {
                return false;
            }
            try {
                return this._hash == IOUtil.crc32Hash(f);
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean contains(File f) {
            return this.accept(f);
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    private static final class SameAttributesFilePredicate
    implements FilePredicate,
    Serializable {
        private final long _lastModified;
        private final long _length;
        private final boolean _canRead;
        private final boolean _canWrite;

        public SameAttributesFilePredicate(File f) throws FileNotFoundException {
            try {
                if (!f.isFile()) {
                    throw new FileNotFoundException(f + " is not a valid file");
                }
                this._lastModified = f.lastModified();
                if (this._lastModified == 0L) {
                    throw new FileNotFoundException("Can't get valid modification date for " + f);
                }
                this._length = f.length();
                this._canRead = f.canRead();
                this._canWrite = f.canWrite();
            }
            catch (SecurityException e) {
                throw new FileNotFoundException(e.getMessage());
            }
        }

        public boolean accept(File f) {
            try {
                return f.isFile() && f.lastModified() == this._lastModified && f.length() == this._length && f.canRead() == this._canRead && f.canWrite() == this._canWrite;
            }
            catch (SecurityException e) {
                return false;
            }
        }

        public boolean contains(File f) {
            return this.accept(f);
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    private static final class SamePathFilePredicate
    implements FilePredicate,
    Serializable {
        private final File _f;

        public SamePathFilePredicate(File f) {
            this._f = IOUtil.canonicalCase(f);
        }

        public boolean accept(File f) {
            File candidate = IOUtil.canonicalCase(IOUtil.attemptAbsoluteFile(f));
            for (File compareTo = this._f; compareTo != null; compareTo = compareTo.getParentFile()) {
                if (candidate == null || !compareTo.getName().equals(candidate.getName())) {
                    return false;
                }
                candidate = candidate.getParentFile();
            }
            return true;
        }

        public boolean contains(File f) {
            return this.accept(f);
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    private static final class RegexCanonicalCaseFilePredicate
    implements FilePredicate,
    Serializable {
        private final Pattern _regex;

        public RegexCanonicalCaseFilePredicate(String regex) {
            this._regex = Pattern.compile(regex);
        }

        public RegexCanonicalCaseFilePredicate(Pattern regex) {
            this._regex = regex;
        }

        public boolean accept(File f) {
            return this._regex.matcher(IOUtil.canonicalCase(f).getName()).matches();
        }

        public boolean contains(File f) {
            return this._regex.matcher(IOUtil.canonicalCase(f).getName()).matches();
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    private static final class RegexFilePredicate
    implements FilePredicate,
    Serializable {
        private final Pattern _regex;

        public RegexFilePredicate(String regex) {
            this._regex = Pattern.compile(regex);
        }

        public RegexFilePredicate(Pattern regex) {
            this._regex = regex;
        }

        public boolean accept(File f) {
            return this._regex.matcher(f.getName()).matches();
        }

        public boolean contains(File f) {
            return this._regex.matcher(f.getName()).matches();
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    private static final class FileFilterFilePredicate
    implements FilePredicate,
    Serializable {
        private final FileFilter _filter;

        public FileFilterFilePredicate(FileFilter filter) {
            this._filter = filter;
        }

        public boolean accept(File f) {
            return this._filter.accept(f);
        }

        public boolean contains(File f) {
            return this._filter.accept(f);
        }

        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PredicateFilePredicate
    implements FilePredicate,
    Serializable {
        private final Predicate<? super File> _p;

        public PredicateFilePredicate(Predicate<? super File> p) {
            this._p = p;
        }

        @Override
        public boolean accept(File f) {
            return this._p.contains(f);
        }

        @Override
        public boolean contains(File f) {
            return this._p.contains(f);
        }

        @Override
        public boolean contains(Object x0) {
            return this.contains((File)x0);
        }
    }
}

