/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.io.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class DirectInputStream
extends InputStream {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;

    public int read() throws IOException {
        byte[] bbuf = new byte[1];
        int readResult = this.read(bbuf, 0, 1);
        if (readResult == -1) {
            return readResult;
        }
        if (readResult == 1) {
            return bbuf[0];
        }
        throw new IOException("Unexpected read result: " + readResult);
    }

    public int read(byte[] bbuf) throws IOException {
        return this.read(bbuf, 0, bbuf.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int read(OutputStream out, int bytes) throws IOException {
        return this.read(out, bytes, bytes < 1024 ? bytes : 1024);
    }

    public int read(OutputStream out, int bytes, int bufferSize) throws IOException {
        return this.read(out, bytes, new byte[bufferSize]);
    }

    public int read(OutputStream out, int bytes, byte[] buffer) throws IOException {
        return IOUtil.doWriteFromInputStream(this, out, bytes, buffer);
    }

    public int readAll(OutputStream out) throws IOException {
        return this.readAll(out, 1024);
    }

    public int readAll(OutputStream out, int bufferSize) throws IOException {
        return this.readAll(out, new byte[bufferSize]);
    }

    public int readAll(OutputStream out, byte[] buffer) throws IOException {
        return IOUtil.doCopyInputStream(this, out, buffer);
    }
}

