/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.debug.AbstractLog;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.swing.ShadedTreeCellRenderer;
import edu.rice.cs.plt.swing.SwingUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLog
extends AbstractLog {
    private final Thunk<Viewer> _viewer;

    public TreeLog(String name) {
        this._viewer = this.makeViewerThunk(name);
    }

    public TreeLog(String name, Predicate2<? super Thread, ? super StackTraceElement> filter) {
        super(filter);
        this._viewer = this.makeViewerThunk(name);
    }

    private Thunk<Viewer> makeViewerThunk(String name) {
        return LazyThunk.make(ConcurrentUtil.computeInProcess(new MakeViewerTask(name), false));
    }

    @Override
    protected void pop() {
        try {
            this._viewer.value().pop();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    protected void push() {
        try {
            this._viewer.value().push();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    protected void write(Date time, Thread thread, StackTraceElement location, SizedIterable<? extends String> messages) {
        try {
            this._viewer.value().write(this.formatTime(time), this.formatThread(thread), this.formatLocation(location), IterUtil.snapshot(messages));
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private final String _time;
        private final String _thread;
        private final String _location;
        private final SizedIterable<? extends String> _messages;
        private int _descendents;
        private static final Entry ROOT = new Entry("<root>", "<root>", "<root>", IterUtil.empty());

        public Entry(String time, String thread, String location, SizedIterable<? extends String> messages) {
            this._time = time;
            this._thread = thread;
            this._location = location;
            this._messages = messages;
            this._descendents = 0;
        }

        public int descendents() {
            return this._descendents;
        }

        public String time() {
            return this._time;
        }

        public String thread() {
            return this._thread;
        }

        public String location() {
            return this._location;
        }

        public SizedIterable<? extends String> messages() {
            return this._messages;
        }

        public void incrementDescendents() {
            ++this._descendents;
        }

        public String toString() {
            return new StringBuffer().append(this._location).append(" ").append(this._time).toString();
        }

        static Entry access$000() {
            return ROOT;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViewerImpl
    implements Viewer {
        private final LinkedList<DefaultMutableTreeNode> _stack;
        private boolean _pop;
        private final DefaultTreeModel _treeModel;
        private volatile long _lastPainted;

        public ViewerImpl(final String name) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(Entry.access$000());
            this._stack = new LinkedList();
            this._stack.addFirst(root);
            this._pop = false;
            this._treeModel = new DefaultTreeModel(root);
            this._lastPainted = 0L;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JFrame frame = SwingUtil.makeMainApplicationFrame(name, 600, 600);
                    final JTree tree = new JTree(ViewerImpl.access$100(ViewerImpl.this)){

                        public void paint(Graphics g) {
                            super.paint(g);
                            ViewerImpl.access$202(ViewerImpl.this, System.currentTimeMillis());
                        }
                    };
                    tree.setRootVisible(false);
                    tree.setShowsRootHandles(true);
                    tree.setRowHeight(0);
                    ViewerImpl.access$100(ViewerImpl.this).addTreeModelListener(new TreeModelListener(){

                        public void treeNodesInserted(TreeModelEvent e) {
                            ViewerImpl.access$100(ViewerImpl.this).removeTreeModelListener(this);
                            tree.expandPath(e.getTreePath());
                        }

                        public void treeNodesChanged(TreeModelEvent e) {
                        }

                        public void treeNodesRemoved(TreeModelEvent e) {
                        }

                        public void treeStructureChanged(TreeModelEvent e) {
                        }
                    });
                    final JPanel entryCell = SwingUtil.makeVerticalBoxPanel(3, 5);
                    JPanel top = SwingUtil.makeHorizontalBoxPanel();
                    final JPanel bottom = SwingUtil.makeBorderPanel(3, 15, 0, 0);
                    SwingUtil.setOpaque(false, top, bottom);
                    SwingUtil.setLeftAlignment(top, bottom);
                    SwingUtil.add(entryCell, top, bottom);
                    final JLabel location = new JLabel();
                    final JLabel time = new JLabel();
                    final JLabel descendents = new JLabel();
                    final JTextArea messages = new JTextArea();
                    SwingUtil.setMonospacedFont(12, location, time, descendents, messages);
                    SwingUtil.setEmptyBorder(0, 10, 0, 0, location, descendents);
                    messages.setOpaque(false);
                    SwingUtil.add(top, time, location, descendents);
                    bottom.add(messages);
                    tree.setCellRenderer(new TreeCellRenderer(){

                        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                            Entry e = (Entry)((DefaultMutableTreeNode)value).getUserObject();
                            if (e.descendents() == 0) {
                                descendents.setVisible(false);
                            } else {
                                descendents.setVisible(true);
                                descendents.setText("(" + e.descendents() + ")");
                            }
                            time.setText(e.time());
                            location.setText(e.location());
                            messages.setText(IterUtil.multilineToString(e.messages()));
                            bottom.setVisible(!messages.getText().equals(""));
                            return entryCell;
                        }
                    });
                    ShadedTreeCellRenderer.shadeTree(tree, SwingUtil.gray(0.1f), SwingUtil.gray(0.03f));
                    frame.getContentPane().add(new JScrollPane(tree));
                    SwingUtil.displayWindow(frame);
                }
            });
        }

        @Override
        public void write(final String time, final String thread, final String location, final SizedIterable<? extends String> messages) {
            if (System.currentTimeMillis() - this._lastPainted > 200L) {
                SwingUtil.attemptClearEventQueue();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Entry entry = new Entry(time, thread, location, messages);
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)ViewerImpl.access$300(ViewerImpl.this).getFirst();
                    ViewerImpl.access$100(ViewerImpl.this).insertNodeInto(new DefaultMutableTreeNode(entry), parent, parent.getChildCount());
                    Iterator i$ = ViewerImpl.access$300(ViewerImpl.this).iterator();
                    while (i$.hasNext()) {
                        DefaultMutableTreeNode ancestor = (DefaultMutableTreeNode)i$.next();
                        ((Entry)ancestor.getUserObject()).incrementDescendents();
                        ViewerImpl.access$100(ViewerImpl.this).nodeChanged(ancestor);
                    }
                    if (ViewerImpl.access$400(ViewerImpl.this)) {
                        ViewerImpl.access$300(ViewerImpl.this).removeFirst();
                        ViewerImpl.access$402(ViewerImpl.this, false);
                    }
                }
            });
        }

        @Override
        public void push() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ViewerImpl.access$300(ViewerImpl.this).addFirst((DefaultMutableTreeNode)((DefaultMutableTreeNode)ViewerImpl.access$300(ViewerImpl.this).getFirst()).getLastChild());
                }
            });
        }

        @Override
        public void pop() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ViewerImpl.access$300(ViewerImpl.this).size() > 1) {
                        ViewerImpl.access$402(ViewerImpl.this, true);
                    }
                }
            });
        }

        static DefaultTreeModel access$100(ViewerImpl x0) {
            return x0._treeModel;
        }

        static long access$202(ViewerImpl x0, long x1) {
            x0._lastPainted = x1;
            return x0._lastPainted;
        }

        static LinkedList access$300(ViewerImpl x0) {
            return x0._stack;
        }

        static boolean access$400(ViewerImpl x0) {
            return x0._pop;
        }

        static boolean access$402(ViewerImpl x0, boolean x1) {
            x0._pop = x1;
            return x0._pop;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class MakeViewerTask
    implements Thunk<Viewer>,
    Serializable {
        private final String _name;

        public MakeViewerTask(String name) {
            this._name = name;
        }

        @Override
        public Viewer value() {
            try {
                return (Viewer)UnicastRemoteObject.exportObject((Remote)new ViewerImpl(this._name), 0);
            }
            catch (RemoteException e) {
                throw new WrappedException(e);
            }
        }

        @Override
        public Object value() {
            return this.value();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Viewer
    extends Remote {
        public void write(String var1, String var2, String var3, SizedIterable<? extends String> var4) throws RemoteException;

        public void push() throws RemoteException;

        public void pop() throws RemoteException;
    }
}

