/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.TextLog;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.lambda.WrappedException;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamLog
extends TextLog {
    private final String _charset;
    private volatile BufferedWriter _writer;

    public OutputStreamLog(OutputStream out) {
        this._charset = null;
        this._writer = new BufferedWriter(new OutputStreamWriter(out));
    }

    public OutputStreamLog(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        this._charset = charsetName;
        this._writer = new BufferedWriter(new OutputStreamWriter(out, charsetName));
    }

    public OutputStreamLog(OutputStream out, Predicate2<? super Thread, ? super StackTraceElement> filter) {
        super(filter);
        this._charset = null;
        this._writer = new BufferedWriter(new OutputStreamWriter(out));
    }

    public OutputStreamLog(OutputStream out, String charsetName, Predicate2<? super Thread, ? super StackTraceElement> filter) throws UnsupportedEncodingException {
        super(filter);
        this._charset = charsetName;
        this._writer = new BufferedWriter(new OutputStreamWriter(out, charsetName));
    }

    public void switchStream(OutputStream newOut) {
        if (this._charset == null) {
            this._writer = new BufferedWriter(new OutputStreamWriter(newOut));
        } else {
            try {
                this._writer = new BufferedWriter(new OutputStreamWriter(newOut, this._charset));
            }
            catch (UnsupportedEncodingException e) {
                throw new WrappedException(e);
            }
        }
    }

    @Override
    protected synchronized void write(Date time, Thread thread, StackTraceElement location, SizedIterable<? extends String> messages) {
        this.writeText(this._writer, time, thread, location, messages);
    }
}

