/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.collect.TotalMap;
import edu.rice.cs.plt.concurrent.ReaderWriterLock;
import edu.rice.cs.plt.debug.TextLog;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Pair;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLog
extends TextLog {
    private final Set<Pair<String, File>> _files = new HashSet<Pair<String, File>>();
    private final ReaderWriterLock _filesLock = new ReaderWriterLock();
    private final TotalMap<File, BufferedWriter> _writers = new TotalMap<File, BufferedWriter>(OPEN_WRITER, true);
    private static final Lambda<File, BufferedWriter> OPEN_WRITER = new Lambda<File, BufferedWriter>(){

        @Override
        public BufferedWriter value(File f) {
            try {
                BufferedWriter result = new BufferedWriter(new FileWriter(f, true));
                IOUtil.closeOnExit(result);
                String stars = TextUtil.repeat('*', 40);
                result.write(stars);
                result.newLine();
                result.write(new StringBuffer().append("Opened log file ").append(new Date()).toString());
                result.newLine();
                result.write(stars);
                result.newLine();
                result.newLine();
                result.flush();
                return result;
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }

        @Override
        public Object value(Object x0) {
            return this.value((File)x0);
        }
    };

    public FileLog() {
    }

    public FileLog(File topLevelFile) {
        this();
        this.addFile(topLevelFile, "");
    }

    public FileLog(String topLevelFileName) {
        this(new File(topLevelFileName));
    }

    public FileLog(Predicate2<? super Thread, ? super StackTraceElement> filter) {
        super(filter);
    }

    public FileLog(File topLevelFile, Predicate2<? super Thread, ? super StackTraceElement> filter) {
        this(filter);
        this.addFile(topLevelFile, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File f, String ... prefixes) {
        this._filesLock.startWrite();
        try {
            File canonical = IOUtil.attemptCanonicalFile(f);
            for (String p : prefixes) {
                this._files.add(Pair.make(p, canonical));
            }
        }
        finally {
            this._filesLock.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void write(Date time, Thread thread, StackTraceElement location, SizedIterable<? extends String> messages) {
        String caller = new StringBuffer().append(location.getClassName()).append(".").append(location.getMethodName()).toString();
        this._filesLock.startRead();
        try {
            for (Pair<String, File> p : this._files) {
                BufferedWriter w;
                if (!caller.startsWith(p.first())) continue;
                Object object = this._writers;
                synchronized (object) {
                    w = this._writers.get(p.second());
                }
                object = w;
                synchronized (object) {
                    this.writeText(w, time, thread, location, messages);
                }
            }
            return;
        }
        finally {
            this._filesLock.endRead();
        }
    }
}

