/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSequence<T>
extends AbstractIterable<T>
implements SizedIterable<T> {
    private final List<T> _events = new LinkedList<T>();

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this._events.size();
    }

    @Override
    public int size(int bound) {
        return IterUtil.sizeOf(this._events, bound);
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>(this._events.iterator());
    }

    public void record(T ... events) {
        this.record((Iterable_)((Object)Arrays.asList(events)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(Iterable_ events) {
        List<T> list = this._events;
        synchronized (list) {
            this._events.addAll(CollectUtil.asCollection(events));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertEmpty() {
        List<T> list = this._events;
        synchronized (list) {
            if (!this._events.isEmpty()) {
                throw new AssertionError((Object)new StringBuffer().append("Unexpected event: ").append(this._events.get(0)).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertEmpty(String message) {
        List<T> list = this._events;
        synchronized (list) {
            if (!this._events.isEmpty()) {
                throw new AssertionError((Object)message);
            }
        }
    }

    public void assertOccurance(T ... expectedEvents) {
        this.assertOccurance((Iterable_)((Object)Arrays.asList(expectedEvents)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public void assertOccurance(Iterable_ expectedEvents) {
        Option missing = this.checkOccurance(expectedEvents);
        if (missing.isSome()) {
            throw new AssertionError((Object)new StringBuffer().append("Event ").append(missing.unwrap()).append(" did not occur").toString());
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public void assertOccurance(String message, Iterable_ expectedEvents) {
        Option missing = this.checkOccurance(expectedEvents);
        if (missing.isSome()) {
            throw new AssertionError((Object)message);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option checkOccurance(Iterable_ expectedEvents) {
        Option<Object> missing = Option.none();
        List<T> list = this._events;
        synchronized (list) {
            Iterator i$ = IterableMethods.iterator(expectedEvents);
            while (i$.hasNext()) {
                Object expected = i$.next();
                boolean removed = this._events.remove(expected);
                if (removed || !missing.isNone()) continue;
                missing = Option.some(expected);
            }
        }
        return missing;
    }

    public void assertSequence(T ... expectedEvents) {
        this.assertSequence((Iterable_)((Object)Arrays.asList(expectedEvents)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public void assertSequence(Iterable_ expectedEvents) {
        Option mismatched = this.checkSequence(expectedEvents);
        if (mismatched.isSome()) {
            Pair pair = (Pair)mismatched.unwrap();
            if (((Option)pair.second()).isSome()) {
                throw new AssertionError((Object)new StringBuffer().append("Unexpected event.  Expected: ").append(pair.first()).append("; Actual: ").append(((Option)pair.second()).unwrap()).toString());
            }
            throw new AssertionError((Object)new StringBuffer().append("Event ").append(pair.first()).append(" did not occur").toString());
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public void assertSequence(String message, Iterable_ expectedEvents) {
        Option mismatched = this.checkSequence(expectedEvents);
        if (mismatched.isSome()) {
            throw new AssertionError((Object)message);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option checkSequence(Iterable_ expectedEvents) {
        Iterator expected = IterableMethods.iterator(expectedEvents);
        List<T> list = this._events;
        synchronized (list) {
            Iterator<T> actual = this._events.iterator();
            while (expected.hasNext() && actual.hasNext()) {
                Object exp = expected.next();
                T act = actual.next();
                if (exp == null ? act == null : exp.equals(act)) {
                    actual.remove();
                    continue;
                }
                return Option.some(Pair.make(exp, Option.some(act)));
            }
        }
        if (expected.hasNext()) {
            return Option.some(Pair.make(expected.next(), Option.none()));
        }
        return Option.none();
    }

    public void assertContents(T ... expectedEvents) {
        this.assertContents((Iterable_)((Object)Arrays.asList(expectedEvents)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public void assertContents(Iterable_ expectedEvents) {
        this.assertSequence(expectedEvents);
        if (!this._events.isEmpty()) {
            throw new AssertionError((Object)new StringBuffer().append("Unexpected additional event: ").append(this._events.get(0)).toString());
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public void assertContents(String message, Iterable_ expectedEvents) {
        this.assertSequence(message, expectedEvents);
        if (!this._events.isEmpty()) {
            throw new AssertionError((Object)message);
        }
    }
}

