/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.AssertEmptyLog;
import edu.rice.cs.plt.debug.FileLog;
import edu.rice.cs.plt.debug.Log;
import edu.rice.cs.plt.debug.LogSplitter;
import edu.rice.cs.plt.debug.PopupLog;
import edu.rice.cs.plt.debug.SystemErrLog;
import edu.rice.cs.plt.debug.SystemOutLog;
import edu.rice.cs.plt.debug.TreeLog;
import edu.rice.cs.plt.debug.VoidLog;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.text.TextUtil;
import java.io.File;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebugUtil {
    public static volatile Log debug;
    public static volatile Log error;
    private static final File DEFAULT_DEBUG_FILE;
    private static final File DEFAULT_ERROR_FILE;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$plt$debug$DebugUtil;

    private DebugUtil() {
    }

    public static void initializeLogs() {
        String debugProp = System.getProperty("plt.debug.log");
        debug = debugProp == null ? VoidLog.INSTANCE : DebugUtil.makeLog(debugProp, "Debug");
        String errorProp = System.getProperty("plt.error.log");
        error = errorProp == null ? VoidLog.INSTANCE : DebugUtil.makeLog(errorProp, "Error");
    }

    private static Log makeLog(String type, String tag) {
        int dot;
        if (type != null && TextUtil.contains(type, 44)) {
            String[] types = type.split(",");
            if (types.length == 0) {
                return DebugUtil.makeLog(null, tag);
            }
            Log[] logs = new Log[types.length];
            for (int i = 0; i < logs.length; ++i) {
                logs[i] = DebugUtil.makeLog(types[i], tag);
            }
            return new LogSplitter(logs);
        }
        Log result = null;
        String factoryName = System.getProperty("plt.log.factory");
        if (factoryName != null && (dot = factoryName.lastIndexOf(46)) >= 0) {
            String className = factoryName.substring(0, dot);
            String methodName = factoryName.substring(dot + 1);
            try {
                result = (Log)ReflectUtil.invokeStaticMethod(className, methodName, new Object[0]);
            }
            catch (ReflectException e) {
                System.err.println(new StringBuffer().append("Unable to invoke plt.log.factory: ").append(e.getCause()).toString());
            }
            catch (ClassCastException e) {
                System.err.println(new StringBuffer().append("Unable to invoke plt.log.factory: ").append(e).toString());
            }
        }
        if (result == null) {
            try {
                result = type.equals("void") ? VoidLog.INSTANCE : (type.equals("System.out") ? new SystemOutLog() : (type.startsWith("System.out:") ? new SystemOutLog(DebugUtil.getParam(type)) : (type.equals("stdout") ? new SystemOutLog() : (type.startsWith("stdout:") ? new SystemOutLog(DebugUtil.getParam(type)) : (type.equals("System.err") ? new SystemErrLog() : (type.startsWith("System.err:") ? new SystemErrLog(DebugUtil.getParam(type)) : (type.equals("stderr") ? new SystemErrLog() : (type.startsWith("stderr") ? new SystemErrLog(DebugUtil.getParam(type)) : (type.equals("file") ? DebugUtil.makeFileLog(new StringBuffer().append(tag.toLowerCase()).append("-log.txt").toString()) : (type.startsWith("file:") ? DebugUtil.makeFileLog(DebugUtil.getParam(type)) : (type.equals("assert") ? new AssertEmptyLog() : (type.equals("popup") ? new PopupLog(new StringBuffer().append(tag).append(" Log").toString()) : (type.equals("tree") ? new TreeLog(new StringBuffer().append(tag).append(" Log").toString()) : VoidLog.INSTANCE)))))))))))));
            }
            catch (Exception e) {
                result = VoidLog.INSTANCE;
            }
        }
        return result;
    }

    private static String getParam(String logProperty) {
        String result = TextUtil.removePrefix(logProperty, 58);
        return result == logProperty ? null : result;
    }

    private static Log makeFileLog(String name) {
        String workingDir = System.getProperty("plt.log.working.dir");
        if (workingDir == null) {
            return new FileLog(new File(name));
        }
        return new FileLog(new File(workingDir, name));
    }

    public static Predicate2<Thread, StackTraceElement> blackListLocationFilter(final String ... prefixes) {
        return new Predicate2<Thread, StackTraceElement>(){

            @Override
            public boolean contains(Thread thread, StackTraceElement location) {
                String caller = new StringBuffer().append(location.getClassName()).append(".").append(location.getMethodName()).toString();
                for (String pre : prefixes) {
                    if (!caller.startsWith(pre)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean contains(Object x0, Object x1) {
                return this.contains((Thread)x0, (StackTraceElement)x1);
            }
        };
    }

    public static Predicate2<Thread, StackTraceElement> whiteListLocationFilter(final String ... prefixes) {
        return new Predicate2<Thread, StackTraceElement>(){

            @Override
            public boolean contains(Thread thread, StackTraceElement location) {
                String caller = new StringBuffer().append(location.getClassName()).append(".").append(location.getMethodName()).toString();
                for (String pre : prefixes) {
                    if (!caller.startsWith(pre)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object x0, Object x1) {
                return this.contains((Thread)x0, (StackTraceElement)x1);
            }
        };
    }

    public static Predicate2<Thread, StackTraceElement> blackListThreadFilter(final Thread ... threads) {
        return new Predicate2<Thread, StackTraceElement>(){

            @Override
            public boolean contains(Thread thread, StackTraceElement location) {
                for (Thread t : threads) {
                    if (!thread.equals(t)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean contains(Object x0, Object x1) {
                return this.contains((Thread)x0, (StackTraceElement)x1);
            }
        };
    }

    public static Predicate2<Thread, StackTraceElement> whiteListThreadFilter(final Thread ... threads) {
        return new Predicate2<Thread, StackTraceElement>(){

            @Override
            public boolean contains(Thread thread, StackTraceElement location) {
                for (Thread t : threads) {
                    if (!thread.equals(t)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object x0, Object x1) {
                return this.contains((Thread)x0, (StackTraceElement)x1);
            }
        };
    }

    public static boolean check(boolean assertion) {
        if (!$assertionsDisabled && !assertion) {
            throw new AssertionError();
        }
        return assertion;
    }

    public static StackTraceElement getCaller() {
        try {
            return new Throwable().getStackTrace()[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("Stack trace information for caller is not available");
        }
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$plt$debug$DebugUtil == null ? (class$edu$rice$cs$plt$debug$DebugUtil = DebugUtil.class$("edu.rice.cs.plt.debug.DebugUtil")) : class$edu$rice$cs$plt$debug$DebugUtil).desiredAssertionStatus();
        DEFAULT_DEBUG_FILE = new File("debug-log.txt");
        DEFAULT_ERROR_FILE = new File("error-log.txt");
        DebugUtil.initializeLogs();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

