/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.debug.Log;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.BinaryMappedIterable;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SkipFirstIterable;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.recur.RecurUtil;
import edu.rice.cs.plt.text.TextUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLog
implements Log {
    private static final SizedIterable<String> EMPTY_MESSAGE = IterUtil.singleton("");
    private static final SizedIterable<String> START_MESSAGE = IterUtil.singleton("Starting");
    private static final SizedIterable<String> END_MESSAGE = IterUtil.singleton("Ending");
    private static final int IDEAL_LINE_WIDTH = 120;
    private static final DateFormat TIME_FORMATTER = new SimpleDateFormat("H:mm:ss.SSS");
    protected final Predicate2<? super Thread, ? super StackTraceElement> _filter;
    private static final Lambda2<String, Object, SizedIterable<String>> PROCESS_VALUE = new Lambda2<String, Object, SizedIterable<String>>(){

        @Override
        public SizedIterable<String> value(String name, Object val) {
            return AbstractLog.access$000(name, val);
        }

        @Override
        public Object value(Object x0, Object x1) {
            return this.value((String)x0, x1);
        }
    };

    protected AbstractLog() {
        this._filter = LambdaUtil.TRUE;
    }

    protected AbstractLog(Predicate2<? super Thread, ? super StackTraceElement> filter) {
        this._filter = filter;
    }

    @Override
    public void log() {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, EMPTY_MESSAGE);
        }
    }

    @Override
    public void log(String message) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, AbstractLog.processText(message));
        }
    }

    @Override
    public void log(Throwable t) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, AbstractLog.processThrowable(t));
        }
    }

    @Override
    public void log(String message, Throwable t) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            Date now = new Date();
            ComposedIterable ms = IterUtil.compose(AbstractLog.processText(message), AbstractLog.processThrowable(t));
            this.write(now, th, e, ms);
        }
    }

    @Override
    public void logStart() {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, START_MESSAGE);
            this.push();
        }
    }

    @Override
    public void logStart(String message) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, AbstractLog.processText(new StringBuffer().append("Start ").append(message).toString()));
            this.push();
        }
    }

    @Override
    public void logStart(String name, Object value) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, IterUtil.compose(START_MESSAGE, AbstractLog.processValue(name, value)));
            this.push();
        }
    }

    @Override
    public void logStart(String message, String name, Object value) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            Date now = new Date();
            ComposedIterable ms = IterUtil.compose(AbstractLog.processText(new StringBuffer().append("Start ").append(message).toString()), AbstractLog.processValue(name, value));
            this.write(now, th, e, ms);
            this.push();
        }
    }

    @Override
    public void logStart(String[] names, Object ... values) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, IterUtil.compose(START_MESSAGE, AbstractLog.processValues(names, values)));
            this.push();
        }
    }

    @Override
    public void logStart(String message, String[] names, Object ... values) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            Date now = new Date();
            ComposedIterable ms = IterUtil.compose(AbstractLog.processText(new StringBuffer().append("Start ").append(message).toString()), AbstractLog.processValues(names, values));
            this.write(now, th, e, ms);
            this.push();
        }
    }

    @Override
    public void logEnd() {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.pop();
            this.write(new Date(), th, e, END_MESSAGE);
        }
    }

    @Override
    public void logEnd(String message) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.pop();
            this.write(new Date(), th, e, AbstractLog.processText(new StringBuffer().append("End ").append(message).toString()));
        }
    }

    @Override
    public void logEnd(String name, Object value) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.pop();
            this.write(new Date(), th, e, IterUtil.compose(END_MESSAGE, AbstractLog.processValue(name, value)));
        }
    }

    @Override
    public void logEnd(String message, String name, Object value) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.pop();
            Date now = new Date();
            ComposedIterable ms = IterUtil.compose(AbstractLog.processText(new StringBuffer().append("End ").append(message).toString()), AbstractLog.processValue(name, value));
            this.write(now, th, e, ms);
        }
    }

    @Override
    public void logEnd(String[] names, Object ... values) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.pop();
            this.write(new Date(), th, e, IterUtil.compose(END_MESSAGE, AbstractLog.processValues(names, values)));
        }
    }

    @Override
    public void logEnd(String message, String[] names, Object ... values) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.pop();
            Date now = new Date();
            ComposedIterable ms = IterUtil.compose(AbstractLog.processText(new StringBuffer().append("End ").append(message).toString()), AbstractLog.processValues(names, values));
            this.write(now, th, e, ms);
        }
    }

    @Override
    public void logStack() {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            ComposedIterable messages = IterUtil.compose("Current stack:", AbstractLog.processCurrentStack());
            this.write(new Date(), th, e, messages);
        }
    }

    @Override
    public void logStack(String message) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            ComposedIterable messages = IterUtil.compose(AbstractLog.processText(message), AbstractLog.processCurrentStack());
            this.write(new Date(), th, e, messages);
        }
    }

    @Override
    public void logValue(String name, Object value) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, AbstractLog.processValue(name, value));
        }
    }

    @Override
    public void logValue(String message, String name, Object value) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, IterUtil.compose(AbstractLog.processText(message), AbstractLog.processValue(name, value)));
        }
    }

    @Override
    public void logValues(String[] names, Object ... values) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, AbstractLog.processValues(names, values));
        }
    }

    @Override
    public void logValues(String message, String[] names, Object ... values) {
        StackTraceElement e;
        Thread th = Thread.currentThread();
        if (this._filter.contains(th, e = DebugUtil.getCaller())) {
            this.write(new Date(), th, e, IterUtil.compose(AbstractLog.processText(message), AbstractLog.processValues(names, values)));
        }
    }

    private static SizedIterable<String> processText(String text) {
        SizedIterable<String> result = TextUtil.getLines(text);
        if (result.size() == 0) {
            return EMPTY_MESSAGE;
        }
        return result;
    }

    private static SizedIterable<String> processThrowable(Throwable t) {
        return AbstractLog.processThrowable(t, false);
    }

    private static SizedIterable<String> processThrowable(Throwable t, boolean asCause) {
        if (t == null) {
            return IterUtil.singleton("null");
        }
        SizedIterable<Object> result = asCause ? IterUtil.make("", new StringBuffer().append("Caused by ").append(t).toString(), "at") : IterUtil.make(t.toString(), "at");
        result = IterUtil.compose(result, AbstractLog.processStack(IterUtil.asIterable(t.getStackTrace())));
        if (t.getCause() != null) {
            result = IterUtil.compose((Iterable_)((Object)result), AbstractLog.processThrowable(t.getCause()));
        }
        return result;
    }

    private static SizedIterable<String> processCurrentStack() {
        StackTraceElement[] stackArray = new Throwable().getStackTrace();
        SkipFirstIterable stack = IterUtil.skipFirst((Iterable_)((Object)IterUtil.skipFirst(IterUtil.asIterable(stackArray))));
        return AbstractLog.processStack(stack);
    }

    private static SizedIterable<String> processStack(SizedIterable<StackTraceElement> stack) {
        AbstractIterable result = IterUtil.empty();
        for (StackTraceElement e : stack) {
            result = IterUtil.compose(result, e.toString());
        }
        return result;
    }

    private static SizedIterable<String> processValue(String name, Object value) {
        SizedIterable<String> valStrings = AbstractLog.processText(RecurUtil.safeToString(value));
        if (valStrings.size() > 1 || ((String)IterUtil.first(valStrings)).length() > 120) {
            if (value instanceof Iterable_) {
                valStrings = AbstractLog.processText(IterUtil.multilineToString((Iterable_)value));
            } else if (value instanceof Collection) {
                valStrings = AbstractLog.processText(IterUtil.multilineToString((Iterable_)((Object)((Collection)value))));
            } else if (value instanceof Object[]) {
                valStrings = AbstractLog.processText(RecurUtil.arrayToString((Object[])value, RecurUtil.ArrayStringMode.SHALLOW_MULTILINE));
            }
        }
        if (valStrings.size() == 1) {
            return IterUtil.singleton(new StringBuffer().append(name).append(": ").append((String)IterUtil.first(valStrings)).toString());
        }
        return IterUtil.compose(new StringBuffer().append(name).append(":").toString(), valStrings);
    }

    private static SizedIterable<String> processValues(String[] names, Object ... values) {
        if (names.length == values.length) {
            SizedIterable<String> namesIter = IterUtil.asIterable(names);
            SizedIterable<Object> valuesIter = IterUtil.asIterable(values);
            BinaryMappedIterable messages = BinaryMappedIterable.make(namesIter, valuesIter, PROCESS_VALUE);
            return IterUtil.collapse((Iterable_)((Object)messages));
        }
        String err = new StringBuffer().append("Invalid invocation of logValues() with ").append(names.length).append(" names and ").append(values.length).append(" values").toString();
        return IterUtil.singleton(err);
    }

    protected String formatTime(Date time) {
        return TIME_FORMATTER.format(time);
    }

    protected String formatThread(Thread thread) {
        return new StringBuffer().append(thread.getName()).append(" ").append(System.identityHashCode(thread)).toString();
    }

    protected String formatLocation(StackTraceElement location) {
        StringBuffer result = new StringBuffer();
        result.append(location.getClassName());
        result.append(".");
        result.append(location.getMethodName());
        result.append("(");
        int line = location.getLineNumber();
        if (line >= 0) {
            result.append(line);
        } else if (location.isNativeMethod()) {
            result.append("native");
        } else {
            result.append("unknown");
        }
        result.append(")");
        return result.toString();
    }

    protected abstract void write(Date var1, Thread var2, StackTraceElement var3, SizedIterable<? extends String> var4);

    protected abstract void push();

    protected abstract void pop();

    static SizedIterable access$000(String x0, Object x1) {
        return AbstractLog.processValue(x0, x1);
    }
}

