/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractPredicateSet;
import edu.rice.cs.plt.collect.ComplementSet;
import edu.rice.cs.plt.iter.ComposedIterator;
import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionSet<E>
extends AbstractPredicateSet<E>
implements Composite,
Serializable {
    private final Set<? extends E> _set1;
    private final Set<? extends E> _set2;
    private final Set<? extends E> _set2Extras;

    public UnionSet(Set<? extends E> set1, Set<? extends E> set2) {
        this._set1 = set1;
        this._set2 = set2;
        this._set2Extras = new ComplementSet<E>(set2, set1);
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._set1, this._set2) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._set1, this._set2) + 1;
    }

    @Override
    public boolean contains(Object o) {
        return this._set1.contains(o) || this._set2.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator<E>(new ComposedIterator<E>(this._set1.iterator(), this._set2Extras.iterator()));
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._set1) || IterUtil.isInfinite(this._set2);
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._set1) && IterUtil.hasFixedSize(this._set2);
    }

    @Override
    public boolean isStatic() {
        return IterUtil.isStatic(this._set1) && IterUtil.isStatic(this._set2);
    }

    @Override
    public int size() {
        return this._set1.size() + this._set2Extras.size();
    }

    @Override
    public int size(int bound) {
        int size1 = IterUtil.sizeOf(this._set1, bound);
        int bound2 = bound - size1;
        int size2 = bound2 > 0 ? IterUtil.sizeOf(this._set2Extras, bound) : 0;
        return size1 + size2;
    }

    @Override
    public boolean isEmpty() {
        return this._set1.isEmpty() && this._set2.isEmpty();
    }
}

