/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractKeyBasedMap;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.UnionSet;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionMap<K, V>
extends AbstractKeyBasedMap<K, V>
implements Composite,
Serializable {
    private final Map<? extends K, ? extends V> _parent;
    private final Map<? extends K, ? extends V> _child;
    private final PredicateSet<K> _keys;

    public UnionMap(Map<? extends K, ? extends V> parent, Map<? extends K, ? extends V> child) {
        this._parent = parent;
        this._child = child;
        this._keys = new UnionSet<K>(parent.keySet(), child.keySet());
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._parent, this._child) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._parent, this._child) + 1;
    }

    @Override
    public V get(Object key) {
        if (this._child.containsKey(key)) {
            return this._child.get(key);
        }
        return this._parent.get(key);
    }

    @Override
    public PredicateSet<K> keySet() {
        return this._keys;
    }

    @Override
    public Set keySet() {
        return this.keySet();
    }
}

