/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractKeyBasedMap;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.SingletonSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonMap<K, V>
extends AbstractKeyBasedMap<K, V>
implements Serializable {
    private final K _key;
    private final V _value;

    public SingletonMap(K key, V value) {
        this._key = key;
        this._value = value;
    }

    @Override
    public V get(Object obj) {
        if (this._key == null ? obj == null : this._key.equals(obj)) {
            return this._value;
        }
        return null;
    }

    @Override
    public PredicateSet<K> keySet() {
        return new SingletonSet<K>(this._key);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object obj) {
        return this._key == null ? obj == null : this._key.equals(obj);
    }

    @Override
    public boolean containsValue(Object obj) {
        return this._value == null ? obj == null : this._value.equals(obj);
    }

    @Override
    public Collection<V> values() {
        return new SingletonSet<V>(this._value);
    }

    public static <K, V> SingletonMap<K, V> make(K key, V value) {
        return new SingletonMap<K, V>(key, value);
    }

    @Override
    public Set keySet() {
        return this.keySet();
    }
}

