/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.collect.AbstractRelation;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.ConcreteRelationIndex;
import edu.rice.cs.plt.collect.LazyRelationIndex;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.RelationIndex;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedRelation<T1, T2>
extends AbstractRelation<T1, T2>
implements Serializable {
    private final RelationIndex<T1, T2> _firstIndex;
    private final RelationIndex<T2, T1> _secondIndex;

    public IndexedRelation() {
        this(CollectUtil.hashMapFactory(), CollectUtil.hashSetFactory(4), CollectUtil.hashMapFactory(), CollectUtil.hashSetFactory(4));
    }

    public IndexedRelation(boolean indexSecond) {
        if (indexSecond) {
            this._firstIndex = this.makeFirstIndex(CollectUtil.<T1, PredicateSet<T2>>hashMapFactory(), CollectUtil.hashSetFactory(4));
            this._secondIndex = this.makeSecondIndex(CollectUtil.<T2, PredicateSet<T1>>hashMapFactory(), CollectUtil.hashSetFactory(4));
        } else {
            this._firstIndex = this.makeFirstIndex(CollectUtil.<T1, PredicateSet<T2>>hashMapFactory(), CollectUtil.hashSetFactory(4));
            this._secondIndex = new LazyRelationIndex<T2, T1>((Iterable_)((Object)IterUtil.map(this._firstIndex, Pair.inverter())));
        }
    }

    public IndexedRelation(Thunk<Map<T1, PredicateSet<T2>>> firstIndexFactory, Thunk<Set<T2>> firstIndexEntryFactory, Thunk<Map<T2, PredicateSet<T1>>> secondIndexFactory, Thunk<Set<T1>> secondIndexEntryFactory) {
        this._firstIndex = this.makeFirstIndex(firstIndexFactory, firstIndexEntryFactory);
        this._secondIndex = this.makeSecondIndex(secondIndexFactory, secondIndexEntryFactory);
    }

    public IndexedRelation(Thunk<Map<T1, PredicateSet<T2>>> firstIndexFactory, Thunk<Set<T2>> firstIndexEntryFactory) {
        this._firstIndex = this.makeFirstIndex(firstIndexFactory, firstIndexEntryFactory);
        this._secondIndex = new LazyRelationIndex<T2, T1>((Iterable_)((Object)IterUtil.map(this._firstIndex, Pair.inverter())));
    }

    private RelationIndex<T1, T2> makeFirstIndex(Thunk<Map<T1, PredicateSet<T2>>> mapFactory, Thunk<Set<T2>> setFactory) {
        return new ConcreteRelationIndex<T1, T2>(mapFactory, setFactory){

            @Override
            public void addToRelation(T1 first, T2 second) {
                IndexedRelation.access$000(IndexedRelation.this).added(second, first);
            }

            @Override
            public void removeFromRelation(T1 first, T2 second) {
                IndexedRelation.access$000(IndexedRelation.this).removed(second, first);
            }

            @Override
            public void clearRelation() {
                IndexedRelation.access$000(IndexedRelation.this).cleared();
            }
        };
    }

    private RelationIndex<T2, T1> makeSecondIndex(Thunk<Map<T2, PredicateSet<T1>>> mapFactory, Thunk<Set<T1>> setFactory) {
        return new ConcreteRelationIndex<T2, T1>(mapFactory, setFactory){

            @Override
            public void addToRelation(T2 second, T1 first) {
                IndexedRelation.access$100(IndexedRelation.this).added(first, second);
            }

            @Override
            public void removeFromRelation(T2 second, T1 first) {
                IndexedRelation.access$100(IndexedRelation.this).removed(first, second);
            }

            @Override
            public void clearRelation() {
                IndexedRelation.access$100(IndexedRelation.this).cleared();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this._firstIndex.isEmpty();
    }

    @Override
    public int size() {
        return this._firstIndex.size();
    }

    @Override
    public int size(int bound) {
        return this._firstIndex.size(bound);
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean contains(T1 first, T2 second) {
        return this._firstIndex.contains(first, second);
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof Pair) {
            Pair p = (Pair)obj;
            return this._firstIndex.contains(p.first(), p.second());
        }
        return false;
    }

    @Override
    public Iterator<Pair<T1, T2>> iterator() {
        return this._firstIndex.iterator();
    }

    @Override
    public PredicateSet<T1> firstSet() {
        return this._firstIndex.keys();
    }

    @Override
    public PredicateSet<T2> matchFirst(T1 first) {
        return this._firstIndex.match(first);
    }

    @Override
    public PredicateSet<T2> secondSet() {
        return this._secondIndex.keys();
    }

    @Override
    public PredicateSet<T1> matchSecond(T2 second) {
        return this._secondIndex.match(second);
    }

    @Override
    public boolean add(T1 first, T2 second) {
        boolean result;
        boolean bl = result = !this._firstIndex.contains(first, second);
        if (result) {
            this._firstIndex.added(first, second);
            this._secondIndex.added(second, first);
        }
        return result;
    }

    @Override
    public boolean remove(T1 first, T2 second) {
        boolean result = this._firstIndex.contains(first, second);
        if (result) {
            this._firstIndex.removed(first, second);
            this._secondIndex.removed(second, first);
        }
        return result;
    }

    @Override
    public void clear() {
        if (!this._firstIndex.isEmpty()) {
            this._firstIndex.cleared();
            this._secondIndex.cleared();
        }
    }

    public static <T1, T2> IndexedRelation<T1, T2> makeHashBased() {
        return new IndexedRelation<T1, T2>(CollectUtil.<T1, PredicateSet<T2>>hashMapFactory(), CollectUtil.hashSetFactory(4), CollectUtil.<T2, PredicateSet<T1>>hashMapFactory(), CollectUtil.hashSetFactory(4));
    }

    public static <T1, T2> IndexedRelation<T1, T2> makeLinkedHashBased() {
        return new IndexedRelation<T1, T2>(CollectUtil.<T1, PredicateSet<T2>>linkedHashMapFactory(), CollectUtil.linkedHashSetFactory(4), CollectUtil.<T2, PredicateSet<T1>>linkedHashMapFactory(), CollectUtil.linkedHashSetFactory(4));
    }

    public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>> IndexedRelation<T1, T2> makeTreeBased() {
        return new IndexedRelation<T1, T2>(CollectUtil.<T1, PredicateSet<T2>>treeMapFactory(), CollectUtil.<T2>treeSetFactory(), CollectUtil.<T2, PredicateSet<T1>>treeMapFactory(), CollectUtil.<T1>treeSetFactory());
    }

    static RelationIndex access$000(IndexedRelation x0) {
        return x0._secondIndex;
    }

    static RelationIndex access$100(IndexedRelation x0) {
        return x0._firstIndex;
    }
}

