/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.collect.AbstractInjectiveRelation;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.ConcreteRelationIndex;
import edu.rice.cs.plt.collect.ImmutableMap;
import edu.rice.cs.plt.collect.LambdaMap;
import edu.rice.cs.plt.collect.LazyRelationIndex;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.RelationIndex;
import edu.rice.cs.plt.lambda.Thunk;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedInjectiveRelation<T1, T2>
extends AbstractInjectiveRelation<T1, T2>
implements Serializable {
    private RelationIndex<T1, T2> _firstIndex;
    private Map<T2, T1> _secondMap;
    private LambdaMap<T2, T1> _injectionMap;

    public IndexedInjectiveRelation() {
        this(CollectUtil.hashMapFactory(), CollectUtil.hashMapFactory(), CollectUtil.hashSetFactory(4));
    }

    public IndexedInjectiveRelation(boolean indexFirst) {
        if (indexFirst) {
            this._secondMap = new HashMap<T2, T1>();
            this._injectionMap = new ImmutableMap<T2, T1>(this._secondMap);
            this._firstIndex = this.makeFirstIndex(CollectUtil.<T1, PredicateSet<T2>>hashMapFactory(), CollectUtil.hashSetFactory(4));
        } else {
            this._secondMap = new HashMap<T2, T1>();
            this._injectionMap = new ImmutableMap<T2, T1>(this._secondMap);
            this._firstIndex = new LazyRelationIndex<T1, T2>((Iterable_)((Object)this));
        }
    }

    public IndexedInjectiveRelation(Thunk<Map<T2, T1>> secondIndexFactory, Thunk<Map<T1, PredicateSet<T2>>> firstIndexFactory, Thunk<Set<T2>> firstIndexEntryFactory) {
        this._secondMap = secondIndexFactory.value();
        this._injectionMap = new ImmutableMap<T2, T1>(this._secondMap);
        this._firstIndex = this.makeFirstIndex(firstIndexFactory, firstIndexEntryFactory);
    }

    public IndexedInjectiveRelation(Thunk<Map<T2, T1>> secondIndexFactory) {
        this._secondMap = secondIndexFactory.value();
        this._injectionMap = new ImmutableMap<T2, T1>(this._secondMap);
        this._firstIndex = new LazyRelationIndex<T1, T2>((Iterable_)((Object)this));
    }

    private RelationIndex<T1, T2> makeFirstIndex(Thunk<Map<T1, PredicateSet<T2>>> mapFactory, Thunk<Set<T2>> setFactory) {
        return new ConcreteRelationIndex<T1, T2>(mapFactory, setFactory){

            @Override
            public void validateAdd(T1 first, T2 second) {
                IndexedInjectiveRelation.access$000(IndexedInjectiveRelation.this, first, second);
            }

            @Override
            public void addToRelation(T1 first, T2 second) {
                IndexedInjectiveRelation.access$100(IndexedInjectiveRelation.this).put(second, first);
            }

            @Override
            public void removeFromRelation(T1 first, T2 second) {
                IndexedInjectiveRelation.access$100(IndexedInjectiveRelation.this).remove(second);
            }

            @Override
            public void clearRelation() {
                IndexedInjectiveRelation.access$100(IndexedInjectiveRelation.this).clear();
            }
        };
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public LambdaMap<T2, T1> injectionMap() {
        return this._injectionMap;
    }

    @Override
    public PredicateSet<T1> firstSet() {
        return this._firstIndex.keys();
    }

    @Override
    public PredicateSet<T2> matchFirst(T1 first) {
        return this._firstIndex.match(first);
    }

    @Override
    public boolean add(T1 first, T2 second) {
        boolean result = this.validateAdd(first, second);
        if (result) {
            this._secondMap.put(second, first);
            this._firstIndex.added(first, second);
        }
        return result;
    }

    private boolean validateAdd(T1 first, T2 second) {
        if (this._secondMap.containsKey(second)) {
            T1 current = this._secondMap.get(second);
            if (current == null ? first == null : current.equals(first)) {
                return false;
            }
            throw new IllegalArgumentException(new StringBuffer().append("Relation already contains an entry for ").append(second).toString());
        }
        return true;
    }

    @Override
    public boolean remove(T1 first, T2 second) {
        boolean result = this.contains(first, second);
        if (result) {
            this._secondMap.remove(second);
            this._firstIndex.removed(first, second);
        }
        return result;
    }

    @Override
    public void clear() {
        this._secondMap.clear();
        this._firstIndex.cleared();
    }

    public static <T1, T2> IndexedInjectiveRelation<T1, T2> makeHashBased() {
        return new IndexedInjectiveRelation<T1, T2>(CollectUtil.<T2, T1>hashMapFactory(), CollectUtil.<T1, PredicateSet<T2>>hashMapFactory(), CollectUtil.hashSetFactory(4));
    }

    public static <T1, T2> IndexedInjectiveRelation<T1, T2> makeLinkedHashBased() {
        return new IndexedInjectiveRelation<T1, T2>(CollectUtil.<T2, T1>linkedHashMapFactory(), CollectUtil.<T1, PredicateSet<T2>>linkedHashMapFactory(), CollectUtil.linkedHashSetFactory(4));
    }

    public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>> IndexedInjectiveRelation<T1, T2> makeTreeBased() {
        return new IndexedInjectiveRelation<T1, T2>(CollectUtil.<T2, T1>treeMapFactory(), CollectUtil.<T1, PredicateSet<T2>>treeMapFactory(), CollectUtil.<T2>treeSetFactory());
    }

    static boolean access$000(IndexedInjectiveRelation x0, Object x1, Object x2) {
        return x0.validateAdd(x1, x2);
    }

    static Map access$100(IndexedInjectiveRelation x0) {
        return x0._secondMap;
    }
}

