/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableCollection<T>
extends AbstractCollection<T>
implements SizedIterable<T>,
Composite,
Serializable {
    protected Collection<? extends T> _delegate;

    public ImmutableCollection(Collection<? extends T> collection) {
        this._delegate = collection;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._delegate) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._delegate) + 1;
    }

    @Override
    public Iterator<T> iterator() {
        return ImmutableIterator.make(this._delegate.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this._delegate.isEmpty();
    }

    @Override
    public int size() {
        return this._delegate.size();
    }

    @Override
    public int size(int bound) {
        return IterUtil.sizeOf(this._delegate, bound);
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._delegate);
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._delegate);
    }

    @Override
    public boolean isStatic() {
        return IterUtil.isStatic(this._delegate);
    }

    @Override
    public boolean contains(Object o) {
        return this._delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._delegate.containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return this._delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._delegate.toArray(a);
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected boolean abstractCollectionIsEmpty() {
        return super.isEmpty();
    }

    protected boolean abstractCollectionContains(Object o) {
        return super.contains(o);
    }

    protected Object[] abstractCollectionToArray() {
        return super.toArray();
    }

    protected <T> T[] abstractCollectionToArray(T[] a) {
        return super.toArray(a);
    }

    protected boolean abstractCollectionRemove(T o) {
        return super.remove(o);
    }

    protected boolean abstractCollectionContainsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    protected boolean abstractCollectionAddAll(Collection<? extends T> c) {
        return super.addAll(c);
    }

    protected boolean abstractCollectionRetainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    protected boolean abstractCollectionRemoveAll(Collection<?> c) {
        return super.removeAll(c);
    }

    protected void abstractCollectionClear() {
        super.clear();
    }

    @Override
    public String toString() {
        return this._delegate.toString();
    }

    public static <T> ImmutableCollection<T> make(Collection<? extends T> collection) {
        return new ImmutableCollection<T>(collection);
    }
}

