/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.Multiset;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.tuple.Option;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMultiset<T>
extends AbstractCollection<T>
implements Multiset<T>,
Serializable {
    private HashMap<T, Integer> _counts = new HashMap();
    private int _size;

    public HashMultiset() {
    }

    public HashMultiset(Collection<? extends T> coll) {
        this();
        this.addAll(coll);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int size(int bound) {
        return this._size < bound ? this._size : bound;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean contains(Object obj) {
        return this._counts.containsKey(obj);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : this.asMultiset(c).asSet()) {
            if (this.contains(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSupersetOf(Multiset<?> m) {
        for (Object elt : m.asSet()) {
            if (m.count(elt) <= this.count(elt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int count(Object value) {
        if (this._counts.containsKey(value)) {
            return this._counts.get(value);
        }
        return 0;
    }

    @Override
    public PredicateSet<T> asSet() {
        return CollectUtil.asPredicateSet(this._counts.keySet());
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Map.Entry<T, Integer>> entries = this._counts.entrySet().iterator();
        return new Iterator<T>(){
            private Map.Entry<T, Integer> _current = null;
            private int _currentCount = 0;
            private boolean _removed = false;

            @Override
            public boolean hasNext() {
                return this._currentCount > 0 || entries.hasNext();
            }

            @Override
            public T next() {
                if (this._currentCount == 0) {
                    this._current = (Map.Entry)entries.next();
                    this._currentCount = this._current.getValue();
                }
                this._removed = false;
                --this._currentCount;
                return this._current.getKey();
            }

            @Override
            public void remove() {
                if (this._current == null || this._removed) {
                    throw new IllegalStateException();
                }
                this._removed = true;
                HashMultiset.access$010(HashMultiset.this);
                int oldCount = this._current.getValue();
                if (oldCount == 1) {
                    entries.remove();
                } else {
                    this._current.setValue(Autobox.valueOf(oldCount - 1));
                }
            }
        };
    }

    @Override
    public boolean add(T val) {
        this._counts.put(val, Autobox.valueOf(this.count(val) + 1));
        ++this._size;
        return true;
    }

    @Override
    public boolean add(T val, int instances) {
        this._counts.put(val, Autobox.valueOf(this.count(val) + instances));
        this._size += instances;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        boolean result = false;
        Multiset<T> collMultiset = this.asMultiset(coll);
        for (Object entry : collMultiset.asSet()) {
            result |= this.add(entry, collMultiset.count(entry));
        }
        return result;
    }

    @Override
    public boolean remove(Object obj) {
        Option cast = CollectUtil.castIfContains(this, obj);
        if (cast.isSome()) {
            this.doRemove(cast.unwrap(), 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object obj, int instances) {
        Option cast = CollectUtil.castIfContains(this, obj);
        if (cast.isSome()) {
            this.doRemove(cast.unwrap(), instances);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllInstances(Object obj) {
        Option cast = CollectUtil.castIfContains(this, obj);
        if (cast.isSome()) {
            this.doRemove(cast.unwrap(), this.count(obj));
            return true;
        }
        return false;
    }

    private void doRemove(T key, int instances) {
        int newCount = this.count(key) - instances;
        if (newCount <= 0) {
            int actualInstances = this._counts.remove(key);
            this._size -= actualInstances;
        } else {
            this._counts.put(key, Autobox.valueOf(newCount));
            this._size -= instances;
        }
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        Multiset<?> collMultiset = this.asMultiset(coll);
        for (Object obj : collMultiset.asSet()) {
            result |= this.remove(obj, collMultiset.count(obj));
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean result = false;
        Multiset<?> collMultiset = this.asMultiset(coll);
        Iterator<Map.Entry<T, Integer>> iter = this._counts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<T, Integer> entry = iter.next();
            if (collMultiset.contains(entry.getKey())) {
                int newCount = collMultiset.count(entry.getKey());
                if (entry.getValue() <= newCount) continue;
                this._size -= entry.getValue() - newCount;
                entry.setValue(Autobox.valueOf(newCount));
                result = true;
                continue;
            }
            this._size -= entry.getValue().intValue();
            iter.remove();
            result = true;
        }
        return result;
    }

    @Override
    public void clear() {
        this._counts.clear();
    }

    @Override
    public String toString() {
        return IterUtil.toString((Iterable_)((Object)this));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Multiset)) {
            return false;
        }
        Multiset cast = (Multiset)obj;
        if (this._size == cast.size()) {
            for (Object elt : cast.asSet()) {
                if (this.count(elt) == cast.count(elt)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Object elt : this.asSet()) {
            result += (elt == null ? 1 : elt.hashCode()) * this.count(elt);
        }
        return result;
    }

    private <T> Multiset<T> asMultiset(Collection<T> coll) {
        if (coll instanceof Multiset) {
            return (Multiset)coll;
        }
        return new HashMultiset<T>(coll);
    }

    static int access$010(HashMultiset x0) {
        return x0._size--;
    }
}

