/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractPredicateSet;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.iter.FilteredIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Option;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredSet<T>
extends AbstractPredicateSet<T>
implements Composite,
Serializable {
    protected final Set<? extends T> _set;
    protected final Predicate<? super T> _pred;

    public FilteredSet(Set<? extends T> set, Predicate<? super T> predicate) {
        this._set = set;
        this._pred = predicate;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._set, this._pred) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._set, this._pred) + 1;
    }

    @Override
    public boolean contains(Object o) {
        Option<T> cast = CollectUtil.castIfContains(this._set, o);
        if (cast.isSome()) {
            return this._pred.contains(cast.unwrap());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objs) {
        if (this._set.containsAll(objs)) {
            Collection<?> iter = objs;
            return IterUtil.and(iter, this._pred);
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteredIterator<T>(this._set.iterator(), this._pred);
    }

    @Override
    public boolean isEmpty() {
        return this._set.isEmpty() || super.isEmpty();
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }
}

