/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractRelation;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.FilteredSet;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.iter.FilteredIterator;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredRelation<T1, T2>
extends AbstractRelation<T1, T2>
implements Composite,
Serializable {
    protected final Relation<T1, T2> _rel;
    protected final Predicate2<? super T1, ? super T2> _pred;
    private final PredicateSet<T1> _firstSet;
    private final PredicateSet<T2> _secondSet;

    public FilteredRelation(Relation<T1, T2> relation, Predicate2<? super T1, ? super T2> predicate) {
        this._rel = relation;
        this._pred = predicate;
        this._firstSet = new FilteredSet<T1>(this._rel.firstSet(), new Predicate<T1>(){

            @Override
            public boolean contains(T1 first) {
                for (Object second : FilteredRelation.this._rel.matchFirst(first)) {
                    if (!FilteredRelation.this._pred.contains(first, second)) continue;
                    return true;
                }
                return false;
            }
        });
        this._secondSet = new FilteredSet<T2>(this._rel.secondSet(), new Predicate<T2>(){

            @Override
            public boolean contains(T2 second) {
                for (Object first : FilteredRelation.this._rel.matchSecond(second)) {
                    if (!FilteredRelation.this._pred.contains(first, second)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._rel, this._pred) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._rel, this._pred) + 1;
    }

    @Override
    public boolean isEmpty() {
        return this._rel.isEmpty() || super.isEmpty();
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean contains(T1 first, T2 second) {
        return this._rel.contains(first, second) && this._pred.contains(first, second);
    }

    @Override
    public boolean contains(Object obj) {
        Option cast = CollectUtil.castIfContains(this._rel, obj);
        if (cast.isSome()) {
            Pair p = (Pair)cast.unwrap();
            return this._pred.contains(p.first(), p.second());
        }
        return false;
    }

    @Override
    public Iterator<Pair<T1, T2>> iterator() {
        return FilteredIterator.make(this._rel.iterator(), LambdaUtil.unary(this._pred));
    }

    @Override
    public PredicateSet<T1> firstSet() {
        return this._firstSet;
    }

    @Override
    public PredicateSet<T2> matchFirst(final T1 first) {
        return new FilteredSet<T2>(this._rel.matchFirst(first), new Predicate<T2>(){

            @Override
            public boolean contains(T2 second) {
                return FilteredRelation.this._pred.contains(first, second);
            }
        });
    }

    @Override
    public PredicateSet<T2> secondSet() {
        return this._secondSet;
    }

    @Override
    public PredicateSet<T1> matchSecond(final T2 second) {
        return new FilteredSet<T1>(this._rel.matchSecond(second), new Predicate<T1>(){

            @Override
            public boolean contains(T1 first) {
                return FilteredRelation.this._pred.contains(first, second);
            }
        });
    }
}

