/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.iter.SizedIterable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternallySortedSet<T, C extends Comparable<? super C>>
implements SizedIterable<T> {
    private final SortedSet<T> _set;
    private final Map<T, C> _orderByMap;
    private final C _lowerBound;
    private final C _upperBound;

    public ExternallySortedSet() {
        this._set = new TreeSet<T>(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                return ((Comparable)ExternallySortedSet.access$000(ExternallySortedSet.this).get(t1)).compareTo(ExternallySortedSet.access$000(ExternallySortedSet.this).get(t2));
            }
        });
        this._orderByMap = new HashMap<T, C>();
        this._lowerBound = null;
        this._upperBound = null;
    }

    private ExternallySortedSet(SortedSet<T> set, Map<T, C> orderByMap, C lowerBound, C upperBound) {
        this._set = set;
        this._orderByMap = orderByMap;
        this._lowerBound = lowerBound;
        this._upperBound = upperBound;
    }

    @Override
    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public int size(int bound) {
        int result = this._set.size();
        return result <= bound ? result : bound;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    public boolean contains(Object element) {
        return this._orderByMap.containsKey(element) && this._set.contains(element);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator setI = this._set.iterator();
        return new Iterator<T>(){
            private T _last = null;

            @Override
            public boolean hasNext() {
                return setI.hasNext();
            }

            @Override
            public T next() {
                this._last = setI.next();
                return this._last;
            }

            @Override
            public void remove() {
                if (this._last == null) {
                    throw new IllegalStateException();
                }
                setI.remove();
                ExternallySortedSet.access$000(ExternallySortedSet.this).remove(this._last);
                this._last = null;
            }
        };
    }

    public Object[] toArray() {
        return this._set.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this._set.toArray(a);
    }

    public boolean add(T element, C orderBy) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.assertInBounds(orderBy);
        if (this.contains(element)) {
            return false;
        }
        this._orderByMap.put(element, orderBy);
        this._set.add(element);
        return true;
    }

    public boolean remove(Object element) {
        if (this.contains(element)) {
            this._set.remove(element);
            this._orderByMap.remove(element);
            return true;
        }
        return false;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public boolean containsAll(Iterable_ i) {
        Iterator i$ = IterableMethods.iterator(i);
        while (i$.hasNext()) {
            Object o = i$.next();
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(ExternallySortedSet<? extends T, ? extends C> s) {
        if ((this._lowerBound == null || s._lowerBound != null && this._lowerBound.compareTo(s._lowerBound) <= 0) && (this._upperBound == null || s._upperBound != null && this._upperBound.compareTo(s._upperBound) >= 0)) {
            return this.uncheckedAddAll(s);
        }
        return this.checkedAddAll(s);
    }

    private boolean checkedAddAll(ExternallySortedSet<? extends T, ? extends C> s) {
        boolean result = false;
        for (T t : s) {
            result |= this.add(t, (Comparable)s._orderByMap.get(t));
        }
        return result;
    }

    private boolean uncheckedAddAll(ExternallySortedSet<? extends T, ? extends C> s) {
        for (Map.Entry<T, C> e : s._orderByMap.entrySet()) {
            if (this._orderByMap.containsKey(e.getKey())) continue;
            this._orderByMap.put(e.getKey(), e.getValue());
        }
        boolean result = this._set.addAll(s._set);
        return result;
    }

    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Iterator<T> i = this.iterator();
        while (i.hasNext()) {
            T t = i.next();
            if (c.contains(t)) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public boolean retainAll(ExternallySortedSet<?, ?> s) {
        boolean result = false;
        Iterator<T> i = this.iterator();
        while (i.hasNext()) {
            T t = i.next();
            if (s.contains(t)) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public boolean removeAll(Iterable_ i) {
        boolean result = false;
        Iterator i$ = IterableMethods.iterator(i);
        while (i$.hasNext()) {
            Object o = i$.next();
            result |= this.remove(i);
        }
        return result;
    }

    public void clear() {
        for (Object t : this._set) {
            this._orderByMap.remove(t);
        }
        this._set.clear();
    }

    public ExternallySortedSet<T, C> subSet(C from, C to) {
        this.assertInBounds(from);
        this.assertInBounds(to);
        T fromElement = this.firstAt(from);
        T toElement = this.firstAt(to);
        SortedSet<T> subSet = fromElement == null ? (toElement == null ? this._set : this._set.headSet(toElement)) : (toElement == null ? this._set.tailSet(fromElement) : this._set.subSet(fromElement, toElement));
        return new ExternallySortedSet<T, C>(subSet, this._orderByMap, from, to);
    }

    public ExternallySortedSet<T, C> headSet(C to) {
        this.assertInBounds(to);
        T toElement = this.firstAt(to);
        SortedSet<T> subSet = toElement == null ? this._set : this._set.headSet(toElement);
        return new ExternallySortedSet<T, Object>(subSet, this._orderByMap, null, to);
    }

    public ExternallySortedSet<T, C> tailSet(C from) {
        this.assertInBounds(from);
        T fromElement = this.firstAt(from);
        SortedSet<T> subSet = fromElement == null ? this._set : this._set.tailSet(fromElement);
        return new ExternallySortedSet<T, Object>(subSet, this._orderByMap, from, null);
    }

    public T first() {
        return this._set.first();
    }

    public T last() {
        return this._set.last();
    }

    private T firstAt(C c) {
        this._orderByMap.put(null, c);
        SortedSet<Object> resultSet = this._set.tailSet(null);
        T result = null;
        if (!resultSet.isEmpty()) {
            result = resultSet.first();
        }
        this._orderByMap.remove(null);
        return result;
    }

    private void assertInBounds(C c) {
        if (this._lowerBound != null && c.compareTo(this._lowerBound) < 0) {
            throw new IllegalArgumentException(new StringBuffer().append(c).append(" is < this set's lower bound: ").append(this._lowerBound).toString());
        }
        if (this._upperBound != null && c.compareTo(this._upperBound) >= 0) {
            throw new IllegalArgumentException(new StringBuffer().append(c).append(" is >= this set's upper bound: ").append(this._upperBound).toString());
        }
    }

    static Map access$000(ExternallySortedSet x0) {
        return x0._orderByMap;
    }
}

