/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.ConsList;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate;
import java.io.Serializable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConsVisitor<T, Ret>
implements Lambda<ConsList<? extends T>, Ret> {
    public abstract Ret forEmpty();

    public abstract Ret forNonempty(T var1, ConsList<? extends T> var2);

    @Override
    public Ret value(ConsList<? extends T> list) {
        return list.apply(this);
    }

    public static final <T> ConsVisitor<T, T> first() {
        return First.access$000();
    }

    public static final <T> ConsVisitor<T, ConsList<? extends T>> rest() {
        return Rest.access$100();
    }

    public static <T> ConsVisitor<T, ConsList<? extends T>> reverse() {
        return new ReverseHelper(ConsList.empty());
    }

    public static <T> ConsVisitor<T, ConsList<? extends T>> append(ConsList<? extends T> rest) {
        return new Append<T>(rest);
    }

    public static <T> ConsVisitor<T, ConsList<T>> filter(Predicate<? super T> pred) {
        return new Filter<T>(pred);
    }

    public static <S, T> ConsVisitor<S, ConsList<T>> map(Lambda<? super S, ? extends T> lambda) {
        return new Map<S, T>(lambda);
    }

    @Override
    public Object value(Object x0) {
        return this.value((ConsList)x0);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Map<S, T>
    extends ConsVisitor<S, ConsList<T>>
    implements Serializable {
        private final Lambda<? super S, ? extends T> _lambda;

        public Map(Lambda<? super S, ? extends T> lambda) {
            this._lambda = lambda;
        }

        @Override
        public ConsList<T> forEmpty() {
            return ConsList.empty();
        }

        @Override
        public ConsList<T> forNonempty(S first, ConsList<? extends S> rest) {
            return ConsList.cons(this._lambda.value(first), (ConsList)rest.apply(this));
        }

        @Override
        public Object forNonempty(Object x0, ConsList x1) {
            return this.forNonempty(x0, x1);
        }

        @Override
        public Object forEmpty() {
            return this.forEmpty();
        }

        @Override
        public Object value(Object x0) {
            return super.value((ConsList)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Filter<T>
    extends ConsVisitor<T, ConsList<T>>
    implements Serializable {
        private final Predicate<? super T> _pred;

        public Filter(Predicate<? super T> pred) {
            this._pred = pred;
        }

        @Override
        public ConsList<T> forEmpty() {
            return ConsList.empty();
        }

        @Override
        public ConsList<T> forNonempty(T first, ConsList<? extends T> rest) {
            if (this._pred.contains(first)) {
                return ConsList.cons(first, (ConsList)rest.apply(this));
            }
            return (ConsList)rest.apply(this);
        }

        @Override
        public Object forNonempty(Object x0, ConsList x1) {
            return this.forNonempty(x0, x1);
        }

        @Override
        public Object forEmpty() {
            return this.forEmpty();
        }

        @Override
        public Object value(Object x0) {
            return super.value((ConsList)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Append<T>
    extends ConsVisitor<T, ConsList<? extends T>>
    implements Serializable {
        private final ConsList<? extends T> _toAppend;

        public Append(ConsList<? extends T> toAppend) {
            this._toAppend = toAppend;
        }

        @Override
        public ConsList<? extends T> forEmpty() {
            return this._toAppend;
        }

        @Override
        public ConsList<? extends T> forNonempty(T first, ConsList<? extends T> rest) {
            return ConsList.cons(first, (ConsList)rest.apply(this));
        }

        @Override
        public Object forNonempty(Object x0, ConsList x1) {
            return this.forNonempty(x0, x1);
        }

        @Override
        public Object forEmpty() {
            return this.forEmpty();
        }

        @Override
        public Object value(Object x0) {
            return super.value((ConsList)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseHelper<T>
    extends ConsVisitor<T, ConsList<? extends T>>
    implements Serializable {
        private ConsList<? extends T> _toAppend;

        public ReverseHelper(ConsList<? extends T> toAppend) {
            this._toAppend = toAppend;
        }

        @Override
        public ConsList<? extends T> forEmpty() {
            return this._toAppend;
        }

        @Override
        public ConsList<? extends T> forNonempty(T first, ConsList<? extends T> rest) {
            return (ConsList)rest.apply(new ReverseHelper<T>(ConsList.cons(first, this._toAppend)));
        }

        @Override
        public Object forNonempty(Object x0, ConsList x1) {
            return this.forNonempty(x0, x1);
        }

        @Override
        public Object forEmpty() {
            return this.forEmpty();
        }

        @Override
        public Object value(Object x0) {
            return super.value((ConsList)x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Rest<T>
    extends ConsVisitor<T, ConsList<? extends T>>
    implements Serializable {
        private static final Rest<Object> INSTANCE = new Rest();

        private Rest() {
        }

        @Override
        public ConsList<? extends T> forEmpty() {
            throw new IllegalArgumentException("Empty ConsList has no rest");
        }

        @Override
        public ConsList<? extends T> forNonempty(T first, ConsList<? extends T> rest) {
            return rest;
        }

        @Override
        public Object forNonempty(Object x0, ConsList x1) {
            return this.forNonempty(x0, x1);
        }

        @Override
        public Object forEmpty() {
            return this.forEmpty();
        }

        @Override
        public Object value(Object x0) {
            return super.value((ConsList)x0);
        }

        static Rest access$100() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class First<T>
    extends ConsVisitor<T, T>
    implements Serializable {
        private static final First<Object> INSTANCE = new First();

        private First() {
        }

        @Override
        public T forEmpty() {
            throw new IllegalArgumentException("Empty ConsList has no first");
        }

        @Override
        public T forNonempty(T first, ConsList<? extends T> rest) {
            return first;
        }

        @Override
        public Object value(Object x0) {
            return super.value((ConsList)x0);
        }

        static First access$000() {
            return INSTANCE;
        }
    }
}

