/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.ConsVisitor;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.object.Composite;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConsList<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
Composite,
Serializable {
    public abstract <Ret> Ret apply(ConsVisitor<? super T, ? extends Ret> var1);

    @Override
    public abstract Iterator<T> iterator();

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract int size();

    @Override
    public abstract int size(int var1);

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public int compositeHeight() {
        return this.size();
    }

    @Override
    public int compositeSize() {
        return this.size() + 1;
    }

    public static <T> Empty<T> empty() {
        return Empty.make();
    }

    public static <T> Nonempty<T> cons(T first, ConsList<? extends T> rest) {
        return new Nonempty<T>(first, rest);
    }

    public static <T> Nonempty<T> singleton(T value) {
        return new Nonempty<T>(value, Empty.make());
    }

    public static <T> T first(ConsList<? extends T> list) {
        return list.apply(ConsVisitor.first());
    }

    public static <T> ConsList<? extends T> rest(ConsList<? extends T> list) {
        return list.apply(ConsVisitor.rest());
    }

    public static <T> ConsList<? extends T> reverse(ConsList<? extends T> list) {
        return list.apply(ConsVisitor.reverse());
    }

    public static <T> ConsList<? extends T> append(ConsList<? extends T> l1, ConsList<? extends T> l2) {
        return l1.apply(ConsVisitor.append(l2));
    }

    public static <T> ConsList<? extends T> filter(ConsList<? extends T> list, Predicate<? super T> pred) {
        return list.apply(ConsVisitor.filter(pred));
    }

    public static <S, T> ConsList<? extends T> map(ConsList<? extends S> list, Lambda<? super S, ? extends T> lambda) {
        return list.apply(ConsVisitor.map(lambda));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Nonempty<T>
    extends ConsList<T> {
        private final T _first;
        private final ConsList<? extends T> _rest;

        public Nonempty(T first, ConsList<? extends T> rest) {
            this._first = first;
            this._rest = rest;
        }

        public T first() {
            return this._first;
        }

        public ConsList<? extends T> rest() {
            return this._rest;
        }

        @Override
        public <Ret> Ret apply(ConsVisitor<? super T, ? extends Ret> visitor) {
            return visitor.forNonempty((T)this._first, this._rest);
        }

        @Override
        public Iterator<T> iterator() {
            return new ReadOnlyIterator<T>(){
                private ConsList<? extends T> _current;
                {
                    this._current = Nonempty.this;
                }

                @Override
                public boolean hasNext() {
                    return !this._current.isEmpty();
                }

                @Override
                public T next() {
                    return this._current.apply(new ConsVisitor<T, T>(){

                        @Override
                        public T forEmpty() {
                            throw new NoSuchElementException();
                        }

                        @Override
                        public T forNonempty(T first, ConsList<? extends T> rest) {
                            1.access$002(this, rest);
                            return first;
                        }
                    });
                }

                static ConsList access$002(1 x0, ConsList x1) {
                    x0._current = x1;
                    return x0._current;
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1 + this._rest.size();
        }

        @Override
        public int size(int bound) {
            if (bound == 0) {
                return 0;
            }
            return 1 + this._rest.size(bound - 1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Empty<T>
    extends ConsList<T> {
        private static final Empty<Void> INSTANCE = new Empty();

        private Empty() {
        }

        public static <T> Empty<T> make() {
            return INSTANCE;
        }

        @Override
        public <Ret> Ret apply(ConsVisitor<? super T, ? extends Ret> visitor) {
            return visitor.forEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return EmptyIterator.make();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int size(int bound) {
            return 0;
        }
    }
}

