/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.collect.AbstractRelation;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.FilteredSet;
import edu.rice.cs.plt.collect.IterableSet;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedRelation<T1, T2, T3>
extends AbstractRelation<T1, T3>
implements Serializable {
    private final Relation<T1, T2> _rel1;
    private final Relation<T2, T3> _rel2;
    private final PredicateSet<T1> _firstSet;
    private final PredicateSet<T3> _secondSet;

    public ComposedRelation(Relation<T1, T2> rel1, Relation<T2, T3> rel2) {
        this._rel1 = rel1;
        this._rel2 = rel2;
        this._firstSet = new FilteredSet<T1>(rel1.firstSet(), new Predicate<T1>(){

            @Override
            public boolean contains(T1 first) {
                for (Object middle : ComposedRelation.access$000(ComposedRelation.this).matchFirst(first)) {
                    if (!ComposedRelation.access$100(ComposedRelation.this).containsFirst(middle)) continue;
                    return true;
                }
                return false;
            }
        });
        this._secondSet = new FilteredSet<T3>(rel2.secondSet(), new Predicate<T3>(){

            @Override
            public boolean contains(T3 second) {
                for (Object middle : ComposedRelation.access$100(ComposedRelation.this).matchSecond(second)) {
                    if (!ComposedRelation.access$000(ComposedRelation.this).containsSecond(middle)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._rel1, this._rel2) + 1;
    }

    public int compositeSize() {
        return ObjectUtil.compositeSize(this._rel1, this._rel2) + 1;
    }

    @Override
    public boolean isEmpty() {
        return this._firstSet.isEmpty();
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return this._rel1.isStatic() && this._rel2.isStatic();
    }

    @Override
    public boolean contains(T1 first, T3 second) {
        return this.matchFirst(first).contains((Object)second);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Pair) {
            Pair p = (Pair)o;
            Option<T1> first = CollectUtil.castIfContains(this._firstSet, p.first());
            return first.isSome() && this.matchFirst(first.unwrap()).contains(p.second());
        }
        return false;
    }

    @Override
    public Iterator<Pair<T1, T3>> iterator() {
        return new ReadOnlyIterator<Pair<T1, T3>>(){
            private final Iterator<T1> _firsts;
            private T1 _currentFirst;
            private Iterator<T2> _currentMiddles;
            private T2 _currentMiddle;
            private Iterator<? extends T3> _currentSeconds;
            {
                this._firsts = ComposedRelation.access$200(ComposedRelation.this).iterator();
                this._currentFirst = null;
                this._currentMiddles = EmptyIterator.make();
                this._currentMiddle = null;
                this._currentSeconds = EmptyIterator.make();
            }

            @Override
            public boolean hasNext() {
                return this._currentSeconds.hasNext() || this._currentMiddles.hasNext() || this._firsts.hasNext();
            }

            @Override
            public Pair<T1, T3> next() {
                if (!this._currentSeconds.hasNext()) {
                    if (!this._currentMiddles.hasNext()) {
                        this._currentFirst = this._firsts.next();
                        this._currentMiddles = ComposedRelation.access$000(ComposedRelation.this).matchFirst(this._currentFirst).iterator();
                    }
                    this._currentMiddle = this._currentMiddles.next();
                    this._currentSeconds = ComposedRelation.access$100(ComposedRelation.this).matchFirst(this._currentMiddle).iterator();
                }
                return new Pair(this._currentFirst, this._currentSeconds.next());
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public PredicateSet<T1> firstSet() {
        return this._firstSet;
    }

    @Override
    public PredicateSet<T3> matchFirst(T1 first) {
        SizedIterable seconds = IterUtil.map(this._rel1.matchFirst(first), new Lambda<T2, PredicateSet<T3>>(){

            @Override
            public PredicateSet<T3> value(T2 middle) {
                return ComposedRelation.access$100(ComposedRelation.this).matchFirst(middle);
            }

            @Override
            public Object value(Object x0) {
                return this.value(x0);
            }
        });
        return new IterableSet((Iterable_)((Object)IterUtil.collapse((Iterable_)((Object)seconds))));
    }

    @Override
    public PredicateSet<T3> secondSet() {
        return this._secondSet;
    }

    @Override
    public PredicateSet<T1> matchSecond(T3 second) {
        SizedIterable firsts = IterUtil.map(this._rel2.matchSecond(second), new Lambda<T2, PredicateSet<T1>>(){

            @Override
            public PredicateSet<T1> value(T2 middle) {
                return ComposedRelation.access$000(ComposedRelation.this).matchSecond(middle);
            }

            @Override
            public Object value(Object x0) {
                return this.value(x0);
            }
        });
        return new IterableSet((Iterable_)((Object)IterUtil.collapse((Iterable_)((Object)firsts))));
    }

    static Relation access$000(ComposedRelation x0) {
        return x0._rel1;
    }

    static Relation access$100(ComposedRelation x0) {
        return x0._rel2;
    }

    static PredicateSet access$200(ComposedRelation x0) {
        return x0._firstSet;
    }
}

