/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractPredicateSet;
import edu.rice.cs.plt.collect.AbstractRelation;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.ImmutableSet;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.iter.CartesianIterator;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartesianRelation<T1, T2>
extends AbstractRelation<T1, T2>
implements Composite,
Serializable {
    private final PredicateSet<T1> _firstSet;
    private final PredicateSet<T2> _secondSet;

    public CartesianRelation(Set<? extends T1> firsts, Set<? extends T2> seconds) {
        this._firstSet = new ImmutableSet<T1>(firsts);
        this._secondSet = new ImmutableSet<T2>(seconds);
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._firstSet, this._secondSet) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._firstSet, this._secondSet) + 1;
    }

    @Override
    public int size(int bound) {
        int size2;
        int result;
        int size1 = this._firstSet.size(bound);
        if (size1 == 0) {
            return 0;
        }
        int bound2 = bound / size1;
        if (bound2 < Integer.MAX_VALUE) {
            ++bound2;
        }
        return (result = size1 * (size2 = this._secondSet.size(bound2))) > bound || result < 0 ? bound : result;
    }

    @Override
    public boolean isEmpty() {
        return this._firstSet.isEmpty() && this._secondSet.isEmpty();
    }

    @Override
    public boolean isInfinite() {
        return this._firstSet.isInfinite() || this._secondSet.isInfinite();
    }

    @Override
    public boolean hasFixedSize() {
        return this._firstSet.hasFixedSize() && this._secondSet.hasFixedSize();
    }

    @Override
    public boolean isStatic() {
        return this._firstSet.isStatic() && this._secondSet.isStatic();
    }

    @Override
    public boolean contains(T1 first, T2 second) {
        return this._firstSet.contains((Object)first) && this._secondSet.contains((Object)second);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Pair) {
            Pair p = (Pair)o;
            return this._firstSet.contains(p.first()) && this._secondSet.contains(p.second());
        }
        return false;
    }

    @Override
    public Iterator<Pair<T1, T2>> iterator() {
        return CartesianIterator.make(this._firstSet.iterator(), this._secondSet, Pair.factory());
    }

    @Override
    public PredicateSet<T1> firstSet() {
        return this._firstSet;
    }

    @Override
    public PredicateSet<T2> matchFirst(T1 first) {
        if (this._firstSet.isStatic()) {
            return this._firstSet.contains((Object)first) ? this._secondSet : CollectUtil.emptySet();
        }
        return new MatchSet<T1, T2>(first, this._firstSet, this._secondSet);
    }

    @Override
    public PredicateSet<T2> secondSet() {
        return this._secondSet;
    }

    @Override
    public PredicateSet<T1> matchSecond(T2 second) {
        if (this._secondSet.isStatic()) {
            return this._secondSet.contains((Object)second) ? this._firstSet : CollectUtil.emptySet();
        }
        return new MatchSet<T2, T1>(second, this._secondSet, this._firstSet);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchSet<K, V>
    extends AbstractPredicateSet<V> {
        private final K _key;
        private final PredicateSet<K> _keys;
        private final PredicateSet<V> _vals;

        public MatchSet(K key, PredicateSet<K> keys, PredicateSet<V> vals) {
            this._key = key;
            this._keys = keys;
            this._vals = vals;
        }

        @Override
        public boolean contains(Object obj) {
            return this._keys.contains((Object)this._key) ? this._vals.contains(obj) : false;
        }

        @Override
        public Iterator<V> iterator() {
            return this._keys.contains((Object)this._key) ? this._vals.iterator() : EmptyIterator.make();
        }

        @Override
        public boolean isEmpty() {
            return !this._keys.contains((Object)this._key) || this._vals.isEmpty();
        }

        @Override
        public int size() {
            return this._keys.contains((Object)this._key) ? this._vals.size() : 0;
        }

        @Override
        public int size(int bound) {
            return this._keys.contains((Object)this._key) ? this._vals.size(bound) : 0;
        }

        @Override
        public boolean isInfinite() {
            return this._keys.contains((Object)this._key) && this._vals.isInfinite();
        }

        @Override
        public boolean hasFixedSize() {
            return this._keys.isStatic() && this._vals.hasFixedSize();
        }

        @Override
        public boolean isStatic() {
            return this._keys.isStatic() && this._vals.isStatic();
        }
    }
}

