/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BodyData;
import edu.rice.cs.javalanglevels.ClassBodyTypeChecker;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.InterfaceBodyTypeChecker;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.PackageData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.VoidMethodsNotAllowedClassBodyTypeChecker;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.tree.AnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Block;
import edu.rice.cs.javalanglevels.tree.BreakStatement;
import edu.rice.cs.javalanglevels.tree.CastExpression;
import edu.rice.cs.javalanglevels.tree.ClassDef;
import edu.rice.cs.javalanglevels.tree.ClassImportStatement;
import edu.rice.cs.javalanglevels.tree.CompoundWord;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ContinueStatement;
import edu.rice.cs.javalanglevels.tree.ExpressionStatement;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.InterfaceDef;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFDepthFirstVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.LabeledStatement;
import edu.rice.cs.javalanglevels.tree.MethodDef;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.PackageStatement;
import edu.rice.cs.javalanglevels.tree.PrimitiveType;
import edu.rice.cs.javalanglevels.tree.ReturnStatement;
import edu.rice.cs.javalanglevels.tree.StaticInitializer;
import edu.rice.cs.javalanglevels.tree.SwitchStatement;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import edu.rice.cs.javalanglevels.tree.Word;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TypeChecker
extends JExpressionIFDepthFirstVisitor<TypeData>
implements JExpressionIFVisitor<TypeData> {
    static LinkedList<Pair<String, JExpressionIF>> errors;
    static Symboltable symbolTable;
    static boolean _errorAdded;
    File _file;
    String _package;
    LinkedList<String> _importedFiles;
    LinkedList<String> _importedPackages;

    public TypeChecker(File file, String packageName, LinkedList<Pair<String, JExpressionIF>> errors, Symboltable symbolTable, LinkedList<String> importedFiles, LinkedList<String> importedPackages) {
        this._file = file;
        this._package = packageName;
        TypeChecker.errors = errors;
        TypeChecker.symbolTable = symbolTable;
        this._importedFiles = importedFiles;
        this._importedPackages = importedPackages;
    }

    public TypeChecker(File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages) {
        this._file = file;
        this._package = packageName;
        this._importedFiles = importedFiles;
        this._importedPackages = importedPackages;
    }

    protected Data _getData() {
        throw new RuntimeException("Internal Program Error: _getData() shouldn't get called from TypeChecker.  Please report this bug.");
    }

    public SymbolData getSymbolData(String className, Data currentData, JExpression jexpr) {
        return this.getSymbolData(className, currentData, jexpr, true);
    }

    public SymbolData getSymbolData(String className, Data currentData, JExpression jexpr, boolean giveException) {
        return this.getSymbolData(giveException, className, currentData, jexpr, giveException);
    }

    public SymbolData getSymbolData(boolean giveAmbigException, String className, Data currentData, JExpression jexpr, boolean giveException) {
        SymbolData result = null;
        for (Data d = currentData; d != null && result == null; d = d.getOuterData()) {
            result = currentData.getInnerClassOrInterface(className);
        }
        if (result == null) {
            result = this.getSymbolData(className, jexpr, giveException, true);
        } else if (result == SymbolData.AMBIGUOUS_REFERENCE) {
            if (giveAmbigException) {
                TypeChecker._addError(new StringBuffer().append("Ambiguous reference to class or interface ").append(className).toString(), jexpr);
                return SymbolData.AMBIGUOUS_REFERENCE;
            }
            return null;
        }
        if (result == null || !giveException) {
            return result;
        }
        if (TypeChecker.checkAccessibility(jexpr, result.getMav(), className, result, currentData.getSymbolData(), "class or interface")) {
            return result;
        }
        return result;
    }

    public SymbolData getSymbolData(String className, JExpression jexpr, boolean giveException, boolean runnableNotOkay) {
        SourceInfo si = jexpr.getSourceInfo();
        LanguageLevelVisitor llv = new LanguageLevelVisitor(this._file, this._package, this._importedFiles, this._importedPackages, new LinkedList<String>(), new Hashtable<String, Pair<TypeDefBase, LanguageLevelVisitor>>(), new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>());
        LanguageLevelVisitor.symbolTable = symbolTable;
        SymbolData sd = llv.getSymbolData(className, si, false, false, false, true);
        if (sd == null || sd.isContinuation()) {
            if (giveException) {
                TypeChecker._addError(new StringBuffer().append("Class or variable ").append(className).append(" not found.").toString(), jexpr);
            }
            return null;
        }
        if (this.notRightPackage(sd)) {
            TypeChecker._addError(new StringBuffer().append("The class ").append(sd.getName()).append(" is not in the right package. Perhaps you meant to package it?").toString(), jexpr);
        }
        if (runnableNotOkay && sd.implementsRunnable()) {
            TypeChecker._addError(new StringBuffer().append(sd.getName()).append(" implements the Runnable interface, which is not allowed at any language level").toString(), jexpr);
            return null;
        }
        return sd;
    }

    protected boolean notRightPackage(SymbolData sd) {
        if (sd.getOuterData() != null) {
            return this.notRightPackage(sd.getOuterData().getSymbolData());
        }
        return sd.getPackage().equals("") && sd.getName().lastIndexOf(".") != -1 || !sd.getName().startsWith(sd.getPackage());
    }

    public LinkedList<VariableData> cloneVariableDataList(LinkedList<VariableData> vars) {
        LinkedList<VariableData> nv = new LinkedList<VariableData>();
        for (int i = 0; i < vars.size(); ++i) {
            VariableData old = vars.get(i);
            nv.addLast(old);
        }
        return nv;
    }

    protected String getQualifiedClassName(String className) {
        if (!this._package.equals("") && !className.startsWith(this._package)) {
            return new StringBuffer().append(this._package).append(".").append(className).toString();
        }
        return className;
    }

    private static boolean _areInSamePackage(SymbolData enclosingSD, SymbolData thisSD) {
        String enclosingSDName = enclosingSD.getName();
        int lastIndexOfDot = enclosingSDName.lastIndexOf(".");
        if (lastIndexOfDot != -1) {
            if (enclosingSD.getOuterData() != null) {
                return TypeChecker._areInSamePackage(enclosingSD.getOuterData().getSymbolData(), thisSD);
            }
            enclosingSDName = enclosingSDName.substring(0, lastIndexOfDot);
        } else {
            enclosingSDName = "";
        }
        String thisSDName = thisSD.getName();
        lastIndexOfDot = thisSDName.lastIndexOf(".");
        if (lastIndexOfDot != -1) {
            if (thisSD.getOuterData() != null) {
                return TypeChecker._areInSamePackage(enclosingSD, thisSD.getOuterData().getSymbolData());
            }
            thisSDName = thisSDName.substring(0, lastIndexOfDot);
        } else {
            thisSDName = "";
        }
        return enclosingSDName.equals(thisSDName);
    }

    protected MethodData _lookupMethodHelper(String methodName, SymbolData enclosingSD, InstanceData[] arguments, JExpression jexpr, boolean isConstructor, SymbolData thisSD) {
        return this._lookupMethodHelper(methodName, enclosingSD, arguments, jexpr, isConstructor, thisSD, new LinkedList<MethodData>());
    }

    protected Pair<LinkedList<MethodData>, LinkedList<MethodData>> _getMatchingMethods(String methodName, SymbolData enclosingSD, InstanceData[] arguments, JExpression jexpr, boolean isConstructor, SymbolData thisSD) {
        LinkedList<MethodData> mds = enclosingSD.getMethods();
        Iterator iter = mds.iterator();
        LinkedList<MethodData> matching = new LinkedList<MethodData>();
        LinkedList<MethodData> matchingWithAutoBoxing = new LinkedList<MethodData>();
        while (iter.hasNext()) {
            int i;
            MethodData md = (MethodData)iter.next();
            if (!md.getName().equals(methodName) || md.getParams().length != arguments.length) continue;
            VariableData[] vds = md.getParams();
            boolean matches = true;
            for (i = 0; i < vds.length && i < arguments.length; ++i) {
                boolean bl = matches = matches && this._isAssignableFromWithoutAutoboxing(vds[i].getType().getSymbolData(), arguments[i].getSymbolData());
                if (!matches) break;
            }
            if (matches && TypeChecker.checkAccessibility(jexpr, md.getMav(), md.getName(), enclosingSD, thisSD, "method")) {
                matching.addLast(md);
            }
            if (matches) continue;
            matches = true;
            for (i = 0; i < vds.length && i < arguments.length; ++i) {
                boolean bl = matches = matches && this._isAssignableFrom(vds[i].getType().getSymbolData(), arguments[i].getSymbolData());
                if (!matches) break;
            }
            if (!matches || !TypeChecker.checkAccessibility(jexpr, md.getMav(), md.getName(), enclosingSD, thisSD, "method")) continue;
            matchingWithAutoBoxing.addLast(md);
        }
        if (!isConstructor) {
            for (SymbolData sup : enclosingSD.getInterfaces()) {
                Pair<LinkedList<MethodData>, LinkedList<MethodData>> p = this._getMatchingMethods(methodName, sup, arguments, jexpr, isConstructor, thisSD);
                matching.addAll((Collection)p.getFirst());
                matchingWithAutoBoxing.addAll((Collection)p.getSecond());
            }
            if (enclosingSD.getSuperClass() != null) {
                Pair<LinkedList<MethodData>, LinkedList<MethodData>> p = this._getMatchingMethods(methodName, enclosingSD.getSuperClass(), arguments, jexpr, isConstructor, thisSD);
                matching.addAll((Collection)p.getFirst());
                matchingWithAutoBoxing.addAll((Collection)p.getSecond());
            }
        }
        return new Pair<LinkedList<MethodData>, LinkedList<MethodData>>(matching, matchingWithAutoBoxing);
    }

    protected MethodData _lookupMethodHelper(String methodName, SymbolData enclosingSD, InstanceData[] arguments, JExpression jexpr, boolean isConstructor, SymbolData thisSD, LinkedList<MethodData> matchingMethods) {
        Pair<LinkedList<MethodData>, LinkedList<MethodData>> p = this._getMatchingMethods(methodName, enclosingSD, arguments, jexpr, isConstructor, thisSD);
        LinkedList<MethodData> matching = p.getFirst();
        LinkedList<MethodData> matchingWithAutoBoxing = p.getSecond();
        SymbolData currData = enclosingSD;
        while (!isConstructor && matching.isEmpty() && matchingWithAutoBoxing.isEmpty() && currData.getOuterData() != null) {
            currData = currData.getOuterData().getSymbolData();
            p = this._getMatchingMethods(methodName, currData, arguments, jexpr, isConstructor, thisSD);
            matching = p.getFirst();
            matchingWithAutoBoxing = p.getSecond();
        }
        if (matching.size() == 1) {
            return matching.getFirst();
        }
        if (matching.size() > 1) {
            return TypeChecker._selectTheMostSpecificMethod(matching, arguments, jexpr);
        }
        if (matchingWithAutoBoxing.size() == 1) {
            return matchingWithAutoBoxing.getFirst();
        }
        if (matchingWithAutoBoxing.size() > 1) {
            return TypeChecker._selectTheMostSpecificMethod(matchingWithAutoBoxing, arguments, jexpr);
        }
        return null;
    }

    protected MethodData _lookupMethod(String methodName, SymbolData enclosingSD, InstanceData[] arguments, JExpression jexpr, String errorMessage, boolean isConstructor, SymbolData thisSD) {
        MethodData md;
        if (!isConstructor && methodName.equals(LanguageLevelVisitor.getUnqualifiedClassName(enclosingSD.getName()))) {
            TypeChecker._addError("The keyword 'new' is required to invoke a constructor", jexpr);
        }
        if ((md = this._lookupMethodHelper(methodName, enclosingSD, arguments, jexpr, isConstructor, thisSD)) != null) {
            return md;
        }
        StringBuffer message = new StringBuffer(new StringBuffer().append(errorMessage).append(methodName).toString());
        message.append("(");
        if (arguments.length > 0) {
            message.append(arguments[0].getName());
            for (int i = 1; i < arguments.length; ++i) {
                message.append(new StringBuffer().append(", ").append(arguments[i].getName()).toString());
            }
        }
        message.append(").");
        TypeChecker._addError(message.toString(), jexpr);
        return null;
    }

    private static MethodData _selectTheMostSpecificMethod(List<MethodData> list, InstanceData[] arguments, JExpression jexpr) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<MethodData> it = list.iterator();
        MethodData best = it.next();
        MethodData ambiguous = null;
        while (it.hasNext()) {
            MethodData curr = it.next();
            Object[] bestParams = new SymbolData[best.getParams().length];
            Object[] currParams = new SymbolData[curr.getParams().length];
            boolean better1 = false;
            boolean better2 = false;
            for (int i = 0; i < bestParams.length; ++i) {
                SymbolData bp = best.getParams()[i].getType().getSymbolData();
                SymbolData cp = curr.getParams()[i].getType().getSymbolData();
                boolean fromCurrToBest = cp.isAssignableTo(bp, LanguageLevelConverter.OPT.javaVersion());
                boolean fromBestToCurr = bp.isAssignableTo(cp, LanguageLevelConverter.OPT.javaVersion());
                bestParams[i] = bp;
                currParams[i] = cp;
                if (fromBestToCurr && !fromCurrToBest) {
                    better1 = true;
                }
                if (!fromCurrToBest || fromBestToCurr) continue;
                better2 = true;
            }
            if (better1 == better2) {
                if (Arrays.equals(bestParams, currParams)) {
                    SymbolData c1 = best.getSymbolData();
                    SymbolData c2 = curr.getSymbolData();
                    boolean c1IsSuperOrSame = c2.isAssignableTo(c1, LanguageLevelConverter.OPT.javaVersion());
                    boolean c2IsSuperOrSame = c1.isAssignableTo(c2, LanguageLevelConverter.OPT.javaVersion());
                    if (c1IsSuperOrSame && !c2IsSuperOrSame) {
                        best = curr;
                        continue;
                    }
                    if (c2IsSuperOrSame && !c1IsSuperOrSame) continue;
                }
                ambiguous = curr;
                continue;
            }
            if (!better2) continue;
            best = curr;
            ambiguous = null;
        }
        if (ambiguous != null) {
            StringBuffer invokeArgs = new StringBuffer("(");
            StringBuffer ambigArgs = new StringBuffer("(");
            StringBuffer bestArgs = new StringBuffer("(");
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    invokeArgs.append(", ");
                    ambigArgs.append(", ");
                    bestArgs.append(", ");
                }
                invokeArgs.append(arguments[i].getSymbolData().getName());
                ambigArgs.append(ambiguous.getParams()[i].getType().getSymbolData().getName());
                bestArgs.append(best.getParams()[i].getType().getSymbolData().getName());
            }
            invokeArgs.append(")");
            ambigArgs.append(")");
            bestArgs.append(")");
            TypeChecker._addError(new StringBuffer().append(best.getName()).append(invokeArgs.toString()).append(" is an ambiguous invocation.  It matches both ").append(best.getName()).append(bestArgs.toString()).append(" and ").append(ambiguous.getName()).append(ambigArgs.toString()).toString(), jexpr);
        }
        return best;
    }

    public static boolean checkAccessibility(JExpression piece, ModifiersAndVisibility mav, String name, SymbolData enclosingSD, SymbolData thisSD, String dataType) {
        return TypeChecker.checkAccessibility(piece, mav, name, enclosingSD, thisSD, dataType, true);
    }

    public static boolean checkAccessibility(ModifiersAndVisibility mav, SymbolData enclosingSD, SymbolData thisSD) {
        return TypeChecker.checkAccessibility(new NullLiteral(JExprParser.NO_SOURCE_INFO), mav, "", enclosingSD, thisSD, "", false);
    }

    public static boolean checkAccessibility(JExpression piece, ModifiersAndVisibility mav, String name, SymbolData enclosingSD, SymbolData thisSD, String dataType, boolean addError) {
        int i;
        if (thisSD.isOuterData(enclosingSD) || enclosingSD.isOuterData(thisSD) || thisSD == enclosingSD) {
            return true;
        }
        String[] modifiers = mav.getModifiers();
        for (i = 0; i < modifiers.length; ++i) {
            if (!modifiers[i].equals("public")) continue;
            Data enclosingOuter = enclosingSD.getOuterData();
            if (enclosingOuter == null) {
                return true;
            }
            if (enclosingOuter instanceof SymbolData) {
                return TypeChecker.checkAccessibility(piece, mav, name, enclosingSD.getOuterData().getSymbolData(), thisSD, dataType, addError);
            }
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Trying to reference ").append(name).append("which is a member of something other than a class from outside of that thing.  Please report this bug.").toString());
        }
        for (i = 0; i < modifiers.length; ++i) {
            if (!modifiers[i].equals("private")) continue;
            if (addError) {
                TypeChecker._addError(new StringBuffer().append("The ").append(dataType).append(" ").append(Data.dollarSignsToDots(name)).append(" is private and cannot be accessed from ").append(Data.dollarSignsToDots(thisSD.getName())).toString(), piece);
            }
            return false;
        }
        for (i = 0; i < modifiers.length; ++i) {
            if (!modifiers[i].equals("protected")) continue;
            if (TypeChecker._areInSamePackage(enclosingSD, thisSD)) {
                return true;
            }
            if (thisSD.isSubClassOf(enclosingSD)) {
                return true;
            }
            if (addError) {
                TypeChecker._addError(new StringBuffer().append("The ").append(dataType).append(" ").append(Data.dollarSignsToDots(name)).append(" is protected and cannot be accessed from ").append(Data.dollarSignsToDots(thisSD.getName())).toString(), piece);
            }
            return false;
        }
        if (TypeChecker._areInSamePackage(enclosingSD, thisSD)) {
            return true;
        }
        if (addError) {
            TypeChecker._addError(new StringBuffer().append("The ").append(dataType).append(" ").append(Data.dollarSignsToDots(name)).append(" is package protected because there is no access specifier and cannot be accessed from ").append(Data.dollarSignsToDots(thisSD.getName())).toString(), piece);
        }
        return false;
    }

    public static VariableData getFieldOrVariable(String text, Data data, SymbolData thisSD, JExpression piece) {
        if (data == null) {
            return null;
        }
        return TypeChecker.getFieldOrVariable(text, data, thisSD, piece, data.getVars(), true, true);
    }

    public static VariableData getFieldOrVariable(String text, Data data, SymbolData thisSD, JExpression piece, LinkedList<VariableData> vars) {
        return TypeChecker.getFieldOrVariable(text, data, thisSD, piece, vars, false, true);
    }

    public static VariableData getFieldOrVariable(String text, Data data, SymbolData thisSD, JExpression piece, LinkedList<VariableData> vars, boolean shouldRecur) {
        return TypeChecker.getFieldOrVariable(text, data, thisSD, piece, vars, shouldRecur, true);
    }

    public static VariableData getFieldOrVariable(String text, Data data, SymbolData thisSD, JExpression piece, LinkedList<VariableData> vars, boolean shouldRecur, boolean addError) {
        VariableData vd2 = null;
        if (data == null) {
            return null;
        }
        for (VariableData vd2 : vars) {
            if (vd2 == null || !vd2.getName().equals(text)) continue;
            if (vd2.getEnclosingData() instanceof BodyData && addError && thisSD.isOuterData(vd2.getEnclosingData()) && !vd2.isFinal() && addError) {
                TypeChecker._addError(new StringBuffer().append("Local variable ").append(vd2.getName()).append(" is accessed from within an inner class; must be declared final").toString(), piece);
            }
            if (addError) {
                TypeChecker.checkAccessibility(piece, vd2.getMav(), vd2.getName(), vd2.getEnclosingData().getSymbolData(), thisSD, "field or variable");
            }
            return vd2;
        }
        if (shouldRecur) {
            for (Data outerData : data.getEnclosingData()) {
                if (outerData == null) {
                    return null;
                }
                vd2 = TypeChecker.getFieldOrVariable(text, outerData, thisSD, piece, outerData.getVars(), true, addError);
                if (vd2 == null) continue;
                return vd2;
            }
        }
        return null;
    }

    public boolean assertInstanceType(TypeData type, String errorMsg, JExpression expression) {
        if (!type.isInstanceType()) {
            TypeChecker._addError(new StringBuffer().append(errorMsg).append(".  Perhaps you meant to create a new instance of ").append(type.getName()).toString(), expression);
            return false;
        }
        return true;
    }

    public boolean assertFound(TypeData type, JExpressionIF expression) {
        if (type instanceof PackageData) {
            TypeChecker._addError(new StringBuffer().append("Could not resolve symbol ").append(type.getName()).toString(), expression);
            return false;
        }
        return true;
    }

    protected static void _addError(String message, JExpressionIF that) {
        _errorAdded = true;
        errors.addLast(new Pair<String, JExpressionIF>(message, that));
    }

    protected TypeData[] makeArrayOfRetType(int len) {
        return new TypeData[len];
    }

    @Override
    protected TypeData defaultCase(JExpressionIF that) {
        return null;
    }

    public TypeData forClassDefOnly(ClassDef that, TypeData mav_result, TypeData name_result, TypeData[] typeParameters_result, TypeData superclass_result, TypeData[] interfaces_result, TypeData body_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forInnerClassDefOnly(InnerClassDef that, TypeData mav_result, TypeData name_result, TypeData[] typeParameters_result, TypeData superclass_result, TypeData[] interfaces_result, TypeData body_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forInterfaceDefOnly(InterfaceDef that, TypeData mav_result, TypeData name_result, TypeData[] typeParameters_result, TypeData[] superinterfaces_result, TypeData body_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forInnerInterfaceDefOnly(InnerInterfaceDef that, TypeData mav_result, TypeData name_result, TypeData[] typeParameters_result, TypeData[] superinterfaces_result, TypeData body_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forInstanceInitializerOnly(InstanceInitializer that, TypeData code_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forStaticInitializerOnly(StaticInitializer that, TypeData code_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forLabeledStatementOnly(LabeledStatement that, TypeData statement_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forBlockOnly(Block that, TypeData[] statements_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forExpressionStatementOnly(ExpressionStatement that, TypeData expression_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forSwitchStatementOnly(SwitchStatement that, TypeData test_result, TypeData[] cases_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forBreakStatementOnly(BreakStatement that) {
        return SymbolData.KEEP_GOING;
    }

    @Override
    public TypeData forContinueStatementOnly(ContinueStatement that) {
        return SymbolData.KEEP_GOING;
    }

    @Override
    public TypeData forReturnStatementOnly(ReturnStatement that) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forTryCatchStatementOnly(TryCatchStatement that, TypeData tryBlock_result, TypeData[] catchBlocks_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    public TypeData forMethodDefOnly(MethodDef that, TypeData mav_result, TypeData[] typeParams_result, TypeData result_result, TypeData name_result, TypeData params_result, TypeData[] throws_result) {
        return result_result;
    }

    public TypeData forConcreteMethodDefOnly(ConcreteMethodDef that, TypeData mav_result, TypeData[] typeParams_result, TypeData result_result, TypeData name_result, TypeData params_result, TypeData[] throws_result, TypeData body_result) {
        return this.forMethodDefOnly((MethodDef)that, mav_result, typeParams_result, result_result, name_result, params_result, throws_result);
    }

    protected SymbolData getCommonSuperTypeBaseCase(SymbolData sdLeft, SymbolData sdRight) {
        if (sdLeft == SymbolData.EXCEPTION) {
            return sdRight;
        }
        if (sdRight == SymbolData.EXCEPTION) {
            return sdLeft;
        }
        if (this._isAssignableFrom(sdLeft, sdRight)) {
            return sdLeft;
        }
        if (this._isAssignableFrom(sdRight, sdLeft)) {
            return sdRight;
        }
        return null;
    }

    protected boolean _isAssignableFrom(SymbolData sdLeft, SymbolData sdRight) {
        if (sdRight == null) {
            return false;
        }
        return sdRight.isAssignableTo(sdLeft, LanguageLevelConverter.OPT.javaVersion());
    }

    protected boolean _isAssignableFromWithoutAutoboxing(SymbolData sdLeft, SymbolData sdRight) {
        if (sdRight == null) {
            return false;
        }
        return sdRight.isAssignableTo(sdLeft, JavaVersion.JAVA_1_4);
    }

    protected void _checkAbstractMethods(SymbolData sd, JExpression classDef) {
        if (sd.hasModifier("abstract") || sd.isInterface()) {
            return;
        }
        LinkedList<MethodData> mds = sd.getMethods();
        LinkedList<MethodData> cmds = this._cloneMethodDataList(mds);
        for (SymbolData superD = sd.getSuperClass(); superD != null && !superD.getName().equals("java.lang.Object"); superD = superD.getSuperClass()) {
            LinkedList<MethodData> smds = superD.getMethods();
            for (MethodData md : smds) {
                if (md.hasModifier("abstract")) continue;
                cmds.addLast(md);
            }
        }
        this._checkAbstractMethodsHelper(sd, sd.getSuperClass(), cmds, classDef);
        LinkedList<SymbolData> interfaces = sd.getInterfaces();
        for (SymbolData next : interfaces) {
            this._checkAbstractMethodsHelper(sd, next, cmds, classDef);
        }
    }

    private void _checkAbstractMethodsHelper(SymbolData origSd, SymbolData sd, LinkedList<MethodData> concreteMds, JExpression classDef) {
        if (sd == null || !sd.hasModifier("abstract") && !sd.isInterface()) {
            return;
        }
        LinkedList<MethodData> mds = sd.getMethods();
        for (MethodData md : mds) {
            if (md.hasModifier("abstract")) {
                int i;
                MethodData matchingMd = SymbolData.repeatedSignature(concreteMds, md);
                if (matchingMd != null) continue;
                StringBuffer message = classDef instanceof AnonymousClassInstantiation ? new StringBuffer(new StringBuffer().append("This anonymous inner class must override the abstract method: ").append(md.getName()).toString()) : new StringBuffer(new StringBuffer().append(origSd.getName()).append(" must be declared abstract or must override the abstract method: ").append(md.getName()).toString());
                VariableData[] params = md.getParams();
                InstanceData[] arguments = new InstanceData[params.length];
                for (i = 0; i < params.length; ++i) {
                    arguments[i] = params[i].getType();
                }
                message.append("(");
                if (arguments.length > 0) {
                    message.append(arguments[0].getName());
                    for (i = 1; i < arguments.length; ++i) {
                        message.append(new StringBuffer().append(", ").append(arguments[i].getName()).toString());
                    }
                }
                message.append(new StringBuffer().append(") in ").append(sd.getName()).toString());
                TypeChecker._addError(message.toString(), classDef);
                continue;
            }
            concreteMds.addLast(md);
        }
        this._checkAbstractMethodsHelper(origSd, sd.getSuperClass(), this._cloneMethodDataList(concreteMds), classDef);
        LinkedList<SymbolData> interfaces = sd.getInterfaces();
        Iterator interiter = interfaces.iterator();
        while (interiter.hasNext()) {
            this._checkAbstractMethodsHelper(origSd, (SymbolData)interiter.next(), this._cloneMethodDataList(concreteMds), classDef);
        }
    }

    private LinkedList<MethodData> _cloneMethodDataList(LinkedList<MethodData> mds) {
        LinkedList<MethodData> toReturn = new LinkedList<MethodData>();
        for (int i = 0; i < mds.size(); ++i) {
            toReturn.addLast(mds.get(i));
        }
        return toReturn;
    }

    private LinkedList<SymbolData> cloneSDList(LinkedList<SymbolData> l) {
        LinkedList<SymbolData> l2 = new LinkedList<SymbolData>();
        for (int i = 0; i < l.size(); ++i) {
            l2.addLast(l.get(i));
        }
        return l2;
    }

    protected boolean checkForCyclicInheritance(SymbolData sd, LinkedList<SymbolData> hierarchy, TypeDefBase tdb) {
        if (sd == null || LanguageLevelVisitor.isJavaLibraryClass(sd.getName())) {
            return false;
        }
        if (hierarchy.contains(sd)) {
            TypeChecker._addError(new StringBuffer().append("Cyclic inheritance involving ").append(sd.getName()).toString(), tdb);
            return true;
        }
        hierarchy.addLast(sd);
        LinkedList<SymbolData> innerClasses = sd.getInnerClasses();
        for (int i = 0; i < innerClasses.size(); ++i) {
            hierarchy.addLast(innerClasses.get(i));
        }
        boolean doReturn = this.checkForCyclicInheritance(sd.getSuperClass(), this.cloneSDList(hierarchy), tdb);
        LinkedList<SymbolData> interfaces = sd.getInterfaces();
        for (int i = 0; i < interfaces.size(); ++i) {
            SymbolData currInterface = interfaces.get(i);
            doReturn |= this.checkForCyclicInheritance(currInterface, this.cloneSDList(hierarchy), tdb);
        }
        return doReturn;
    }

    @Override
    public TypeData forClassDef(ClassDef that) {
        SymbolData superClass;
        String className = this.getQualifiedClassName(that.getName().getText());
        SymbolData sd = this.getSymbolData(className, that, true, false);
        if (this.checkForCyclicInheritance(sd, new LinkedList<SymbolData>(), that)) {
            return null;
        }
        if (sd.hasModifier("public")) {
            String fileName = className.replace('.', System.getProperty("file.separator").charAt(0));
            if (!(this._file.getAbsolutePath().endsWith(new StringBuffer().append(fileName).append(".dj0").toString()) || this._file.getAbsolutePath().endsWith(new StringBuffer().append(fileName).append(".dj1").toString()) || this._file.getAbsolutePath().endsWith(new StringBuffer().append(fileName).append(".dj2").toString()))) {
                TypeChecker._addError(new StringBuffer().append(className).append(" is public thus must be defined in a file with the same name.").toString(), that.getName());
            }
        }
        sd.setAnonymousInnerClassNum(0);
        if (sd.hasInterface(this.getSymbolData("java.lang.Runnable", that, false, false))) {
            TypeChecker._addError(new StringBuffer().append(sd.getName()).append(" implements the Runnable interface, which is not allowed at any language level").toString(), that);
        }
        if ((superClass = sd.getSuperClass()) != null) {
            TypeChecker.checkAccessibility(that.getSuperclass(), superClass.getMav(), superClass.getName(), superClass, sd, "class");
            if (superClass.isInterface()) {
                TypeChecker._addError(new StringBuffer().append(superClass.getName()).append(" is an interface and thus cannot appear after the keyword 'extends' here.  Perhaps you meant to say 'implements'?").toString(), that);
            }
        }
        if (superClass != null && superClass.hasModifier("final")) {
            TypeChecker._addError(new StringBuffer().append("Class ").append(sd.getName()).append(" cannot extend the final class ").append(superClass.getName()).toString(), that);
            return sd;
        }
        TypeData mav_result = that.getMav().visit(this);
        TypeData name_result = that.getName().visit(this);
        TypeData[] typeParameters_result = this.makeArrayOfRetType(that.getTypeParameters().length);
        for (int i = 0; i < that.getTypeParameters().length; ++i) {
            typeParameters_result[i] = that.getTypeParameters()[i].visit(this);
        }
        TypeData superclass_result = that.getSuperclass().visit(this);
        TypeData[] interfaces_result = new SymbolData[that.getInterfaces().length];
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            interfaces_result[i] = this.getSymbolData(that.getInterfaces()[i].getName(), that.getInterfaces()[i], true, true);
            if (interfaces_result[i] != null) {
                TypeChecker.checkAccessibility(that.getInterfaces()[i], interfaces_result[i].getMav(), interfaces_result[i].getName(), interfaces_result[i], sd, "interface");
                if (interfaces_result[i].isInterface()) continue;
                TypeChecker._addError(new StringBuffer().append(interfaces_result[i].getName()).append(" is not an interface and thus cannot appear after the keyword 'implements' here.  Perhaps you meant to say 'extends'?").toString(), that);
                continue;
            }
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: getSymbolData( ").append(that.getInterfaces()[i].getName()).append(") returned null.  Please report this bug.").toString());
        }
        ClassBodyTypeChecker cbtc = null;
        SymbolData testSd = this.getSymbolData("junit.framework.TestCase", new NullLiteral(JExprParser.NO_SOURCE_INFO), false, true);
        if (testSd != null && sd.isSubClassOf(testSd)) {
            if (!sd.hasModifier("public")) {
                TypeChecker._addError(new StringBuffer().append(sd.getName()).append(" extends TestCase and thus must be explicitly declared public").toString(), that);
            }
            boolean foundOne = false;
            for (int i = 0; i < sd.getMethods().size(); ++i) {
                MethodData myMd = sd.getMethods().get(i);
                if (!myMd.getName().startsWith("test") || myMd.getReturnType() != SymbolData.VOID_TYPE || !myMd.hasModifier("public")) continue;
                foundOne = true;
                break;
            }
            if (!foundOne) {
                TypeChecker._addError(new StringBuffer().append("Class ").append(sd.getName()).append(" does not have any valid test methods.  Test methods must be declared public, must return void, and must start with the word \"test\"").toString(), that);
            }
        } else if (LanguageLevelConverter.isElementaryFile(this._file)) {
            cbtc = new VoidMethodsNotAllowedClassBodyTypeChecker(sd, this._file, this._package, this._importedFiles, this._importedPackages, new LinkedList<VariableData>(), new LinkedList<Pair<SymbolData, JExpression>>(), "Elementary");
        } else if (LanguageLevelConverter.isIntermediateFile(this._file)) {
            cbtc = new VoidMethodsNotAllowedClassBodyTypeChecker(sd, this._file, this._package, this._importedFiles, this._importedPackages, new LinkedList<VariableData>(), new LinkedList<Pair<SymbolData, JExpression>>(), "Intermediate");
        }
        if (cbtc == null) {
            cbtc = new ClassBodyTypeChecker(sd, this._file, this._package, this._importedFiles, this._importedPackages, new LinkedList<VariableData>(), new LinkedList<Pair<SymbolData, JExpression>>());
        }
        TypeData body_result = (TypeData)that.getBody().visit(cbtc);
        this._checkAbstractMethods(sd, that);
        if (!cbtc.hasConstructor) {
            LinkedList<VariableData> sdVars = sd.getVars();
            for (int i = 0; i < sdVars.size(); ++i) {
                if (sdVars.get(i).hasValue()) continue;
                TypeChecker._addError(new StringBuffer().append("The final field ").append(sdVars.get(i).getName()).append(" has not been initialized").toString(), that);
                return null;
            }
        }
        this.unassignVariableDatas(cbtc.thingsThatHaveBeenAssigned);
        return this.forClassDefOnly(that, mav_result, name_result, typeParameters_result, superclass_result, interfaces_result, body_result);
    }

    @Override
    public TypeData forInterfaceDef(InterfaceDef that) {
        String interfaceName = this.getQualifiedClassName(that.getName().getText());
        SymbolData sd = this.getSymbolData(interfaceName, that, true, false);
        if (sd.hasModifier("public")) {
            String fileName = interfaceName.replace('.', System.getProperty("file.separator").charAt(0));
            if (!(this._file.getAbsolutePath().endsWith(new StringBuffer().append(fileName).append(".dj0").toString()) || this._file.getAbsolutePath().endsWith(new StringBuffer().append(fileName).append(".dj1").toString()) || this._file.getAbsolutePath().endsWith(new StringBuffer().append(fileName).append(".dj2").toString()))) {
                TypeChecker._addError(new StringBuffer().append(interfaceName).append(" is public thus must be defined in a file with the same name.").toString(), that.getName());
            }
        }
        if (this.checkForCyclicInheritance(sd, new LinkedList<SymbolData>(), that)) {
            return null;
        }
        if (sd.hasInterface(this.getSymbolData("java.lang.Runnable", that, false, false))) {
            TypeChecker._addError(new StringBuffer().append(sd.getName()).append(" extends the Runnable interface, which is not allowed at any language level").toString(), that);
        }
        TypeData mav_result = that.getMav().visit(this);
        TypeData name_result = that.getName().visit(this);
        TypeData[] typeParameters_result = this.makeArrayOfRetType(that.getTypeParameters().length);
        for (int i = 0; i < that.getTypeParameters().length; ++i) {
            typeParameters_result[i] = that.getTypeParameters()[i].visit(this);
        }
        TypeData[] interfaces_result = new SymbolData[that.getInterfaces().length];
        for (int i = 0; i < that.getInterfaces().length; ++i) {
            interfaces_result[i] = this.getSymbolData(that.getInterfaces()[i].getName(), that.getInterfaces()[i], true, true);
            if (interfaces_result[i] != null) {
                TypeChecker.checkAccessibility(that.getInterfaces()[i], interfaces_result[i].getMav(), interfaces_result[i].getName(), (SymbolData)interfaces_result[i], sd, "interface");
                if (((SymbolData)interfaces_result[i]).isInterface()) continue;
                TypeChecker._addError(new StringBuffer().append(interfaces_result[i].getName()).append(" is not an interface and thus cannot appear after the keyword 'extends' here").toString(), that);
                continue;
            }
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: getSymbolData( ").append(that.getInterfaces()[i].getName()).append(") returned null.  Please report this bug.").toString());
        }
        TypeData body_result = that.getBody().visit(new InterfaceBodyTypeChecker(sd, this._file, this._package, this._importedFiles, this._importedPackages, new LinkedList<VariableData>(), new LinkedList<Pair<SymbolData, JExpression>>()));
        return this.forInterfaceDefOnly(that, mav_result, name_result, typeParameters_result, interfaces_result, body_result);
    }

    @Override
    public TypeData forClassImportStatement(ClassImportStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        StringBuffer name = new StringBuffer(words[0].getText());
        for (int i = 1; i < words.length; ++i) {
            name.append(new StringBuffer().append(".").append(words[i].getText()).toString());
        }
        SymbolData cWord_result = this.getSymbolData(name.toString(), that, true, true);
        if (cWord_result != null && !cWord_result.hasModifier("public")) {
            TypeChecker._addError(new StringBuffer().append(cWord_result.getName()).append(" is not public, and thus cannot be seen here").toString(), that);
        }
        return this.forClassImportStatementOnly(that, cWord_result);
    }

    @Override
    public TypeData forPackageStatement(PackageStatement that) {
        CompoundWord cWord = that.getCWord();
        Word[] words = cWord.getWords();
        StringBuffer nameBuff = new StringBuffer(words[0].getText());
        for (int i = 1; i < words.length; ++i) {
            nameBuff.append(new StringBuffer().append(".").append(words[i].getText()).toString());
        }
        String name = nameBuff.toString();
        if (symbolTable.get(name) != null) {
            TypeChecker._addError(new StringBuffer().append(name).append(" is not a allowable package name, because it conflicts with a class you have already defined").toString(), that);
        }
        return null;
    }

    @Override
    public TypeData forPrimitiveType(PrimitiveType that) {
        String text = that.getName();
        if (text.equals("boolean")) {
            return SymbolData.BOOLEAN_TYPE;
        }
        if (text.equals("char")) {
            return SymbolData.CHAR_TYPE;
        }
        if (text.equals("byte")) {
            return SymbolData.BYTE_TYPE;
        }
        if (text.equals("short")) {
            return SymbolData.SHORT_TYPE;
        }
        if (text.equals("int")) {
            return SymbolData.INT_TYPE;
        }
        if (text.equals("long")) {
            return SymbolData.LONG_TYPE;
        }
        if (text.equals("float")) {
            return SymbolData.FLOAT_TYPE;
        }
        if (text.equals("double")) {
            return SymbolData.DOUBLE_TYPE;
        }
        throw new RuntimeException(new StringBuffer().append("Internal Program Error: Not a legal primitive type: ").append(text).append(".  Please report this bug").toString());
    }

    @Override
    public TypeData forCastExpression(CastExpression that) {
        TypeData type_result = that.getType().visit(this);
        TypeData value_result = that.getValue().visit(this);
        if (value_result == null) {
            return type_result;
        }
        return this.forCastExpressionOnly(that, type_result, value_result);
    }

    void unassignVariableDatas(LinkedList<VariableData> toUnassign) {
        for (int i = 0; i < toUnassign.size(); ++i) {
            toUnassign.get(i).lostValue();
        }
    }

    @Override
    public Object forCastExpression(CastExpression x0) {
        return this.forCastExpression(x0);
    }

    @Override
    public Object forPrimitiveType(PrimitiveType x0) {
        return this.forPrimitiveType(x0);
    }

    @Override
    public Object forClassImportStatement(ClassImportStatement x0) {
        return this.forClassImportStatement(x0);
    }

    @Override
    public Object forPackageStatement(PackageStatement x0) {
        return this.forPackageStatement(x0);
    }

    @Override
    public Object forInterfaceDef(InterfaceDef x0) {
        return this.forInterfaceDef(x0);
    }

    @Override
    public Object forClassDef(ClassDef x0) {
        return this.forClassDef(x0);
    }

    @Override
    public Object forTryCatchStatementOnly(TryCatchStatement x0, Object x1, Object[] x2) {
        return this.forTryCatchStatementOnly(x0, (TypeData)x1, (TypeData[])x2);
    }

    @Override
    public Object forReturnStatementOnly(ReturnStatement x0) {
        return this.forReturnStatementOnly(x0);
    }

    @Override
    public Object forContinueStatementOnly(ContinueStatement x0) {
        return this.forContinueStatementOnly(x0);
    }

    @Override
    public Object forBreakStatementOnly(BreakStatement x0) {
        return this.forBreakStatementOnly(x0);
    }

    @Override
    public Object forSwitchStatementOnly(SwitchStatement x0, Object x1, Object[] x2) {
        return this.forSwitchStatementOnly(x0, (TypeData)x1, (TypeData[])x2);
    }

    @Override
    public Object forExpressionStatementOnly(ExpressionStatement x0, Object x1) {
        return this.forExpressionStatementOnly(x0, (TypeData)x1);
    }

    @Override
    public Object forStaticInitializerOnly(StaticInitializer x0, Object x1) {
        return this.forStaticInitializerOnly(x0, (TypeData)x1);
    }

    @Override
    public Object forInstanceInitializerOnly(InstanceInitializer x0, Object x1) {
        return this.forInstanceInitializerOnly(x0, (TypeData)x1);
    }

    @Override
    public Object forInnerInterfaceDefOnly(InnerInterfaceDef x0, Object x1, Object x2, Object[] x3, Object[] x4, Object x5) {
        return this.forInnerInterfaceDefOnly(x0, (TypeData)x1, (TypeData)x2, (TypeData[])x3, (TypeData[])x4, (TypeData)x5);
    }

    @Override
    public Object forInterfaceDefOnly(InterfaceDef x0, Object x1, Object x2, Object[] x3, Object[] x4, Object x5) {
        return this.forInterfaceDefOnly(x0, (TypeData)x1, (TypeData)x2, (TypeData[])x3, (TypeData[])x4, (TypeData)x5);
    }

    @Override
    public Object forInnerClassDefOnly(InnerClassDef x0, Object x1, Object x2, Object[] x3, Object x4, Object[] x5, Object x6) {
        return this.forInnerClassDefOnly(x0, (TypeData)x1, (TypeData)x2, (TypeData[])x3, (TypeData)x4, (TypeData[])x5, (TypeData)x6);
    }

    @Override
    public Object forClassDefOnly(ClassDef x0, Object x1, Object x2, Object[] x3, Object x4, Object[] x5, Object x6) {
        return this.forClassDefOnly(x0, (TypeData)x1, (TypeData)x2, (TypeData[])x3, (TypeData)x4, (TypeData[])x5, (TypeData)x6);
    }

    @Override
    protected Object defaultCase(JExpressionIF x0) {
        return this.defaultCase(x0);
    }

    @Override
    protected Object[] makeArrayOfRetType(int x0) {
        return this.makeArrayOfRetType(x0);
    }

    static boolean access$000(SymbolData x0, SymbolData x1) {
        return TypeChecker._areInSamePackage(x0, x1);
    }

    static void access$100(TypeChecker x0, SymbolData x1, SymbolData x2, LinkedList x3, JExpression x4) {
        x0._checkAbstractMethodsHelper(x1, x2, x3, x4);
    }
}

