/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.javalanglevels.AdvancedVisitor;
import edu.rice.cs.javalanglevels.Augmentor;
import edu.rice.cs.javalanglevels.ElementaryVisitor;
import edu.rice.cs.javalanglevels.IntermediateVisitor;
import edu.rice.cs.javalanglevels.JExprParseException;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.Options;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.Symboltable;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.parser.JExprParser;
import edu.rice.cs.javalanglevels.parser.ParseException;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.SourceFile;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageLevelConverter {
    public static Options OPT = Options.DEFAULT;
    private static final boolean SAFE_SUPPORT_CODE = false;
    private LinkedList<JExprParseException> _parseExceptions = new LinkedList();
    private LinkedList<Pair<String, JExpressionIF>> _visitorErrors = new LinkedList();

    private void _addParseException(ParseException pe) {
        JExprParseException jpe = pe instanceof JExprParseException ? (JExprParseException)pe : new JExprParseException(pe);
        this._parseExceptions.addLast(jpe);
    }

    private void _addVisitorError(Pair<String, JExpressionIF> ve) {
        this._visitorErrors.addLast(ve);
    }

    public Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> convert(File[] files, Options options) {
        String firstLine;
        BufferedReader tempBr;
        int ind;
        OPT = options;
        LanguageLevelVisitor._newSDs = new Hashtable();
        LinkedList<Pair<String, JExpressionIF>> languageLevelVisitorErrors = new LinkedList<Pair<String, JExpressionIF>>();
        Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations = new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>();
        Hashtable<SymbolData, LanguageLevelVisitor> languageLevelNewSDs = new Hashtable<SymbolData, LanguageLevelVisitor>();
        Symboltable languageLevelVisitorSymbolTable = new Symboltable();
        LinkedList<Pair<LanguageLevelVisitor, SourceFile>> languageLevelVisitedFiles = new LinkedList<Pair<LanguageLevelVisitor, SourceFile>>();
        Hashtable<Integer, Pair<SourceFile, Object>> mediator = new Hashtable<Integer, Pair<SourceFile, Object>>();
        LinkedList<File> filesNotToCheck = new LinkedList<File>();
        int originalNumOfFiles = files.length;
        LinkedList<Pair<ElementaryVisitor, SourceFile>> visited = new LinkedList<Pair<ElementaryVisitor, SourceFile>>();
        for (ind = 0; ind < originalNumOfFiles; ++ind) {
            try {
                SourceFile sf;
                tempBr = new BufferedReader(new FileReader(files[ind]));
                firstLine = tempBr.readLine();
                if (firstLine == null) continue;
                tempBr.close();
                boolean foundFile = false;
                for (int i = 0; i < filesNotToCheck.size(); ++i) {
                    if (!((File)filesNotToCheck.get(i)).getAbsolutePath().equals(files[ind].getAbsolutePath())) continue;
                    foundFile = true;
                    break;
                }
                if (!LanguageLevelConverter._isLanguageLevelFile(files[ind]) || foundFile) continue;
                System.out.flush();
                File f = files[ind];
                JExprParser jExprParser = new JExprParser(f);
                try {
                    sf = jExprParser.SourceFile();
                }
                catch (ParseException pe) {
                    this._addParseException(pe);
                    continue;
                }
                LanguageLevelVisitor llv = null;
                if (LanguageLevelConverter.isElementaryFile(f)) {
                    llv = new ElementaryVisitor(f, new LinkedList<Pair<String, JExpressionIF>>(), languageLevelVisitorSymbolTable, new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), languageLevelVisitedFiles, languageLevelNewSDs);
                } else if (LanguageLevelConverter.isIntermediateFile(f)) {
                    llv = new IntermediateVisitor(f, new LinkedList<Pair<String, JExpressionIF>>(), languageLevelVisitorSymbolTable, new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), languageLevelVisitedFiles, languageLevelNewSDs);
                } else if (LanguageLevelConverter.isAdvancedFile(f)) {
                    llv = new AdvancedVisitor(f, new LinkedList<Pair<String, JExpressionIF>>(), languageLevelVisitorSymbolTable, new Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>>(), languageLevelVisitedFiles, languageLevelNewSDs);
                } else {
                    throw new RuntimeException("Internal Bug: Invalid file format not caught initially.  Please report this bug.");
                }
                sf.visit(llv);
                visited.add(new Pair<ElementaryVisitor, SourceFile>((ElementaryVisitor)llv, sf));
                continuations.putAll(LanguageLevelVisitor.continuations);
                languageLevelVisitorErrors.addAll(LanguageLevelVisitor.errors);
                continue;
            }
            catch (IOException ioe) {
                this._addVisitorError(new Pair<String, JExpressionIF>(ioe.getMessage(), new NullLiteral(JExprParser.NO_SOURCE_INFO)));
            }
        }
        LanguageLevelVisitor.errors = new LinkedList();
        while (!continuations.isEmpty()) {
            Enumeration en = continuations.keys();
            while (en.hasMoreElements()) {
                String className = (String)en.nextElement();
                Pair pair = (Pair)continuations.remove(className);
                SymbolData returnedSd = ((LanguageLevelVisitor)pair.getSecond()).getSymbolData(className, (SourceInfo)pair.getFirst(), true);
                if (returnedSd != null) continue;
                LanguageLevelVisitor.errors.add(new Pair<String, NullLiteral>(new StringBuffer().append("Could not resolve ").append(className).toString(), new NullLiteral((SourceInfo)pair.getFirst())));
            }
        }
        while (!LanguageLevelVisitor._newSDs.isEmpty()) {
            Enumeration<SymbolData> en = LanguageLevelVisitor._newSDs.keys();
            while (en.hasMoreElements()) {
                SymbolData first = en.nextElement();
                LanguageLevelVisitor sdlv = LanguageLevelVisitor._newSDs.remove(first);
                sdlv.createConstructor(first);
            }
        }
        languageLevelVisitorErrors.addAll(LanguageLevelVisitor.errors);
        if (languageLevelVisitorErrors.size() > 0) {
            this._visitorErrors.addAll(languageLevelVisitorErrors);
        } else {
            for (ind = 0; ind < visited.size(); ++ind) {
                LanguageLevelVisitor llv = (LanguageLevelVisitor)((Pair)visited.get(ind)).getFirst();
                SourceFile sf = (SourceFile)((Pair)visited.get(ind)).getSecond();
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Integer") == null) {
                    llv.getSymbolData("java.lang.Integer", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Double") == null) {
                    llv.getSymbolData("java.lang.Double", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Character") == null) {
                    llv.getSymbolData("java.lang.Character", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Boolean") == null) {
                    llv.getSymbolData("java.lang.Boolean", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Long") == null) {
                    llv.getSymbolData("java.lang.Long", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Byte") == null) {
                    llv.getSymbolData("java.lang.Byte", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Short") == null) {
                    llv.getSymbolData("java.lang.Short", JExprParser.NO_SOURCE_INFO);
                }
                if (LanguageLevelVisitor.symbolTable.get("java.lang.Float") == null) {
                    llv.getSymbolData("java.lang.Float", JExprParser.NO_SOURCE_INFO);
                }
                TypeChecker btc = new TypeChecker(llv._file, llv._package, LanguageLevelVisitor.errors, LanguageLevelVisitor.symbolTable, llv._importedFiles, llv._importedPackages);
                sf.visit(btc);
                if (TypeChecker.errors.size() > 0) {
                    this._visitorErrors.addAll(TypeChecker.errors);
                }
                if (LanguageLevelVisitor.visitedFiles.size() > 0) {
                    LinkedList<File> newFiles = new LinkedList<File>();
                    for (int i = 0; i < files.length; ++i) {
                        newFiles.addLast(files[i]);
                    }
                    for (Pair pair : LanguageLevelVisitor.visitedFiles) {
                        File fileToAdd = ((LanguageLevelVisitor)pair.getFirst())._file;
                        SourceFile currSf = (SourceFile)pair.getSecond();
                        if (currSf != null) {
                            if (newFiles.contains(fileToAdd)) {
                                mediator.put(new Integer(newFiles.indexOf(fileToAdd)), new Pair(currSf, pair.getFirst()));
                            }
                            if (!newFiles.contains(fileToAdd) && currSf != null) {
                                mediator.put(new Integer(newFiles.size()), new Pair(currSf, pair.getFirst()));
                                newFiles.addLast(fileToAdd);
                            }
                        }
                        if (filesNotToCheck.contains(fileToAdd)) continue;
                        filesNotToCheck.addLast(fileToAdd);
                    }
                    files = newFiles.toArray(new File[newFiles.size()]);
                }
                mediator.put(new Integer(ind), new Pair<SourceFile, LanguageLevelVisitor>(sf, llv));
            }
        }
        if (this._parseExceptions.size() > 0 || this._visitorErrors.size() > 0) {
            return new Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>>(this._parseExceptions, this._visitorErrors);
        }
        for (ind = 0; ind < files.length; ++ind) {
            try {
                Pair pair;
                tempBr = new BufferedReader(new FileReader(files[ind]));
                firstLine = tempBr.readLine();
                tempBr.close();
                if (firstLine == null || !LanguageLevelConverter._isLanguageLevelFile(files[ind]) || (pair = (Pair)mediator.get(new Integer(ind))) == null) continue;
                SourceFile sf = (SourceFile)pair.getFirst();
                LanguageLevelVisitor llv = (LanguageLevelVisitor)pair.getSecond();
                File file = files[ind];
                String augmentedFilePath = file.getAbsolutePath();
                augmentedFilePath = augmentedFilePath.substring(0, augmentedFilePath.length() - 4);
                File augmentedFile = new File(new StringBuffer().append(augmentedFilePath).append(".java").toString());
                BufferedReader br = new BufferedReader(new FileReader(file));
                BufferedWriter bw = new BufferedWriter(new FileWriter(augmentedFile));
                Augmentor a = new Augmentor(false, br, bw, llv);
                sf.visit(a);
                br.close();
                bw.close();
                continue;
            }
            catch (Augmentor.Exception ae) {
                this._addVisitorError(new Pair<String, JExpressionIF>(ae.getMessage(), new NullLiteral(JExprParser.NO_SOURCE_INFO)));
                continue;
            }
            catch (IOException ioe) {
                this._addVisitorError(new Pair<String, JExpressionIF>(ioe.getMessage(), new NullLiteral(JExprParser.NO_SOURCE_INFO)));
            }
        }
        return new Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>>(this._parseExceptions, this._visitorErrors);
    }

    public static boolean isElementaryFile(File f) {
        return f.getPath().endsWith(".dj0");
    }

    public static boolean isIntermediateFile(File f) {
        return f.getPath().endsWith(".dj1");
    }

    public static boolean isAdvancedFile(File f) {
        return f.getPath().endsWith(".dj2");
    }

    public static boolean _isLanguageLevelFile(File f) {
        return LanguageLevelConverter.isElementaryFile(f) || LanguageLevelConverter.isIntermediateFile(f) || LanguageLevelConverter.isAdvancedFile(f);
    }

    public static boolean versionSupportsAutoboxing(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionSupportsGenerics(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionSupportsForEach(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static boolean versionIs15(JavaVersion version) {
        return version.supports(JavaVersion.JAVA_5);
    }

    public static void main(String[] args) {
        LanguageLevelConverter llc = new LanguageLevelConverter();
        File[] files = new File[args.length];
        for (int i = 0; i < args.length; ++i) {
            files[i] = new File(args[i]);
        }
        Pair<LinkedList<JExprParseException>, LinkedList<Pair<String, JExpressionIF>>> result = llc.convert(files, new Options(JavaVersion.JAVA_5, (Iterable_)((Object)IterUtil.empty())));
        System.out.println(new StringBuffer().append(result.getFirst().size() + result.getSecond().size()).append(" errors.").toString());
        for (JExprParseException jExprParseException : result.getFirst()) {
            System.out.println(jExprParseException);
        }
        for (Pair pair : result.getSecond()) {
            System.out.println(new StringBuffer().append((String)pair.getFirst()).append(" ").append(((JExpressionIF)pair.getSecond()).getSourceInfo()).toString());
        }
    }
}

