/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Bob;
import edu.rice.cs.javalanglevels.BodyTypeChecker;
import edu.rice.cs.javalanglevels.ConstructorBodyTypeChecker;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.FormalParameter;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.Type;
import edu.rice.cs.javalanglevels.tree.UninitializedVariableDeclarator;
import edu.rice.cs.javalanglevels.tree.Word;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ClassBodyTypeChecker
extends Bob {
    private SymbolData _symbolData;
    protected boolean hasConstructor;

    public ClassBodyTypeChecker(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<VariableData> vars, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        super(sd, file, packageName, importedFiles, importedPackages, vars, thrown);
        this._symbolData = sd;
        this.hasConstructor = false;
        this._vars.addAll(sd.getVars());
        LinkedList<VariableData> superVars = sd.getAllSuperVars();
        for (int i = 0; i < superVars.size(); ++i) {
            VariableData tempVD = superVars.get(i);
            if (!tempVD.isFinal() || !tempVD.gotValue()) continue;
            this.thingsThatHaveBeenAssigned.addLast(tempVD);
        }
        this._vars.addAll(superVars);
    }

    @Override
    protected Data _getData() {
        return this._symbolData;
    }

    @Override
    public TypeData forUninitializedVariableDeclaratorOnly(UninitializedVariableDeclarator that, TypeData type_result, TypeData name_result) {
        Word name = that.getName();
        String text = that.getName().getText();
        VariableData vd = ClassBodyTypeChecker.getFieldOrVariable(text, this._symbolData, this._symbolData, name);
        if (vd == null) {
            throw new RuntimeException(new StringBuffer().append("The field ").append(text).append(" was not found in ").append(this._symbolData.getName()).append(".").toString());
        }
        this._vars.addLast(vd);
        return null;
    }

    private void _checkReturnType(SymbolData expected, SymbolData actual, ConcreteMethodDef that) {
        if (expected == SymbolData.VOID_TYPE) {
            if (actual != null && actual == SymbolData.VOID_TYPE) {
                // empty if block
            }
        } else if (actual == null) {
            ClassBodyTypeChecker._addError("This method is missing a return statement.", that);
        }
    }

    @Override
    public TypeData forConstructorDef(ConstructorDef that) {
        this.hasConstructor = true;
        TypeData mav_result = that.getMav().visit(this);
        TypeData[] parameters_result = this.makeArrayOfRetType(that.getParameters().length);
        TypeData[] throws_result = this.makeArrayOfRetType(that.getThrows().length);
        for (int i = 0; i < that.getThrows().length; ++i) {
            throws_result[i] = this.getSymbolData(that.getThrows()[i].getName(), this._symbolData, that);
        }
        MethodData md = null;
        FormalParameter[] fParams = that.getParameters();
        String[] paramTypes = new String[fParams.length];
        for (int i = 0; i < fParams.length; ++i) {
            paramTypes[i] = fParams[i].getDeclarator().getType().getName();
        }
        LinkedList<MethodData> mds = this._symbolData.getMethods();
        Iterator iter = mds.iterator();
        while (iter.hasNext()) {
            VariableData[] vds;
            boolean match = true;
            MethodData tempMd = (MethodData)iter.next();
            if (!tempMd.getName().equals(LanguageLevelVisitor.getUnqualifiedClassName(this._symbolData.getName())) || paramTypes.length != (vds = tempMd.getParams()).length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (vds[i].getType().getName().equals(paramTypes[i]) || LanguageLevelVisitor.getUnqualifiedClassName(vds[i].getType().getName()).equals(paramTypes[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            md = tempMd;
            break;
        }
        if (md == null) {
            throw new RuntimeException(new StringBuffer().append("The constructor ").append(LanguageLevelVisitor.getUnqualifiedClassName(this._symbolData.getName())).append(" was not in the class ").append(this._symbolData.getName()).append(".").toString());
        }
        LinkedList<VariableData> ll = new LinkedList<VariableData>();
        VariableData[] vds = md.getParams();
        for (int i = 0; i < vds.length; ++i) {
            ll.addLast(vds[i]);
        }
        ll.addAll(this.cloneVariableDataList(this._vars));
        ConstructorBodyTypeChecker btc = new ConstructorBodyTypeChecker(md, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, ll, new LinkedList<Pair<SymbolData, JExpression>>());
        TypeData body_result = that.getStatements().visit(btc);
        LinkedList<VariableData> sdVars = this._symbolData.getVars();
        for (int i = 0; i < sdVars.size(); ++i) {
            if (sdVars.get(i).hasValue()) continue;
            ClassBodyTypeChecker._addError(new StringBuffer().append("The final field ").append(sdVars.get(i).getName()).append(" has not been initialized.  Make sure you give it a value in this constructor").toString(), that);
            return null;
        }
        this._symbolData.decrementConstructorCount();
        if (this._symbolData.getConstructorCount() > 0) {
            this.unassignVariableDatas(btc.thingsThatHaveBeenAssigned);
        }
        return this.forConstructorDefOnly(that, mav_result, parameters_result, throws_result, body_result);
    }

    public TypeData forConstructorDefOnly(ConstructorDef that, TypeData mav_result, TypeData[] parameters_result, TypeData[] throws_result, TypeData body_result) {
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public TypeData forConcreteMethodDef(ConcreteMethodDef that) {
        int i;
        TypeData mav_result = that.getMav().visit(this);
        TypeData[] typeParams_result = this.makeArrayOfRetType(that.getTypeParams().length);
        for (int i2 = 0; i2 < that.getTypeParams().length; ++i2) {
            typeParams_result[i2] = that.getTypeParams()[i2].visit(this);
        }
        SymbolData result_result = this.getSymbolData(that.getResult().getName(), this._symbolData, that);
        TypeData name_result = that.getName().visit(this);
        TypeData[] throws_result = this.makeArrayOfRetType(that.getThrows().length);
        for (int i3 = 0; i3 < that.getThrows().length; ++i3) {
            throws_result[i3] = this.getSymbolData(that.getThrows()[i3].getName(), this._symbolData, that.getThrows()[i3]);
        }
        MethodData md = null;
        FormalParameter[] fParams = that.getParams();
        String[] paramTypes = new String[fParams.length];
        for (int i4 = 0; i4 < fParams.length; ++i4) {
            paramTypes[i4] = fParams[i4].getDeclarator().getType().getName();
        }
        LinkedList<MethodData> mds = this._symbolData.getMethods();
        Iterator iter = mds.iterator();
        while (iter.hasNext()) {
            boolean match = false;
            MethodData tempMd = (MethodData)iter.next();
            if (!tempMd.getName().equals(that.getName().getText())) continue;
            match = true;
            VariableData[] vds = tempMd.getParams();
            if (paramTypes.length != vds.length) continue;
            for (i = 0; i < paramTypes.length; ++i) {
                if (vds[i].getType().getName().equals(paramTypes[i]) || LanguageLevelVisitor.getUnqualifiedClassName(vds[i].getType().getName()).equals(paramTypes[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            md = tempMd;
            break;
        }
        if (md == null) {
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: The method ").append(that.getName().getText()).append(" was not in the class ").append(this._symbolData.getName()).append(".  Please report this bug.").toString());
        }
        LinkedList<VariableData> ll = new LinkedList<VariableData>();
        VariableData[] vds = md.getParams();
        for (int i5 = 0; i5 < vds.length; ++i5) {
            ll.addLast(vds[i5]);
        }
        ll.addAll(this.cloneVariableDataList(this._vars));
        LinkedList<VariableData> thingsWeAssigned = new LinkedList<VariableData>();
        for (i = 0; i < this._symbolData.getVars().size(); ++i) {
            VariableData tempVd = this._symbolData.getVars().get(i);
            if (!tempVd.gotValue()) continue;
            thingsWeAssigned.addLast(tempVd);
        }
        BodyTypeChecker btc = new BodyTypeChecker(md, this._file, this._package, (LinkedList<String>)this._importedFiles, (LinkedList<String>)this._importedPackages, ll, new LinkedList<Pair<SymbolData, JExpression>>());
        TypeData body_result = that.getBody().visit(btc);
        if (body_result != null) {
            body_result = body_result.getSymbolData();
        }
        this._checkReturnType(md.getReturnType(), (SymbolData)body_result, that);
        if (md.getReturnType() != null) {
            SymbolData.checkDifferentReturnTypes(md, this._symbolData, LanguageLevelConverter.OPT.javaVersion());
        }
        TypeData[] params_result = this.makeArrayOfRetType(that.getParams().length);
        for (int i6 = 0; i6 < thingsWeAssigned.size(); ++i6) {
            ((VariableData)thingsWeAssigned.get(i6)).lostValue();
        }
        return result_result;
    }

    @Override
    public TypeData forAbstractMethodDef(AbstractMethodDef that) {
        TypeData mav_result = that.getMav().visit(this);
        TypeData[] typeParams_result = this.makeArrayOfRetType(that.getTypeParams().length);
        for (int i = 0; i < that.getTypeParams().length; ++i) {
            typeParams_result[i] = that.getTypeParams()[i].visit(this);
        }
        SymbolData result_result = this.getSymbolData(that.getResult().getName(), this._symbolData, that);
        TypeData name_result = that.getName().visit(this);
        TypeData[] params_result = this.makeArrayOfRetType(that.getParams().length);
        for (int i = 0; i < params_result.length; ++i) {
            params_result[i] = this.getSymbolData(that.getParams()[i].getDeclarator().getType().getName(), this._symbolData, that.getParams()[i]);
        }
        TypeData[] throws_result = this.makeArrayOfRetType(that.getThrows().length);
        for (int i = 0; i < that.getThrows().length; ++i) {
            throws_result[i] = this.getSymbolData(that.getThrows()[i].getName(), this._symbolData, that.getThrows()[i]);
        }
        MethodData md = this._symbolData.getMethod(that.getName().getText(), params_result);
        if (md == null) {
            throw new RuntimeException(new StringBuffer().append("Internal Program Error: Could not find the method ").append(that.getName().getText()).append(" in class ").append(this._symbolData.getName()).append(".  Please report this bug.").toString());
        }
        SymbolData.checkDifferentReturnTypes(md, this._symbolData, LanguageLevelConverter.OPT.javaVersion());
        return result_result;
    }

    @Override
    public TypeData forTypeOnly(Type that) {
        Data sd = this.getSymbolData(that.getName(), this._symbolData, that);
        if (sd != null) {
            sd = sd.getOuterData();
        }
        while (sd != null && !LanguageLevelVisitor.isJavaLibraryClass(sd.getSymbolData().getName())) {
            if (!ClassBodyTypeChecker.checkAccessibility(that, sd.getMav(), sd.getName(), sd.getSymbolData(), this._symbolData, "class or interface")) {
                return null;
            }
            sd = sd.getOuterData();
        }
        return (TypeData)this.forJExpressionOnly(that);
    }

    @Override
    public Object forAbstractMethodDef(AbstractMethodDef x0) {
        return this.forAbstractMethodDef(x0);
    }

    @Override
    public Object forConcreteMethodDef(ConcreteMethodDef x0) {
        return this.forConcreteMethodDef(x0);
    }

    @Override
    public Object forConstructorDef(ConstructorDef x0) {
        return this.forConstructorDef(x0);
    }

    @Override
    public Object forTypeOnly(Type x0) {
        return this.forTypeOnly(x0);
    }

    @Override
    public Object forUninitializedVariableDeclaratorOnly(UninitializedVariableDeclarator x0, Object x1, Object x2) {
        return this.forUninitializedVariableDeclaratorOnly(x0, (TypeData)x1, (TypeData)x2);
    }

    static void access$000(ClassBodyTypeChecker x0, SymbolData x1, SymbolData x2, ConcreteMethodDef x3) {
        x0._checkReturnType(x1, x2, x3);
    }

    static SymbolData access$102(ClassBodyTypeChecker x0, SymbolData x1) {
        x0._symbolData = x1;
        return x0._symbolData;
    }

    static SymbolData access$100(ClassBodyTypeChecker x0) {
        return x0._symbolData;
    }
}

