/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.Function;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.iter.IterUtil;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FunctionContext
extends DelegatingContext {
    private Function _f;

    public FunctionContext(TypeContext next, Function f) {
        super(next);
        this._f = f;
    }

    @Override
    protected FunctionContext duplicate(TypeContext next) {
        return new FunctionContext(next, this._f);
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.getParameter(name) != null || super.variableExists(name, ts);
    }

    @Override
    public boolean localVariableExists(String name, TypeSystem ts) {
        return this.getParameter(name) != null || super.localVariableExists(name, ts);
    }

    @Override
    public LocalVariable getLocalVariable(String name, TypeSystem ts) {
        LocalVariable result = this.getParameter(name);
        return result == null ? super.getLocalVariable(name, ts) : result;
    }

    private LocalVariable getParameter(String name) {
        Iterator i$ = IterableMethods.iterator(this._f.declaredParameters());
        while (i$.hasNext()) {
            LocalVariable v = (LocalVariable)i$.next();
            if (!v.declaredName().equals(name)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.isLocalFunction(name) || super.functionExists(name, ts);
    }

    @Override
    public boolean localFunctionExists(String name, TypeSystem ts) {
        return this.isLocalFunction(name) || super.localFunctionExists(name, ts);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @Override
    public Iterable_ getLocalFunctions(String name, TypeSystem ts, Iterable_ partial) {
        if (IterUtil.isEmpty((Iterable_)partial)) {
            if (this.isLocalFunction(name)) {
                partial = IterUtil.singleton((LocalFunction)this._f);
            }
            return super.getLocalFunctions(name, ts, (Iterable_)partial);
        }
        return partial;
    }

    private boolean isLocalFunction(String name) {
        return this._f instanceof LocalFunction && ((LocalFunction)this._f).declaredName().equals(name);
    }

    @Override
    public String makeClassName(String n) {
        return new StringBuffer().append(super.makeAnonymousClassName()).append(n).toString();
    }

    @Override
    public DJClass getThis() {
        if (this.isStatic()) {
            return null;
        }
        return super.getThis();
    }

    @Override
    public DJClass getThis(String className) {
        if (this.isStatic()) {
            return null;
        }
        return super.getThis(className);
    }

    @Override
    public Type getSuperType(TypeSystem ts) {
        if (this.isStatic()) {
            return null;
        }
        return super.getSuperType(ts);
    }

    @Override
    public Type getReturnType() {
        if (this._f instanceof LocalFunction) {
            return ((LocalFunction)this._f).returnType();
        }
        if (this._f instanceof DJMethod) {
            return ((DJMethod)this._f).returnType();
        }
        return null;
    }

    @Override
    public Iterable<Type> getDeclaredThrownTypes() {
        return this._f.thrownTypes();
    }

    private boolean isStatic() {
        return this._f instanceof DJMethod && ((DJMethod)this._f).isStatic();
    }

    @Override
    protected TypeContext duplicate(TypeContext x0) {
        return this.duplicate(x0);
    }
}

