/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.ExpressionChecker;
import edu.rice.cs.dynamicjava.interpreter.FunctionContext;
import edu.rice.cs.dynamicjava.interpreter.FunctionSignatureContext;
import edu.rice.cs.dynamicjava.interpreter.StatementChecker;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.interpreter.TypeNameChecker;
import edu.rice.cs.dynamicjava.symbol.BoundedSymbol;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.tiger.PolymorphicConstructorDeclaration;
import koala.dynamicjava.tree.tiger.PolymorphicMethodDeclaration;
import koala.dynamicjava.tree.tiger.TypeParameter;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMemberChecker {
    private final TypeContext _context;
    private final Options _opt;

    public ClassMemberChecker(TypeContext context, Options opt) {
        this._context = context;
        this._opt = opt;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public void checkClassMembers(Iterable_ nodes) {
        this.checkClassSignatures(nodes);
        this.checkBodies(nodes);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public void checkInterfaceMembers(Iterable_ nodes) {
        this.checkInterfaceSignatures(nodes);
        this.checkBodies(nodes);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void checkClassSignatures(Iterable_ nodes) {
        ClassMemberSignatureVisitor sig = new ClassMemberSignatureVisitor(null);
        Iterator i$ = IterableMethods.iterator(nodes);
        while (i$.hasNext()) {
            Node n = (Node)i$.next();
            n.acceptVisitor(sig);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void checkInterfaceSignatures(Iterable_ nodes) {
        InterfaceMemberSignatureVisitor sig = new InterfaceMemberSignatureVisitor(null);
        Iterator i$ = IterableMethods.iterator(nodes);
        while (i$.hasNext()) {
            Node n = (Node)i$.next();
            n.acceptVisitor(sig);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void checkBodies(Iterable_ nodes) {
        BodyVisitor bod = new BodyVisitor(null);
        Iterator i$ = IterableMethods.iterator(nodes);
        while (i$.hasNext()) {
            Node n = (Node)i$.next();
            n.acceptVisitor(bod);
        }
    }

    static TypeContext access$300(ClassMemberChecker x0) {
        return x0._context;
    }

    static Options access$400(ClassMemberChecker x0) {
        return x0._opt;
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class BodyVisitor
    extends AbstractVisitor<Void> {
        private BodyVisitor() {
        }

        @Override
        public Void visit(ClassDeclaration node) {
            throw new ExecutionError("not.implemented", node);
        }

        @Override
        public Void visit(InterfaceDeclaration node) {
            throw new ExecutionError("not.implemented", node);
        }

        @Override
        public Void visit(MethodDeclaration node) {
            if (node.getBody() != null) {
                DJMethod m = NodeProperties.getMethod(node);
                FunctionSignatureContext sigContext = new FunctionSignatureContext(ClassMemberChecker.access$300(ClassMemberChecker.this), m);
                FunctionContext bodyContext = new FunctionContext(sigContext, m);
                node.getBody().acceptVisitor(new StatementChecker(bodyContext, ClassMemberChecker.access$400(ClassMemberChecker.this)));
            }
            return null;
        }

        @Override
        public Void visit(ConstructorDeclaration node) {
            DJConstructor k = NodeProperties.getConstructor(node);
            FunctionSignatureContext sigContext = new FunctionSignatureContext(ClassMemberChecker.access$300(ClassMemberChecker.this), k);
            TypeContext bodyContext = new FunctionContext(sigContext, k);
            ConstructorCall call = node.getConstructorCall();
            if (call == null) {
                call = new ConstructorCall(null, null, true);
            }
            new ExpressionChecker(bodyContext, ClassMemberChecker.access$400(ClassMemberChecker.this)).check(call);
            for (Node n : node.getStatements()) {
                bodyContext = n.acceptVisitor(new StatementChecker(bodyContext, ClassMemberChecker.access$400(ClassMemberChecker.this)));
            }
            return null;
        }

        @Override
        public Void visit(FieldDeclaration node) {
            Expression init = node.getInitializer();
            if (init != null) {
                Type expectedT = NodeProperties.getType(node.getType());
                Type initT = new ExpressionChecker(ClassMemberChecker.access$300(ClassMemberChecker.this), ClassMemberChecker.access$400(ClassMemberChecker.this)).check(init, expectedT);
                TypeSystem ts = ClassMemberChecker.access$400(ClassMemberChecker.this).typeSystem();
                try {
                    Expression newInit = ts.assign(expectedT, init);
                    node.setInitializer(newInit);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    NodeProperties.setErrorStrings(node, ts.userRepresentation(initT), ts.userRepresentation(expectedT));
                    throw new ExecutionError("assignment.types", node);
                }
            }
            return null;
        }

        @Override
        public Void visit(ClassInitializer node) {
            node.getBlock().acceptVisitor(new StatementChecker(ClassMemberChecker.access$300(ClassMemberChecker.this), ClassMemberChecker.access$400(ClassMemberChecker.this)));
            return null;
        }

        @Override
        public Void visit(InstanceInitializer node) {
            node.getBlock().acceptVisitor(new StatementChecker(ClassMemberChecker.access$300(ClassMemberChecker.this), ClassMemberChecker.access$400(ClassMemberChecker.this)));
            return null;
        }

        @Override
        public Object visit(InstanceInitializer x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(ClassInitializer x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(FieldDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(MethodDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(ConstructorDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(InterfaceDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(ClassDeclaration x0) {
            return this.visit(x0);
        }

        BodyVisitor(1 x1) {
            this();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class InterfaceMemberSignatureVisitor
    extends SignatureVisitor {
        private InterfaceMemberSignatureVisitor() {
            super(null);
        }

        public Void visit(MethodDeclaration node) {
            int access = node.getAccessFlags();
            if (Modifier.isProtected(access) || Modifier.isPrivate(access) || Modifier.isStatic(access) || Modifier.isStrict(access) || Modifier.isNative(access) || Modifier.isSynchronized(access) || Modifier.isFinal(access)) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("interface.method.modifier", node);
            }
            super.visit(node);
            if (node.getBody() != null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("abstract.method.body", node);
            }
            return null;
        }

        public Void visit(FieldDeclaration node) {
            int access = node.getAccessFlags();
            if (Modifier.isProtected(access) || Modifier.isPrivate(access)) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("interface.field.modifier", node);
            }
            super.visit(node);
            if (node.getInitializer() == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("uninitialized.variable", node);
            }
            return null;
        }

        public Void visit(ConstructorDeclaration node) {
            throw new ExecutionError("interface.member", node);
        }

        public Void visit(ClassInitializer node) {
            throw new ExecutionError("interface.member", node);
        }

        public Void visit(InstanceInitializer node) {
            throw new ExecutionError("interface.member", node);
        }

        public Object visit(InstanceInitializer x0) {
            return this.visit(x0);
        }

        public Object visit(ClassInitializer x0) {
            return this.visit(x0);
        }

        public Object visit(FieldDeclaration x0) {
            return this.visit(x0);
        }

        public Object visit(MethodDeclaration x0) {
            return this.visit(x0);
        }

        public Object visit(ConstructorDeclaration x0) {
            return this.visit(x0);
        }

        InterfaceMemberSignatureVisitor(1 x1) {
            this();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class ClassMemberSignatureVisitor
    extends SignatureVisitor {
        private ClassMemberSignatureVisitor() {
            super(null);
        }

        public Void visit(MethodDeclaration node) {
            super.visit(node);
            int access = node.getAccessFlags();
            if (Modifier.isAbstract(access) && node.getBody() != null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("abstract.method.body", node);
            }
            if (!Modifier.isAbstract(access) && node.getBody() == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("missing.method.body", node);
            }
            return null;
        }

        public Void visit(ConstructorDeclaration node) {
            DJClass thisClass = ClassMemberChecker.access$300(ClassMemberChecker.this).getThis();
            DJConstructor k = NodeProperties.getConstructor(node);
            if (thisClass.isAnonymous() || !thisClass.declaredName().equals(node.getName())) {
                NodeProperties.setErrorStrings(node, SymbolUtil.shortName(thisClass));
                throw new ExecutionError("constructor.name");
            }
            TypeParameter[] tparams = node instanceof PolymorphicConstructorDeclaration ? ((PolymorphicConstructorDeclaration)node).getTypeParameters() : new TypeParameter[]{};
            TypeParameter[] arr$ = tparams;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                TypeParameter tparam = arr$[i$];
                NodeProperties.setTypeVariable(tparam, new VariableType(new BoundedSymbol(tparam, tparam.getRepresentation())));
            }
            FunctionSignatureContext sigContext = new FunctionSignatureContext(ClassMemberChecker.access$300(ClassMemberChecker.this), k);
            TypeNameChecker sigChecker = new TypeNameChecker(sigContext, ClassMemberChecker.access$400(ClassMemberChecker.this));
            sigChecker.setTypeParameterBounds(tparams);
            Iterator<Node> i$ = node.getParameters().iterator();
            while (i$.hasNext()) {
                FormalParameter param = i$.next();
                Type t = sigChecker.check(param.getType());
                NodeProperties.setVariable(param, new LocalVariable(param.getName(), t, param.isFinal()));
            }
            i$ = node.getExceptions().iterator();
            while (i$.hasNext()) {
                ReferenceTypeName tn = (ReferenceTypeName)i$.next();
                sigChecker.check(tn);
            }
            return null;
        }

        public Void visit(ClassInitializer node) {
            return null;
        }

        public Void visit(InstanceInitializer node) {
            return null;
        }

        public Object visit(InstanceInitializer x0) {
            return this.visit(x0);
        }

        public Object visit(ClassInitializer x0) {
            return this.visit(x0);
        }

        public Object visit(MethodDeclaration x0) {
            return this.visit(x0);
        }

        public Object visit(ConstructorDeclaration x0) {
            return this.visit(x0);
        }

        ClassMemberSignatureVisitor(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    private abstract class SignatureVisitor
    extends AbstractVisitor<Void> {
        private SignatureVisitor() {
        }

        @Override
        public Void visit(ClassDeclaration node) {
            throw new ExecutionError("not.implemented", node);
        }

        @Override
        public Void visit(InterfaceDeclaration node) {
            throw new ExecutionError("not.implemented", node);
        }

        @Override
        public Void visit(MethodDeclaration node) {
            DJMethod m = NodeProperties.getMethod(node);
            TypeParameter[] tparams = node instanceof PolymorphicMethodDeclaration ? ((PolymorphicMethodDeclaration)node).getTypeParameters() : new TypeParameter[]{};
            for (TypeParameter tparam : tparams) {
                NodeProperties.setTypeVariable(tparam, new VariableType(new BoundedSymbol(tparam, tparam.getRepresentation())));
            }
            FunctionSignatureContext sigContext = new FunctionSignatureContext(ClassMemberChecker.access$300(ClassMemberChecker.this), m);
            TypeNameChecker sigChecker = new TypeNameChecker(sigContext, ClassMemberChecker.access$400(ClassMemberChecker.this));
            sigChecker.setTypeParameterBounds(tparams);
            Type returnT = sigChecker.check(node.getReturnType());
            NodeProperties.setErasedType(node, ClassMemberChecker.access$400(ClassMemberChecker.this).typeSystem().erasedClass(returnT));
            for (FormalParameter formalParameter : node.getParameters()) {
                Type t = sigChecker.check(formalParameter.getType());
                NodeProperties.setVariable(formalParameter, new LocalVariable(formalParameter.getName(), t, formalParameter.isFinal()));
            }
            for (ReferenceTypeName referenceTypeName : node.getExceptions()) {
                sigChecker.check(referenceTypeName);
            }
            return null;
        }

        @Override
        public Void visit(FieldDeclaration node) {
            new TypeNameChecker(ClassMemberChecker.access$300(ClassMemberChecker.this), ClassMemberChecker.access$400(ClassMemberChecker.this)).check(node.getType());
            return null;
        }

        @Override
        public abstract Void visit(ConstructorDeclaration var1);

        @Override
        public abstract Void visit(ClassInitializer var1);

        @Override
        public abstract Void visit(InstanceInitializer var1);

        @Override
        public Object visit(InstanceInitializer x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(ClassInitializer x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(FieldDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(MethodDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(ConstructorDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(InterfaceDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public Object visit(ClassDeclaration x0) {
            return this.visit(x0);
        }

        SignatureVisitor(1 x1) {
            this();
        }
    }
}

