/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SequenceIterator;
import edu.rice.cs.plt.lambda.LambdaUtil;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ClassContext
extends DelegatingContext {
    private final DJClass _c;
    private final ClassType _thisType;
    private final Iterator<Integer> _anonymousCounter;

    public ClassContext(TypeContext next, DJClass c) {
        super(next);
        this._c = c;
        this._thisType = SymbolUtil.thisType(c);
        this._anonymousCounter = new SequenceIterator<Integer>(Autobox.valueOf(1), LambdaUtil.INCREMENT_INT);
    }

    private ClassContext(TypeContext next, DJClass c, Iterator<Integer> anonymousCounter) {
        super(next);
        this._c = c;
        this._thisType = SymbolUtil.thisType(c);
        this._anonymousCounter = anonymousCounter;
    }

    @Override
    protected ClassContext duplicate(TypeContext next) {
        return new ClassContext(next, this._c, this._anonymousCounter);
    }

    @Override
    public boolean typeExists(String name, TypeSystem ts) {
        return this.hasMemberClass(name, ts) || super.typeExists(name, ts);
    }

    @Override
    public boolean memberClassExists(String name, TypeSystem ts) {
        return this.hasMemberClass(name, ts) || super.memberClassExists(name, ts);
    }

    @Override
    public ClassType typeContainingMemberClass(String name, TypeSystem ts) throws AmbiguousNameException {
        if (this.hasMemberClass(name, ts)) {
            return this._thisType;
        }
        return super.typeContainingMemberClass(name, ts);
    }

    private boolean hasMemberClass(String name, TypeSystem ts) {
        return ts.containsClass(this._thisType, name);
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.hasField(name, ts) || super.variableExists(name, ts);
    }

    @Override
    public boolean fieldExists(String name, TypeSystem ts) {
        return this.hasField(name, ts) || super.fieldExists(name, ts);
    }

    @Override
    public ClassType typeContainingField(String name, TypeSystem ts) throws AmbiguousNameException {
        if (this.hasField(name, ts)) {
            return this._thisType;
        }
        return super.typeContainingField(name, ts);
    }

    private boolean hasField(String name, TypeSystem ts) {
        return ts.containsField(this._thisType, name);
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.hasMethod(name, ts) || super.functionExists(name, ts);
    }

    @Override
    public boolean methodExists(String name, TypeSystem ts) {
        return this.hasMethod(name, ts) || super.methodExists(name, ts);
    }

    @Override
    public ClassType typeContainingMethod(String name, TypeSystem ts) throws AmbiguousNameException {
        if (this.hasMethod(name, ts)) {
            return this._thisType;
        }
        return super.typeContainingMethod(name, ts);
    }

    private boolean hasMethod(String name, TypeSystem ts) {
        return ts.containsMethod(this._thisType, name);
    }

    @Override
    public String makeClassName(String n) {
        return new StringBuffer().append(this._c.fullName()).append("$").append(n).toString();
    }

    @Override
    public String makeAnonymousClassName() {
        return this.makeClassName(this._anonymousCounter.next().toString());
    }

    @Override
    public DJClass getThis() {
        return this._c;
    }

    @Override
    public DJClass getThis(String className) {
        if (className.equals(this._c.declaredName())) {
            return this._c;
        }
        return super.getThis(className);
    }

    @Override
    public Type getReturnType() {
        return null;
    }

    @Override
    public Iterable<Type> getDeclaredThrownTypes() {
        return IterUtil.empty();
    }

    @Override
    public Type getSuperType(TypeSystem ts) {
        return this._c.immediateSuperclass();
    }

    @Override
    protected TypeContext duplicate(TypeContext x0) {
        return this.duplicate(x0);
    }
}

