/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.Interpreter;
import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.OptionVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public final class DynamicJava {
    private DynamicJava() {
    }

    public static void main(String ... args) throws IOException {
        DebugUtil.debug.log();
        Interpreter i = new Interpreter(Options.DEFAULT);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("> ");
            System.out.flush();
            String input = in.readLine();
            try {
                Option<Object> result = i.interpret(input);
                result.apply(new OptionVisitor<Object, Void>(){

                    @Override
                    public Void forSome(Object o) {
                        System.out.println(TextUtil.toString(o));
                        return null;
                    }

                    @Override
                    public Void forNone() {
                        return null;
                    }

                    @Override
                    public Object forNone() {
                        return this.forNone();
                    }

                    @Override
                    public Object forSome(Object x0) {
                        return this.forSome(x0);
                    }
                });
            }
            catch (InterpreterException e) {
                e.printUserMessage();
                DebugUtil.debug.log(e);
            }
            catch (RuntimeException e) {
                System.out.println("INTERNAL ERROR: Uncaught exception");
                e.printStackTrace();
            }
            System.out.println();
        }
    }
}

