/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.predictive;

import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.ui.predictive.PredictiveInputModel;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredictiveInputFrame<T extends Comparable<? super T>>
extends SwingFrame {
    private volatile PredictiveInputModel<T> _pim;
    private volatile String _buttonPressed;
    private final JButton[] _buttons;
    private final JTextField _textField = new JTextField();
    protected JPanel _optionsPanel;
    protected JComponent[] _optionalComponents;
    private final JLabel _tabCompletesLabel = new JLabel("Tab completes: ");
    private final JList _matchList;
    private final boolean _force;
    private final JLabel _sharedExtLabel = new JLabel("");
    private final PredictiveInputListener _listener = new PredictiveInputListener(null);
    private final InfoSupplier<? super T> _info;
    private final JLabel _infoLabel = new JLabel("");
    private final SwingFrame _owner;
    private final ArrayList<CloseAction<T>> _actions;
    private final int _cancelIndex;
    private final List<PredictiveInputModel.MatchingStrategy<T>> _strategies;
    private final JComboBox _strategyBox;
    private volatile FrameState _lastState;
    private volatile PredictiveInputModel.MatchingStrategy<T> _currentStrategy;
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            PredictiveInputFrame.access$1500(PredictiveInputFrame.this);
        }

        @Override
        public void run(Object x0) {
            this.run((WindowEvent)x0);
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$predictive$PredictiveInputFrame;

    public PredictiveInputFrame(SwingFrame owner, String title, boolean force, boolean ignoreCase, InfoSupplier<? super T> info, List<PredictiveInputModel.MatchingStrategy<T>> strategies, List<CloseAction<T>> actions, int cancelIndex, List<T> items) {
        super(title);
        this._strategies = strategies;
        this._strategyBox = new JComboBox<Object>(this._strategies.toArray());
        this._currentStrategy = this._strategies.get(0);
        this._pim = new PredictiveInputModel<T>(ignoreCase, this._currentStrategy, items);
        this._matchList = new JList<Object>(this._pim.getMatchingItems().toArray());
        this._force = force;
        this._info = info;
        this._lastState = null;
        this._owner = owner;
        this._actions = new ArrayList<CloseAction<T>>(actions);
        this._buttons = new JButton[actions.size()];
        this._cancelIndex = cancelIndex;
        this.init(this._info != null);
        this.initDone();
    }

    public PredictiveInputFrame(SwingFrame owner, String title, boolean force, boolean ignoreCase, InfoSupplier<? super T> info, List<PredictiveInputModel.MatchingStrategy<T>> strategies, List<CloseAction<T>> actions, int cancelIndex, T ... items) {
        this(owner, title, force, ignoreCase, info, strategies, actions, cancelIndex, Arrays.asList(items));
    }

    public FrameState getFrameState() {
        return this._lastState;
    }

    public void setFrameState(FrameState ds) {
        this._lastState = ds;
        if (this._lastState != null) {
            this.setSize(this._lastState.getDimension());
            this.setLocation(this._lastState.getLocation());
            int index = this._lastState.getCurrentStrategyIndex();
            if (index >= 0 && index < this._strategies.size()) {
                this._currentStrategy = this._strategies.get(index);
                this._strategyBox.setSelectedIndex(index);
            }
            this.selectStrategy();
            this.validate();
        }
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
        if (this._lastState != null) {
            this.setSize(this._lastState.getDimension());
            this.setLocation(this._lastState.getLocation());
            int index = this._lastState.getCurrentStrategyIndex();
            if (index >= 0 && index < this._strategies.size()) {
                this._currentStrategy = this._strategies.get(index);
                this._strategyBox.setSelectedIndex(index);
            }
            this.selectStrategy();
            this.validate();
        } else {
            Dimension parentDim = this._owner != null ? this._owner.getSize() : this.getToolkit().getScreenSize();
            int ys = (int)parentDim.getHeight() / 4;
            this.setSize(new Dimension((int)this.getSize().getWidth(), (int)Math.min(parentDim.getHeight(), (double)Math.max(ys, 300))));
            this.setLocationRelativeTo(this._owner);
            this._currentStrategy = this._strategies.get(0);
            this._strategyBox.setSelectedIndex(0);
            this.selectStrategy();
        }
    }

    public List<T> getList() {
        return this._pim.getList();
    }

    public void setModel(boolean ignoreCase, PredictiveInputModel<T> pim) {
        this._pim = new PredictiveInputModel<T>(ignoreCase, pim);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public void setItems(boolean ignoreCase, List<T> items) {
        this._pim = new PredictiveInputModel<T>(ignoreCase, this._currentStrategy, items);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public void setCurrentItem(T item) {
        this._pim.setCurrentItem(item);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public void setItems(boolean ignoreCase, T ... items) {
        this._pim = new PredictiveInputModel(ignoreCase, this._currentStrategy, items);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public String getButtonPressed() {
        return this._buttonPressed;
    }

    public String getMask() {
        return this._textField.getText();
    }

    public void setMask(String mask) {
        this._pim.setMask(mask);
        this.removeListener();
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
    }

    public String getText() {
        if (this._force) {
            Comparable item = (Comparable)this._matchList.getSelectedValue();
            return item == null ? "" : this._currentStrategy.force(item, this._textField.getText());
        }
        return this._textField.getText();
    }

    public T getItem() {
        if (!this._force && this._pim.getMatchingItems().size() == 0) {
            return null;
        }
        Comparable item = (Comparable)this._matchList.getSelectedValue();
        return (T)item;
    }

    private void init(boolean info) {
        this._buttonPressed = null;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PredictiveInputFrame.this.validate();
                PredictiveInputFrame.access$300(PredictiveInputFrame.this).ensureIndexIsVisible(PredictiveInputFrame.access$300(PredictiveInputFrame.this).getSelectedIndex());
            }
        });
        int i = 0;
        for (final CloseAction<T> a : this._actions) {
            this._buttons[i] = new JButton(a.getName());
            String tooltip = a.getToolTipText();
            if (tooltip != null) {
                this._buttons[i].setToolTipText(tooltip);
            }
            this._buttons[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PredictiveInputFrame.access$400(PredictiveInputFrame.this, a);
                }
            });
            ++i;
        }
        this.getRootPane().setDefaultButton(this._buttons[0]);
        this._strategyBox.setEditable(false);
        this._strategyBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PredictiveInputFrame.this.selectStrategy();
            }
        });
        this._strategyBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                int i$;
                boolean bf = false;
                JComponent[] arr$ = PredictiveInputFrame.access$500(PredictiveInputFrame.this);
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    JButton b = arr$[i$];
                    if (e.getOppositeComponent() != b) continue;
                    bf = true;
                    break;
                }
                if (e.getOppositeComponent() != PredictiveInputFrame.access$600(PredictiveInputFrame.this) && !bf) {
                    arr$ = PredictiveInputFrame.this._optionalComponents;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        JComponent c = arr$[i$];
                        if (e.getOppositeComponent() != c) continue;
                        return;
                    }
                    PredictiveInputFrame.access$600(PredictiveInputFrame.this).requestFocus();
                }
            }
        });
        this._textField.setDragEnabled(false);
        this._textField.setFocusTraversalKeysEnabled(false);
        this.addListener();
        Keymap ourMap = JTextComponent.addKeymap("PredictiveInputFrame._textField", this._textField.getKeymap());
        for (final CloseAction<T> a : this._actions) {
            KeyStroke ks = a.getKeyStroke();
            if (ks == null) continue;
            ourMap.addActionForKeyStroke(ks, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    PredictiveInputFrame.access$400(PredictiveInputFrame.this, a);
                }
            });
        }
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PredictiveInputFrame.access$700(PredictiveInputFrame.this);
                PredictiveInputFrame.access$800(PredictiveInputFrame.this).extendSharedMask();
                PredictiveInputFrame.access$900(PredictiveInputFrame.this);
                PredictiveInputFrame.access$1000(PredictiveInputFrame.this);
                PredictiveInputFrame.access$1100(PredictiveInputFrame.this);
                PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PredictiveInputFrame.access$300(PredictiveInputFrame.this).getModel().getSize() > 0) {
                    PredictiveInputFrame.access$700(PredictiveInputFrame.this);
                    int i = PredictiveInputFrame.access$300(PredictiveInputFrame.this).getSelectedIndex();
                    if (i > 0) {
                        PredictiveInputFrame.access$300(PredictiveInputFrame.this).setSelectedIndex(i - 1);
                        PredictiveInputFrame.access$300(PredictiveInputFrame.this).ensureIndexIsVisible(i - 1);
                        PredictiveInputFrame.access$800(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$800(PredictiveInputFrame.this).getMatchingItems().get(i - 1));
                        PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                    }
                    PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                }
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PredictiveInputFrame.access$300(PredictiveInputFrame.this).getModel().getSize() > 0) {
                    PredictiveInputFrame.access$700(PredictiveInputFrame.this);
                    int i = PredictiveInputFrame.access$300(PredictiveInputFrame.this).getSelectedIndex();
                    if (i < PredictiveInputFrame.access$300(PredictiveInputFrame.this).getModel().getSize() - 1) {
                        PredictiveInputFrame.access$300(PredictiveInputFrame.this).setSelectedIndex(i + 1);
                        PredictiveInputFrame.access$300(PredictiveInputFrame.this).ensureIndexIsVisible(i + 1);
                        PredictiveInputFrame.access$800(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$800(PredictiveInputFrame.this).getMatchingItems().get(i + 1));
                        PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                    }
                    PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                }
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(33, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PredictiveInputFrame.access$300(PredictiveInputFrame.this).getModel().getSize() > 0) {
                    PredictiveInputFrame.access$700(PredictiveInputFrame.this);
                    int page = PredictiveInputFrame.access$300(PredictiveInputFrame.this).getLastVisibleIndex() - PredictiveInputFrame.access$300(PredictiveInputFrame.this).getFirstVisibleIndex() + 1;
                    int i = PredictiveInputFrame.access$300(PredictiveInputFrame.this).getSelectedIndex() - page;
                    if (i < 0) {
                        i = 0;
                    }
                    PredictiveInputFrame.access$300(PredictiveInputFrame.this).setSelectedIndex(i);
                    PredictiveInputFrame.access$300(PredictiveInputFrame.this).ensureIndexIsVisible(i);
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$800(PredictiveInputFrame.this).getMatchingItems().get(i));
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                }
            }
        });
        ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(34, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (PredictiveInputFrame.access$300(PredictiveInputFrame.this).getModel().getSize() > 0) {
                    PredictiveInputFrame.access$700(PredictiveInputFrame.this);
                    int page = PredictiveInputFrame.access$300(PredictiveInputFrame.this).getLastVisibleIndex() - PredictiveInputFrame.access$300(PredictiveInputFrame.this).getFirstVisibleIndex() + 1;
                    int i = PredictiveInputFrame.access$300(PredictiveInputFrame.this).getSelectedIndex() + page;
                    if (i >= PredictiveInputFrame.access$300(PredictiveInputFrame.this).getModel().getSize()) {
                        i = PredictiveInputFrame.access$300(PredictiveInputFrame.this).getModel().getSize() - 1;
                    }
                    PredictiveInputFrame.access$300(PredictiveInputFrame.this).setSelectedIndex(i);
                    PredictiveInputFrame.access$300(PredictiveInputFrame.this).ensureIndexIsVisible(i);
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$800(PredictiveInputFrame.this).getMatchingItems().get(i));
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                }
            }
        });
        this._textField.setKeymap(ourMap);
        this._textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                int i$;
                boolean bf = false;
                JComponent[] arr$ = PredictiveInputFrame.access$500(PredictiveInputFrame.this);
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    JButton b = arr$[i$];
                    if (e.getOppositeComponent() != b) continue;
                    bf = true;
                    break;
                }
                if (e.getOppositeComponent() != PredictiveInputFrame.access$1400(PredictiveInputFrame.this) && !bf) {
                    arr$ = PredictiveInputFrame.this._optionalComponents;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        JComponent c = arr$[i$];
                        if (e.getOppositeComponent() != c) continue;
                        return;
                    }
                    PredictiveInputFrame.access$600(PredictiveInputFrame.this).requestFocus();
                }
            }
        });
        this._matchList.setSelectionMode(0);
        this._matchList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PredictiveInputFrame.access$700(PredictiveInputFrame.this);
                int i = PredictiveInputFrame.access$300(PredictiveInputFrame.this).getSelectedIndex();
                if (i >= 0) {
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this).setCurrentItem((Comparable)PredictiveInputFrame.access$800(PredictiveInputFrame.this).getMatchingItems().get(i));
                    PredictiveInputFrame.access$300(PredictiveInputFrame.this).ensureIndexIsVisible(i);
                    PredictiveInputFrame.access$1300(PredictiveInputFrame.this);
                }
                PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
            }
        });
        Container contentPane = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets.top = 2;
        c.insets.left = 2;
        c.insets.bottom = 2;
        c.insets.right = 2;
        if (info) {
            c.fill = 0;
            contentPane.add((Component)this._infoLabel, c);
        }
        c.fill = 1;
        c.weighty = 1.0;
        contentPane.add((Component)new JScrollPane(this._matchList, 20, 30), c);
        c.anchor = 16;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        contentPane.add((Component)this._tabCompletesLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        contentPane.add((Component)this._sharedExtLabel, c);
        contentPane.add((Component)this._textField, c);
        this._optionalComponents = this.makeOptions();
        if (this._optionalComponents.length > 0) {
            this._optionsPanel = new JPanel(new BorderLayout());
            this._setupOptionsPanel(this._optionalComponents);
            contentPane.add((Component)this._optionsPanel, c);
        }
        c.anchor = 16;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets.top = 2;
        c.insets.left = 2;
        c.insets.bottom = 2;
        c.insets.right = 2;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints bc = new GridBagConstraints();
        bc.insets.left = 2;
        bc.insets.right = 2;
        buttonPanel.add((Component)new JLabel("Matching strategy:"), bc);
        buttonPanel.add((Component)this._strategyBox, bc);
        for (JButton b : this._buttons) {
            buttonPanel.add((Component)b, bc);
        }
        contentPane.add((Component)buttonPanel, c);
        this.pack();
        Dimension parentDim = this._owner != null ? this._owner.getSize() : this.getToolkit().getScreenSize();
        int ys = (int)parentDim.getHeight() / 4;
        this.setSize(new Dimension((int)this.getSize().getWidth(), (int)Math.min(parentDim.getHeight(), (double)Math.max(ys, 300))));
        this.setLocationRelativeTo(this._owner);
        this.removeListener();
        this.updateTextField();
        this.addListener();
        this.updateList();
    }

    protected JComponent[] makeOptions() {
        return new JComponent[0];
    }

    private void _setupOptionsPanel(JComponent[] components) {
        JPanel mainButtons = new JPanel();
        JPanel emptyPanel = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        mainButtons.setLayout(gbLayout);
        for (JComponent b : components) {
            mainButtons.add(b);
        }
        mainButtons.add(emptyPanel);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weightx = 1.0;
        for (JComponent b : components) {
            gbLayout.setConstraints(b, c);
        }
        c.fill = 1;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 1.0;
        gbLayout.setConstraints(emptyPanel, c);
        this._optionsPanel.add((Component)mainButtons, "Center");
    }

    public void setOwnerEnabled(boolean b) {
    }

    @Override
    public void setVisible(boolean vis) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.validate();
        if (vis) {
            DrJavaRoot.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            this.setOwnerEnabled(false);
            this.selectStrategy();
            this._textField.requestFocus();
            this.toFront();
        } else {
            DrJavaRoot.removeModalWindowAdapter(this);
            this.setOwnerEnabled(true);
            this._owner.toFront();
        }
        super.setVisible(vis);
    }

    private void addListener() {
        this._textField.getDocument().addDocumentListener(this._listener);
        this._textField.addCaretListener(this._listener);
    }

    private void removeListener() {
        this._textField.getDocument().removeDocumentListener(this._listener);
        this._textField.removeCaretListener(this._listener);
    }

    private void updateTextField() {
        this._textField.setText(this._pim.getMask());
        this._textField.setCaretPosition(this._pim.getMask().length());
    }

    public void resetFocus() {
        this._textField.requestFocus();
    }

    private void updateExtensionLabel() {
        this._sharedExtLabel.setText(new StringBuffer().append(this._pim.getSharedMaskExtension()).append(" ").toString());
        this._tabCompletesLabel.setVisible(this._pim.getSharedMaskExtension().length() > 0);
    }

    private void updateList() {
        this._matchList.setListData(this._pim.getMatchingItems().toArray());
        this._matchList.setSelectedValue(this._pim.getCurrentItem(), true);
        this.updateExtensionLabel();
        this.updateInfo();
        if (this._force) {
            for (int i = 0; i < this._buttons.length - 1; ++i) {
                this._buttons[i].setEnabled(this._matchList.getModel().getSize() > 0);
            }
        }
    }

    private void updateInfo() {
        if (this._info == null) {
            return;
        }
        if (this._matchList.getModel().getSize() > 0) {
            Comparable item = (Comparable)this._matchList.getSelectedValue();
            this._infoLabel.setText(new StringBuffer().append("Path:   ").append((String)this._info.value(item)).toString());
        } else {
            this._infoLabel.setText("No file selected");
        }
    }

    private void cancel() {
        this.buttonPressed(this._actions.get(this._cancelIndex));
    }

    private void buttonPressed(CloseAction<T> a) {
        this._buttonPressed = a.getName();
        this._lastState = new FrameState(this);
        this.setVisible(false);
        a.value(this);
    }

    public void selectStrategy() {
        this._currentStrategy = this._strategies.get(this._strategyBox.getSelectedIndex());
        this.removeListener();
        this._pim.setStrategy(this._currentStrategy);
        this.updateTextField();
        this.updateExtensionLabel();
        this.updateList();
        this.addListener();
        this._textField.requestFocus();
    }

    static PredictiveInputModel.MatchingStrategy access$000(PredictiveInputFrame x0) {
        return x0._currentStrategy;
    }

    static List access$100(PredictiveInputFrame x0) {
        return x0._strategies;
    }

    static JList access$300(PredictiveInputFrame x0) {
        return x0._matchList;
    }

    static void access$400(PredictiveInputFrame x0, CloseAction x1) {
        x0.buttonPressed(x1);
    }

    static JButton[] access$500(PredictiveInputFrame x0) {
        return x0._buttons;
    }

    static JTextField access$600(PredictiveInputFrame x0) {
        return x0._textField;
    }

    static void access$700(PredictiveInputFrame x0) {
        x0.removeListener();
    }

    static PredictiveInputModel access$800(PredictiveInputFrame x0) {
        return x0._pim;
    }

    static void access$900(PredictiveInputFrame x0) {
        x0.updateTextField();
    }

    static void access$1000(PredictiveInputFrame x0) {
        x0.updateExtensionLabel();
    }

    static void access$1100(PredictiveInputFrame x0) {
        x0.updateList();
    }

    static void access$1200(PredictiveInputFrame x0) {
        x0.addListener();
    }

    static void access$1300(PredictiveInputFrame x0) {
        x0.updateInfo();
    }

    static JComboBox access$1400(PredictiveInputFrame x0) {
        return x0._strategyBox;
    }

    static void access$1500(PredictiveInputFrame x0) {
        x0.cancel();
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$predictive$PredictiveInputFrame == null ? (class$edu$rice$cs$drjava$ui$predictive$PredictiveInputFrame = PredictiveInputFrame.class$("edu.rice.cs.drjava.ui.predictive.PredictiveInputFrame")) : class$edu$rice$cs$drjava$ui$predictive$PredictiveInputFrame).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private class PredictiveInputListener
    implements CaretListener,
    DocumentListener {
        private PredictiveInputListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            Utilities.invokeLater(new Runnable(){

                public void run() {
                    PredictiveInputFrame.access$700(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$800(PredictiveInputFrame.this).setMask(PredictiveInputFrame.access$600(PredictiveInputFrame.this).getText());
                    PredictiveInputFrame.access$1000(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1100(PredictiveInputFrame.this);
                    PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
                }
            });
        }

        public void removeUpdate(DocumentEvent e) {
            PredictiveInputFrame.access$700(PredictiveInputFrame.this);
            PredictiveInputFrame.access$800(PredictiveInputFrame.this).setMask(PredictiveInputFrame.access$600(PredictiveInputFrame.this).getText());
            PredictiveInputFrame.access$1000(PredictiveInputFrame.this);
            PredictiveInputFrame.access$1100(PredictiveInputFrame.this);
            PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
        }

        public void changedUpdate(DocumentEvent e) {
            PredictiveInputFrame.access$700(PredictiveInputFrame.this);
            PredictiveInputFrame.access$800(PredictiveInputFrame.this).setMask(PredictiveInputFrame.access$600(PredictiveInputFrame.this).getText());
            PredictiveInputFrame.access$1000(PredictiveInputFrame.this);
            PredictiveInputFrame.access$1100(PredictiveInputFrame.this);
            PredictiveInputFrame.access$1200(PredictiveInputFrame.this);
        }

        public void caretUpdate(CaretEvent e) {
        }

        PredictiveInputListener(1 x1) {
            this();
        }
    }

    public static class FrameState {
        private volatile Dimension _dim;
        private volatile Point _loc;
        private volatile int _currentStrategyIndex;

        public FrameState(Dimension d, Point l, int currentStrategyIndex) {
            this._dim = d;
            this._loc = l;
            this._currentStrategyIndex = currentStrategyIndex;
        }

        public FrameState(String s) {
            StringTokenizer tok = new StringTokenizer(s);
            try {
                int x = Integer.valueOf(tok.nextToken());
                int y = Integer.valueOf(tok.nextToken());
                this._dim = new Dimension(x, y);
                x = Integer.valueOf(tok.nextToken());
                y = Integer.valueOf(tok.nextToken());
                this._loc = new Point(x, y);
                this._currentStrategyIndex = Integer.valueOf(tok.nextToken());
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nsee);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nfe);
            }
        }

        public FrameState(PredictiveInputFrame comp) {
            this._dim = comp.getSize();
            this._loc = comp.getLocation();
            this._currentStrategyIndex = PredictiveInputFrame.access$100(comp).indexOf(PredictiveInputFrame.access$000(comp));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append((int)this._dim.getWidth());
            sb.append(' ');
            sb.append((int)this._dim.getHeight());
            sb.append(' ');
            sb.append(this._loc.x);
            sb.append(' ');
            sb.append(this._loc.y);
            sb.append(' ');
            sb.append(this._currentStrategyIndex);
            return sb.toString();
        }

        public Dimension getDimension() {
            return this._dim;
        }

        public Point getLocation() {
            return this._loc;
        }

        public int getCurrentStrategyIndex() {
            return this._currentStrategyIndex;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CloseAction<X extends Comparable<? super X>>
    extends Lambda<PredictiveInputFrame<X>, Object> {
        @Override
        public Object value(PredictiveInputFrame<X> var1);

        public String getName();

        public KeyStroke getKeyStroke();

        public String getToolTipText();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface InfoSupplier<X>
    extends Lambda<X, String> {
    }
}

