/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.util.swing.SwingFrame;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionComponent<T>
implements Serializable {
    protected final Option<T> _option;
    protected final JLabel _label;
    protected final SwingFrame _parent;
    protected volatile boolean _entireColumn;
    protected volatile String _labelText;
    private volatile Vector<ChangeListener> _changeListeners = new Vector();

    public OptionComponent(Option<T> option, String labelText, SwingFrame parent) {
        this._option = option;
        this._labelText = labelText;
        this._label = new JLabel(this._labelText);
        this._label.setHorizontalAlignment(4);
        this._parent = parent;
        if (option != null) {
            DrJava.getConfig().addOptionListener(option, new OptionListener<T>(){

                @Override
                public void optionChanged(OptionEvent<T> oe) {
                    OptionComponent.this.resetToCurrent();
                }
            });
        }
    }

    public OptionComponent(String labelText, SwingFrame parent) {
        this(null, labelText, parent);
    }

    public Option<T> getOption() {
        return this._option;
    }

    public String getLabelText() {
        return this._label.getText();
    }

    public JLabel getLabel() {
        return this._label;
    }

    public boolean useEntireColumn() {
        return this._entireColumn;
    }

    public abstract JComponent getComponent();

    public abstract void setDescription(String var1);

    public OptionComponent<T> setEntireColumn(boolean entireColumn) {
        this._entireColumn = entireColumn;
        return this;
    }

    public boolean getEntireColumn() {
        return this._entireColumn;
    }

    public abstract boolean updateConfig();

    public void resetToCurrent() {
        if (this._option != null) {
            this.setValue(DrJava.getConfig().getSetting(this._option));
        }
    }

    public void resetToDefault() {
        if (this._option != null) {
            this.setValue(this._option.getDefault());
            this.notifyChangeListeners();
        }
    }

    public abstract void setValue(T var1);

    public void showErrorMessage(String title, OptionParseException e) {
        this.showErrorMessage(title, e.value, e.message);
    }

    public void showErrorMessage(String title, String value, String message) {
        JOptionPane.showMessageDialog(this._parent, new StringBuffer().append("There was an error in one of the options that you entered.\nOption: '").append(this.getLabelText()).append("'\n").append("Your value: '").append(value).append("'\n").append("Error: ").append(message).toString(), title, 2);
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove(listener);
    }

    protected void notifyChangeListeners() {
        ChangeListener[] listeners;
        for (ChangeListener l : listeners = this._changeListeners.toArray(new ChangeListener[this._changeListeners.size()])) {
            l.value(this);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ChangeListener
    extends Lambda<Object, Object> {
    }
}

