/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitErrorModel;
import edu.rice.cs.drjava.ui.ErrorPanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JUnitPanel
extends ErrorPanel {
    private static final String START_JUNIT_MSG = "Testing in progress.  Please wait ...\n";
    private static final String JUNIT_FINISHED_MSG = "All tests completed successfully.\n";
    private static final String NO_TESTS_MSG = "";
    private static final SimpleAttributeSet OUT_OF_SYNC_ATTRIBUTES = JUnitPanel._getOutOfSyncAttributes();
    private static final SimpleAttributeSet TEST_PASS_ATTRIBUTES = JUnitPanel._getTestPassAttributes();
    private static final SimpleAttributeSet TEST_FAIL_ATTRIBUTES = JUnitPanel._getTestFailAttributes();
    private static final String TEST_OUT_OF_SYNC = "The documents being tested have been modified and should be recompiled!\n";
    protected JUnitErrorListPane _errorListPane;
    private final MainFrame _mainFrame;
    private int _testCount;
    private boolean _testsSuccessful;
    private JUnitProgressBar _progressBar;
    private List<OpenDefinitionsDocument> _odds = new ArrayList<OpenDefinitionsDocument>();
    private Action _showStackTraceAction = new AbstractAction("Show Stack Trace"){

        public void actionPerformed(ActionEvent ae) {
            if (JUnitPanel.access$000(JUnitPanel.this) != null) {
                JUnitPanel.access$100(JUnitPanel.this, JUnitPanel.access$000(JUnitPanel.this));
            }
        }
    };
    private JButton _showStackTraceButton;
    private JUnitError _error = null;
    private Window _stackFrame = null;
    private JTextArea _stackTextArea;
    private final JLabel _errorLabel = new JLabel();
    private final JLabel _testLabel = new JLabel();
    private final JLabel _fileLabel = new JLabel();

    private static final SimpleAttributeSet _getOutOfSyncAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        s.addAttribute(StyleConstants.Foreground, Color.red.darker());
        s.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        return s;
    }

    private static final SimpleAttributeSet _getTestPassAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        s.addAttribute(StyleConstants.Foreground, Color.green.darker());
        return s;
    }

    private static final SimpleAttributeSet _getTestFailAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        s.addAttribute(StyleConstants.Foreground, Color.red);
        return s;
    }

    public JUnitPanel(SingleDisplayModel model, MainFrame frame) {
        super(model, frame, "Test Output", "Test Progress");
        this._mainFrame = frame;
        this._testCount = 0;
        this._testsSuccessful = true;
        this._progressBar = new JUnitProgressBar();
        this._progressBar.setUI(new BasicProgressBarUI());
        this._showStackTraceButton = new JButton(this._showStackTraceAction);
        this.customPanel.add((Component)this._progressBar, "North");
        this.customPanel.add((Component)this._showStackTraceButton, "South");
        this._errorListPane = new JUnitErrorListPane();
        this.setErrorListPane(this._errorListPane);
    }

    public JUnitErrorListPane getErrorListPane() {
        return this._errorListPane;
    }

    protected JUnitErrorModel getErrorModel() {
        return this.getModel().getJUnitModel().getJUnitErrorModel();
    }

    protected void _updateStyles(AttributeSet newSet) {
        super._updateStyles(newSet);
        OUT_OF_SYNC_ATTRIBUTES.addAttributes(newSet);
        StyleConstants.setBold(OUT_OF_SYNC_ATTRIBUTES, true);
        TEST_PASS_ATTRIBUTES.addAttributes(newSet);
        TEST_FAIL_ATTRIBUTES.addAttributes(newSet);
    }

    public void setJUnitInProgress() {
        this._errorListPane.setJUnitInProgress();
    }

    protected void _close() {
        super._close();
        this.getModel().getJUnitModel().resetJUnitErrors();
        this.reset();
    }

    public void reset() {
        JUnitErrorModel juem = this.getModel().getJUnitModel().getJUnitErrorModel();
        boolean testsHaveRun = false;
        if (juem != null) {
            this._numErrors = juem.getNumErrors();
            testsHaveRun = juem.haveTestsRun();
        } else {
            this._numErrors = 0;
        }
        this._errorListPane.updateListPane(testsHaveRun);
        this.repaint();
    }

    public void progressReset(int numTests) {
        this._progressBar.reset();
        this._progressBar.start(numTests);
        this._testsSuccessful = true;
        this._testCount = 0;
    }

    public void progressStep(boolean successful) {
        ++this._testCount;
        this._testsSuccessful &= successful;
        this._progressBar.step(this._testCount, this._testsSuccessful);
    }

    public void testStarted(String className, String testName) {
    }

    private void _displayStackTrace(JUnitError e) {
        this._errorLabel.setText((e.isWarning() ? "Error: " : "Failure: ") + e.message());
        this._fileLabel.setText("File: " + new File(e.fileName()).getName());
        if (!e.testName().equals(NO_TESTS_MSG)) {
            this._testLabel.setText("Test: " + e.testName());
        } else {
            this._testLabel.setText(NO_TESTS_MSG);
        }
        this._stackTextArea.setText(e.stackTrace());
        this._stackTextArea.setCaretPosition(0);
        this._frame.setPopupLoc(this._stackFrame);
        this._stackFrame.setVisible(true);
    }

    protected CompilerErrorModel getErrorModel() {
        return this.getErrorModel();
    }

    public ErrorPanel.ErrorListPane getErrorListPane() {
        return this.getErrorListPane();
    }

    static JUnitError access$000(JUnitPanel x0) {
        return x0._error;
    }

    static void access$100(JUnitPanel x0, JUnitError x1) {
        x0._displayStackTrace(x1);
    }

    static Action access$200(JUnitPanel x0) {
        return x0._showStackTraceAction;
    }

    static JUnitError access$002(JUnitPanel x0, JUnitError x1) {
        x0._error = x1;
        return x0._error;
    }

    static JButton access$400(JUnitPanel x0) {
        return x0._showStackTraceButton;
    }

    static SimpleAttributeSet access$500() {
        return TEST_FAIL_ATTRIBUTES;
    }

    static SimpleAttributeSet access$600() {
        return TEST_PASS_ATTRIBUTES;
    }

    static MainFrame access$700(JUnitPanel x0) {
        return x0._mainFrame;
    }

    static Window access$802(JUnitPanel x0, Window x1) {
        x0._stackFrame = x1;
        return x0._stackFrame;
    }

    static JTextArea access$902(JUnitPanel x0, JTextArea x1) {
        x0._stackTextArea = x1;
        return x0._stackTextArea;
    }

    static JTextArea access$900(JUnitPanel x0) {
        return x0._stackTextArea;
    }

    static Window access$800(JUnitPanel x0) {
        return x0._stackFrame;
    }

    static JLabel access$1000(JUnitPanel x0) {
        return x0._fileLabel;
    }

    static JLabel access$1100(JUnitPanel x0) {
        return x0._testLabel;
    }

    static JLabel access$1200(JUnitPanel x0) {
        return x0._errorLabel;
    }

    static class JUnitProgressBar
    extends JProgressBar {
        private boolean _hasError = false;

        public JUnitProgressBar() {
            this.setForeground(this.getStatusColor());
        }

        private Color getStatusColor() {
            if (this._hasError) {
                return Color.red;
            }
            return Color.green;
        }

        public void reset() {
            this._hasError = false;
            this.setForeground(this.getStatusColor());
            this.setValue(0);
        }

        public void start(int total) {
            this.setMaximum(total);
            this.reset();
        }

        public void step(int value, boolean successful) {
            this.setValue(value);
            if (!this._hasError && !successful) {
                this._hasError = true;
                this.setForeground(this.getStatusColor());
            }
        }
    }

    public class JUnitErrorListPane
    extends ErrorPanel.ErrorListPane {
        private JPopupMenu _popMenu;
        private String _runningTestName;
        private boolean _warnedOutOfSync;
        private static final String JUNIT_WARNING = "junit.framework.TestSuite$1.warning";
        private final HashMap<String, Position> _runningTestNamePositions;
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$JUnitPanel;

        public JUnitErrorListPane() {
            this.removeMouseListener(this.defaultMouseListener);
            this._popMenu = new JPopupMenu();
            this._popMenu.add(JUnitPanel.access$200(JUnitPanel.this));
            JUnitPanel.access$002(JUnitPanel.this, null);
            this._setupStackTraceFrame();
            this.addMouseListener(new PopupAdapter(null));
            this._runningTestName = null;
            this._runningTestNamePositions = new HashMap();
            JUnitPanel.access$400(JUnitPanel.this).setEnabled(false);
        }

        private String _getTestFromName(String name) {
            int paren = name.indexOf(40);
            if (paren > -1 && paren < name.length()) {
                return name.substring(0, paren);
            }
            throw new IllegalArgumentException("Name does not contain any parens: " + name);
        }

        private String _getClassFromName(String name) {
            int paren = name.indexOf(40);
            if (paren > -1 && paren < name.length()) {
                return name.substring(paren + 1, name.length() - 1);
            }
            throw new IllegalArgumentException("Name does not contain any parens: " + name);
        }

        public void testStarted(String name) {
            String testName = this._getTestFromName(name);
            String className = this._getClassFromName(name);
            String fullName = className + "." + testName;
            if (fullName.equals(JUNIT_WARNING)) {
                return;
            }
            SwingDocument doc = this.getSwingDocument();
            try {
                int len = doc.getLength();
                if (!className.equals(this._runningTestName)) {
                    this._runningTestName = className;
                    doc.insertString(len, "  " + className + "\n", ErrorPanel.NORMAL_ATTRIBUTES);
                    len = doc.getLength();
                }
                doc.insertString(len, "    ", ErrorPanel.NORMAL_ATTRIBUTES);
                len = doc.getLength();
                doc.insertString(len, testName + "\n", ErrorPanel.NORMAL_ATTRIBUTES);
                Position pos = doc.createPosition(len);
                this._runningTestNamePositions.put(fullName, pos);
                this.setCaretPosition(len);
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
        }

        public void testEnded(String name, boolean wasSuccessful, boolean causedError) {
            String testName = this._getTestFromName(name);
            String fullName = this._getClassFromName(name) + "." + testName;
            if (fullName.equals(JUNIT_WARNING)) {
                return;
            }
            SwingDocument doc = this.getSwingDocument();
            Position namePos = this._runningTestNamePositions.get(fullName);
            SimpleAttributeSet set = !wasSuccessful || causedError ? JUnitPanel.access$500() : JUnitPanel.access$600();
            if (namePos != null) {
                int index = namePos.getOffset();
                int length = testName.length();
                doc.setCharacterAttributes(index, length, set, false);
            }
        }

        public void setJUnitInProgress() {
            if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                throw new AssertionError();
            }
            this._errorListPositions = new Position[0];
            JUnitPanel.this.progressReset(0);
            this._runningTestNamePositions.clear();
            this._runningTestName = null;
            this._warnedOutOfSync = false;
            SwingDocument doc = new SwingDocument();
            doc.append(JUnitPanel.START_JUNIT_MSG, ErrorPanel.BOLD_ATTRIBUTES);
            this.setDocument(doc);
            this.selectNothing();
        }

        protected void _updateWithErrors() throws BadLocationException {
            SwingDocument doc = this.getSwingDocument();
            this._updateWithErrors("test", "failed", doc);
        }

        protected String _getNumErrorsMessage(String failureName, String failureMeaning) {
            StringBuffer numErrMsg;
            int numCompErrs = JUnitPanel.this.getErrorModel().getNumCompErrors();
            int numWarnings = JUnitPanel.this.getErrorModel().getNumWarnings();
            if (!JUnitPanel.this.getErrorModel().hasOnlyWarnings()) {
                numErrMsg = new StringBuffer(numCompErrs + " " + failureName);
                if (numCompErrs > 1) {
                    numErrMsg.append("s");
                }
                numErrMsg.append(" " + failureMeaning);
                if (numWarnings > 0) {
                    numErrMsg.append(" and " + numWarnings + " warning");
                }
            } else {
                numErrMsg = new StringBuffer(numWarnings + " warning");
            }
            if (numWarnings > 1) {
                numErrMsg.append("s");
            }
            if (numWarnings > 0) {
                numErrMsg.append(" found");
            }
            numErrMsg.append(":\n");
            return numErrMsg.toString();
        }

        protected void _updateWithErrors(String failureName, String failureMeaning, SwingDocument doc) throws BadLocationException {
            this._replaceInProgressText(this._getNumErrorsMessage(failureName, failureMeaning));
            this._insertErrors(doc);
            this.switchToError(0);
        }

        public void _replaceInProgressText(String msg) throws BadLocationException {
            if (!$assertionsDisabled && JUnitPanel.access$700(JUnitPanel.this).isVisible() && !EventQueue.isDispatchThread()) {
                throw new AssertionError();
            }
            int start = 0;
            if (this._warnedOutOfSync) {
                start = JUnitPanel.TEST_OUT_OF_SYNC.length();
            }
            int len = JUnitPanel.START_JUNIT_MSG.length();
            SwingDocument doc = this.getSwingDocument();
            if (doc.getLength() >= len + start) {
                doc.remove(start, len);
                doc.insertString(start, msg, ErrorPanel.BOLD_ATTRIBUTES);
            }
        }

        protected String _getWarningText() {
            return "Error: ";
        }

        protected String _getErrorText() {
            return "Failure: ";
        }

        protected void _updateNoErrors(boolean haveTestsRun) throws BadLocationException {
            this._replaceInProgressText(haveTestsRun ? JUnitPanel.JUNIT_FINISHED_MSG : JUnitPanel.NO_TESTS_MSG);
            this.selectNothing();
            this.setCaretPosition(0);
        }

        private void _setupStackTraceFrame() {
            JDialog _dialog = new JDialog(JUnitPanel.this._frame, "JUnit Error Stack Trace", false);
            JUnitPanel.access$802(JUnitPanel.this, _dialog);
            JUnitPanel.access$902(JUnitPanel.this, new JTextArea());
            JUnitPanel.access$900(JUnitPanel.this).setEditable(false);
            JUnitPanel.access$900(JUnitPanel.this).setLineWrap(false);
            BorderlessScrollPane scroll = new BorderlessScrollPane(JUnitPanel.access$900(JUnitPanel.this), 20, 30);
            ActionListener closeListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JUnitPanel.access$800(JUnitPanel.this).setVisible(false);
                }
            };
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(closeListener);
            JPanel closePanel = new JPanel(new BorderLayout());
            closePanel.setBorder(new EmptyBorder(5, 5, 0, 0));
            closePanel.add((Component)closeButton, "East");
            JPanel cp = new JPanel(new BorderLayout());
            _dialog.setContentPane(cp);
            cp.setBorder(new EmptyBorder(5, 5, 5, 5));
            cp.add((Component)scroll, "Center");
            cp.add((Component)closePanel, "South");
            JPanel topPanel = new JPanel(new GridLayout(0, 1, 0, 5));
            topPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
            topPanel.add(JUnitPanel.access$1000(JUnitPanel.this));
            topPanel.add(JUnitPanel.access$1100(JUnitPanel.this));
            topPanel.add(JUnitPanel.access$1200(JUnitPanel.this));
            cp.add((Component)topPanel, "North");
            _dialog.setSize(600, 500);
        }

        public void selectItem(CompilerError error) {
            super.selectItem(error);
            JUnitPanel.access$002(JUnitPanel.this, (JUnitError)error);
            JUnitPanel.access$400(JUnitPanel.this).setEnabled(true);
        }

        protected void _removeListHighlight() {
            super._removeListHighlight();
            JUnitPanel.access$400(JUnitPanel.this).setEnabled(false);
        }

        static JPopupMenu access$1300(JUnitErrorListPane x0) {
            return x0._popMenu;
        }

        static {
            $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$JUnitPanel == null ? (class$edu$rice$cs$drjava$ui$JUnitPanel = JUnitErrorListPane.class$("edu.rice.cs.drjava.ui.JUnitPanel")) : class$edu$rice$cs$drjava$ui$JUnitPanel).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }

        private class PopupAdapter
        extends RightClickMouseAdapter {
            private PopupAdapter() {
            }

            public void mousePressed(MouseEvent e) {
                if (this._selectError(e)) {
                    super.mousePressed(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (this._selectError(e)) {
                    super.mouseReleased(e);
                }
            }

            private boolean _selectError(MouseEvent e) {
                JUnitPanel.access$002(JUnitPanel.this, (JUnitError)JUnitErrorListPane.this._errorAtPoint(e.getPoint()));
                if (JUnitErrorListPane.this._isEmptySelection() && JUnitPanel.access$000(JUnitPanel.this) != null) {
                    JUnitPanel.this._errorListPane.switchToError(JUnitPanel.access$000(JUnitPanel.this));
                    return true;
                }
                JUnitErrorListPane.this.selectNothing();
                return false;
            }

            protected void _popupAction(MouseEvent e) {
                JUnitErrorListPane.access$1300(JUnitErrorListPane.this).show(e.getComponent(), e.getX(), e.getY());
            }

            PopupAdapter(1 x1) {
                this();
            }
        }
    }
}

