/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.ui.AbortablePanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.predictive.PredictiveInputModel;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.util.GeneralProcessCreator;
import edu.rice.cs.util.ProcessCreator;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProcessPanel
extends AbortablePanel {
    public final int BUFFER_SIZE = 10240;
    public final int BUFFER_READS_PER_TIMER = 5;
    protected JTextArea _textArea;
    protected ProcessCreator _pc = null;
    protected Process _p = null;
    protected InputStreamReader _is = null;
    protected InputStreamReader _erris = null;
    protected JButton _updateNowButton;
    protected JButton _runAgainButton;
    protected Thread _updateThread;
    protected Thread _readThread;
    protected Thread _deathThread;
    protected StringBuffer _sb = new StringBuffer();
    protected volatile int _changeCount = 0;
    private char[] _buf = new char[10240];
    private int _red = -1;
    private char[] _errbuf = new char[10240];
    private int _errred = -1;
    private int _retVal;
    private String _header;
    protected CompletionMonitor _abortMonitor = new CompletionMonitor();

    public ExternalProcessPanel(MainFrame frame, String title, ProcessCreator pc) {
        super(frame, title);
        this._sb = new StringBuffer("Command line: ");
        this._sb.append(pc.cmdline());
        this._sb.append('\n');
        this._header = this._sb.toString();
        this._textArea.setText(this._header);
        this.initThread(pc);
        this._textArea.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ExternalProcessPanel.this.doubleClicked(e);
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ExternalProcessPanel.this.updateText();
            }
        });
    }

    protected void initThread(ProcessCreator pc) {
        this._abortMonitor.reset();
        try {
            this._pc = pc;
            this._pc.getPropertyMaps().clearVariables();
            this._readThread = new Thread(new Runnable(){

                public void run() {
                    while (ExternalProcessPanel.this._is != null || ExternalProcessPanel.this._erris != null) {
                        ExternalProcessPanel.this.readText(false);
                    }
                }
            }, "External Process Read Thread");
            this._updateThread = new Thread(new Runnable(){

                public void run() {
                    while (ExternalProcessPanel.this._is != null || ExternalProcessPanel.this._erris != null) {
                        try {
                            Thread.sleep(DrJava.getConfig().getSetting(OptionConstants.FOLLOW_FILE_DELAY).intValue());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ExternalProcessPanel.this.updateText();
                    }
                }
            }, "External Process Update Thread");
            this._p = this._pc.start();
            this._sb.append("Evaluated command line: ");
            this._sb.append(this._pc.evaluatedCommandLine());
            this._sb.append('\n');
            this._is = new InputStreamReader(this._p.getInputStream());
            this._erris = new InputStreamReader(this._p.getErrorStream());
            this._readThread.start();
            this._updateThread.start();
            this._updateNowButton.setEnabled(true);
            this._deathThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        try {
                            ExternalProcessPanel.access$002(ExternalProcessPanel.this, ExternalProcessPanel.this._p.waitFor());
                            Utilities.invokeLater(new Runnable(){

                                public void run() {
                                    ExternalProcessPanel.this._sb.append("\n\nProcess returned ");
                                    ExternalProcessPanel.this._sb.append(ExternalProcessPanel.access$000(ExternalProcessPanel.this));
                                    ExternalProcessPanel.this._sb.append("\n");
                                    ExternalProcessPanel.this._textArea.setText(ExternalProcessPanel.this._sb.toString());
                                }
                            });
                        }
                        catch (InterruptedException e) {
                            Utilities.invokeLater(new Runnable(){

                                public void run() {
                                    ExternalProcessPanel.this._p.destroy();
                                    ExternalProcessPanel.this._sb.append("\n\nProcess returned ");
                                    ExternalProcessPanel.this._sb.append(ExternalProcessPanel.access$000(ExternalProcessPanel.this));
                                    ExternalProcessPanel.this._sb.append("\n");
                                    ExternalProcessPanel.this._textArea.setText(ExternalProcessPanel.this._sb.toString());
                                }
                            });
                            Object var3_2 = null;
                            ExternalProcessPanel.this.abortActionPerformed(null);
                        }
                        Object var3_1 = null;
                        ExternalProcessPanel.this.abortActionPerformed(null);
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        ExternalProcessPanel.this.abortActionPerformed(null);
                        throw throwable;
                    }
                }
            }, "External Process Death Thread");
            this._deathThread.start();
        }
        catch (Exception e) {
            this._sb.append(new StringBuffer().append("\n\nException from process:\n").append(e.toString()).toString());
            this._textArea.setText(this._sb.toString());
            GeneralProcessCreator.LOG.log(this._sb.toString());
            this.abortActionPerformed(null);
        }
    }

    @Override
    protected Component makeLeftPanel() {
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        return this._textArea;
    }

    @Override
    protected void abortActionPerformed(ActionEvent e) {
        this._abortButton.setEnabled(false);
        this._updateNowButton.setEnabled(false);
        this._runAgainButton.setEnabled(true);
        new Thread(new Runnable(){

            public void run() {
                if (ExternalProcessPanel.this._is != null) {
                    try {
                        ExternalProcessPanel.this._p.getInputStream().close();
                        ExternalProcessPanel.this._is.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    ExternalProcessPanel.this._is = null;
                    Utilities.invokeLater(new Runnable(){

                        public void run() {
                            ExternalProcessPanel.this.updateButtons();
                        }
                    });
                }
                if (ExternalProcessPanel.this._erris != null) {
                    try {
                        ExternalProcessPanel.this._p.getErrorStream().close();
                        ExternalProcessPanel.this._erris.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ExternalProcessPanel.this._erris = null;
                    Utilities.invokeLater(new Runnable(){

                        public void run() {
                            ExternalProcessPanel.this.updateButtons();
                        }
                    });
                }
                if (ExternalProcessPanel.this._p != null) {
                    ExternalProcessPanel.this._p.destroy();
                    ExternalProcessPanel.this._p = null;
                }
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        ExternalProcessPanel.this.updateText();
                        ExternalProcessPanel.this.updateButtons();
                    }
                });
                ExternalProcessPanel.this._abortMonitor.signal();
            }
        }).start();
    }

    protected void runAgainActionPerformed(ActionEvent e) {
        this.abortActionPerformed(e);
        this._abortButton.setEnabled(false);
        this._updateNowButton.setEnabled(false);
        this._runAgainButton.setEnabled(false);
        new Thread(new Runnable(){

            public void run() {
                while (!ExternalProcessPanel.this._abortMonitor.attemptEnsureSignalled()) {
                }
                ExternalProcessPanel.this._abortMonitor.reset();
                ExternalProcessPanel.this._sb = new StringBuffer("Command line: ");
                ExternalProcessPanel.this._sb.append(ExternalProcessPanel.this._pc.cmdline());
                ExternalProcessPanel.this._sb.append('\n');
                ExternalProcessPanel.access$102(ExternalProcessPanel.this, ExternalProcessPanel.this._sb.toString());
                ExternalProcessPanel.this.initThread(ExternalProcessPanel.this._pc);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ExternalProcessPanel.this.updateText();
                    }
                });
            }
        }).start();
    }

    public void doubleClicked(MouseEvent e) {
        List<OpenDefinitionsDocument> docs;
        char ch;
        int caret;
        int start;
        String t = this._textArea.getText();
        int end = start = (caret = this._textArea.getCaretPosition());
        while (start - 1 > 0 && t.charAt(start - 1) != '\n') {
            --start;
        }
        while (end >= 0 && end < t.length() && t.charAt(end) != '\n') {
            ++end;
        }
        if (start < 0 || end < 0 || start >= t.length() || end >= t.length()) {
            return;
        }
        String line = t.substring(start, end);
        if ((caret -= start) >= line.length()) {
            caret = line.length() - 1;
        }
        start = end = caret;
        while (end >= 0 && end < line.length()) {
            ch = line.charAt(end);
            if (ch == ':') {
                if (end + 1 >= line.length() || !Character.isDigit(line.charAt(end + 1))) break;
                while (++end < line.length() && Character.isDigit(line.charAt(end))) {
                }
                break;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                ++end;
                continue;
            }
            if (ch != '.' && ch != File.separatorChar) break;
            ++end;
        }
        if ((docs = this._model.getOpenDefinitionsDocuments()) == null || docs.size() == 0) {
            return;
        }
        ArrayList<MainFrame.GoToFileListEntry> list = new ArrayList<MainFrame.GoToFileListEntry>(docs.size());
        for (OpenDefinitionsDocument d : docs) {
            try {
                String fullyQualified = new StringBuffer().append(d.getPackageName()).append(".").append(d.toString()).toString();
                if (fullyQualified.startsWith(".")) {
                    fullyQualified = fullyQualified.substring(1);
                }
                list.add(new MainFrame.GoToFileListEntry(d, fullyQualified));
            }
            catch (IllegalStateException ex) {}
        }
        PredictiveInputModel<MainFrame.GoToFileListEntry> pim = new PredictiveInputModel<MainFrame.GoToFileListEntry>(true, (PredictiveInputModel.MatchingStrategy<MainFrame.GoToFileListEntry>)new PredictiveInputModel.PrefixLineNumStrategy(), (List<MainFrame.GoToFileListEntry>)list);
        MainFrame.GoToFileListEntry uniqueMatch = null;
        String oldName = null;
        String simpleName = null;
        while (start > 0) {
            ch = line.charAt(start);
            while (start > 0 && ((ch = line.charAt(start)) == ':' || ch == '.' || Character.isJavaIdentifierPart(ch))) {
                --start;
            }
            if (start < 0 || end < start || start >= line.length() || end >= line.length()) break;
            String name = line.substring(start, end).replace(File.separatorChar, '.');
            if (name.length() > 0 && !Character.isJavaIdentifierPart(name.charAt(0))) {
                name = name.substring(1);
            }
            if (simpleName == null) {
                simpleName = name;
            }
            if (name.equals(oldName)) break;
            if ((name.indexOf(".java") >= 0 || name.indexOf(".j") >= 0 || name.indexOf(".dj0") >= 0 || name.indexOf(".dj1") >= 0 || name.indexOf(".dj2") >= 0) && (uniqueMatch = this.getUniqueMatch(name, pim)) != null) {
                boolean docSwitch;
                OpenDefinitionsDocument newDoc = pim.getCurrentItem().doc;
                boolean docChanged = !newDoc.equals(this._model.getActiveDocument());
                boolean bl = docSwitch = this._model.getActiveDocument() != newDoc;
                if (docSwitch) {
                    this._model.setActiveDocument(newDoc);
                }
                final int curLine = newDoc.getCurrentLine();
                int last = name.lastIndexOf(58);
                if (last >= 0) {
                    try {
                        String nend = name.substring(last + 1);
                        int val = Integer.parseInt(nend);
                        final int lineNum = Math.max(1, val);
                        Runnable command = new Runnable(){

                            public void run() {
                                try {
                                    ExternalProcessPanel.this._frame._jumpToLine(lineNum);
                                }
                                catch (RuntimeException ex) {
                                    ExternalProcessPanel.this._frame._jumpToLine(curLine);
                                }
                            }
                        };
                        if (docSwitch) {
                            EventQueue.invokeLater(command);
                            break;
                        }
                        command.run();
                    }
                    catch (RuntimeException ex) {}
                    break;
                }
                if (!docChanged) break;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ExternalProcessPanel.this._frame.addToBrowserHistory();
                    }
                });
                break;
            }
            oldName = name;
            if (ch != File.separatorChar) continue;
            --start;
        }
        if (uniqueMatch == null) {
            this._frame.gotoFileMatchingMask(simpleName);
        }
    }

    MainFrame.GoToFileListEntry getUniqueMatch(String mask, PredictiveInputModel<MainFrame.GoToFileListEntry> pim) {
        pim.setMask(mask);
        if (pim.getMatchingItems().size() == 1 && pim.getCurrentItem() != null) {
            return pim.getCurrentItem();
        }
        return null;
    }

    @Override
    protected void updateButtons() {
        boolean ended = true;
        if (this._p != null) {
            try {
                int ignored = this._p.exitValue();
                ended = true;
            }
            catch (IllegalThreadStateException e) {
                ended = false;
            }
        }
        this._abortButton.setEnabled(this._is != null && this._erris != null && !ended);
        this._updateNowButton.setEnabled(this._is != null && this._erris != null && !ended);
        this._runAgainButton.setEnabled(this._is == null || this._erris == null || ended);
    }

    @Override
    protected JComponent[] makeButtons() {
        this._updateNowButton = new JButton("Update");
        this._updateNowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ExternalProcessPanel.this.updateText();
                    }
                });
            }
        });
        this._runAgainButton = new JButton("Run Again");
        this._runAgainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalProcessPanel.this.runAgainActionPerformed(e);
            }
        });
        return new JComponent[]{this._updateNowButton, this._runAgainButton};
    }

    protected void readText(boolean finish) {
        if (this._is != null || this._erris != null) {
            this._changeCount = 0;
            try {
                int ignored;
                while (this._is != null && this._erris != null && this._changeCount <= 5 && this._erris != null && (this._red = this._is.read(this._buf)) >= 0) {
                    this._sb.append(new String(this._buf, 0, this._red));
                    if (finish) {
                        this._changeCount = 1;
                        continue;
                    }
                    ++this._changeCount;
                }
                while (this._changeCount <= 5 && this._erris != null && (this._errred = this._erris.read(this._errbuf)) >= 0) {
                    this._sb.append(new String(this._errbuf, 0, this._errred));
                    if (finish) {
                        this._changeCount = 1;
                        continue;
                    }
                    ++this._changeCount;
                }
                if (this._red > 0 && this._changeCount < 5) {
                    this._sb.append(new String(this._buf, 0, this._red));
                    this._changeCount = finish ? 1 : ++this._changeCount;
                }
                if (this._errred > 0 && this._changeCount < 5) {
                    this._sb.append(new String(this._errbuf, 0, this._errred));
                    this._changeCount = finish ? 1 : ++this._changeCount;
                }
                if (this._p != null && this._is == null) {
                    try {
                        ignored = this._p.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        this._sb.append("\nInput stream suddenly became null.");
                    }
                }
                if (this._p != null && this._erris == null) {
                    try {
                        ignored = this._p.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        this._sb.append("\nError input stream suddenly became null.");
                    }
                }
            }
            catch (IOException ioe) {
                if (this._p != null) {
                    try {
                        this._p.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        this._sb.append(new StringBuffer().append("\n\nI/O Exception reading from process:\n").append(ioe.toString()).toString());
                        GeneralProcessCreator.LOG.log("\n\nI/O Exception reading from process:");
                        GeneralProcessCreator.LOG.log(ioe.toString(), ioe);
                    }
                }
                this._changeCount = finish ? 1 : ++this._changeCount;
                this.abortActionPerformed(null);
            }
        }
    }

    protected void updateText() {
        if (this._updateNowButton.isEnabled()) {
            if (this._changeCount > 0) {
                this._changeCount = 0;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ExternalProcessPanel.this._textArea.setText(ExternalProcessPanel.this._sb.toString());
                        int maxLines = DrJava.getConfig().getSetting(OptionConstants.FOLLOW_FILE_LINES);
                        if (maxLines > 0) {
                            try {
                                int start = 0;
                                int len = ExternalProcessPanel.this._textArea.getText().length();
                                int curLines = ExternalProcessPanel.this._textArea.getLineCount();
                                if (curLines > maxLines) {
                                    start = ExternalProcessPanel.this._textArea.getLineStartOffset(curLines - maxLines);
                                    ExternalProcessPanel.this._sb = new StringBuffer(ExternalProcessPanel.this._textArea.getText(start, len -= start));
                                    ExternalProcessPanel.this._textArea.setText(ExternalProcessPanel.this._sb.toString());
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            this.updateButtons();
        }
    }

    static int access$002(ExternalProcessPanel x0, int x1) {
        x0._retVal = x1;
        return x0._retVal;
    }

    static int access$000(ExternalProcessPanel x0) {
        return x0._retVal;
    }

    static String access$102(ExternalProcessPanel x0, String x1) {
        x0._header = x1;
        return x0._header;
    }
}

