/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.DrJavaProperty;
import edu.rice.cs.drjava.config.MutableFileProperty;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.drjava.ui.ExternalProcessPanel;
import edu.rice.cs.drjava.ui.InsertVariableDialog;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.BalancingStreamTokenizer;
import edu.rice.cs.util.GeneralProcessCreator;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.XMLConfig;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.FileChooser;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ExecuteExternalDialog
extends SwingFrame
implements OptionConstants {
    private static final int FRAME_WIDTH = 750;
    private static final int FRAME_HEIGHT = 500;
    private JButton _runCommandButton;
    private JButton _saveCommandButton;
    private JButton _insertCommandButton;
    private JButton _cancelCommandButton;
    private JTextPane _commandLine;
    private JLabel _commandLinePreviewLabel;
    private JTextPane _commandLinePreview;
    private StyledDocument _commandLineDoc;
    private JTextPane _commandWorkDirLine;
    private JTextPane _commandWorkDirLinePreview;
    private StyledDocument _commandWorkDirLineDoc;
    private JButton _commandWorkDirBtn;
    private JTextPane _commandEnclosingFileLine;
    private JTextPane _commandEnclosingFileLinePreview;
    private StyledDocument _commandEnclosingFileLineDoc;
    private JButton _commandEnclosingFileBtn;
    private JTextPane _lastCommandFocus;
    SimpleAttributeSet _varCommandLineCmdStyle;
    SimpleAttributeSet _varErrorCommandLineCmdStyle;
    SimpleAttributeSet _commandLineCmdAS;
    JPanel _commandPanel;
    DocumentListener _documentListener;
    DocumentListener _workDirDocumentListener;
    DocumentListener _enclosingFileDocumentListener;
    protected DirectoryChooser _dirChooser;
    protected FileChooser _fileChooser;
    protected InsertVariableDialog _insertVarDialog;
    protected CompletionMonitor _insertVarDialogMonitor = new CompletionMonitor();
    private CompletionMonitor _cm;
    protected MainFrame _mainFrame;
    protected FrameState _lastState = null;
    protected boolean _editMode = false;
    protected int _editIndex = -1;
    protected PropertyMaps _props;
    public static final String STALE_TOOLTIP = "<html>Note: Values of variables might not be current for<br>performance reasons. They will be current when executed.</html>";
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            ExecuteExternalDialog.access$800(ExecuteExternalDialog.this);
        }

        @Override
        public void run(Object x0) {
            this.run((WindowEvent)x0);
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$ExecuteExternalDialog;

    public FrameState getFrameState() {
        return this._lastState;
    }

    public void setFrameState(FrameState ds) {
        this._lastState = ds;
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
            this.validate();
        }
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
        } else {
            MainFrame.setPopupLoc(this, this._mainFrame);
        }
        this.validate();
    }

    public ExecuteExternalDialog(MainFrame mf, boolean editMode, int editIndex, CompletionMonitor cm) {
        super("Execute External Process");
        try {
            this._props = PropertyMaps.TEMPLATE.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnexpectedException(e);
        }
        this._mainFrame = mf;
        this._editMode = editMode;
        this._editIndex = editIndex;
        this._cm = cm;
        this.initComponents();
        if (editMode) {
            if (editIndex >= DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_COUNT)) {
                throw new IllegalArgumentException("Trying to edit saved external process that does not exist");
            }
            String cmdline = (String)((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES))).get(editIndex);
            String workdir = (String)((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS))).get(editIndex);
            String enclosingFile = (String)((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES))).get(editIndex);
            this._commandLine.setText(cmdline);
            this._commandWorkDirLine.setText(workdir);
            this._commandEnclosingFileLine.setText(enclosingFile);
        }
        this.initDone();
    }

    public ExecuteExternalDialog(MainFrame mf) {
        this(mf, false, -1, null);
    }

    private void initComponents() {
        this._dirChooser = new DirectoryChooser(this);
        this._dirChooser.setDialogTitle("Select Work Directory");
        this._dirChooser.setApproveButtonText("Select");
        this._fileChooser = new FileChooser(null);
        this._fileChooser.setDialogTitle("Select Enclosing .djapp File");
        this._fileChooser.setApproveButtonText("Select");
        super.getContentPane().setLayout(new GridLayout(1, 1));
        if (this._editMode) {
            AbstractAction saveCommandAction = new AbstractAction("Save"){

                public void actionPerformed(ActionEvent e) {
                    ExecuteExternalDialog.access$000(ExecuteExternalDialog.this);
                }
            };
            this._saveCommandButton = new JButton(saveCommandAction);
        } else {
            AbstractAction runCommandAction = new AbstractAction("Run Command Line"){

                public void actionPerformed(ActionEvent e) {
                    ExecuteExternalDialog.access$100(ExecuteExternalDialog.this);
                }
            };
            this._runCommandButton = new JButton(runCommandAction);
            this._runCommandButton.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ExecuteExternalDialog.access$200(ExecuteExternalDialog.this).setEnabled(false);
                }

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == ExecuteExternalDialog.access$300(ExecuteExternalDialog.this) || e.getOppositeComponent() == ExecuteExternalDialog.access$400(ExecuteExternalDialog.this) || e.getOppositeComponent() == ExecuteExternalDialog.access$500(ExecuteExternalDialog.this)) {
                        ExecuteExternalDialog.access$600(ExecuteExternalDialog.this).requestFocus();
                    }
                }
            });
            AbstractAction saveCommandAction = new AbstractAction("Save to Menu..."){

                public void actionPerformed(ActionEvent e) {
                    ExecuteExternalDialog.access$000(ExecuteExternalDialog.this);
                }
            };
            this._saveCommandButton = new JButton(saveCommandAction);
        }
        this._insertVarDialog = new InsertVariableDialog(this._mainFrame, this._insertVarDialogMonitor);
        AbstractAction insertCommandAction = new AbstractAction("Insert Variable..."){

            public void actionPerformed(ActionEvent e) {
                ExecuteExternalDialog.access$700(ExecuteExternalDialog.this);
            }
        };
        this._insertCommandButton = new JButton(insertCommandAction);
        this._insertCommandButton.setEnabled(false);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ExecuteExternalDialog.access$800(ExecuteExternalDialog.this);
            }
        };
        this._cancelCommandButton = new JButton(cancelAction);
        this._commandPanel = this.makeCommandPane();
        super.getContentPane().add(this._commandPanel);
        super.setResizable(false);
        this.setSize(750, 500);
        MainFrame.setPopupLoc(this, this._mainFrame);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ExecuteExternalDialog.access$900(ExecuteExternalDialog.this).requestFocus();
            }
        });
    }

    private JPanel makeCommandPane() {
        JPanel panel = new JPanel(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        JPanel main = new JPanel(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        main.setLayout(gridbag);
        c.fill = 1;
        Insets labelInsets = new Insets(5, 10, 0, 0);
        Insets compInsets = new Insets(5, 5, 0, 10);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = labelInsets;
        JLabel commandLineLabel = new JLabel("Command line:");
        gridbag.setConstraints(commandLineLabel, c);
        main.add(commandLineLabel);
        c.weightx = 1.0;
        c.weighty = 32.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandLine = new JTextPane();
        this._commandLine.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                } else if (e.getKeyCode() == 9) {
                    e.consume();
                    if (e.isShiftDown()) {
                        ExecuteExternalDialog.access$200(ExecuteExternalDialog.this).setEnabled(false);
                        ExecuteExternalDialog.access$1000(ExecuteExternalDialog.this).requestFocus();
                    } else {
                        ExecuteExternalDialog.access$1100(ExecuteExternalDialog.this).requestFocus();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane commandLineSP = new JScrollPane(this._commandLine);
        commandLineSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandLineSP, c);
        main.add(commandLineSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        this._commandLinePreviewLabel = new JLabel("<html>Command line preview:<br>(0 characters)</html>");
        this._commandLinePreviewLabel.setToolTipText(STALE_TOOLTIP);
        gridbag.setConstraints(this._commandLinePreviewLabel, c);
        main.add(this._commandLinePreviewLabel);
        c.weightx = 1.0;
        c.weighty = 32.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandLinePreview = new JTextPane();
        this._commandLinePreview.setToolTipText(STALE_TOOLTIP);
        this._commandLineDoc = (StyledDocument)this._commandLinePreview.getDocument();
        this._varCommandLineCmdStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this._varCommandLineCmdStyle, DrJava.getConfig().getSetting(DEFINITIONS_MATCH_COLOR));
        this._commandLineCmdAS = new SimpleAttributeSet();
        StyleConstants.setForeground(this._commandLineCmdAS, DrJava.getConfig().getSetting(DEFINITIONS_NORMAL_COLOR));
        this._varCommandLineCmdStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this._varCommandLineCmdStyle, DrJava.getConfig().getSetting(DEFINITIONS_MATCH_COLOR));
        this._varErrorCommandLineCmdStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this._varErrorCommandLineCmdStyle, DrJava.getConfig().getSetting(DEBUG_BREAKPOINT_COLOR));
        this._varCommandLineCmdStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this._varCommandLineCmdStyle, DrJava.getConfig().getSetting(DEFINITIONS_MATCH_COLOR));
        this._commandLinePreview.setEditable(false);
        this._commandLinePreview.setBackground(Color.LIGHT_GRAY);
        this._commandLinePreview.setSelectedTextColor(Color.LIGHT_GRAY);
        JScrollPane commandLinePreviewSP = new JScrollPane(this._commandLinePreview);
        commandLinePreviewSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandLinePreviewSP, c);
        main.add(commandLinePreviewSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel workDirLabel = new JLabel("Work directory:");
        gridbag.setConstraints(workDirLabel, c);
        main.add(workDirLabel);
        c.weightx = 1.0;
        c.weighty = 8.0;
        c.gridwidth = -1;
        c.insets = compInsets;
        this._commandWorkDirLine = new JTextPane();
        this._commandWorkDirLine.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                } else if (e.getKeyCode() == 9) {
                    e.consume();
                    if (e.isShiftDown()) {
                        ExecuteExternalDialog.access$900(ExecuteExternalDialog.this).requestFocus();
                    } else {
                        ExecuteExternalDialog.access$1200(ExecuteExternalDialog.this).requestFocus();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane commandWorkDirLineSP = new JScrollPane(this._commandWorkDirLine);
        commandWorkDirLineSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandWorkDirLineSP, c);
        main.add(commandWorkDirLineSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandWorkDirBtn = new JButton("...");
        this._commandWorkDirBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExecuteExternalDialog.this.chooseFile(ExecuteExternalDialog.access$1100(ExecuteExternalDialog.this));
            }
        });
        gridbag.setConstraints(this._commandWorkDirBtn, c);
        main.add(this._commandWorkDirBtn);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel commandWorkDirLinePreviewLabel = new JLabel("Work directory preview:");
        commandWorkDirLinePreviewLabel.setToolTipText(STALE_TOOLTIP);
        gridbag.setConstraints(commandWorkDirLinePreviewLabel, c);
        main.add(commandWorkDirLinePreviewLabel);
        c.weightx = 1.0;
        c.weighty = 8.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandWorkDirLinePreview = new JTextPane();
        this._commandWorkDirLinePreview.setToolTipText(STALE_TOOLTIP);
        this._commandWorkDirLineDoc = (StyledDocument)this._commandWorkDirLinePreview.getDocument();
        this._commandWorkDirLinePreview.setEditable(false);
        this._commandWorkDirLinePreview.setBackground(Color.LIGHT_GRAY);
        this._commandWorkDirLinePreview.setSelectedTextColor(Color.LIGHT_GRAY);
        JScrollPane commandWorkDirLinePreviewSP = new JScrollPane(this._commandWorkDirLinePreview);
        commandWorkDirLinePreviewSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandWorkDirLinePreviewSP, c);
        main.add(commandWorkDirLinePreviewSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel enclosingFileLabel = new JLabel("Enclosing .djapp file:");
        gridbag.setConstraints(enclosingFileLabel, c);
        main.add(enclosingFileLabel);
        c.weightx = 1.0;
        c.weighty = 8.0;
        c.gridwidth = -1;
        c.insets = compInsets;
        this._commandEnclosingFileLine = new JTextPane();
        this._commandEnclosingFileLine.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                } else if (e.getKeyCode() == 9) {
                    e.consume();
                    if (e.isShiftDown()) {
                        ExecuteExternalDialog.access$1100(ExecuteExternalDialog.this).requestFocus();
                    } else {
                        ExecuteExternalDialog.access$200(ExecuteExternalDialog.this).setEnabled(false);
                        if (ExecuteExternalDialog.this._editMode) {
                            ExecuteExternalDialog.access$1300(ExecuteExternalDialog.this).requestFocus();
                        } else {
                            ExecuteExternalDialog.access$600(ExecuteExternalDialog.this).requestFocus();
                        }
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane commandEnclosingFileLineSP = new JScrollPane(this._commandEnclosingFileLine);
        commandEnclosingFileLineSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandEnclosingFileLineSP, c);
        main.add(commandEnclosingFileLineSP);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandEnclosingFileBtn = new JButton("...");
        this._commandEnclosingFileBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExecuteExternalDialog.this.chooseFile(ExecuteExternalDialog.access$1200(ExecuteExternalDialog.this));
            }
        });
        gridbag.setConstraints(this._commandEnclosingFileBtn, c);
        main.add(this._commandEnclosingFileBtn);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel commandEnclosingFileLinePreviewLabel = new JLabel("Enclosing .djapp file preview:");
        commandEnclosingFileLinePreviewLabel.setToolTipText(STALE_TOOLTIP);
        gridbag.setConstraints(commandEnclosingFileLinePreviewLabel, c);
        main.add(commandEnclosingFileLinePreviewLabel);
        c.weightx = 1.0;
        c.weighty = 8.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._commandEnclosingFileLinePreview = new JTextPane();
        this._commandEnclosingFileLinePreview.setToolTipText(STALE_TOOLTIP);
        this._commandEnclosingFileLineDoc = (StyledDocument)this._commandEnclosingFileLinePreview.getDocument();
        this._commandEnclosingFileLinePreview.setEditable(false);
        this._commandEnclosingFileLinePreview.setBackground(Color.LIGHT_GRAY);
        this._commandEnclosingFileLinePreview.setSelectedTextColor(Color.LIGHT_GRAY);
        JScrollPane commandEnclosingFileLinePreviewSP = new JScrollPane(this._commandEnclosingFileLinePreview);
        commandEnclosingFileLinePreviewSP.setVerticalScrollBarPolicy(20);
        gridbag.setConstraints(commandEnclosingFileLinePreviewSP, c);
        main.add(commandEnclosingFileLinePreviewSP);
        panel.add((Component)main, "Center");
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        if (!this._editMode) {
            bottom.add(this._runCommandButton);
        }
        bottom.add(this._saveCommandButton);
        bottom.add(this._insertCommandButton);
        bottom.add(this._cancelCommandButton);
        bottom.add(Box.createHorizontalGlue());
        panel.add((Component)bottom, "South");
        this._documentListener = new DocumentListener(){

            public void update(DocumentEvent e) {
                try {
                    ExecuteExternalDialog.access$1400(ExecuteExternalDialog.this).remove(0, ExecuteExternalDialog.access$1400(ExecuteExternalDialog.this).getLength());
                    String text = StringOps.replaceVariables(ExecuteExternalDialog.access$900(ExecuteExternalDialog.this).getText(), ExecuteExternalDialog.this._props, PropertyMaps.GET_LAZY);
                    ExecuteExternalDialog.access$1400(ExecuteExternalDialog.this).insertString(ExecuteExternalDialog.access$1400(ExecuteExternalDialog.this).getLength(), StringOps.unescapeFileName(text), null);
                    ExecuteExternalDialog.this.colorVariables(ExecuteExternalDialog.access$900(ExecuteExternalDialog.this), ExecuteExternalDialog.this._props, this, ExecuteExternalDialog.this._commandLineCmdAS, ExecuteExternalDialog.this._varCommandLineCmdStyle, ExecuteExternalDialog.this._varErrorCommandLineCmdStyle);
                    ExecuteExternalDialog.access$1500(ExecuteExternalDialog.this).setText("<html>Command line preview:<br>(" + ExecuteExternalDialog.access$300(ExecuteExternalDialog.this).getText().length() + " characters)</html>");
                }
                catch (BadLocationException ble) {
                    ExecuteExternalDialog.access$300(ExecuteExternalDialog.this).setText("Error.");
                }
            }

            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }
        };
        this._commandLine.getDocument().addDocumentListener(this._documentListener);
        this._documentListener.changedUpdate(null);
        this._workDirDocumentListener = new DocumentListener(){

            public void update(DocumentEvent e) {
                try {
                    ExecuteExternalDialog.access$1600(ExecuteExternalDialog.this).remove(0, ExecuteExternalDialog.access$1600(ExecuteExternalDialog.this).getLength());
                    String text = StringOps.replaceVariables(ExecuteExternalDialog.access$1100(ExecuteExternalDialog.this).getText(), ExecuteExternalDialog.this._props, PropertyMaps.GET_LAZY);
                    ExecuteExternalDialog.access$1600(ExecuteExternalDialog.this).insertString(0, StringOps.unescapeFileName(text), null);
                    ExecuteExternalDialog.this.colorVariables(ExecuteExternalDialog.access$1100(ExecuteExternalDialog.this), ExecuteExternalDialog.this._props, this, ExecuteExternalDialog.this._commandLineCmdAS, ExecuteExternalDialog.this._varCommandLineCmdStyle, ExecuteExternalDialog.this._varErrorCommandLineCmdStyle);
                }
                catch (BadLocationException ble) {
                    ExecuteExternalDialog.access$300(ExecuteExternalDialog.this).setText("Error: " + ble);
                }
            }

            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }
        };
        this._commandWorkDirLine.getDocument().addDocumentListener(this._workDirDocumentListener);
        this._commandWorkDirLine.setText("${drjava.working.dir}");
        this._workDirDocumentListener.changedUpdate(null);
        this._enclosingFileDocumentListener = new DocumentListener(){

            public void update(DocumentEvent e) {
                try {
                    ExecuteExternalDialog.access$1700(ExecuteExternalDialog.this).remove(0, ExecuteExternalDialog.access$1700(ExecuteExternalDialog.this).getLength());
                    String text = StringOps.replaceVariables(ExecuteExternalDialog.access$1200(ExecuteExternalDialog.this).getText(), ExecuteExternalDialog.this._props, PropertyMaps.GET_LAZY);
                    ExecuteExternalDialog.access$1700(ExecuteExternalDialog.this).insertString(0, StringOps.unescapeFileName(text), null);
                    ExecuteExternalDialog.this.colorVariables(ExecuteExternalDialog.access$1200(ExecuteExternalDialog.this), ExecuteExternalDialog.this._props, this, ExecuteExternalDialog.this._commandLineCmdAS, ExecuteExternalDialog.this._varCommandLineCmdStyle, ExecuteExternalDialog.this._varErrorCommandLineCmdStyle);
                }
                catch (BadLocationException ble) {
                    ExecuteExternalDialog.access$300(ExecuteExternalDialog.this).setText("Error: " + ble);
                }
            }

            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }
        };
        this._commandEnclosingFileLine.getDocument().addDocumentListener(this._enclosingFileDocumentListener);
        this._commandEnclosingFileLine.setText("");
        this._enclosingFileDocumentListener.changedUpdate(null);
        this._lastCommandFocus = this._commandLine;
        this._commandLine.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ExecuteExternalDialog.access$1802(ExecuteExternalDialog.this, (JTextPane)e.getComponent());
                ExecuteExternalDialog.access$200(ExecuteExternalDialog.this).setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == ExecuteExternalDialog.access$300(ExecuteExternalDialog.this) || e.getOppositeComponent() == ExecuteExternalDialog.access$400(ExecuteExternalDialog.this)) {
                    ExecuteExternalDialog.access$900(ExecuteExternalDialog.this).requestFocus();
                }
            }
        });
        this._commandWorkDirLine.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ExecuteExternalDialog.access$1802(ExecuteExternalDialog.this, (JTextPane)e.getComponent());
                ExecuteExternalDialog.access$200(ExecuteExternalDialog.this).setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == ExecuteExternalDialog.access$300(ExecuteExternalDialog.this) || e.getOppositeComponent() == ExecuteExternalDialog.access$400(ExecuteExternalDialog.this)) {
                    ExecuteExternalDialog.access$1100(ExecuteExternalDialog.this).requestFocus();
                }
            }
        });
        return panel;
    }

    protected void colorVariables(final JTextPane pane, final PropertyMaps props, final DocumentListener dl, final SimpleAttributeSet normal, final SimpleAttributeSet variable, final SimpleAttributeSet error) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StyledDocument doc = (StyledDocument)pane.getDocument();
                doc.removeDocumentListener(dl);
                String str = pane.getText();
                BalancingStreamTokenizer tok = new BalancingStreamTokenizer(new StringReader(str), Autobox.valueOf('$'));
                tok.wordRange(0, 255);
                tok.addQuotes("${", "}");
                int pos = 0;
                doc.setCharacterAttributes(0, str.length(), normal, true);
                String next = null;
                try {
                    while ((next = tok.getNextToken()) != null) {
                        if (tok.token() == BalancingStreamTokenizer.Token.QUOTED && next.startsWith("${")) {
                            if (next.endsWith("}")) {
                                String key;
                                String attrList = "";
                                int firstCurly = next.indexOf(125);
                                int firstSemi = next.indexOf(59);
                                if (firstSemi < 0) {
                                    key = next.substring(2, firstCurly);
                                } else {
                                    key = next.substring(2, firstSemi);
                                    attrList = next.substring(firstSemi + 1, next.length() - 1).trim();
                                }
                                boolean found = false;
                                Iterator<String> i$ = props.getCategories().iterator();
                                while (i$.hasNext()) {
                                    String category = i$.next();
                                    DrJavaProperty p = props.getProperty(category, key);
                                    if (p != null) {
                                        found = true;
                                        doc.setCharacterAttributes(pos, pos + next.length(), variable, true);
                                        if (attrList.length() > 0) {
                                            int subpos = pos + 2 + key.length() + 1;
                                            int added = 0;
                                            BalancingStreamTokenizer atok = new BalancingStreamTokenizer(new StringReader(attrList), Autobox.valueOf('$'));
                                            atok.wordRange(0, 255);
                                            atok.addQuotes("${", "}");
                                            atok.addQuotes("\"", "\"");
                                            atok.addKeyword(";");
                                            atok.addKeyword("=");
                                            String n = null;
                                            while ((n = atok.getNextToken()) != null) {
                                                if (n == null || atok.token() != BalancingStreamTokenizer.Token.NORMAL || n.trim().equals(";") || n.trim().equals("=") || n.trim().startsWith("\"")) {
                                                    doc.setCharacterAttributes(subpos, pos + next.length(), error, true);
                                                    break;
                                                }
                                                added += n.length();
                                                String name = n.trim();
                                                n = atok.getNextToken();
                                                if (n == null || atok.token() != BalancingStreamTokenizer.Token.KEYWORD || !n.trim().equals("=")) {
                                                    doc.setCharacterAttributes(subpos, pos + next.length(), error, true);
                                                    break;
                                                }
                                                added += n.length();
                                                n = atok.getNextToken();
                                                if (n == null || atok.token() != BalancingStreamTokenizer.Token.QUOTED || !n.trim().startsWith("\"")) {
                                                    doc.setCharacterAttributes(subpos, pos + next.length(), error, true);
                                                    break;
                                                }
                                                added += n.length();
                                                n = atok.getNextToken();
                                                if (n != null && (atok.token() != BalancingStreamTokenizer.Token.KEYWORD || !n.equals(";")) || n == null && atok.token() != BalancingStreamTokenizer.Token.END) {
                                                    doc.setCharacterAttributes(subpos, pos + next.length(), error, true);
                                                    break;
                                                }
                                                if (n != null) {
                                                    added += n.length();
                                                }
                                                try {
                                                    p.getAttribute(name);
                                                }
                                                catch (IllegalArgumentException e) {
                                                    doc.setCharacterAttributes(subpos, subpos + added, error, true);
                                                }
                                                subpos += added;
                                            }
                                        }
                                    }
                                    if (!found) continue;
                                    break;
                                }
                                if (!found) {
                                    doc.setCharacterAttributes(pos, pos + next.length(), error, true);
                                }
                            } else {
                                doc.setCharacterAttributes(pos, pos + next.length(), error, true);
                            }
                        } else {
                            doc.setCharacterAttributes(pos, pos + next.length(), normal, true);
                        }
                        pos += next.length();
                    }
                }
                catch (IOException e) {
                }
                finally {
                    doc.addDocumentListener(dl);
                }
            }
        });
    }

    private void _cancel() {
        this._lastState = new FrameState(this);
        this.setVisible(false);
        if (this._cm != null) {
            this._cm.signal();
        }
    }

    public ExternalProcessPanel runCommand(String name, String cmdline, String workdir, String enclosingFile, PropertyMaps pm) {
        ((MutableFileProperty)pm.getProperty("enclosing.djapp.file")).setFile(enclosingFile.length() > 0 ? new File(enclosingFile) : null);
        GeneralProcessCreator pc = new GeneralProcessCreator(cmdline, workdir.trim(), pm);
        String label = "External";
        if (!name.equals("")) {
            label = label + ": " + name;
        }
        final ExternalProcessPanel panel = new ExternalProcessPanel(this._mainFrame, label, pc);
        this._mainFrame._tabs.addLast(panel);
        panel.getMainPanel().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ExecuteExternalDialog.this._mainFrame._lastFocusOwner = panel;
            }
        });
        panel.setVisible(true);
        this._mainFrame.showTab(panel, true);
        this._mainFrame._tabbedPane.setSelectedComponent(panel);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                panel.requestFocusInWindow();
            }
        });
        return panel;
    }

    private void _runCommand() {
        this._mainFrame.updateStatusField("Executing external process...");
        GeneralProcessCreator.LOG.log("_runCommand(): ${enclosing.djapp.file} = " + this._commandEnclosingFileLine.getText());
        this._mainFrame.removeModalWindowAdapter(this);
        if (this._commandLinePreview.getText().length() > 0) {
            try {
                this._props = PropertyMaps.TEMPLATE.clone();
                PropertyMaps pm = this._props.clone();
                this.runCommand("", this._commandLine.getText(), this._commandWorkDirLine.getText(), this._commandEnclosingFileLine.getText().trim(), pm);
            }
            catch (CloneNotSupportedException e) {
                throw new UnexpectedException(e);
            }
        }
        this._saveSettings();
        this.setVisible(false);
        if (this._cm != null) {
            this._cm.signal();
        }
    }

    private void _saveCommand() {
        if (this._editMode) {
            Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
            this._mainFrame.removeModalWindowAdapter(this);
            String name = JOptionPane.showInputDialog(this, "Name for saved process:", names.get(this._editIndex));
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            if (name == null) {
                this._saveSettings();
                this.setVisible(false);
                if (this._cm != null) {
                    this._cm.signal();
                }
                return;
            }
            ExecuteExternalDialog.editInMenu(this._editIndex, name, this._commandLine.getText(), this._commandWorkDirLine.getText(), this._commandEnclosingFileLine.getText());
        } else {
            int count = DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_COUNT);
            this._mainFrame.removeModalWindowAdapter(this);
            String name = JOptionPane.showInputDialog(this, "Name for saved process:", "External Java " + (count + 1));
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            if (name == null) {
                this._saveSettings();
                this.setVisible(false);
                if (this._cm != null) {
                    this._cm.signal();
                }
                return;
            }
            ExecuteExternalDialog.addToMenu(name, this._commandLine.getText(), this._commandWorkDirLine.getText(), this._commandEnclosingFileLine.getText());
        }
        this._saveSettings();
        this.setVisible(false);
        if (this._cm != null) {
            this._cm.signal();
        }
    }

    public static int addToMenu(String name, String cmdline, String workdir, String enclosingFile) {
        GeneralProcessCreator.LOG.log("addToMenu(): enclosingFile = " + enclosingFile);
        int count = DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_COUNT);
        ++count;
        Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
        Vector cmdlines = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES));
        Vector workdirs = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS));
        Vector enclosingFiles = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES));
        names.add(name);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_NAMES, names);
        cmdlines.add(cmdline);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES, cmdlines);
        workdirs.add(workdir);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS, workdirs);
        enclosingFiles.add(enclosingFile);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES, enclosingFiles);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_COUNT, Autobox.valueOf(count));
        return count;
    }

    public static void editInMenu(int editIndex, String name, String cmdline, String workdir, String enclosingFile) {
        GeneralProcessCreator.LOG.log("editInMenu(): enclosingFile = " + enclosingFile);
        Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
        Vector cmdlines = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES));
        Vector workdirs = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS));
        Vector enclosingFiles = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES));
        names.set(editIndex, name);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_NAMES, names);
        cmdlines.set(editIndex, cmdline);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES, cmdlines);
        workdirs.set(editIndex, workdir);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS, workdirs);
        enclosingFiles.set(editIndex, enclosingFile);
        DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES, enclosingFiles);
    }

    public static void saveToFile(int index, File f) {
        Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
        Vector cmdlines = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES));
        Vector workdirs = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS));
        Vector enclosingFiles = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES));
        XMLConfig xc = new XMLConfig();
        xc.set("drjava/extprocess/name", (String)names.get(index));
        xc.set("drjava/extprocess/cmdline", (String)cmdlines.get(index));
        xc.set("drjava/extprocess/workdir", (String)workdirs.get(index));
        xc.set("drjava/extprocess/enlcosingfile", (String)enclosingFiles.get(index));
        xc.save(f);
    }

    private boolean _saveSettings() {
        this._lastState = new FrameState(this);
        return true;
    }

    private void _insertVariableCommand() {
        this._props.clearVariables();
        this._mainFrame.removeModalWindowAdapter(this);
        this._insertVarDialogMonitor.reset();
        this._insertVarDialog.setVisible(true);
        new Thread(new Runnable(){

            public void run() {
                ExecuteExternalDialog.this._insertVarDialogMonitor.attemptEnsureSignalled();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                ExecuteExternalDialog.this.toFront();
                            }
                        });
                        ExecuteExternalDialog.this._mainFrame.installModalWindowAdapter(ExecuteExternalDialog.this, LambdaUtil.NO_OP, ExecuteExternalDialog.this.CANCEL);
                        Pair<String, DrJavaProperty> selected = ExecuteExternalDialog.this._insertVarDialog.getSelected();
                        if (selected != null) {
                            int max;
                            String text = ExecuteExternalDialog.access$1800(ExecuteExternalDialog.this).getText();
                            Caret caret = ExecuteExternalDialog.access$1800(ExecuteExternalDialog.this).getCaret();
                            int min = Math.min(caret.getDot(), caret.getMark());
                            if (min != (max = Math.max(caret.getDot(), caret.getMark()))) {
                                text = text.substring(0, min) + text.substring(max);
                            }
                            text = text.substring(0, min) + "${" + selected.first() + "}" + text.substring(min);
                            ExecuteExternalDialog.access$1800(ExecuteExternalDialog.this).setText(text);
                            caret.setDot(min + selected.first().length() + 2);
                            ExecuteExternalDialog.access$1800(ExecuteExternalDialog.this).setCaret(caret);
                        }
                    }
                });
            }
        }).start();
    }

    public void setVisible(boolean vis) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.validate();
        if (vis) {
            try {
                this._props = PropertyMaps.TEMPLATE.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UnexpectedException(e);
            }
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            this._documentListener.changedUpdate(null);
            this._workDirDocumentListener.changedUpdate(null);
            this.toFront();
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    protected void chooseDir(JTextPane pane) {
        File chosen;
        File wd = new File(StringOps.replaceVariables(pane.getText().trim(), this._props, PropertyMaps.GET_CURRENT));
        if (pane.getText().equals("") || !wd.exists() && !wd.isDirectory()) {
            wd = new File(System.getProperty("user.dir"));
        }
        this._dirChooser.setSelectedFile(wd);
        this._mainFrame.removeModalWindowAdapter(this);
        int returnValue = this._dirChooser.showDialog(wd);
        this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
        if (returnValue == 0 && (chosen = this._dirChooser.getSelectedDirectory()) != null) {
            pane.setText(chosen.toString());
        }
    }

    protected void chooseFile(JTextPane pane) {
        File wd = new File(StringOps.replaceVariables(pane.getText().trim(), this._props, PropertyMaps.GET_CURRENT));
        if (pane.getText().equals("") || !wd.exists() && !wd.isFile()) {
            wd = null;
        }
        this._fileChooser.setSelectedFile(wd);
        this._mainFrame.removeModalWindowAdapter(this);
        int returnValue = this._fileChooser.showOpenDialog(this);
        this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
        if (returnValue == 0) {
            File chosen = this._fileChooser.getSelectedFile();
            if (chosen != null) {
                pane.setText(chosen.toString());
            } else {
                pane.setText("");
            }
        }
    }

    static void access$000(ExecuteExternalDialog x0) {
        x0._saveCommand();
    }

    static void access$100(ExecuteExternalDialog x0) {
        x0._runCommand();
    }

    static JButton access$200(ExecuteExternalDialog x0) {
        return x0._insertCommandButton;
    }

    static JTextPane access$300(ExecuteExternalDialog x0) {
        return x0._commandLinePreview;
    }

    static JTextPane access$400(ExecuteExternalDialog x0) {
        return x0._commandWorkDirLinePreview;
    }

    static JTextPane access$500(ExecuteExternalDialog x0) {
        return x0._commandEnclosingFileLinePreview;
    }

    static JButton access$600(ExecuteExternalDialog x0) {
        return x0._runCommandButton;
    }

    static void access$700(ExecuteExternalDialog x0) {
        x0._insertVariableCommand();
    }

    static void access$800(ExecuteExternalDialog x0) {
        x0._cancel();
    }

    static JTextPane access$900(ExecuteExternalDialog x0) {
        return x0._commandLine;
    }

    static JButton access$1000(ExecuteExternalDialog x0) {
        return x0._cancelCommandButton;
    }

    static JTextPane access$1100(ExecuteExternalDialog x0) {
        return x0._commandWorkDirLine;
    }

    static JTextPane access$1200(ExecuteExternalDialog x0) {
        return x0._commandEnclosingFileLine;
    }

    static JButton access$1300(ExecuteExternalDialog x0) {
        return x0._saveCommandButton;
    }

    static StyledDocument access$1400(ExecuteExternalDialog x0) {
        return x0._commandLineDoc;
    }

    static JLabel access$1500(ExecuteExternalDialog x0) {
        return x0._commandLinePreviewLabel;
    }

    static StyledDocument access$1600(ExecuteExternalDialog x0) {
        return x0._commandWorkDirLineDoc;
    }

    static StyledDocument access$1700(ExecuteExternalDialog x0) {
        return x0._commandEnclosingFileLineDoc;
    }

    static JTextPane access$1802(ExecuteExternalDialog x0, JTextPane x1) {
        x0._lastCommandFocus = x1;
        return x0._lastCommandFocus;
    }

    static JTextPane access$1800(ExecuteExternalDialog x0) {
        return x0._lastCommandFocus;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$ExecuteExternalDialog == null ? (class$edu$rice$cs$drjava$ui$ExecuteExternalDialog = ExecuteExternalDialog.class$("edu.rice.cs.drjava.ui.ExecuteExternalDialog")) : class$edu$rice$cs$drjava$ui$ExecuteExternalDialog).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public static class FrameState {
        private Point _loc;

        public FrameState(Point l) {
            this._loc = l;
        }

        public FrameState(String s) {
            StringTokenizer tok = new StringTokenizer(s);
            try {
                int x = Integer.valueOf(tok.nextToken());
                int y = Integer.valueOf(tok.nextToken());
                this._loc = new Point(x, y);
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nsee);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nfe);
            }
        }

        public FrameState(ExecuteExternalDialog comp) {
            this._loc = comp.getLocation();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._loc.x);
            sb.append(' ');
            sb.append(this._loc.y);
            return sb.toString();
        }

        public Point getLocation() {
            return this._loc;
        }
    }
}

