/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerError;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.ErrorPanel;
import edu.rice.cs.drjava.ui.MainFrame;
import java.awt.EventQueue;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Position;

public class ErrorCaretListener
implements CaretListener {
    private final OpenDefinitionsDocument _openDoc;
    private final DefinitionsPane _definitionsPane;
    protected final MainFrame _frame;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$ErrorCaretListener;

    public ErrorCaretListener(OpenDefinitionsDocument doc, DefinitionsPane defPane, MainFrame frame) {
        this._openDoc = doc;
        this._definitionsPane = defPane;
        this._frame = frame;
    }

    public OpenDefinitionsDocument getOpenDefDoc() {
        return this._openDoc;
    }

    public void caretUpdate(CaretEvent evt) {
        if (this._frame.getSelectedErrorPanel() == null) {
            return;
        }
        this.updateHighlight(evt.getDot());
    }

    public void updateHighlight(int curPos) {
        ErrorPanel panel = this._frame.getSelectedErrorPanel();
        if (panel == null) {
            return;
        }
        CompilerErrorModel model = panel.getErrorModel();
        if (!model.hasErrorsWithPositions(this._openDoc)) {
            return;
        }
        CompilerError error = model.getErrorAtOffset(this._openDoc, curPos);
        ErrorPanel.ErrorListPane errorListPane = panel.getErrorListPane();
        if (error == null) {
            errorListPane.selectNothing();
        } else {
            if (errorListPane.shouldShowHighlightsInSource()) {
                this._highlightErrorInSource(model.getPosition(error));
            }
            errorListPane.selectItem(error);
        }
    }

    public void removeHighlight() {
        this._definitionsPane.removeErrorHighlight();
    }

    private void _highlightErrorInSource(Position pos) {
        int nextNewline;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (pos == null) {
            return;
        }
        int errPos = pos.getOffset();
        String text = this._openDoc.getText();
        int prevNewline = text.lastIndexOf(10, errPos - 1);
        if (prevNewline == -1) {
            prevNewline = 0;
        }
        if ((nextNewline = text.indexOf(10, errPos)) == -1) {
            nextNewline = text.length();
        }
        this.removeHighlight();
        if (prevNewline > 0) {
            ++prevNewline;
        }
        if (prevNewline <= nextNewline) {
            this._definitionsPane.addErrorHighlight(prevNewline, nextNewline);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$ErrorCaretListener == null ? (class$edu$rice$cs$drjava$ui$ErrorCaretListener = ErrorCaretListener.class$("edu.rice.cs.drjava.ui.ErrorCaretListener")) : class$edu$rice$cs$drjava$ui$ErrorCaretListener).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

