/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.UneditableTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DrJavaSurveyPopup
extends JDialog {
    public static final String[] DRJAVA_SURVEY_KEYS;
    private JButton _noButton;
    private JButton _yesButton;
    private MainFrame _mainFrame;
    private JOptionPane _questionPanel;
    private JTable _propertiesTable;
    private JPanel _bottomPanel;
    private JCheckBox _neverAskAgain;
    private Action _noAction = new AbstractAction("No"){

        public void actionPerformed(ActionEvent e) {
            DrJavaSurveyPopup.this.noAction();
        }
    };
    private Action _yesAction = new AbstractAction("Yes"){

        public void actionPerformed(ActionEvent e) {
            DrJavaSurveyPopup.this.yesAction();
        }
    };
    public static final Log LOG;
    protected final Runnable1<WindowEvent> NO = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            DrJavaSurveyPopup.this.noAction();
        }

        @Override
        public void run(Object x0) {
            this.run((WindowEvent)x0);
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$DrJavaSurveyPopup;

    public DrJavaSurveyPopup(MainFrame parent) {
        super((Frame)parent, "Send System Information to DrJava Developers");
        this.setResizable(false);
        this.setSize(550, 350);
        this._mainFrame = parent;
        this._yesButton = new JButton(this._yesAction);
        this._noButton = new JButton(this._noAction);
        this._neverAskAgain = new JCheckBox("Never ask me again", DrJava.getConfig().getSetting(OptionConstants.DIALOG_DRJAVA_SURVEY_ENABLED) == false);
        this._neverAskAgain.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DrJava.getConfig().setSetting(OptionConstants.DIALOG_DRJAVA_SURVEY_ENABLED, Autobox.valueOf(!DrJavaSurveyPopup.access$000(DrJavaSurveyPopup.this).isSelected()));
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this._neverAskAgain);
        buttonPanel.add(this._yesButton);
        buttonPanel.add(this._noButton);
        this._questionPanel = new JOptionPane("May DrJava anonymously send the information\nbelow to the DrJava developers?", 3, -1, null, new Object[0]);
        int size = DRJAVA_SURVEY_KEYS.length + 2;
        Object[][] rowData = new String[size][2];
        int rowNum = 0;
        String[] arr$ = DRJAVA_SURVEY_KEYS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String k;
            rowData[rowNum][0] = k = arr$[i$];
            rowData[rowNum][1] = System.getProperty(k);
            ++rowNum;
        }
        rowData[rowNum][0] = "DrJava revision";
        rowData[rowNum++][1] = String.valueOf(Version.getRevisionNumber());
        rowData[rowNum][0] = "DrJava build time";
        rowData[rowNum++][1] = String.valueOf(Version.getBuildTimeString());
        Arrays.sort(rowData, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                return o1[0].compareTo(o2[0]);
            }

            @Override
            public int compare(Object x0, Object x1) {
                return this.compare((String[])x0, (String[])x1);
            }
        });
        Object[] nvStrings = new String[]{"Name", "Value"};
        UneditableTableModel model = new UneditableTableModel(rowData, nvStrings);
        this._propertiesTable = new JTable(model);
        BorderlessScrollPane scroller = new BorderlessScrollPane(this._propertiesTable);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this._questionPanel, "North");
        centerPanel.add((Component)scroller, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this._mainFrame.setPopupLoc(this);
    }

    protected void noAction() {
        DrJava.getConfig().setSetting(OptionConstants.LAST_DRJAVA_SURVEY, Autobox.valueOf(new Date().getTime()));
        DrJava.getConfig().setSetting(OptionConstants.LAST_DRJAVA_SURVEY_RESULT, DrJavaSurveyPopup.getSurveyURL());
        this.setVisible(false);
        this.dispose();
    }

    public static String getSurveyURL() {
        String DRJAVA_SURVEY_PAGE = "http://www.drjava.org/submit-usage.php?";
        StringBuffer sb = new StringBuffer();
        sb.append("http://www.drjava.org/submit-usage.php?");
        sb.append("rev=");
        sb.append(Version.getRevisionNumber());
        String[] arr$ = DRJAVA_SURVEY_KEYS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String k = arr$[i$];
            sb.append('&');
            sb.append(k);
            sb.append('=');
            sb.append(System.getProperty(k));
        }
        LOG.log(sb.toString());
        return sb.toString().replaceAll(" ", "%20");
    }

    public static boolean maySubmitSurvey() {
        int days = DrJava.getConfig().getSetting(OptionConstants.DRJAVA_SURVEY_DAYS);
        Date nextCheck = new Date(DrJava.getConfig().getSetting(OptionConstants.LAST_DRJAVA_SURVEY) + (long)days * 24L * 60L * 60L * 1000L);
        return new Date().after(nextCheck) || !DrJava.getConfig().getSetting(OptionConstants.LAST_DRJAVA_SURVEY_RESULT).equals(DrJavaSurveyPopup.getSurveyURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void yesAction() {
        try {
            String result = DrJavaSurveyPopup.getSurveyURL() + "&buildtime=" + Version.getBuildTimeString();
            LOG.log(result);
            int days = DrJava.getConfig().getSetting(OptionConstants.DRJAVA_SURVEY_DAYS);
            Date nextCheck = new Date(DrJava.getConfig().getSetting(OptionConstants.LAST_DRJAVA_SURVEY) + (long)days * 24L * 60L * 60L * 1000L);
            if (!DrJavaSurveyPopup.maySubmitSurvey()) {
                return;
            }
            BufferedReader br = null;
            try {
                String line;
                URL url = new URL(result);
                InputStream urls = url.openStream();
                InputStreamReader is = new InputStreamReader(urls);
                br = new BufferedReader(is);
                StringBuffer sb = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(System.getProperty("line.separator"));
                }
                LOG.log(sb.toString());
            }
            catch (IOException e) {
                LOG.log("Could not open URL using Java", e);
                try {
                    PlatformFactory.ONLY.openURL(new URL(result));
                    DrJava.getConfig().setSetting(OptionConstants.LAST_DRJAVA_SURVEY_RESULT, result);
                }
                catch (IOException e2) {
                    LOG.log("Could not open URL using web browser", e2);
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        finally {
            this.noAction();
        }
    }

    public void setVisible(boolean vis) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.NO);
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    static JCheckBox access$000(DrJavaSurveyPopup x0) {
        return x0._neverAskAgain;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$DrJavaSurveyPopup == null ? (class$edu$rice$cs$drjava$ui$DrJavaSurveyPopup = DrJavaSurveyPopup.class$("edu.rice.cs.drjava.ui.DrJavaSurveyPopup")) : class$edu$rice$cs$drjava$ui$DrJavaSurveyPopup).desiredAssertionStatus();
        DRJAVA_SURVEY_KEYS = new String[]{"os.name", "os.version", "java.version", "java.vendor"};
        LOG = new Log("survey.txt", false);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

