/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DrJavaErrorWindow
extends JDialog {
    public static final String SF_ADD_BUG_URL = "http://sourceforge.net/tracker/?func=add&group_id=44253&atid=438935/";
    public static final String SF_LINK_NAME = "http://sourceforge.net/projects/drjava";
    private volatile JEditorPane _errorInfo;
    private final JTextArea _stackTrace;
    private final JLabel _indexLabel;
    private final JScrollPane _stackTraceScroll;
    private final JPanel _bottomPanel;
    private final JPanel _buttonPanel;
    private final JButton _copyButton;
    private final JButton _okButton;
    private final JButton _nextButton;
    private final JButton _prevButton;
    private final JButton _dismissButton;
    private volatile int _errorCount;
    private volatile Throwable _error;
    private volatile int _errorIndex;
    private static volatile JFrame _parentFrame;
    private static volatile boolean _parentChanged;
    private static volatile DrJavaErrorWindow _singletonInstance;
    protected WindowAdapter _windowListener = new WindowAdapter(){

        public void windowDeactivated(WindowEvent we) {
            DrJavaErrorWindow.this.toFront();
        }

        public void windowClosing(WindowEvent we) {
            DrJavaErrorWindow.this.dispose();
            if (DrJavaErrorHandler.getButton() == null) {
                System.exit(1);
            }
        }
    };
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            if (DrJavaErrorHandler.getButton() == null) {
                System.exit(1);
            }
        }

        @Override
        public void run(Object x0) {
            this.run((WindowEvent)x0);
        }
    };
    private final Action _okAction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            DrJavaErrorWindow.this.dispose();
            if (DrJavaErrorHandler.getButton() == null) {
                System.exit(1);
            }
        }
    };
    private final Action _prevAction = new AbstractAction("Previous"){

        public void actionPerformed(ActionEvent e) {
            if (DrJavaErrorWindow.access$000(DrJavaErrorWindow.this) > 0) {
                DrJavaErrorWindow.access$006(DrJavaErrorWindow.this);
                DrJavaErrorWindow.access$102(DrJavaErrorWindow.this, DrJavaErrorHandler.getError(DrJavaErrorWindow.access$000(DrJavaErrorWindow.this)));
                if (DrJavaErrorWindow.access$000(DrJavaErrorWindow.this) == 0) {
                    this.setEnabled(false);
                }
                if (DrJavaErrorWindow.access$200(DrJavaErrorWindow.this) > 1) {
                    DrJavaErrorWindow.access$300(DrJavaErrorWindow.this).setEnabled(true);
                }
                DrJavaErrorWindow.access$400(DrJavaErrorWindow.this);
            }
        }
    };
    private final Action _nextAction = new AbstractAction("Next"){

        public void actionPerformed(ActionEvent e) {
            if (DrJavaErrorWindow.access$000(DrJavaErrorWindow.this) < DrJavaErrorWindow.access$200(DrJavaErrorWindow.this) - 1) {
                DrJavaErrorWindow.access$004(DrJavaErrorWindow.this);
                DrJavaErrorWindow.access$102(DrJavaErrorWindow.this, DrJavaErrorHandler.getError(DrJavaErrorWindow.access$000(DrJavaErrorWindow.this)));
                if (DrJavaErrorWindow.access$000(DrJavaErrorWindow.this) == DrJavaErrorWindow.access$200(DrJavaErrorWindow.this) - 1) {
                    this.setEnabled(false);
                }
                if (DrJavaErrorWindow.access$200(DrJavaErrorWindow.this) > 1) {
                    DrJavaErrorWindow.access$500(DrJavaErrorWindow.this).setEnabled(true);
                }
                DrJavaErrorWindow.access$400(DrJavaErrorWindow.this);
            }
        }
    };
    private Action _dismissAction = new AbstractAction("Dismiss"){

        public void actionPerformed(ActionEvent e) {
            DrJavaErrorHandler.clearErrors();
            DrJavaErrorWindow.access$202(DrJavaErrorWindow.this, 0);
            DrJavaErrorWindow.access$102(DrJavaErrorWindow.this, null);
            DrJavaErrorWindow.access$002(DrJavaErrorWindow.this, -1);
            this.setEnabled(false);
            DrJavaErrorWindow.access$500(DrJavaErrorWindow.this).setEnabled(false);
            DrJavaErrorWindow.access$300(DrJavaErrorWindow.this).setEnabled(false);
            DrJavaErrorWindow.access$600(DrJavaErrorWindow.this).setEnabled(false);
            DrJavaErrorWindow.access$400(DrJavaErrorWindow.this);
            JButton errorsButton = DrJavaErrorHandler.getButton();
            if (errorsButton != null) {
                errorsButton.setVisible(false);
            }
            DrJavaErrorWindow.access$700(DrJavaErrorWindow.this).actionPerformed(e);
        }
    };
    private Action _copyAction = new AbstractAction("Copy This Error"){

        public void actionPerformed(ActionEvent e) {
            DrJavaErrorWindow.access$800(DrJavaErrorWindow.this).grabFocus();
            DrJavaErrorWindow.access$800(DrJavaErrorWindow.this).getActionMap().get("select-all").actionPerformed(e);
            DrJavaErrorWindow.access$800(DrJavaErrorWindow.this).getActionMap().get("copy-to-clipboard").actionPerformed(e);
        }
    };
    private static final String HEADER_HTML = "<html><font size=\"-1\" face=\"sans-serif, Arial, Helvetica, Geneva\"><b>";
    private static final String ERRORS_FOOTER_HTML = "Please submit a bug report containing the information below and an account of the actions that caused the bug (if known) to <a href=\"http://sourceforge.net/tracker/?func=add&group_id=44253&atid=438935/\"><b>http://sourceforge.net/projects/drjava</b></a>.<br>You may wish to save all your work and restart DrJava.<br>Thanks for your help in making DrJava better!</b></font></p></html>";
    private static final String NO_ERRORS_HTML = "No errors occurred!<br>Thanks for using DrJava!</b></font></p></html>";
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$DrJavaErrorWindow;

    public static void setFrame(JFrame f) {
        _parentFrame = f;
        _parentChanged = true;
    }

    public static JFrame getFrame() {
        return _parentFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DrJavaErrorWindow singleton() {
        if (_parentChanged) {
            Class clazz = class$edu$rice$cs$drjava$ui$DrJavaErrorWindow == null ? (class$edu$rice$cs$drjava$ui$DrJavaErrorWindow = DrJavaErrorWindow.class$("edu.rice.cs.drjava.ui.DrJavaErrorWindow")) : class$edu$rice$cs$drjava$ui$DrJavaErrorWindow;
            synchronized (clazz) {
                if (_parentChanged) {
                    _singletonInstance = new DrJavaErrorWindow();
                    _parentChanged = false;
                }
            }
        }
        return _singletonInstance;
    }

    private DrJavaErrorWindow() {
        super((Frame)_parentFrame, "DrJava Errors");
        this.setSize(600, 400);
        this._stackTrace = new JTextArea();
        this._stackTrace.setEditable(false);
        this._prevButton = new JButton(this._prevAction);
        this._nextButton = new JButton(this._nextAction);
        this._copyButton = new JButton(this._copyAction);
        this._dismissButton = new JButton(this._dismissAction);
        this._okButton = new JButton(this._okAction);
        this._bottomPanel = new JPanel(new BorderLayout());
        this._buttonPanel = new JPanel();
        this._buttonPanel.add(this._prevButton);
        this._buttonPanel.add(this._nextButton);
        this._buttonPanel.add(this._copyButton);
        this._buttonPanel.add(this._dismissButton);
        this._buttonPanel.add(this._okButton);
        this._indexLabel = new JLabel();
        this._bottomPanel.add((Component)this._indexLabel, "Center");
        this._bottomPanel.add((Component)this._buttonPanel, "East");
        this._stackTraceScroll = new BorderlessScrollPane(this._stackTrace, 22, 32);
        this._errorInfo = new JEditorPane("text/html", "<html><font size=\"-1\" face=\"sans-serif, Arial, Helvetica, Geneva\"><b>No errors occurred!<br>Thanks for using DrJava!</b></font></p></html>");
        this._errorInfo.setEditable(false);
        this._errorInfo.setBackground(this.getContentPane().getBackground());
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        cp.add((Component)this._errorInfo, "North");
        cp.add((Component)this._stackTraceScroll, "Center");
        cp.add((Component)this._bottomPanel, "South");
        this.getRootPane().setDefaultButton(this._okButton);
        this.init();
    }

    public void setVisible(boolean vis) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.validate();
        if (vis) {
            this.init();
            if (_parentFrame != null) {
                DrJavaRoot.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            }
            this.toFront();
        } else if (_parentFrame != null) {
            DrJavaRoot.removeModalWindowAdapter(this);
            _parentFrame.toFront();
        }
        super.setVisible(vis);
    }

    private void init() {
        this._errorCount = DrJavaErrorHandler.getErrorCount();
        if (this._errorCount > 0) {
            this._error = DrJavaErrorHandler.getError(0);
            this._errorIndex = 0;
        } else {
            this._error = null;
            this._errorIndex = -1;
        }
        this._prevAction.setEnabled(false);
        this._nextAction.setEnabled(this._errorCount > 1);
        this._dismissAction.setEnabled(this._errorCount > 0);
        this._copyAction.setEnabled(this._errorCount > 0);
        this.updateErrorInfo();
    }

    private void updateErrorInfo() {
        this.getContentPane().remove(this._errorInfo);
        if (this._error != null) {
            StringBuffer b = new StringBuffer();
            if (this._error instanceof DrJavaErrorHandler.LoggedCondition) {
                b.append("Logged condition: ");
                b.append(this._error.getMessage());
                b.append('\n');
                boolean first = true;
                StackTraceElement[] arr$ = this._error.getStackTrace();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    StackTraceElement ste = arr$[i$];
                    if (first) {
                        first = false;
                        continue;
                    }
                    b.append("\tat ");
                    b.append(ste);
                    b.append('\n');
                }
            } else {
                b.append(StringOps.getStackTrace(this._error));
                if (this._error instanceof UnexpectedException) {
                    Throwable t = ((UnexpectedException)this._error).getCause();
                    b.append("\nCaused by:\n");
                    b.append(StringOps.getStackTrace(t));
                }
            }
            b.append("\n\n");
            b.append(DrJavaErrorWindow.getSystemAndDrJavaInfo());
            this._stackTrace.setText(b.toString());
            this._stackTrace.setCaretPosition(0);
            StringBuffer b2 = new StringBuffer();
            b2.append(HEADER_HTML);
            b2.append(this._errorCount);
            b2.append(" error");
            b2.append(this._errorCount > 1 ? "s" : "");
            b2.append(" occured!<br>");
            b2.append(ERRORS_FOOTER_HTML);
            this._errorInfo = new JEditorPane("text/html", b2.toString());
            this._errorInfo.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            PlatformFactory.ONLY.openURL(e.getURL());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this._errorInfo.setEditable(false);
            this._errorInfo.setBackground(this.getContentPane().getBackground());
            this._indexLabel.setText("Error " + (this._errorIndex + 1) + " of " + this._errorCount);
        } else {
            this._errorInfo = new JEditorPane("text/html", "<html><font size=\"-1\" face=\"sans-serif, Arial, Helvetica, Geneva\"><b>No errors occurred!<br>Thanks for using DrJava!</b></font></p></html>");
            this._errorInfo.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            PlatformFactory.ONLY.openURL(e.getURL());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this._errorInfo.setEditable(false);
            this._errorInfo.setBackground(this.getContentPane().getBackground());
            this._stackTrace.setText("");
            this._indexLabel.setText("");
        }
        this.getContentPane().add((Component)this._errorInfo, "North");
        this.validate();
    }

    public static String getSystemAndDrJavaInfo() {
        StringBuffer b = new StringBuffer();
        b.append("System Properties:\n");
        b.append("DrJava Version ");
        b.append(Version.getVersionString());
        b.append('\n');
        b.append("DrJava Build Time ");
        b.append(Version.getBuildTimeString());
        b.append("\n\n");
        Properties props = System.getProperties();
        Iterator<Map.Entry<Object, Object>> entries = props.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<Object, Object> entry = entries.next();
            b.append(entry.getKey());
            b.append(" = ");
            if (entry.getKey().equals("line.separator")) {
                b.append("\"");
                String ls = (String)entry.getValue();
                for (int i = 0; i < ls.length(); ++i) {
                    char ch = ls.charAt(i);
                    b.append("\\u");
                    String hexString = "0000" + Integer.toHexString(ch);
                    b.append(hexString.substring(hexString.length() - 4));
                }
                b.append("\"");
            } else {
                b.append(entry.getValue());
            }
            b.append('\n');
        }
        b.append('\n');
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DrJava.getConfig().saveConfiguration(baos, "DrJava configuration file");
            b.append(baos.toString());
        }
        catch (IOException ioe) {
            b.append("IOException when trying to print DrJava configuration file");
        }
        b.append("\n\nUsed memory: about ");
        b.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        b.append("\nFree memory: about ");
        b.append(StringOps.memSizeToString(Runtime.getRuntime().freeMemory()));
        b.append("\nTotal memory: about ");
        b.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory()));
        b.append("\nTotal memory can expand to: about ");
        b.append(StringOps.memSizeToString(Runtime.getRuntime().maxMemory()));
        b.append("\n\n");
        String infoText = b.toString();
        String userHome = System.getProperty("user.home");
        String anonUserHome = "<anonymized user.home>";
        infoText = DrJavaErrorWindow.replaceString(infoText, userHome, anonUserHome);
        String userDir = System.getProperty("user.dir");
        String anonUserDir = "<anonymized user.dir>";
        infoText = DrJavaErrorWindow.replaceString(infoText, userDir, anonUserDir);
        String userName = System.getProperty("user.name");
        String anonUserName = "<anonymized user.name>";
        infoText = DrJavaErrorWindow.replaceString(infoText, userName, anonUserName);
        return infoText;
    }

    private static String replaceString(String text, String orig, String repl) {
        int pos = 0;
        while ((pos = text.indexOf(orig, pos)) >= 0) {
            text = text.substring(0, pos) + repl + text.substring(pos + orig.length(), text.length());
        }
        return text;
    }

    static int access$000(DrJavaErrorWindow x0) {
        return x0._errorIndex;
    }

    static int access$006(DrJavaErrorWindow x0) {
        return --x0._errorIndex;
    }

    static Throwable access$102(DrJavaErrorWindow x0, Throwable x1) {
        x0._error = x1;
        return x0._error;
    }

    static int access$200(DrJavaErrorWindow x0) {
        return x0._errorCount;
    }

    static Action access$300(DrJavaErrorWindow x0) {
        return x0._nextAction;
    }

    static void access$400(DrJavaErrorWindow x0) {
        x0.updateErrorInfo();
    }

    static int access$004(DrJavaErrorWindow x0) {
        return ++x0._errorIndex;
    }

    static Action access$500(DrJavaErrorWindow x0) {
        return x0._prevAction;
    }

    static int access$202(DrJavaErrorWindow x0, int x1) {
        x0._errorCount = x1;
        return x0._errorCount;
    }

    static int access$002(DrJavaErrorWindow x0, int x1) {
        x0._errorIndex = x1;
        return x0._errorIndex;
    }

    static Action access$600(DrJavaErrorWindow x0) {
        return x0._copyAction;
    }

    static Action access$700(DrJavaErrorWindow x0) {
        return x0._okAction;
    }

    static JTextArea access$800(DrJavaErrorWindow x0) {
        return x0._stackTrace;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$DrJavaErrorWindow == null ? (class$edu$rice$cs$drjava$ui$DrJavaErrorWindow = DrJavaErrorWindow.class$("edu.rice.cs.drjava.ui.DrJavaErrorWindow")) : class$edu$rice$cs$drjava$ui$DrJavaErrorWindow).desiredAssertionStatus();
        _parentFrame = null;
        _parentChanged = true;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

