/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.BooleanOption;
import edu.rice.cs.drjava.config.ColorOption;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.Finalizable;
import edu.rice.cs.drjava.model.FinalizationEvent;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DefinitionsEditorKit;
import edu.rice.cs.drjava.model.definitions.NoSuchDocumentException;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.drjava.ui.AbstractDJPane;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ErrorCaretListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.ReverseHighlighter;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Keymap;
import javax.swing.text.LayeredHighlighter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionsPane
extends AbstractDJPane
implements Finalizable<DefinitionsPane> {
    private static DefinitionsEditorKit EDITOR_KIT;
    private static int INDENT_WARNING_THRESHOLD;
    private final MainFrame _mainFrame;
    private final OpenDefinitionsDocument _doc;
    private volatile UndoAction _undoAction;
    private volatile RedoAction _redoAction;
    private volatile boolean testVariable;
    private volatile boolean _hasWarnedAboutModified = false;
    private volatile boolean _antiAliasText = false;
    private volatile HighlightManager.HighlightInfo _errorHighlightTag = null;
    static volatile ReverseHighlighter.DefaultUnderlineHighlightPainter BOOKMARK_PAINTER;
    static volatile LayeredHighlighter.LayerPainter[] FIND_RESULTS_PAINTERS;
    static volatile int[] FIND_RESULTS_PAINTERS_USAGE;
    static ReverseHighlighter.DrJavaHighlightPainter BREAKPOINT_PAINTER;
    static volatile ReverseHighlighter.DrJavaHighlightPainter DISABLED_BREAKPOINT_PAINTER;
    static volatile ReverseHighlighter.DrJavaHighlightPainter THREAD_PAINTER;
    public static final String INDENT_KEYMAP_NAME = "INDENT_KEYMAP";
    private final UndoableEditListener _undoListener = new UndoableEditListener(){

        public void undoableEditHappened(UndoableEditEvent e) {
            UndoableEdit undo = e.getEdit();
            if (!DefinitionsPane.this._inCompoundEdit) {
                CompoundUndoManager undoMan = DefinitionsPane.access$300(DefinitionsPane.this).getUndoManager();
                DefinitionsPane.this._inCompoundEdit = true;
                DefinitionsPane.access$402(DefinitionsPane.this, undoMan.startCompoundEdit());
                DefinitionsPane.this.getUndoAction().updateUndoState();
                DefinitionsPane.this.getRedoAction().updateRedoState();
            }
            DefinitionsPane.access$300(DefinitionsPane.this).getUndoManager().addEdit(undo);
            DefinitionsPane.this.getRedoAction().setEnabled(false);
        }
    };
    private volatile JMenuItem _toggleBreakpointMenuItem;
    private volatile JPopupMenu _popMenu;
    private volatile PopupMenuMouseAdapter _popupMenuMA;
    private volatile ErrorCaretListener _errorListener;
    private volatile ActionListener _setSizeListener = null;
    private volatile Action _indentKeyActionTab = new IndentKeyActionTab(null);
    private final Action _indentKeyActionLine = new IndentKeyAction("\n", (Action)this.getActionForKeyStroke(KeyStroke.getKeyStroke(10, 0)), true){

        protected Indenter.IndentReason getIndentReason() {
            return Indenter.IndentReason.ENTER_KEY_PRESS;
        }
    };
    private final Action _indentKeyActionCurly = new IndentKeyAction("}", this.getKeymap().getDefaultAction());
    private final Action _indentKeyActionOpenCurly = new IndentKeyAction("{", this.getKeymap().getDefaultAction());
    private final Action _indentKeyActionColon = new IndentKeyAction(":", this.getKeymap().getDefaultAction());
    public volatile boolean _inCompoundEdit = false;
    private volatile int _compoundEditKey;
    final Keymap ourMap;
    private volatile JScrollPane _scrollPane;
    private volatile int _savedVScroll;
    private volatile int _savedHScroll;
    private volatile int _position;
    private volatile int _selStart;
    private volatile int _selEnd;
    private List<Pair<Option<Color>, OptionListener<Color>>> _colorOptionListeners = new LinkedList<Pair<Option<Color>, OptionListener<Color>>>();
    private List<Pair<Option<Boolean>, OptionListener<Boolean>>> _booleanOptionListeners = new LinkedList<Pair<Option<Boolean>, OptionListener<Boolean>>>();
    private List<FinalizationListener<DefinitionsPane>> _finalizationListeners = new LinkedList<FinalizationListener<DefinitionsPane>>();
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$DefinitionsPane;

    @Override
    protected void matchUpdate(int offset) {
        this._doc.setCurrentLocation(offset);
        this._removePreviousHighlight();
        int to = this.getCaretPosition();
        int from = this._doc.balanceBackward();
        if (from > -1) {
            from = to - from;
            this._addHighlight(from, to);
            String matchText = this._matchText(from);
            if (matchText != null) {
                this._mainFrame.updateStatusField(new StringBuffer().append("Bracket matches: ").append(matchText).toString());
            } else {
                this.updateStatusField();
            }
        } else {
            from = to;
            to = this._doc.balanceForward();
            if (to > -1) {
                this._addHighlight(from - 1, to += from);
            }
            this.updateStatusField();
        }
    }

    @Override
    protected void updateStatusField() {
        this._mainFrame.updateStatusField();
    }

    private String _matchText(int braceIndex) {
        OpenDefinitionsDocument doc = this._doc;
        String docText = doc.getText();
        char ch = docText.charAt(braceIndex);
        if (ch == '{' || ch == '(') {
            Character charBefore = null;
            int charBeforeIndex = braceIndex - 1;
            boolean previousLine = false;
            if (charBeforeIndex != -1) {
                charBefore = Autobox.valueOf(docText.charAt(charBeforeIndex));
            }
            --charBeforeIndex;
            while (charBeforeIndex >= 0 && (charBefore.charValue() == '\n' || charBefore.charValue() == ' ')) {
                charBefore = Autobox.valueOf(docText.charAt(charBeforeIndex));
                if (!previousLine && charBefore.charValue() != '\n' && charBefore.charValue() != ' ') {
                    charBeforeIndex = braceIndex - 1;
                }
                if (charBefore.charValue() == '\n') {
                    previousLine = true;
                }
                --charBeforeIndex;
            }
            StringBuffer returnText = new StringBuffer(docText.substring(0, charBeforeIndex + 2));
            if (previousLine) {
                returnText.append("...");
            }
            returnText.append(ch);
            int lastNewlineIndex = returnText.lastIndexOf("\n");
            return returnText.substring(lastNewlineIndex + 1);
        }
        return null;
    }

    public DefinitionsPane(MainFrame mf, final OpenDefinitionsDocument doc) {
        super(new SwingDocument());
        this._mainFrame = mf;
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DefinitionsPane.access$100(DefinitionsPane.this).getModel().getDocumentNavigator().requestSelectionUpdate(doc);
            }
        });
        this._doc = doc;
        this._selStart = this._doc.getInitialSelectionStart();
        this._selEnd = this._doc.getInitialSelectionEnd();
        this._savedVScroll = this._doc.getInitialVerticalScroll();
        this._savedHScroll = this._doc.getInitialHorizontalScroll();
        this._resetUndo();
        Font mainFont = DrJava.getConfig().getSetting(FONT_MAIN);
        this.setFont(mainFont);
        this.setEditable(true);
        this.ourMap = DefinitionsPane.addKeymap(INDENT_KEYMAP_NAME, this.getKeymap());
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), this._indentKeyActionLine);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), this._indentKeyActionTab);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke('}'), this._indentKeyActionCurly);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke('{'), this._indentKeyActionOpenCurly);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(':'), this._indentKeyActionColon);
        this.setKeymap(this.ourMap);
        this._antiAliasText = DrJava.getConfig().getSetting(TEXT_ANTIALIAS);
        OptionListener<Color> temp = new ForegroundColorListener(this);
        Pair<ColorOption, ForegroundColorListener> pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_NORMAL_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        temp = new BackgroundColorListener(this);
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        temp = new MatchColorOptionListener(null);
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_MATCH_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_MATCH_COLOR, temp);
        temp = new ErrorColorOptionListener(null);
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.COMPILER_ERROR_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.COMPILER_ERROR_COLOR, temp);
        temp = new BookmarkColorOptionListener(null);
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.BOOKMARK_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.BOOKMARK_COLOR, temp);
        for (int i = 0; i < FIND_RESULTS_COLORS.length; ++i) {
            temp = new FindResultsColorOptionListener(i);
            pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.FIND_RESULTS_COLORS[i], (ForegroundColorListener)temp);
            this._colorOptionListeners.add(pair);
            DrJava.getConfig().addOptionListener(OptionConstants.FIND_RESULTS_COLORS[i], temp);
        }
        temp = new BreakpointColorOptionListener(null);
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEBUG_BREAKPOINT_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_BREAKPOINT_COLOR, temp);
        temp = new DisabledBreakpointColorOptionListener(null);
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEBUG_BREAKPOINT_DISABLED_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_BREAKPOINT_DISABLED_COLOR, temp);
        temp = new ThreadColorOptionListener(null);
        pair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEBUG_THREAD_COLOR, (ForegroundColorListener)temp);
        this._colorOptionListeners.add(pair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_THREAD_COLOR, temp);
        AntiAliasOptionListener aaTemp = new AntiAliasOptionListener(null);
        Pair<BooleanOption, AntiAliasOptionListener> aaPair = new Pair<BooleanOption, AntiAliasOptionListener>(OptionConstants.TEXT_ANTIALIAS, aaTemp);
        this._booleanOptionListeners.add(aaPair);
        DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, aaTemp);
        this.createPopupMenu();
        this._popupMenuMA = new PopupMenuMouseAdapter(null);
        this.addMouseListener(this._popupMenuMA);
        this.setHighlighter(new ReverseHighlighter());
        this._highlightManager = new HighlightManager(this);
        int rate = this.getCaret().getBlinkRate();
        this.getCaret().setBlinkRate(rate);
    }

    public void endCompoundEdit() {
        if (this._inCompoundEdit) {
            CompoundUndoManager undoMan = this._doc.getUndoManager();
            this._inCompoundEdit = false;
            undoMan.endCompoundEdit(this._compoundEditKey);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (this._mainFrame.getAllowKeyEvents()) {
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
            Action a = KeyBindingManager.ONLY.get(ks);
            if (ks != KeyStrokeOption.NULL_KEYSTROKE && a != null) {
                this.endCompoundEdit();
                SwingUtilities.notifyAction(a, ks, e, e.getSource(), e.getModifiers());
                e.consume();
            } else {
                Keymap km = this.getKeymap();
                if (km.isLocallyDefined(ks) || km.isLocallyDefined(KeyStroke.getKeyStroke(ks.getKeyChar()))) {
                    if (e.getKeyCode() == 10) {
                        this.endCompoundEdit();
                    }
                    super.processKeyEvent(e);
                    this.endCompoundEdit();
                } else {
                    if ((e.getModifiers() & 4) != 0 && e.getKeyCode() == 0) {
                        return;
                    }
                    if ((e.getModifiers() & 1) != 0) {
                        int newModifiers = e.getModifiers() & 0xFFFFFFFE;
                        KeyStroke newKs = KeyStroke.getKeyStroke(ks.getKeyCode(), newModifiers, ks.isOnKeyRelease());
                        String name = KeyBindingManager.ONLY.getName(newKs);
                        if (name != null && (name.equals("Delete Previous") || name.equals("Delete Next"))) {
                            this.endCompoundEdit();
                            SwingUtilities.notifyAction(KeyBindingManager.ONLY.get(newKs), newKs, e, e.getSource(), newModifiers);
                            e.consume();
                            return;
                        }
                    }
                    if (e.getID() != 400) {
                        super.processKeyEvent(e);
                        return;
                    }
                }
                this.testVariable = (e.getModifiers() & 8) != 0;
                super.processKeyEvent(e);
            }
        }
    }

    public static void setEditorKit(DefinitionsEditorKit editorKit) {
        EDITOR_KIT = editorKit;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._antiAliasText && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintComponent(g);
    }

    private void createPopupMenu() {
        this._popMenu = new JPopupMenu();
        this._popMenu.add(this._mainFrame.cutAction);
        this._popMenu.add(this._mainFrame.copyAction);
        this._popMenu.add(this._mainFrame.pasteAction);
        this._popMenu.addSeparator();
        JMenuItem indentItem = new JMenuItem("Indent Line(s)");
        indentItem.addActionListener(new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                DefinitionsPane.access$100(DefinitionsPane.this).hourglassOn();
                try {
                    DefinitionsPane.this.indent();
                    Object var3_2 = null;
                    DefinitionsPane.access$100(DefinitionsPane.this).hourglassOff();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    DefinitionsPane.access$100(DefinitionsPane.this).hourglassOff();
                    throw throwable;
                }
            }
        });
        this._popMenu.add(indentItem);
        JMenuItem commentLinesItem = new JMenuItem("Comment Line(s)");
        commentLinesItem.addActionListener(new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                DefinitionsPane.access$100(DefinitionsPane.this).hourglassOn();
                try {
                    DefinitionsPane.access$300(DefinitionsPane.this).setCurrentLocation(DefinitionsPane.this.getCaretPosition());
                    DefinitionsPane.access$1400(DefinitionsPane.this);
                    Object var3_2 = null;
                    DefinitionsPane.access$100(DefinitionsPane.this).hourglassOff();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    DefinitionsPane.access$100(DefinitionsPane.this).hourglassOff();
                    throw throwable;
                }
            }
        });
        this._popMenu.add(commentLinesItem);
        JMenuItem uncommentLinesItem = new JMenuItem("Uncomment Line(s)");
        uncommentLinesItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                DefinitionsPane.access$300(DefinitionsPane.this).setCurrentLocation(DefinitionsPane.this.getCaretPosition());
                DefinitionsPane.access$1500(DefinitionsPane.this);
            }
        });
        this._popMenu.add(uncommentLinesItem);
        this._popMenu.addSeparator();
        JMenuItem gotoFileUnderCursorItem = new JMenuItem("Go to File Under Cursor");
        gotoFileUnderCursorItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                DefinitionsPane.access$300(DefinitionsPane.this).setCurrentLocation(DefinitionsPane.this.getCaretPosition());
                DefinitionsPane.access$100(DefinitionsPane.this)._gotoFileUnderCursor();
            }
        });
        this._popMenu.add(gotoFileUnderCursorItem);
        JMenuItem toggleBookmarkItem = new JMenuItem("Toggle Bookmark");
        toggleBookmarkItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                DefinitionsPane.access$100(DefinitionsPane.this).toggleBookmark();
            }
        });
        this._popMenu.add(toggleBookmarkItem);
        if (this._mainFrame.getModel().getDebugger().isAvailable()) {
            this._popMenu.addSeparator();
            JMenuItem breakpointItem = new JMenuItem("Toggle Breakpoint");
            breakpointItem.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    DefinitionsPane.this.setCaretPosition(DefinitionsPane.this.viewToModel(DefinitionsPane.access$1600(DefinitionsPane.this).getLastMouseClick().getPoint()));
                    DefinitionsPane.access$100(DefinitionsPane.this).debuggerToggleBreakpoint();
                }
            });
            this._toggleBreakpointMenuItem = this._popMenu.add(breakpointItem);
        }
    }

    private void _commentLines() {
        this._mainFrame.commentLines();
    }

    private void _uncommentLines() {
        this._mainFrame.uncommentLines();
    }

    public UndoAction getUndoAction() {
        return this._undoAction;
    }

    public RedoAction getRedoAction() {
        return this._redoAction;
    }

    public OpenDefinitionsDocument getOpenDefDocument() {
        return this._doc;
    }

    @Override
    public DJDocument getDJDocument() {
        return this._doc;
    }

    public HighlightManager getHighlightManager() {
        return this._highlightManager;
    }

    public void setPositionAndScroll(int pos) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        try {
            this.setCaretPos(pos);
            this.scrollRectToVisible(this.modelToView(pos));
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    public void setDocument(Document d) {
        if (!(this._doc == null || d != null && d.equals(this._doc))) {
            throw new IllegalStateException("Cannot set the document of a DefinitionsPane to a different document.");
        }
        super.setDocument(d);
    }

    public boolean checkAltKey() {
        return this.testVariable;
    }

    public void addErrorCaretListener(ErrorCaretListener listener) {
        this._errorListener = listener;
        this.addCaretListener(listener);
    }

    public ErrorCaretListener getErrorCaretListener() {
        return this._errorListener;
    }

    public void addErrorHighlight(int from, int to) {
        this.removeErrorHighlight();
        this._errorHighlightTag = this._highlightManager.addHighlight(from, to, ERROR_PAINTER);
    }

    public void removeErrorHighlight() {
        if (this._errorHighlightTag != null) {
            this._errorHighlightTag.remove();
            this._errorHighlightTag = null;
        }
    }

    public boolean hasWarnedAboutModified() {
        return this._hasWarnedAboutModified;
    }

    public void hasWarnedAboutModified(boolean hasWarned) {
        this._hasWarnedAboutModified = hasWarned;
    }

    public void addBreakpointHighlight(Breakpoint bp) {
    }

    public void removeBreakpointHighlight(Breakpoint bp) {
    }

    public void setScrollPane(JScrollPane s) {
        this._scrollPane = s;
    }

    public void notifyInactive() {
        try {
            this.getOpenDefDocument().setCurrentLocation(this.getCaretPosition());
            this.removeErrorHighlight();
            this._position = this._doc.getCurrentLocation();
            this._selStart = super.getSelectionStart();
            this._selEnd = super.getSelectionEnd();
            this._savedVScroll = this._scrollPane.getVerticalScrollBar().getValue();
            this._savedHScroll = this._scrollPane.getHorizontalScrollBar().getValue();
            super.setDocument(NULL_DOCUMENT);
        }
        catch (NoSuchDocumentException noSuchDocumentException) {
            // empty catch block
        }
    }

    public void notifyActive() {
        int len;
        if (!$assertionsDisabled && this._mainFrame.isVisible() && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        super.setDocument(this._doc);
        if (this._doc.getUndoableEditListeners().length == 0) {
            this._resetUndo();
        }
        if ((len = this._doc.getLength()) < this._position || len < this._selEnd) {
            this._position = len;
            this._selStart = len;
            this._selEnd = len;
        }
        if (this._position == this._selStart) {
            this.setCaretPosition(this._selEnd);
            this.moveCaretPosition(this._selStart);
            this._doc.setCurrentLocation(this._selStart);
        } else {
            this.setCaretPosition(this._selStart);
            this.moveCaretPosition(this._selEnd);
            this._doc.setCurrentLocation(this._selEnd);
        }
        this._scrollPane.getVerticalScrollBar().setValue(this._savedVScroll);
        this._scrollPane.getHorizontalScrollBar().setValue(this._savedHScroll);
        this._scrollPane.setVerticalScrollBarPolicy(20);
        this._scrollPane.setHorizontalScrollBarPolicy(30);
    }

    @Override
    public int getSelectionStart() {
        if (this.getDocument() == NULL_DOCUMENT) {
            return this._selStart;
        }
        return super.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        if (this.getDocument() == NULL_DOCUMENT) {
            return this._selEnd;
        }
        return super.getSelectionEnd();
    }

    public int getVerticalScroll() {
        if (this.getDocument() == NULL_DOCUMENT) {
            return this._savedVScroll;
        }
        return this._scrollPane.getVerticalScrollBar().getValue();
    }

    public int getHorizontalScroll() {
        if (this.getDocument() == NULL_DOCUMENT) {
            return this._savedHScroll;
        }
        return this._scrollPane.getHorizontalScrollBar().getValue();
    }

    public int getCurrentLine() {
        return this._doc.getLineOfOffset(this.getCaretPosition()) + 1;
    }

    public int getCurrentLinefromDoc() {
        return this._doc.getCurrentLine();
    }

    public int getCurrentCol() {
        return this._doc.getCurrentCol();
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this._setSizeListener != null) {
            this._setSizeListener.actionPerformed(null);
        }
    }

    public void centerViewOnOffset(int offset) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        try {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            JViewport defViewPort = this._mainFrame.getDefViewport();
            double viewWidth = defViewPort.getWidth();
            double viewHeight = defViewPort.getHeight();
            Rectangle startRect = this.modelToView(offset);
            if (startRect != null) {
                int startRectX = (int)startRect.getX();
                int startRectY = (int)startRect.getY();
                startRect.setLocation(startRectX - (int)(viewWidth * 0.5), startRectY - (int)(viewHeight * 0.5));
                Point endPoint = new Point(startRectX + (int)(viewWidth * 0.5), startRectY + (int)(viewHeight * 0.5) + metrics.getHeight() / 2);
                startRect.add(endPoint);
                this.scrollRectToVisible(startRect);
            }
            this.setCaretPos(offset);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public void centerViewOnLine(int lineNumber) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        Point p = new Point(0, metrics.getHeight() * lineNumber);
        int offset = this.viewToModel(p);
        this.centerViewOnOffset(offset);
    }

    @Override
    public void select(int selectionStart, int selectionEnd) {
        this.setCaretPosition(selectionStart);
        this.moveCaretPosition(selectionEnd);
    }

    public void resetUndo() {
        this._doc.getUndoManager().discardAllEdits();
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    private void _resetUndo() {
        if (this._undoAction == null) {
            this._undoAction = new UndoAction(null);
        }
        if (this._redoAction == null) {
            this._redoAction = new RedoAction(null);
        }
        this._doc.resetUndoManager();
        this.getDocument().addUndoableEditListener(this._undoListener);
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    @Override
    protected boolean shouldIndent(int selStart, int selEnd) {
        if (selEnd > selStart + INDENT_WARNING_THRESHOLD) {
            Object[] options = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(this._mainFrame, "Re-indenting this block may take a long time.  Are you sure?", "Confirm Re-indent", 0, 3, null, options, options[1]);
            switch (n) {
                case -1: 
                case 1: 
                case 2: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected void indentLines(int selStart, int selEnd, Indenter.IndentReason reason, ProgressMonitor pm) {
        try {
            this._doc.indentLines(selStart, selEnd, reason, pm);
            this.endCompoundEdit();
            this.setCaretPosition(this._doc.getCurrentLocation());
        }
        catch (OperationCanceledException oce) {
            this.endCompoundEdit();
            this._doc.getUndoManager().undo();
            throw new UnexpectedException(oce);
        }
    }

    public void close() {
        for (Pair<Option<Color>, OptionListener<Color>> pair : this._colorOptionListeners) {
            DrJava.getConfig().removeOptionListener(pair.first(), pair.second());
        }
        for (Pair<Option<Serializable>, OptionListener<Serializable>> pair : this._booleanOptionListeners) {
            DrJava.getConfig().removeOptionListener(pair.first(), pair.second());
        }
        this._colorOptionListeners.clear();
        this._booleanOptionListeners.clear();
        this.ourMap.removeBindings();
        DefinitionsPane.removeKeymap(this.ourMap.getName());
        this._popMenu.removeAll();
    }

    @Override
    public void addFinalizationListener(FinalizationListener<DefinitionsPane> fl) {
        this._finalizationListeners.add(fl);
    }

    @Override
    public List<FinalizationListener<DefinitionsPane>> getFinalizationListeners() {
        return this._finalizationListeners;
    }

    protected void finalize() {
        FinalizationEvent<DefinitionsPane> fe = new FinalizationEvent<DefinitionsPane>(this);
        for (FinalizationListener<DefinitionsPane> fl : this._finalizationListeners) {
            fl.finalized(fe);
        }
    }

    static HighlightManager.HighlightInfo access$000(DefinitionsPane x0) {
        return x0._errorHighlightTag;
    }

    static MainFrame access$100(DefinitionsPane x0) {
        return x0._mainFrame;
    }

    static boolean access$202(DefinitionsPane x0, boolean x1) {
        x0._antiAliasText = x1;
        return x0._antiAliasText;
    }

    static OpenDefinitionsDocument access$300(DefinitionsPane x0) {
        return x0._doc;
    }

    static int access$402(DefinitionsPane x0, int x1) {
        x0._compoundEditKey = x1;
        return x0._compoundEditKey;
    }

    static void access$1400(DefinitionsPane x0) {
        x0._commentLines();
    }

    static void access$1500(DefinitionsPane x0) {
        x0._uncommentLines();
    }

    static PopupMenuMouseAdapter access$1600(DefinitionsPane x0) {
        return x0._popupMenuMA;
    }

    static JPopupMenu access$1700(DefinitionsPane x0) {
        return x0._popMenu;
    }

    static RedoAction access$2000(DefinitionsPane x0) {
        return x0._redoAction;
    }

    static UndoAction access$2100(DefinitionsPane x0) {
        return x0._undoAction;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$DefinitionsPane == null ? (class$edu$rice$cs$drjava$ui$DefinitionsPane = DefinitionsPane.class$("edu.rice.cs.drjava.ui.DefinitionsPane")) : class$edu$rice$cs$drjava$ui$DefinitionsPane).desiredAssertionStatus();
        INDENT_WARNING_THRESHOLD = 200000;
        BOOKMARK_PAINTER = new ReverseHighlighter.DefaultUnderlineHighlightPainter(DrJava.getConfig().getSetting(BOOKMARK_COLOR), 3);
        FIND_RESULTS_PAINTERS = new LayeredHighlighter.LayerPainter[FIND_RESULTS_COLORS.length + 1];
        for (int i = 0; i < FIND_RESULTS_COLORS.length; ++i) {
            DefinitionsPane.FIND_RESULTS_PAINTERS[i] = new ReverseHighlighter.DefaultFrameHighlightPainter(DrJava.getConfig().getSetting(FIND_RESULTS_COLORS[i]), 2);
        }
        DefinitionsPane.FIND_RESULTS_PAINTERS[DefinitionsPane.FIND_RESULTS_COLORS.length] = new ReverseHighlighter.DefaultUnderlineHighlightPainter(Color.WHITE, 0);
        FIND_RESULTS_PAINTERS_USAGE = new int[FIND_RESULTS_COLORS.length];
        BREAKPOINT_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter(DrJava.getConfig().getSetting(DEBUG_BREAKPOINT_COLOR));
        DISABLED_BREAKPOINT_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter(DrJava.getConfig().getSetting(DEBUG_BREAKPOINT_DISABLED_COLOR));
        THREAD_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter(DrJava.getConfig().getSetting(DEBUG_THREAD_COLOR));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public class RedoAction
    extends AbstractAction {
        private RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DefinitionsPane.access$300(DefinitionsPane.this).getUndoManager().redo();
                DefinitionsPane.access$300(DefinitionsPane.this).updateModifiedSinceSave();
                DefinitionsPane.access$100(DefinitionsPane.this).updateStatusField();
            }
            catch (CannotRedoException ex) {
                throw new UnexpectedException(ex);
            }
            this.updateRedoState();
            DefinitionsPane.access$2100(DefinitionsPane.this).updateUndoState();
        }

        protected void updateRedoState() {
            if (DefinitionsPane.access$300(DefinitionsPane.this).undoManagerCanRedo()) {
                this.setEnabled(true);
                this.putValue("Name", DefinitionsPane.access$300(DefinitionsPane.this).getUndoManager().getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }

        RedoAction(1 x1) {
            this();
        }
    }

    public class UndoAction
    extends AbstractAction {
        private UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DefinitionsPane.access$300(DefinitionsPane.this).getUndoManager().undo();
                DefinitionsPane.access$300(DefinitionsPane.this).updateModifiedSinceSave();
                DefinitionsPane.access$100(DefinitionsPane.this).updateStatusField();
            }
            catch (CannotUndoException ex) {
                throw new UnexpectedException(ex);
            }
            this.updateUndoState();
            DefinitionsPane.access$2000(DefinitionsPane.this).updateRedoState();
        }

        protected void updateUndoState() {
            if (DefinitionsPane.access$300(DefinitionsPane.this).undoManagerCanUndo()) {
                this.setEnabled(true);
                this.putValue("Name", DefinitionsPane.access$300(DefinitionsPane.this).getUndoManager().getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }

        UndoAction(1 x1) {
            this();
        }
    }

    private class PopupMenuMouseAdapter
    extends RightClickMouseAdapter {
        private MouseEvent _lastMouseClick = null;

        private PopupMenuMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this._lastMouseClick = e;
            DefinitionsPane.this.endCompoundEdit();
        }

        protected void _popupAction(MouseEvent e) {
            DefinitionsPane.this.requestFocusInWindow();
            DefinitionsPane.access$1700(DefinitionsPane.this).show(e.getComponent(), e.getX(), e.getY());
        }

        public MouseEvent getLastMouseClick() {
            return this._lastMouseClick;
        }

        PopupMenuMouseAdapter(1 x1) {
            this();
        }
    }

    private class IndentKeyAction
    extends AbstractAction {
        private final String _key;
        private final Action _defaultAction;
        private final boolean _indentNonCode;

        IndentKeyAction(String key, Action defaultAction) {
            this(key, defaultAction, false);
        }

        IndentKeyAction(String key, Action defaultAction, boolean indentNonCode) {
            this._key = key;
            this._defaultAction = defaultAction;
            this._indentNonCode = indentNonCode;
        }

        protected Indenter.IndentReason getIndentReason() {
            return Indenter.IndentReason.OTHER;
        }

        public void actionPerformed(ActionEvent e) {
            this._defaultAction.actionPerformed(e);
            DefinitionsPane.access$300(DefinitionsPane.this).setCurrentLocation(DefinitionsPane.this.getCaretPosition());
            ReducedModelState state = DefinitionsPane.access$300(DefinitionsPane.this).getStateAtCurrent();
            if (state.equals(ReducedModelStates.FREE) || this._indentNonCode) {
                DefinitionsPane.this.indent(this.getIndentReason());
            }
        }
    }

    private class IndentKeyActionTab
    extends AbstractAction {
        private IndentKeyActionTab() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            DefinitionsPane.access$100(DefinitionsPane.this).hourglassOn();
            try {
                DefinitionsPane.this.indent();
                Object var3_2 = null;
                DefinitionsPane.access$100(DefinitionsPane.this).hourglassOff();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                DefinitionsPane.access$100(DefinitionsPane.this).hourglassOff();
                throw throwable;
            }
        }

        IndentKeyActionTab(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AntiAliasOptionListener
    implements OptionListener<Boolean> {
        private AntiAliasOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            DefinitionsPane.access$202(DefinitionsPane.this, (Boolean)oce.value);
            DefinitionsPane.this.repaint();
        }

        AntiAliasOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadColorOptionListener
    implements OptionListener<Color> {
        private ThreadColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            THREAD_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
        }

        ThreadColorOptionListener(1 x0) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisabledBreakpointColorOptionListener
    implements OptionListener<Color> {
        private DisabledBreakpointColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            DISABLED_BREAKPOINT_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
            DefinitionsPane.access$100(DefinitionsPane.this).refreshBreakpointHighlightPainter();
        }

        DisabledBreakpointColorOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BreakpointColorOptionListener
    implements OptionListener<Color> {
        private BreakpointColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            BREAKPOINT_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
            DefinitionsPane.access$100(DefinitionsPane.this).refreshBreakpointHighlightPainter();
        }

        BreakpointColorOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindResultsColorOptionListener
    implements OptionListener<Color> {
        private int _index;

        public FindResultsColorOptionListener(int i) {
            this._index = i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            LayeredHighlighter.LayerPainter[] layerPainterArray = FIND_RESULTS_PAINTERS;
            synchronized (FIND_RESULTS_PAINTERS) {
                DefinitionsPane.FIND_RESULTS_PAINTERS[this._index] = new ReverseHighlighter.DefaultFrameHighlightPainter((Color)oce.value, 2);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BookmarkColorOptionListener
    implements OptionListener<Color> {
        private BookmarkColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            BOOKMARK_PAINTER = new ReverseHighlighter.DefaultUnderlineHighlightPainter((Color)oce.value, BOOKMARK_PAINTER.getThickness());
            DefinitionsPane.access$100(DefinitionsPane.this).refreshBookmarkHighlightPainter();
        }

        BookmarkColorOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ErrorColorOptionListener
    implements OptionListener<Color> {
        private ErrorColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            AbstractDJPane.ERROR_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
            if (DefinitionsPane.access$000(DefinitionsPane.this) != null) {
                int start = DefinitionsPane.access$000(DefinitionsPane.this).getStartOffset();
                int end = DefinitionsPane.access$000(DefinitionsPane.this).getEndOffset();
                DefinitionsPane.access$000(DefinitionsPane.this).remove();
                DefinitionsPane.this.addErrorHighlight(start, end);
            }
        }

        ErrorColorOptionListener(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchColorOptionListener
    implements OptionListener<Color> {
        private MatchColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            AbstractDJPane.MATCH_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
            if (DefinitionsPane.this._matchHighlight != null) {
                int start = DefinitionsPane.this._matchHighlight.getStartOffset();
                int end = DefinitionsPane.this._matchHighlight.getEndOffset();
                DefinitionsPane.this._matchHighlight.remove();
                DefinitionsPane.this._addHighlight(start, end);
            }
        }

        MatchColorOptionListener(1 x1) {
            this();
        }
    }
}

