/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.BrowserDocumentRegion;
import edu.rice.cs.drjava.model.BrowserHistoryManager;
import edu.rice.cs.drjava.model.IDocumentRegion;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RegionsListPanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserHistoryPanel
extends RegionsListPanel<BrowserDocumentRegion> {
    protected volatile JButton _backButton;
    protected volatile JButton _forwardButton;
    protected volatile JButton _goToButton;
    protected volatile JButton _removeButton;
    protected volatile JButton _removeAllButton;
    protected volatile AbstractAction _backAction;
    protected volatile AbstractAction _forwardAction;

    public BrowserHistoryPanel(MainFrame frame) {
        super(frame, "Browser History");
        BrowserHistoryManager rm = this._model.getBrowserHistoryManager();
    }

    @Override
    protected void performDefaultAction() {
        this.goToRegion();
    }

    @Override
    protected void goToRegion() {
        ArrayList r = this.getSelectedRegions();
        if (r.size() == 1) {
            this._model.getBrowserHistoryManager().setCurrentRegion((BrowserDocumentRegion)r.get(0));
            this.updateButtons();
            RegionsListPanel.RegionListUserObj<BrowserDocumentRegion> userObj = this.getUserObjForRegion((BrowserDocumentRegion)r.get(0));
            if (userObj != null) {
                this._list.ensureIndexIsVisible(this._listModel.indexOf(userObj));
            }
            this._frame.scrollToDocumentAndOffset(((BrowserDocumentRegion)r.get(0)).getDocument(), ((BrowserDocumentRegion)r.get(0)).getStartOffset(), false, false);
        }
    }

    protected void backRegion() {
        BrowserHistoryManager rm = this._model.getBrowserHistoryManager();
        this._frame.addToBrowserHistory();
        BrowserDocumentRegion r = rm.prevCurrentRegion(this._frame.getModel().getNotifier());
        this.updateButtons();
        RegionsListPanel.RegionListUserObj<BrowserDocumentRegion> userObj = this.getUserObjForRegion(r);
        if (userObj != null) {
            this._list.ensureIndexIsVisible(this._listModel.indexOf(userObj));
        }
        this._frame.scrollToDocumentAndOffset(r.getDocument(), r.getStartOffset(), false, false);
    }

    protected void forwardRegion() {
        BrowserHistoryManager rm = this._model.getBrowserHistoryManager();
        this._frame.addToBrowserHistory();
        BrowserDocumentRegion r = rm.nextCurrentRegion(this._frame.getModel().getNotifier());
        this.updateButtons();
        RegionsListPanel.RegionListUserObj<BrowserDocumentRegion> userObj = this.getUserObjForRegion(r);
        if (userObj != null) {
            this._list.ensureIndexIsVisible(this._listModel.indexOf(userObj));
        }
        this._frame.scrollToDocumentAndOffset(r.getDocument(), r.getStartOffset(), false, false);
    }

    AbstractAction getBackAction() {
        return this._backAction;
    }

    AbstractAction getForwardAction() {
        return this._forwardAction;
    }

    @Override
    protected JComponent[] makeButtons() {
        this._backAction = new AbstractAction("Back"){

            public void actionPerformed(ActionEvent ae) {
                BrowserHistoryPanel.this.backRegion();
            }
        };
        this._backButton = new JButton(this._backAction);
        this._forwardAction = new AbstractAction("Forward"){

            public void actionPerformed(ActionEvent ae) {
                BrowserHistoryPanel.this.forwardRegion();
            }
        };
        this._forwardButton = new JButton(this._forwardAction);
        AbstractAction goToAction = new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent ae) {
                BrowserHistoryPanel.this.goToRegion();
            }
        };
        this._goToButton = new JButton(goToAction);
        AbstractAction removeAction = new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ae) {
                Iterator i$ = BrowserHistoryPanel.this.getSelectedRegions().iterator();
                while (i$.hasNext()) {
                    BrowserDocumentRegion r = (BrowserDocumentRegion)i$.next();
                    BrowserHistoryPanel.this._model.getBrowserHistoryManager().remove(r);
                }
            }
        };
        this._removeButton = new JButton(removeAction);
        AbstractAction removeAllAction = new AbstractAction("Remove All"){

            public void actionPerformed(ActionEvent ae) {
                BrowserHistoryPanel.this._model.getBrowserHistoryManager().clearBrowserRegions();
            }
        };
        this._removeAllButton = new JButton(removeAllAction);
        JComponent[] buts = new JComponent[]{this._backButton, this._forwardButton, this._goToButton, this._removeButton, this._removeAllButton};
        return buts;
    }

    @Override
    protected void updateButtons() {
        ArrayList regs = this.getSelectedRegions();
        this._goToButton.setEnabled(regs.size() == 1);
        this._removeButton.setEnabled(regs.size() > 0);
        this._removeAllButton.setEnabled(this._listModel.size() > 0);
        this._backAction.setEnabled(this._listModel.size() > 0 && !this._model.getBrowserHistoryManager().isCurrentRegionFirst());
        this._forwardAction.setEnabled(this._listModel.size() > 0 && !this._model.getBrowserHistoryManager().isCurrentRegionLast());
    }

    protected AbstractAction[] makePopupMenuActions() {
        AbstractAction[] acts = new AbstractAction[]{new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent e) {
                BrowserHistoryPanel.this.goToRegion();
            }
        }, new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                Iterator i$ = BrowserHistoryPanel.this.getSelectedRegions().iterator();
                while (i$.hasNext()) {
                    BrowserDocumentRegion r = (BrowserDocumentRegion)i$.next();
                    BrowserHistoryPanel.this._model.getBrowserHistoryManager().remove(r);
                }
            }
        }};
        return acts;
    }

    @Override
    protected RegionsListPanel.RegionListUserObj<BrowserDocumentRegion> getUserObjForRegion(BrowserDocumentRegion r) {
        for (int i = 0; i < this._listModel.size(); ++i) {
            RegionsListPanel.RegionListUserObj userObj = (RegionsListPanel.RegionListUserObj)this._listModel.get(i);
            if (userObj.region() != r) continue;
            return userObj;
        }
        return null;
    }

    @Override
    protected RegionsListPanel.RegionListUserObj<BrowserDocumentRegion> makeRegionListUserObj(BrowserDocumentRegion r) {
        return new BrowserHistoryListUserObj(r);
    }

    @Override
    protected RegionsListPanel.RegionListUserObj makeRegionListUserObj(IDocumentRegion x0) {
        return this.makeRegionListUserObj((BrowserDocumentRegion)x0);
    }

    @Override
    protected RegionsListPanel.RegionListUserObj getUserObjForRegion(IDocumentRegion x0) {
        return this.getUserObjForRegion((BrowserDocumentRegion)x0);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BrowserHistoryListUserObj
    extends RegionsListPanel.RegionListUserObj<BrowserDocumentRegion> {
        public BrowserHistoryListUserObj(BrowserDocumentRegion r) {
            super(r);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            if (this._region == BrowserHistoryPanel.this._model.getBrowserHistoryManager().getCurrentRegion()) {
                sb.append("<font color=\"red\">");
            }
            sb.append(((BrowserDocumentRegion)this._region).getDocument().toString());
            sb.append(':');
            sb.append(this.lineNumber());
            try {
                sb.append(": ");
                int length = Math.min(120, ((BrowserDocumentRegion)this._region).getEndOffset() - ((BrowserDocumentRegion)this._region).getStartOffset());
                sb.append(((BrowserDocumentRegion)this._region).getDocument().getText(((BrowserDocumentRegion)this._region).getStartOffset(), length).trim());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (((BrowserDocumentRegion)this._region).equals(BrowserHistoryPanel.this._model.getBrowserHistoryManager().getCurrentRegion())) {
                sb.append("</font>");
            }
            sb.append("</html>");
            return sb.toString();
        }
    }
}

