/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.IDocumentRegion;
import edu.rice.cs.drjava.model.OrderedDocumentRegion;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RegionsTreePanel;
import edu.rice.cs.plt.lambda.Lambda;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointsPanel
extends RegionsTreePanel<Breakpoint> {
    protected JButton _goToButton;
    protected JButton _enableDisableButton;
    protected JButton _removeButton;
    protected JButton _removeAllButton;
    protected final Debugger _debugger;

    public BreakpointsPanel(MainFrame frame, RegionManager<Breakpoint> breakpointManager) {
        super(frame, "Breakpoints", breakpointManager);
        this._regionManager.addListener(new RegionManagerListener<Breakpoint>(){
            static final /* synthetic */ boolean $assertionsDisabled;
            private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$BreakpointsPanel;

            @Override
            public void regionAdded(Breakpoint bp) {
                if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                    throw new AssertionError();
                }
                BreakpointsPanel.this.addRegion(bp);
            }

            @Override
            public void regionChanged(Breakpoint bp) {
                if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                    throw new AssertionError();
                }
                File file = bp.getDocument().getRawFile();
                DefaultMutableTreeNode regNode = (DefaultMutableTreeNode)BreakpointsPanel.this._regionToTreeNode.get(bp);
                ((DefaultTreeModel)BreakpointsPanel.this._regTree.getModel()).nodeChanged(regNode);
            }

            @Override
            public void regionRemoved(Breakpoint bp) {
                BreakpointsPanel.this.removeRegion(bp);
            }

            @Override
            public void regionRemoved(IDocumentRegion x0) {
                this.regionRemoved((Breakpoint)x0);
            }

            @Override
            public void regionChanged(IDocumentRegion x0) {
                this.regionChanged((Breakpoint)x0);
            }

            @Override
            public void regionAdded(IDocumentRegion x0) {
                this.regionAdded((Breakpoint)x0);
            }

            static {
                $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$BreakpointsPanel == null ? (class$edu$rice$cs$drjava$ui$BreakpointsPanel = 1.class$("edu.rice.cs.drjava.ui.BreakpointsPanel")) : class$edu$rice$cs$drjava$ui$BreakpointsPanel).desiredAssertionStatus();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        });
        this._debugger = this._model.getDebugger();
    }

    @Override
    protected void performDefaultAction() {
        this.goToRegion();
    }

    @Override
    protected JComponent[] makeButtons() {
        AbstractAction goToAction = new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent ae) {
                BreakpointsPanel.this.goToRegion();
            }
        };
        this._goToButton = new JButton(goToAction);
        AbstractAction enableDisableAction = new AbstractAction("Disable"){

            public void actionPerformed(ActionEvent ae) {
                BreakpointsPanel.this.enableDisableBreakpoint();
            }
        };
        this._enableDisableButton = new JButton(enableDisableAction);
        AbstractAction removeAction = new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ae) {
                Iterator i$ = BreakpointsPanel.this.getSelectedRegions().iterator();
                while (i$.hasNext()) {
                    Breakpoint bp = (Breakpoint)i$.next();
                    BreakpointsPanel.this._regionManager.removeRegion(bp);
                }
            }
        };
        this._removeButton = new JButton(removeAction);
        AbstractAction removeAllAction = new AbstractAction("Remove All"){

            public void actionPerformed(ActionEvent ae) {
                BreakpointsPanel.this._regionManager.clearRegions();
            }
        };
        this._removeAllButton = new JButton(removeAllAction);
        JComponent[] buts = new JComponent[]{this._enableDisableButton, this._goToButton, this._removeButton, this._removeAllButton};
        return buts;
    }

    @Override
    protected void _updateButtons() {
        ArrayList regs = this.getSelectedRegions();
        this._goToButton.setEnabled(regs.size() == 1);
        this._removeButton.setEnabled(regs.size() > 0);
        this._removeAllButton.setEnabled(this._rootNode != null && this._rootNode.getDepth() > 0);
        this._enableDisableButton.setEnabled(regs.size() > 0);
        if (regs.size() > 0) {
            if (((Breakpoint)regs.get(0)).isEnabled()) {
                this._enableDisableButton.setText("Disable");
            } else {
                this._enableDisableButton.setText("Enable");
            }
        }
        this._removeAllButton.setEnabled(this._rootNode != null && this._rootNode.getDepth() > 0);
    }

    @Override
    protected AbstractAction[] makePopupMenuActions() {
        AbstractAction[] acts = new AbstractAction[]{new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent e) {
                BreakpointsPanel.this.goToRegion();
            }
        }, new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                Iterator i$ = BreakpointsPanel.this.getSelectedRegions().iterator();
                while (i$.hasNext()) {
                    Breakpoint bp = (Breakpoint)i$.next();
                    BreakpointsPanel.this._regionManager.removeRegion(bp);
                }
            }
        }};
        return acts;
    }

    @Override
    protected void goToRegion() {
        ArrayList bps = this.getSelectedRegions();
        if (bps.size() == 1) {
            this._debugger.scrollToSource((Breakpoint)bps.get(0));
        }
    }

    protected void enableDisableBreakpoint() {
        ArrayList bps = this.getSelectedRegions();
        if (bps.size() > 0) {
            final boolean newState = !((Breakpoint)bps.get(0)).isEnabled();
            for (Breakpoint bp : bps) {
                this._regionManager.changeRegion(bp, new Lambda<Breakpoint, Object>(){

                    @Override
                    public Object value(Breakpoint bp) {
                        bp.setEnabled(newState);
                        return null;
                    }

                    @Override
                    public Object value(Object x0) {
                        return this.value((Breakpoint)x0);
                    }
                });
            }
        }
    }

    @Override
    protected RegionsTreePanel.RegionTreeUserObj<Breakpoint> makeRegionTreeUserObj(Breakpoint bp) {
        return new BreakpointRegionTreeUserObj(bp);
    }

    @Override
    protected RegionsTreePanel.RegionTreeUserObj makeRegionTreeUserObj(OrderedDocumentRegion x0) {
        return this.makeRegionTreeUserObj((Breakpoint)x0);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BreakpointRegionTreeUserObj
    extends RegionsTreePanel.RegionTreeUserObj<Breakpoint> {
        public BreakpointRegionTreeUserObj(Breakpoint bp) {
            super(bp);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.lineNumber());
            try {
                if (!((Breakpoint)this._region).isEnabled()) {
                    sb.append(" (disabled)");
                }
                sb.append(": ");
                int length = Math.min(120, ((Breakpoint)this._region).getEndOffset() - ((Breakpoint)this._region).getStartOffset());
                sb.append(((Breakpoint)this._region).getDocument().getText(((Breakpoint)this._region).getStartOffset(), length).trim());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return sb.toString();
        }
    }
}

