/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.ReverseHighlighter;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitor;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public abstract class AbstractDJPane
extends JTextPane
implements OptionConstants,
DropTargetListener {
    private static final double SCROLL_UNIT = 0.05;
    static ReverseHighlighter.DrJavaHighlightPainter MATCH_PAINTER;
    static ReverseHighlighter.DrJavaHighlightPainter ERROR_PAINTER;
    protected volatile HighlightManager _highlightManager;
    protected final CaretListener _matchListener = new CaretListener(){

        public void caretUpdate(CaretEvent ce) {
            AbstractDJPane.this._removePreviousHighlight();
            int offset = ce.getDot();
            if (offset < 1) {
                return;
            }
            DJDocument doc = AbstractDJPane.this.getDJDocument();
            try {
                char prevChar = doc.getText(offset - 1, 1).charAt(0);
                if (prevChar == '{' || prevChar == '(' || prevChar == '}' || prevChar == ')') {
                    AbstractDJPane.this.matchUpdate(offset);
                } else {
                    AbstractDJPane.this.updateStatusField();
                }
            }
            catch (BadLocationException e) {
                DrJavaErrorHandler.record(e);
            }
        }
    };
    protected volatile HighlightManager.HighlightInfo _matchHighlight = null;
    protected static final SwingDocument NULL_DOCUMENT;
    DropTarget dropTarget = new DropTarget(this, this);

    AbstractDJPane(SwingDocument doc) {
        super(doc);
        this.setContentType("text/java");
        this.addCaretListener(this._matchListener);
    }

    protected void _addHighlight(int from, int to) {
        this._matchHighlight = this._highlightManager.addHighlight(from, to, MATCH_PAINTER);
    }

    protected abstract void matchUpdate(int var1);

    protected abstract void updateStatusField();

    protected void _removePreviousHighlight() {
        if (this._matchHighlight != null) {
            this._matchHighlight.remove();
            this._matchHighlight = null;
        }
    }

    public void setCaretPos(int pos) {
        DJDocument doc = this.getDJDocument();
        int len = doc.getLength();
        if (pos > len) {
            this.setCaretPosition(len);
            return;
        }
        this.setCaretPosition(pos);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRectangle, int orientation, int direction) {
        return (int)(visibleRectangle.getHeight() * 0.05);
    }

    public void indent() {
        this.indent(Indenter.IndentReason.OTHER);
    }

    public void indent(Indenter.IndentReason reason) {
        this.getDJDocument().setCurrentLocation(this.getCaretPosition());
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        ProgressMonitor pm = null;
        if (this.shouldIndent(selStart, selEnd)) {
            this.indentLines(selStart, selEnd, reason, pm);
        }
    }

    protected abstract void indentLines(int var1, int var2, Indenter.IndentReason var3, ProgressMonitor var4);

    protected abstract boolean shouldIndent(int var1, int var2);

    public abstract DJDocument getDJDocument();

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        DrJavaRoot.dragEnter(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        DrJavaRoot.drop(dropTargetDropEvent);
    }

    static {
        Color highColor = DrJava.getConfig().getSetting(DEFINITIONS_MATCH_COLOR);
        MATCH_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter(highColor);
        ERROR_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter(DrJava.getConfig().getSetting(COMPILER_ERROR_COLOR));
        NULL_DOCUMENT = new SwingDocument();
    }
}

