/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.drjava.model.DummyDocumentRegion;
import edu.rice.cs.drjava.model.FileRegion;
import edu.rice.cs.drjava.model.debug.DebugBreakpointData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.drjava.project.ProjectFileParserFacade;
import edu.rice.cs.drjava.project.ProjectProfile;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.XMLConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProjectFileParser
extends ProjectFileParserFacade {
    public static final XMLProjectFileParser ONLY = new XMLProjectFileParser();
    protected String _parent;
    protected String _srcFileBase;
    protected XMLConfig _xc;
    static Log LOG = new Log("xmlparser.log", false);

    private XMLProjectFileParser() {
        this._xmlProjectFile = true;
    }

    @Override
    public ProjectFileIR parse(File projFile) throws IOException, FileNotFoundException, MalformedProjectFileException {
        this._projectFile = projFile;
        this._srcFileBase = this._parent = projFile.getParent();
        ProjectProfile pfir = new ProjectProfile(projFile);
        try {
            String s;
            XMLConfig xcParent = new XMLConfig(projFile);
            String version = xcParent.get("drjava.version", "unknown");
            LOG.log(new StringBuffer().append("version = '").append(version).append("'").toString());
            this._xc = new XMLConfig(xcParent, xcParent.getNodes("drjava/project").get(0));
            LOG.log(this._xc.toString());
            try {
                s = this._xc.get(".root");
                LOG.log(new StringBuffer().append("root = '").append(s).append("'").toString());
                File root = new File(this._parent, s);
                pfir.setProjectRoot(root);
                this._srcFileBase = root.getCanonicalPath();
            }
            catch (XMLConfig.XMLConfigException e) {
                throw new MalformedProjectFileException(new StringBuffer().append("XML Parse Error: ").append(e.getMessage()).append("\n").append(StringOps.getStackTrace(e)).toString());
            }
            try {
                s = this._xc.get("createjar.file");
                LOG.log(new StringBuffer().append("createjar.file = '").append(s).append("'").toString());
                File jarFile = new File(this._parent, s);
                pfir.setCreateJarFile(jarFile);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get("createjar.flags");
                LOG.log(new StringBuffer().append("createjar.flags = '").append(s).append("'").toString());
                int flags = Integer.valueOf(s);
                pfir.setCreateJarFlags(flags);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get(".build");
                LOG.log(new StringBuffer().append("build = '").append(s).append("'").toString());
                File buildDir = new File(this._parent, s);
                pfir.setBuildDirectory(buildDir);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get(".work");
                LOG.log(new StringBuffer().append("work = '").append(s).append("'").toString());
                File workDir = new File(this._parent, s);
                pfir.setWorkingDirectory(workDir);
            }
            catch (XMLConfig.XMLConfigException e) {
                throw new MalformedProjectFileException(new StringBuffer().append("XML Parse Error: ").append(e.getMessage()).append("\n").append(StringOps.getStackTrace(e)).toString());
            }
            try {
                s = this._xc.get(".main");
                LOG.log(new StringBuffer().append("main = '").append(s).append("'").toString());
                File mainClass = new File(this._parent, s);
                pfir.setMainClass(mainClass);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                s = this._xc.get(".autorefresh");
                boolean b = Boolean.valueOf(s);
                pfir.setAutoRefreshStatus(b);
            }
            catch (XMLConfig.XMLConfigException e) {
                // empty catch block
            }
            try {
                pfir.setSourceFiles(this.readSourceFiles("source", this._srcFileBase));
                pfir.setAuxiliaryFiles(this.readSourceFiles("included", ""));
                pfir.setExcludedFiles(this.readSourceFiles("excluded", ""));
                pfir.setCollapsedPaths(this.readCollapsed());
                pfir.setClassPaths((Iterable_)((Object)this.readFiles("classpath")));
                pfir.setBreakpoints(this.readBreakpoints());
                pfir.setWatches(this.readWatches());
                pfir.setBookmarks(this.readBookmarks());
            }
            catch (XMLConfig.XMLConfigException e) {
                throw new MalformedProjectFileException(new StringBuffer().append("XML Parse Error: ").append(e.getMessage()).append("\n").append(StringOps.getStackTrace(e)).toString());
            }
        }
        catch (XMLConfig.XMLConfigException e) {
            throw new MalformedProjectFileException(new StringBuffer().append("Malformed XML project file.").append(e.getMessage()).append("\n").append(StringOps.getStackTrace(e)).toString());
        }
        catch (NumberFormatException e) {
            throw new MalformedProjectFileException(new StringBuffer().append("Malformed XML project file; a value that should have been an integer was not.\n").append(StringOps.getStackTrace(e)).toString());
        }
        catch (IllegalArgumentException e) {
            throw new MalformedProjectFileException(new StringBuffer().append("Malformed XML project file; a value had the wrong type.\n").append(StringOps.getStackTrace(e)).toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MalformedProjectFileException(new StringBuffer().append("Malformed XML project file; a required value was missing.\n").append(StringOps.getStackTrace(e)).toString());
        }
        LOG.log(((Object)pfir).toString());
        return pfir;
    }

    protected List<DocFile> readSourceFiles(String path, String rootPath) throws MalformedProjectFileException {
        LOG.log(new StringBuffer().append("readSourceFiles(path='").append(path).append("', rootPath='").append(rootPath).append("')").toString());
        ArrayList<DocFile> docFList = new ArrayList<DocFile>();
        List<Node> defs = this._xc.getNodes(new StringBuffer().append(path).append("/file").toString());
        LOG.log(new StringBuffer().append("\tdefs.size() = ").append(defs.size()).toString());
        for (Node n : defs) {
            LOG.log(new StringBuffer().append("\t").append(n.getNodeValue()).toString());
        }
        for (Node n : defs) {
            boolean active;
            Date modDate;
            LOG.log(new StringBuffer().append("\t").append(n.toString()).toString());
            String name = this._xc.get(".name", n);
            LOG.log(new StringBuffer().append("\t\tname = '").append(name).append("'").toString());
            int selectFrom = this._xc.getInt("select.from", n);
            int selectTo = this._xc.getInt("select.to", n);
            LOG.log(new StringBuffer().append("\t\tselect = '").append(selectFrom).append(" to ").append(selectTo).append("'").toString());
            int scrollCol = this._xc.getInt("scroll.column", n);
            int scrollRow = this._xc.getInt("scroll.row", n);
            LOG.log(new StringBuffer().append("\t\tscroll = '").append(scrollCol).append(" , ").append(scrollRow).append("'").toString());
            String timestamp = this._xc.get(".timestamp", n);
            LOG.log(new StringBuffer().append("\t\ttimestamp = '").append(timestamp).append("'").toString());
            try {
                modDate = ProjectProfile.MOD_DATE_FORMAT.parse(timestamp);
            }
            catch (ParseException e1) {
                try {
                    modDate = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(timestamp);
                }
                catch (ParseException e2) {
                    throw new MalformedProjectFileException("Source file node contains badly formatted timestamp.");
                }
            }
            String pkg = this._xc.get(".package", n);
            LOG.log(new StringBuffer().append("\t\tpackage = '").append(pkg).append("'").toString());
            try {
                active = this._xc.getBool(".active", n);
                LOG.log(new StringBuffer().append("\t\tactive = '").append(active).append("'").toString());
            }
            catch (XMLConfig.XMLConfigException e) {
                active = false;
            }
            DocFile docF = new DocFile((rootPath.length() > 0 ? new File(rootPath, name) : new File(name)).getAbsoluteFile(), new Pair<Integer, Integer>(Autobox.valueOf(selectFrom), Autobox.valueOf(selectTo)), new Pair<Integer, Integer>(Autobox.valueOf(scrollCol), Autobox.valueOf(scrollCol)), active, pkg);
            docF.setSavedModDate(modDate.getTime());
            docFList.add(docF);
        }
        return docFList;
    }

    protected List<File> readFiles(String path) {
        ArrayList<File> fList = new ArrayList<File>();
        List<Node> defs = this._xc.getNodes(new StringBuffer().append(path).append("/file").toString());
        for (Node n : defs) {
            String name = this._xc.get(".name", n);
            fList.add(new File(name).getAbsoluteFile());
        }
        return fList;
    }

    protected List<String> readCollapsed() {
        ArrayList<String> pList = new ArrayList<String>();
        List<Node> defs = this._xc.getNodes("collapsed/path");
        for (Node n : defs) {
            pList.add(this._xc.get(".name", n));
        }
        return pList;
    }

    protected List<DebugBreakpointData> readBreakpoints() {
        ArrayList<DebugBreakpointData> bpList = new ArrayList<DebugBreakpointData>();
        List<Node> defs = this._xc.getNodes("breakpoints/breakpoint");
        for (Node n : defs) {
            DebugBreakpointData dbd;
            File f;
            String name = this._xc.get(".file", n);
            final int lnr = this._xc.getInt(".line", n);
            final boolean enabled = this._xc.getBool(".enabled", n);
            if (this._srcFileBase == null || new File(name).isAbsolute()) {
                f = new File(name);
                dbd = new DebugBreakpointData(){

                    public File getFile() {
                        return f;
                    }

                    public int getLineNumber() {
                        return lnr;
                    }

                    public boolean isEnabled() {
                        return enabled;
                    }
                };
            } else {
                f = new File(this._srcFileBase, name);
                dbd = new DebugBreakpointData(){

                    public File getFile() {
                        return f;
                    }

                    public int getLineNumber() {
                        return lnr;
                    }

                    public boolean isEnabled() {
                        return enabled;
                    }
                };
            }
            bpList.add(dbd);
        }
        return bpList;
    }

    protected List<DebugWatchData> readWatches() {
        ArrayList<DebugWatchData> wList = new ArrayList<DebugWatchData>();
        List<Node> defs = this._xc.getNodes("watches/watch");
        for (Node n : defs) {
            wList.add(new DebugWatchData(this._xc.get(".name", n)));
        }
        return wList;
    }

    protected List<FileRegion> readBookmarks() {
        ArrayList<FileRegion> rList = new ArrayList<FileRegion>();
        List<Node> defs = this._xc.getNodes("bookmarks/bookmark");
        for (Node n : defs) {
            String name = this._xc.get(".file", n);
            int from = this._xc.getInt(".from", n);
            int to = this._xc.getInt(".to", n);
            File f = this._srcFileBase == null || new File(name).isAbsolute() ? new File(name) : new File(this._srcFileBase, name);
            rList.add(new DummyDocumentRegion(f, from, to));
        }
        return rList;
    }
}

