/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.model.FileRegion;
import edu.rice.cs.drjava.model.debug.DebugBreakpointData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.XMLConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProfile
implements ProjectFileIR {
    static final String MOD_DATE_FORMAT_STRING = "dd-MMM-yyyy HH:mm:ss";
    static final DateFormat MOD_DATE_FORMAT;
    private List<DocFile> _sourceFiles = new LinkedList<DocFile>();
    private List<DocFile> _auxiliaryFiles = new LinkedList<DocFile>();
    private List<DocFile> _excludedFiles = new ArrayList<DocFile>();
    private List<String> _collapsedPaths = new ArrayList<String>();
    private File _buildDir = FileOps.NULL_FILE;
    private File _workDir = FileOps.NULL_FILE;
    private List<File> _classPathFiles = new ArrayList<File>();
    private File _mainClass = null;
    private File _projectRoot;
    private File _projectFile;
    private File _createJarFile = FileOps.NULL_FILE;
    private int _createJarFlags = 0;
    private boolean _autoRefreshStatus = false;
    private List<FileRegion> _bookmarks = new ArrayList<FileRegion>();
    private List<DebugBreakpointData> _breakpoints = new ArrayList<DebugBreakpointData>();
    private List<DebugWatchData> _watches = new ArrayList<DebugWatchData>();
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$project$ProjectProfile;

    public ProjectProfile(String fileName) throws IOException {
        this(new File(fileName));
    }

    public ProjectProfile(File f) throws IOException {
        this._projectFile = f;
        this._projectRoot = this._projectFile.getParentFile();
        if (!this._projectRoot.exists()) {
            throw new IOException(new StringBuffer().append("Parent directory of project root ").append(this._projectRoot).append(" does not exist").toString());
        }
    }

    @Override
    public DocFile[] getSourceFiles() {
        return this._sourceFiles.toArray(new DocFile[this._sourceFiles.size()]);
    }

    @Override
    public DocFile[] getAuxiliaryFiles() {
        return this._auxiliaryFiles.toArray(new DocFile[this._auxiliaryFiles.size()]);
    }

    @Override
    public DocFile[] getExcludedFiles() {
        return this._excludedFiles.toArray(new DocFile[this._excludedFiles.size()]);
    }

    @Override
    public File getProjectFile() {
        return this._projectFile;
    }

    @Override
    public File getBuildDirectory() {
        return this._buildDir;
    }

    @Override
    public File getWorkingDirectory() {
        return this._workDir;
    }

    @Override
    public String[] getCollapsedPaths() {
        return this._collapsedPaths.toArray(new String[this._collapsedPaths.size()]);
    }

    @Override
    public Iterable<File> getClassPaths() {
        return this._classPathFiles;
    }

    @Override
    public File getMainClass() {
        return this._mainClass;
    }

    @Override
    public File getProjectRoot() {
        return this._projectRoot;
    }

    @Override
    public File getCreateJarFile() {
        return this._createJarFile;
    }

    @Override
    public int getCreateJarFlags() {
        return this._createJarFlags;
    }

    @Override
    public FileRegion[] getBookmarks() {
        return this._bookmarks.toArray(new FileRegion[this._bookmarks.size()]);
    }

    @Override
    public DebugBreakpointData[] getBreakpoints() {
        return this._breakpoints.toArray(new DebugBreakpointData[this._breakpoints.size()]);
    }

    @Override
    public DebugWatchData[] getWatches() {
        return this._watches.toArray(new DebugWatchData[this._watches.size()]);
    }

    @Override
    public boolean getAutoRefreshStatus() {
        return this._autoRefreshStatus;
    }

    public void addSourceFile(DocFile df) {
        this._sourceFiles.add(df);
    }

    public void addSourceFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this.addSourceFile(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addAuxiliaryFile(DocFile df) {
        this._auxiliaryFiles.add(df);
    }

    public void addAuxiliaryFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this.addAuxiliaryFile(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addExcludedFile(DocFile df) {
        this._excludedFiles.add(df);
    }

    public void addExcludedFile(File f) {
        this._excludedFiles.add(new DocFile(f));
    }

    public void addExcludedFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this.addExcludedFile(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addClassPathFile(File cp) {
        if (cp != null) {
            this._classPathFiles.add(cp);
        }
    }

    public void addCollapsedPath(String cp) {
        if (cp != null) {
            this._collapsedPaths.add(cp);
        }
    }

    @Override
    public void setBuildDirectory(File dir) {
        this._buildDir = dir;
    }

    @Override
    public void setWorkingDirectory(File dir) {
        this._workDir = FileOps.validate(dir);
    }

    @Override
    public void setMainClass(File main) {
        this._mainClass = main;
    }

    @Override
    public void setSourceFiles(List<DocFile> sf) {
        this._sourceFiles = new LinkedList<DocFile>(sf);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @Override
    public void setClassPaths(Iterable_ cpf) {
        this._classPathFiles = new ArrayList<File>();
        Iterator i$ = IterableMethods.iterator(cpf);
        while (i$.hasNext()) {
            File f = (File)i$.next();
            this._classPathFiles.add(f);
        }
    }

    @Override
    public void setCollapsedPaths(List<String> cp) {
        this._collapsedPaths = new ArrayList<String>(cp);
    }

    @Override
    public void setAuxiliaryFiles(List<DocFile> af) {
        this._auxiliaryFiles = new LinkedList<DocFile>(af);
    }

    @Override
    public void setExcludedFiles(List<DocFile> ef) {
        this._excludedFiles = new ArrayList<DocFile>(ef);
    }

    @Override
    public void setProjectRoot(File root) {
        this._projectRoot = root;
        if (!$assertionsDisabled && root.getParentFile() == null) {
            throw new AssertionError();
        }
    }

    @Override
    public void setCreateJarFile(File createJarFile) {
        this._createJarFile = createJarFile;
    }

    @Override
    public void setCreateJarFlags(int createJarFlags) {
        this._createJarFlags = createJarFlags;
    }

    @Override
    public void setBookmarks(List<? extends FileRegion> bms) {
        this._bookmarks = new ArrayList<FileRegion>(bms);
    }

    @Override
    public void setBreakpoints(List<? extends DebugBreakpointData> bps) {
        this._breakpoints = new ArrayList<DebugBreakpointData>(bps);
    }

    @Override
    public void setWatches(List<? extends DebugWatchData> ws) {
        this._watches = new ArrayList<DebugWatchData>(ws);
    }

    @Override
    public void setAutoRefreshStatus(boolean status) {
        this._autoRefreshStatus = status;
    }

    public void write() throws IOException {
        this.write(new FileOutputStream(this._projectFile));
    }

    public void write(OutputStream os) throws IOException {
        Node f;
        String pkg;
        Node f2;
        String s;
        Pair<Integer, Integer> pScr;
        Pair<Integer, Integer> pSel;
        XMLConfig xc = new XMLConfig();
        xc.set("drjava.version", Version.getVersionString());
        String path = FileOps.stringMakeRelativeTo(this._projectRoot, this._projectFile);
        path = StringOps.replace(path, File.separator, "/");
        xc.set("drjava/project.root", path);
        path = FileOps.stringMakeRelativeTo(this._workDir, this._projectFile);
        path = StringOps.replace(path, File.separator, "/");
        xc.set("drjava/project.work", path);
        if (this._buildDir != null && this._buildDir.getPath() != "") {
            path = FileOps.stringMakeRelativeTo(this._buildDir, this._projectFile);
            path = StringOps.replace(path, File.separator, "/");
            xc.set("drjava/project.build", path);
        }
        if (this._mainClass != null && this._mainClass.getPath() != "") {
            path = FileOps.stringMakeRelativeTo(this._mainClass, this._projectFile);
            path = StringOps.replace(path, File.separator, "/");
            xc.set("drjava/project.main", path);
        }
        xc.set("drjava/project.autorefresh", String.valueOf(this._autoRefreshStatus));
        if (this._createJarFile != null) {
            path = FileOps.stringMakeRelativeTo(this._createJarFile, this._createJarFile);
            path = StringOps.replace(path, File.separator, "/");
            xc.set("drjava/project/createjar.file", path);
        }
        if (this._createJarFlags != 0) {
            xc.set("drjava/project/createjar.flags", String.valueOf(this._createJarFlags));
        }
        xc.createNode("drjava/project/source");
        DocFile active = null;
        if (!this._sourceFiles.isEmpty()) {
            for (DocFile df : this._sourceFiles) {
                if (!df.isActive()) continue;
                active = df;
                break;
            }
            if (active != null) {
                this._sourceFiles.remove(active);
                this._sourceFiles.add(0, active);
            }
            for (DocFile df : this._sourceFiles) {
                path = FileOps.stringMakeRelativeTo(df, this._projectRoot);
                path = StringOps.replace(path, File.separator, "/");
                pSel = df.getSelection();
                pScr = df.getScroll();
                s = MOD_DATE_FORMAT.format(new Date(df.lastModified()));
                f2 = xc.createNode("drjava/project/source/file", null, false);
                xc.set(".name", path, f2, true);
                xc.set(".timestamp", s, f2, true);
                pkg = df.getPackage();
                xc.set(".package", pkg != null ? pkg : "", f2, true);
                xc.set("select.from", String.valueOf(pSel != null ? pSel.first() : 0), f2, true);
                xc.set("select.to", String.valueOf(pSel != null ? pSel.second() : 0), f2, true);
                xc.set("scroll.column", String.valueOf(pScr != null ? pScr.first() : 0), f2, true);
                xc.set("scroll.row", String.valueOf(pScr != null ? pScr.second() : 0), f2, true);
                if (df != active) continue;
                xc.set(".active", "true", f2, true);
            }
        }
        xc.createNode("drjava/project/included");
        if (!this._auxiliaryFiles.isEmpty()) {
            if (active == null) {
                for (DocFile df : this._auxiliaryFiles) {
                    if (!df.isActive()) continue;
                    active = df;
                    break;
                }
                if (active != null) {
                    this._auxiliaryFiles.remove(active);
                    this._auxiliaryFiles.add(0, active);
                }
            }
            for (DocFile df : this._auxiliaryFiles) {
                path = df.getAbsolutePath();
                path = StringOps.replace(path, File.separator, "/");
                pSel = df.getSelection();
                pScr = df.getScroll();
                s = MOD_DATE_FORMAT.format(new Date(df.lastModified()));
                f2 = xc.createNode("drjava/project/included/file", null, false);
                xc.set(".name", path, f2, true);
                xc.set(".timestamp", s, f2, true);
                pkg = df.getPackage();
                xc.set(".package", pkg != null ? pkg : "", f2, true);
                xc.set("select.from", String.valueOf(pSel != null ? pSel.first() : 0), f2, true);
                xc.set("select.to", String.valueOf(pSel != null ? pSel.second() : 0), f2, true);
                xc.set("scroll.column", String.valueOf(pScr != null ? pScr.first() : 0), f2, true);
                xc.set("scroll.row", String.valueOf(pScr != null ? pScr.second() : 0), f2, true);
                if (df != active) continue;
                xc.set(".active", "true", f2, true);
            }
        }
        xc.createNode("drjava/project/excluded");
        if (!this._excludedFiles.isEmpty()) {
            if (active == null) {
                for (DocFile df : this._excludedFiles) {
                    if (!df.isActive()) continue;
                    active = df;
                    break;
                }
                if (active != null) {
                    this._excludedFiles.remove(active);
                    this._excludedFiles.add(0, active);
                }
            }
            for (DocFile df : this._excludedFiles) {
                path = df.getAbsolutePath();
                path = StringOps.replace(path, File.separator, "/");
                pSel = df.getSelection();
                pScr = df.getScroll();
                s = MOD_DATE_FORMAT.format(new Date(df.lastModified()));
                f2 = xc.createNode("drjava/project/excluded/file", null, false);
                xc.set(".name", path, f2, true);
                xc.set(".timestamp", s, f2, true);
                pkg = df.getPackage();
                xc.set(".package", pkg != null ? pkg : "", f2, true);
                xc.set("select.from", String.valueOf(pSel != null ? pSel.first() : 0), f2, true);
                xc.set("select.to", String.valueOf(pSel != null ? pSel.second() : 0), f2, true);
                xc.set("scroll.column", String.valueOf(pScr != null ? pScr.first() : 0), f2, true);
                xc.set("scroll.row", String.valueOf(pScr != null ? pScr.second() : 0), f2, true);
                if (df != active) continue;
                xc.set(".active", "true", f2, true);
            }
        }
        xc.createNode("drjava/project/collapsed");
        if (!this._collapsedPaths.isEmpty()) {
            for (String s2 : this._collapsedPaths) {
                f = xc.createNode("drjava/project/collapsed/path", null, false);
                xc.set(".name", s2, f, true);
            }
        }
        xc.createNode("drjava/project/classpath");
        if (!this._classPathFiles.isEmpty()) {
            for (File cp : this._classPathFiles) {
                f = xc.createNode("drjava/project/classpath/file", null, false);
                xc.set(".name", cp.getAbsolutePath(), f, true);
            }
        }
        xc.createNode("drjava/project/breakpoints");
        if (!this._breakpoints.isEmpty()) {
            for (DebugBreakpointData bp : this._breakpoints) {
                f = xc.createNode("drjava/project/breakpoints/breakpoint", null, false);
                path = FileOps.stringMakeRelativeTo(bp.getFile(), this._projectRoot);
                path = StringOps.replace(path, File.separator, "/");
                xc.set(".file", path, f, true);
                xc.set(".line", String.valueOf(bp.getLineNumber()), f, true);
                xc.set(".enabled", String.valueOf(bp.isEnabled()), f, true);
            }
        }
        xc.createNode("drjava/project/watches");
        if (!this._watches.isEmpty()) {
            for (DebugWatchData w : this._watches) {
                f = xc.createNode("drjava/project/watches/watch", null, false);
                xc.set(".name", w.getName(), f, true);
            }
        }
        xc.createNode("drjava/project/bookmarks");
        if (!this._bookmarks.isEmpty()) {
            for (FileRegion bm : this._bookmarks) {
                Node n = xc.createNode("drjava/project/bookmarks/bookmark", null, false);
                File file = bm.getFile();
                path = FileOps.stringMakeRelativeTo(file, this._projectRoot);
                path = StringOps.replace(path, File.separator, "/");
                xc.set(".file", path, n, true);
                xc.set(".from", String.valueOf(bm.getStartOffset()), n, true);
                xc.set(".to", String.valueOf(bm.getEndOffset()), n, true);
            }
        }
        xc.save(os);
    }

    public void writeOld() throws IOException {
        this.writeOld(new FileWriter(this._projectFile));
    }

    public String toString() {
        try {
            StringWriter w = new StringWriter();
            this.writeOld(w);
            return w.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public void writeOld(Writer fw) throws IOException {
        if (!$assertionsDisabled && this._projectRoot == null) {
            throw new AssertionError();
        }
        fw.write(new StringBuffer().append(";; DrJava project file, written by build ").append(Version.getVersionString()).toString());
        fw.write(new StringBuffer().append("\n;; files in the source tree are relative to: ").append(this._projectRoot.getCanonicalPath()).toString());
        fw.write("\n;; other files with relative paths are rooted at (the parent of) this project file");
        fw.write("\n(proj-root-and-base");
        fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._projectRoot, "  ", this._projectFile)).toString());
        fw.write(")");
        if (!this._sourceFiles.isEmpty()) {
            fw.write("\n(source-files");
            DocFile active = null;
            for (DocFile df : this._sourceFiles) {
                if (!df.isActive()) continue;
                active = df;
                fw.write(new StringBuffer().append("\n").append(this.encodeDocFileRelative(df, "  ")).toString());
                break;
            }
            for (DocFile df : this._sourceFiles) {
                if (df == active) continue;
                fw.write(new StringBuffer().append("\n").append(this.encodeDocFileRelative(df, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no source files");
        }
        if (!this._auxiliaryFiles.isEmpty()) {
            fw.write("\n(auxiliary");
            for (DocFile df : this._auxiliaryFiles) {
                fw.write(new StringBuffer().append("\n").append(this.encodeDocFileAbsolute(df, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no aux files");
        }
        if (!this._collapsedPaths.isEmpty()) {
            fw.write("\n(collapsed");
            for (String s : this._collapsedPaths) {
                fw.write(new StringBuffer().append("\n  (path ").append(StringOps.convertToLiteral(s)).append(")").toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no collapsed branches");
        }
        if (!this._classPathFiles.isEmpty()) {
            fw.write("\n(classpaths");
            for (File f : this._classPathFiles) {
                fw.write(new StringBuffer().append("\n").append(this.encodeFileAbsolute(f, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no classpaths files");
        }
        if (this._buildDir != null && this._buildDir.getPath() != "") {
            fw.write("\n(build-dir");
            fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._buildDir, "  ", this._projectFile)).toString());
            fw.write(")");
        } else {
            fw.write("\n;; no build directory");
        }
        if (this._workDir.getPath() != "") {
            fw.write("\n(work-dir");
            fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._workDir, "  ", this._projectFile)).toString());
            fw.write(")");
        } else {
            fw.write("\n;; no working directory");
        }
        if (this._mainClass != null) {
            fw.write("\n;; rooted at the (parent of the) project file");
            fw.write("\n(main-class");
            fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._mainClass, "  ", this._projectFile)).toString());
            fw.write(")");
        } else {
            fw.write("\n;; no main class");
        }
        if (this._createJarFile != null) {
            fw.write("\n(create-jar-file");
            fw.write(new StringBuffer().append("\n").append(this.encodeFileRelative(this._createJarFile, "  ", this._projectFile)).toString());
            fw.write(")");
        } else {
            fw.write("\n;; no create jar file");
        }
        if (this._createJarFlags != 0) {
            fw.write(new StringBuffer().append("\n(create-jar-flags ").append(this._createJarFlags).append(")").toString());
        } else {
            fw.write("\n;; no create jar flags");
        }
        if (!this._breakpoints.isEmpty()) {
            fw.write("\n(breakpoints");
            for (DebugBreakpointData bp : this._breakpoints) {
                fw.write(new StringBuffer().append("\n").append(this.encodeBreakpointRelative(bp, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no breakpoints");
        }
        if (!this._watches.isEmpty()) {
            fw.write("\n(watches");
            for (DebugWatchData w : this._watches) {
                fw.write(new StringBuffer().append("\n").append(this.encodeWatch(w, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no watches");
        }
        if (!this._bookmarks.isEmpty()) {
            fw.write("\n(bookmarks");
            for (FileRegion bm : this._bookmarks) {
                fw.write(new StringBuffer().append("\n").append(this.encodeBookmarkRelative(bm, "  ")).toString());
            }
            fw.write(")");
        } else {
            fw.write("\n;; no bookmarks");
        }
        fw.close();
    }

    private DocFile docFileFromGetter(DocumentInfoGetter g) throws IOException {
        return new DocFile(g.getFile().getCanonicalPath(), g.getSelection(), g.getScroll(), g.isActive(), g.getPackage());
    }

    private String encodeFileRelative(File f, String prefix, File base) throws IOException {
        String path = FileOps.stringMakeRelativeTo(f, base);
        path = StringOps.replace(path, File.separator, "/");
        return new StringBuffer().append(prefix).append("(file (name ").append(StringOps.convertToLiteral(path)).append("))").toString();
    }

    private String encodeFileAbsolute(File f, String prefix) throws IOException {
        String path = f.getCanonicalPath();
        path = StringOps.replace(path, File.separator, "/");
        return new StringBuffer().append(prefix).append("(file (name ").append(StringOps.convertToLiteral(path)).append("))").toString();
    }

    private String encodeDocFile(DocFile df, String prefix, boolean relative) throws IOException {
        String pack;
        String ret = "";
        String path = relative ? FileOps.stringMakeRelativeTo(df, this._projectRoot) : IOUtil.attemptCanonicalFile(df).getPath();
        path = StringOps.replace(path, File.separator, "/");
        ret = new StringBuffer().append(ret).append(prefix).append("(file (name ").append(StringOps.convertToLiteral(path)).append(")").toString();
        Pair<Integer, Integer> p1 = df.getSelection();
        Pair<Integer, Integer> p2 = df.getScroll();
        long modDate = df.lastModified();
        if (p1 != null || p2 != null) {
            ret = new StringBuffer().append(ret).append("\n").append(prefix).append("      ").toString();
        }
        if (p1 != null) {
            ret = new StringBuffer().append(ret).append("(select ").append(p1.first()).append(" ").append(p1.second()).append(")").toString();
        }
        if (p2 != null) {
            ret = new StringBuffer().append(ret).append("(scroll ").append(p2.first()).append(" ").append(p2.second()).append(")").toString();
        }
        if (modDate > 0L) {
            String s = MOD_DATE_FORMAT.format(new Date(modDate));
            ret = new StringBuffer().append(ret).append("(mod-date ").append(StringOps.convertToLiteral(s)).append(")").toString();
        }
        if ((pack = df.getPackage()) != null) {
            ret = new StringBuffer().append(ret).append("\n").append(prefix).append("      ").toString();
            ret = new StringBuffer().append(ret).append("(package ").append(StringOps.convertToLiteral(pack)).append(")").toString();
        }
        ret = new StringBuffer().append(ret).append(")").toString();
        return ret;
    }

    private String encodeDocFileRelative(DocFile df, String prefix) throws IOException {
        return this.encodeDocFile(df, prefix, true);
    }

    private String encodeDocFileAbsolute(DocFile df, String prefix) throws IOException {
        return this.encodeDocFile(df, prefix, false);
    }

    private String encodeBreakpointRelative(DebugBreakpointData bp, String prefix) throws IOException {
        String ret = "";
        String path = FileOps.stringMakeRelativeTo(bp.getFile(), this._projectRoot);
        path = StringOps.replace(path, File.separator, "/");
        ret = new StringBuffer().append(ret).append(prefix).append("(breakpoint (name ").append(StringOps.convertToLiteral(path)).append(")").toString();
        int lineNumber = bp.getLineNumber();
        ret = new StringBuffer().append(ret).append("\n").append(prefix).append("      ").toString();
        ret = new StringBuffer().append(ret).append("(line ").append(lineNumber).append(")").toString();
        if (bp.isEnabled()) {
            ret = new StringBuffer().append(ret).append("(enabled)").toString();
        }
        ret = new StringBuffer().append(ret).append(")").toString();
        return ret;
    }

    private String encodeWatch(DebugWatchData w, String prefix) throws IOException {
        String ret = "";
        ret = new StringBuffer().append(ret).append(prefix).append("(watch ").append(StringOps.convertToLiteral(w.getName())).append(")").toString();
        return ret;
    }

    private String encodeBookmarkRelative(FileRegion bm, String prefix) throws IOException {
        String ret = "";
        String path = FileOps.stringMakeRelativeTo(bm.getFile(), this._projectRoot);
        path = StringOps.replace(path, File.separator, "/");
        ret = new StringBuffer().append(ret).append(prefix).append("(bookmark (name ").append(StringOps.convertToLiteral(path)).append(")").toString();
        int startOffset = bm.getStartOffset();
        int endOffset = bm.getEndOffset();
        ret = new StringBuffer().append(ret).append("\n").append(prefix).append("      ").toString();
        ret = new StringBuffer().append(ret).append("(start ").append(startOffset).append(")").toString();
        ret = new StringBuffer().append(ret).append("(end ").append(endOffset).append(")").toString();
        ret = new StringBuffer().append(ret).append(")").toString();
        return ret;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$project$ProjectProfile == null ? (class$edu$rice$cs$drjava$project$ProjectProfile = ProjectProfile.class$("edu.rice.cs.drjava.project.ProjectProfile")) : class$edu$rice$cs$drjava$project$ProjectProfile).desiredAssertionStatus();
        MOD_DATE_FORMAT = new SimpleDateFormat(MOD_DATE_FORMAT_STRING, Locale.US);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

