/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsModel;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.EditDocumentException;
import java.awt.EventQueue;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionsScriptModel {
    private volatile InteractionsModel _model;
    private volatile InteractionsDocument _doc;
    private volatile List<String> _interactions;
    private volatile int _currentInteraction;
    private volatile boolean _passedCurrent;

    public InteractionsScriptModel(InteractionsModel model, List<String> interactions) {
        this._model = model;
        this._doc = model.getDocument();
        this._interactions = interactions;
        this._currentInteraction = -1;
        this._passedCurrent = false;
    }

    public void nextInteraction() {
        if (!this.hasNextInteraction()) {
            throw new IllegalStateException("There is no next interaction!");
        }
        ++this._currentInteraction;
        this._showCurrentInteraction();
        this._passedCurrent = false;
    }

    public void prevInteraction() {
        if (!this.hasPrevInteraction()) {
            throw new IllegalStateException("There is no previous interaction!");
        }
        if (!this._passedCurrent) {
            --this._currentInteraction;
        }
        this._showCurrentInteraction();
        this._passedCurrent = false;
    }

    private void _showCurrentInteraction() {
        try {
            this._doc.clearCurrentInteraction();
            String text = this._interactions.get(this._currentInteraction);
            this._doc.insertText(this._doc.getLength(), text, "default");
        }
        catch (EditDocumentException dae) {
            throw new UnexpectedException(dae);
        }
    }

    public void executeInteraction() {
        this._passedCurrent = true;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                InteractionsScriptModel.access$000(InteractionsScriptModel.this).interpretCurrentInteraction();
            }
        });
    }

    public boolean hasNextInteraction() {
        return this._currentInteraction < this._interactions.size() - 1;
    }

    public boolean hasPrevInteraction() {
        int index = this._currentInteraction;
        if (this._passedCurrent) {
            ++index;
        }
        return index > 0;
    }

    static InteractionsModel access$000(InteractionsScriptModel x0) {
        return x0._model;
    }
}

